/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.ajaxproxy.internal.facets;

import com.ibm.etools.webtools.ajaxproxy.internal.facets.AjaxProxyFacetInstallDelegate;
import com.ibm.etools.webtools.ajaxproxy.internal.facets.AjaxProxyFacetUninstallDelegate;
import com.ibm.etools.webtools.ajaxproxy.internal.facets.FacetDelegateDispatcher;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;

public class FacetInstallDelegateDispatcher
extends FacetDelegateDispatcher {
    private static final String INSTALL = "INSTALL";

    @Override
    public String getDelegateType() {
        return INSTALL;
    }

    @Override
    public void executeDefaultDelegate(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        new AjaxProxyFacetInstallDelegate().execute(project, fv, config, monitor);
        if (this.delegateElements != null && this.delegateElements.length > 0) {
            this.addFacetListener(project);
        }
    }

    private void addFacetListener(IProject project) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        facetedProject.addListener((IFacetedProjectListener)new FacetListener(), new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.POST_INSTALL});
    }

    private class FacetListener
    implements IFacetedProjectListener {
        private FacetListener() {
        }

        public void handleEvent(IFacetedProjectEvent event) {
            IProjectFacetActionEvent actionEvent;
            String id;
            if (event.getType() == IFacetedProjectEvent.Type.POST_INSTALL && FacetInstallDelegateDispatcher.this.interestingFacets.contains(id = (actionEvent = (IProjectFacetActionEvent)event).getProjectFacet().getId())) {
                IProject project = actionEvent.getProject().getProject();
                IConfigurationElement matchingElement = FacetInstallDelegateDispatcher.this.findMatchingElement(actionEvent.getProject().getProject());
                if (matchingElement != null) {
                    try {
                        new AjaxProxyFacetUninstallDelegate().execute(project, FacetInstallDelegateDispatcher.this.ajaxProxyFacetVersion, FacetInstallDelegateDispatcher.this.ajaxProxyConfig, (IProgressMonitor)new NullProgressMonitor());
                        IDelegate delegateExecutable = (IDelegate)matchingElement.createExecutableExtension("class");
                        delegateExecutable.execute(project, FacetInstallDelegateDispatcher.this.ajaxProxyFacetVersion, FacetInstallDelegateDispatcher.this.ajaxProxyConfig, (IProgressMonitor)new NullProgressMonitor());
                        IFacetedProject facetProj = actionEvent.getProject();
                        if (facetProj != null) {
                            facetProj.removeListener((IFacetedProjectListener)this);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

