/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.ajaxproxy.internal.facets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public abstract class FacetDelegateDispatcher
implements IDelegate {
    private static final String DELEGATE_EXT_PT = "com.ibm.etools.webtools.ajaxproxy.facetdelegate";
    private static final String TYPE = "type";
    private static final String FACET = "facet";
    private static final String ID = "id";
    private static final String DELEGATE_CLASS = "delegateClass";
    private static final String OR = "or";
    protected IConfigurationElement[] delegateElements;
    protected List<String> interestingFacets = new ArrayList<String>();
    protected IProjectFacetVersion ajaxProxyFacetVersion = null;
    protected Object ajaxProxyConfig = null;

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        IConfigurationElement matchingElement;
        if (this.delegateElements == null) {
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint delegates = extensionRegistry.getExtensionPoint(DELEGATE_EXT_PT);
            if (delegates != null) {
                this.delegateElements = delegates.getConfigurationElements();
            }
            this.ajaxProxyFacetVersion = fv;
            this.ajaxProxyConfig = config;
        }
        if ((matchingElement = this.findMatchingElement(project)) != null) {
            try {
                IDelegate delegateExecutable = (IDelegate)matchingElement.createExecutableExtension("class");
                delegateExecutable.execute(project, fv, config, monitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            this.executeDefaultDelegate(project, fv, config, monitor);
        }
    }

    protected IConfigurationElement findMatchingElement(IProject project) {
        IConfigurationElement matchingElement = null;
        int i = 0;
        while (i < this.delegateElements.length) {
            matchingElement = this.processDelegate(this.delegateElements[i], project);
            if (matchingElement != null) break;
            ++i;
        }
        return matchingElement;
    }

    protected IConfigurationElement processDelegate(IConfigurationElement delegate, IProject project) {
        IConfigurationElement[] delegateClasses = delegate.getChildren(DELEGATE_CLASS);
        IConfigurationElement delegateClass = null;
        IConfigurationElement[] iConfigurationElementArray = delegateClasses;
        int n = delegateClasses.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement delClass = iConfigurationElementArray[n2];
            String type = delClass.getAttribute(TYPE);
            if (type != null && type.equals(this.getDelegateType())) {
                delegateClass = delClass;
                break;
            }
            ++n2;
        }
        if (delegateClass != null) {
            IConfigurationElement[] ordGroups;
            boolean matchFacets = true;
            boolean matchAllOrdFacets = true;
            IConfigurationElement[] iConfigurationElementArray2 = ordGroups = delegate.getChildren(OR);
            int n3 = ordGroups.length;
            int type = 0;
            while (type < n3) {
                IConfigurationElement[] facets;
                IConfigurationElement orGroup = iConfigurationElementArray2[type];
                boolean matchThisGroup = false;
                IConfigurationElement[] iConfigurationElementArray3 = facets = orGroup.getChildren(FACET);
                int n4 = facets.length;
                int n5 = 0;
                while (n5 < n4) {
                    IConfigurationElement facet = iConfigurationElementArray3[n5];
                    String id = facet.getAttribute(ID);
                    if (!this.interestingFacets.contains(id)) {
                        this.interestingFacets.add(id);
                    }
                    if (this.projectHasFacet(project, id, null)) {
                        matchThisGroup = true;
                        break;
                    }
                    ++n5;
                }
                if (!matchThisGroup) {
                    matchAllOrdFacets = false;
                    matchFacets = false;
                    break;
                }
                ++type;
            }
            if (matchAllOrdFacets) {
                IConfigurationElement[] facets;
                IConfigurationElement[] iConfigurationElementArray4 = facets = delegate.getChildren(FACET);
                int n6 = facets.length;
                n3 = 0;
                while (n3 < n6) {
                    IConfigurationElement facetElement = iConfigurationElementArray4[n3];
                    String id = facetElement.getAttribute(ID);
                    if (!this.interestingFacets.contains(id)) {
                        this.interestingFacets.add(id);
                    }
                    if (!this.projectHasFacet(project, id, null)) {
                        matchFacets = false;
                        break;
                    }
                    ++n3;
                }
                if (matchFacets) {
                    return delegateClass;
                }
            }
        }
        return null;
    }

    private boolean projectHasFacet(IProject project, String facetID, String facetVersion) {
        boolean hasFacet = false;
        if (ProjectFacetsManager.isProjectFacetDefined((String)facetID)) {
            IProjectFacet requiredFacet;
            IFacetedProject facetedProject = null;
            try {
                facetedProject = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            if (facetedProject != null && (requiredFacet = ProjectFacetsManager.getProjectFacet((String)facetID)) != null) {
                if (facetVersion != null) {
                    IProjectFacetVersion requiredFacetVersion = requiredFacet.getVersion(facetVersion);
                    if (requiredFacetVersion != null) {
                        hasFacet = facetedProject.hasProjectFacet(requiredFacetVersion);
                    }
                } else {
                    hasFacet = facetedProject.hasProjectFacet(requiredFacet);
                }
            }
        }
        return hasFacet;
    }

    public abstract String getDelegateType();

    public abstract void executeDefaultDelegate(IProject var1, IProjectFacetVersion var2, Object var3, IProgressMonitor var4) throws CoreException;
}

