/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.ajaxproxy.internal.facets;

import com.ibm.etools.webtools.ajaxproxy.Activator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class AjaxProxyFacetUninstallDelegate
implements IDelegate {
    private static final String LIB_PATH = "/WEB-INF/lib";
    private static List<String> jarsToUninstall = new ArrayList<String>();

    public static void addToJarsToUninstall(String jarName) {
        if (!jarsToUninstall.contains(jarName)) {
            jarsToUninstall.add(jarName);
        }
    }

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        this.removeJars(project);
        this.removeConfigFile(project);
        this.updateWebXML(project);
    }

    private void removeConfigFile(IProject project) {
        IFile configFile = this.getProxyConfigFile(project);
        IStatus editStatus = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{configFile}, null);
        if (editStatus.isOK()) {
            try {
                configFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void removeJars(IProject project) {
        int i = 0;
        while (i < jarsToUninstall.size()) {
            IFile jarFile = this.getJarFile(project, "/WEB-INF/lib/" + jarsToUninstall.get(i));
            IStatus editStatus = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{jarFile}, null);
            if (editStatus.isOK()) {
                try {
                    jarFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    private IFile getJarFile(IProject project, String jarName) {
        IVirtualComponent module = ComponentCore.createComponent((IProject)project);
        IContainer rootFolder = module.getRootFolder().getUnderlyingFolder();
        IFile jarFile = rootFolder.getFile((IPath)new Path(jarName));
        return jarFile;
    }

    private IFile getProxyConfigFile(IProject project) {
        IVirtualComponent module = ComponentCore.createComponent((IProject)project);
        IContainer rootFolder = module.getRootFolder().getUnderlyingFolder();
        IFile configFile = rootFolder.getFile((IPath)new Path("/WEB-INF/proxy-config.xml"));
        return configFile;
    }

    protected void updateWebXML(IProject project) {
        block10: {
            WebArtifactEdit editModel = WebArtifactEdit.getWebArtifactEditForWrite((IProject)project);
            if (editModel != null) {
                try {
                    try {
                        IPath ddPath = editModel.getDeploymentDescriptorPath();
                        if (ddPath == null) break block10;
                        IFile ddFile = ResourcesPlugin.getWorkspace().getRoot().getFile(ddPath);
                        IStatus editStatus = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{ddFile}, null);
                        if (editStatus.isOK()) {
                            WebApp app = editModel.getWebApp();
                            Servlet servlet = app.getServletNamed("ProxyServlet");
                            if (servlet != null) {
                                ServletMapping servletMapping = app.getServletMapping(servlet);
                                app.getServletMappings().remove((Object)servletMapping);
                                app.getServlets().remove((Object)servlet);
                                editModel.saveIfNecessary(null);
                            }
                            break block10;
                        }
                        Activator.getDefault().write(editStatus.getMessage());
                    }
                    catch (Exception e) {
                        Activator.getDefault().write(e.getMessage());
                        if (editModel != null) {
                            editModel.dispose();
                        }
                    }
                }
                finally {
                    if (editModel != null) {
                        editModel.dispose();
                    }
                }
            }
        }
    }
}

