/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.ajaxproxy.internal.facets;

import com.ibm.etools.webtools.ajaxproxy.Activator;
import com.ibm.etools.webtools.ajaxproxy.internal.facets.AjaxProxyFacetUninstallDelegate;
import com.ibm.etools.webtools.rpcadapter.websphere.internal.facets.Web2FeaturePackFacetUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;
import org.eclipse.jst.jee.project.facet.IWebCreateDeploymentFilesDataModelProperties;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;

public class AjaxProxyFacetInstallDelegate
implements IDelegate {
    private static final String LIB_PATH = "/WEB-INF/lib";
    private static final String PATH_TO_AJAX_PROXY_WAR = "/installableApps/AjaxProxy/AjaxProxy.war";

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (this.isWeb2FPInstalled(project)) {
            this.addJarToProject(project);
            this.setUpWebXML(project);
            this.createProxyConfigXML(project);
        }
    }

    protected void addJarToProject(IProject project) {
        String runtimeLocation = this.getRuntimeLocation(project);
        if (runtimeLocation == null) {
            return;
        }
        IFolder libFolder = this.getLibFolderPath(project);
        if (!libFolder.exists()) {
            try {
                libFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (libFolder.exists()) {
            String pathToWar = Web2FeaturePackFacetUtil.findWeb20FePLocation((IProject)project, null) + PATH_TO_AJAX_PROXY_WAR;
            ZipInputStream zipInputStream = null;
            try {
                zipInputStream = new ZipInputStream(new FileInputStream(new File(pathToWar)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            try {
                ZipEntry entry = null;
                byte[] buf = new byte[8024];
                while ((entry = zipInputStream.getNextEntry()) != null) {
                    String ajaxProxyJar;
                    String entryName = entry.getName();
                    if (!entryName.endsWith(".jar") || !entryName.contains("WEB-INF/lib/") || libFolder.getFile(ajaxProxyJar = entryName.substring(entryName.lastIndexOf(47) + 1, entryName.length())).exists()) continue;
                    AjaxProxyFacetUninstallDelegate.addToJarsToUninstall(ajaxProxyJar);
                    String ajaxJarFilePath = project.getWorkspace().getRoot().getLocation() + libFolder.getFullPath().toString() + "/" + ajaxProxyJar;
                    FileOutputStream fileoutputstream = new FileOutputStream(ajaxJarFilePath);
                    int n = 0;
                    while ((n = zipInputStream.read(buf, 0, 1024)) > -1) {
                        fileoutputstream.write(buf, 0, n);
                    }
                    fileoutputstream.close();
                }
                zipInputStream.close();
                libFolder.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void setUpWebXML(IProject project) {
        block13: {
            WebArtifactEdit editModel;
            if (!this.hasDeploymentDescriptor(project)) {
                try {
                    Class<IWebCreateDeploymentFilesDataModelProperties> dataModelClass = IWebCreateDeploymentFilesDataModelProperties.class;
                    IDataModel dataModel = DataModelFactory.createDataModel(dataModelClass);
                    dataModel.setProperty("ICreateDeploymentFilesDataModelProperties.TARGET_PROJECT", (Object)project);
                    dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((editModel = WebArtifactEdit.getWebArtifactEditForWrite((IProject)project)) != null) {
                try {
                    try {
                        IPath ddPath = editModel.getDeploymentDescriptorPath();
                        if (ddPath == null) break block13;
                        IFile ddFile = ResourcesPlugin.getWorkspace().getRoot().getFile(ddPath);
                        IStatus editStatus = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{ddFile}, null);
                        if (editStatus.isOK()) {
                            WebApp app = editModel.getWebApp();
                            Servlet servlet = app.getServletNamed("ProxyServlet");
                            if (servlet == null) {
                                WebapplicationFactory factory = WebapplicationPackage.eINSTANCE.getWebapplicationFactory();
                                ServletType servletType = factory.createServletType();
                                servletType.setClassName("com.ibm.ws.ajaxproxy.servlet.ProxyServlet");
                                servlet = factory.createServlet();
                                servlet.setServletName("ProxyServlet");
                                servlet.setWebType((WebType)servletType);
                                app.getServlets().add((Object)servlet);
                                ServletMapping servletMapping = factory.createServletMapping();
                                servletMapping.setServlet(servlet);
                                servletMapping.setUrlPattern("/proxy/*");
                                app.getServletMappings().add((Object)servletMapping);
                                editModel.saveIfNecessary(null);
                            }
                            break block13;
                        }
                        Activator.getDefault().write(editStatus.getMessage());
                    }
                    catch (Exception e) {
                        Activator.getDefault().write(e.getMessage());
                        if (editModel != null) {
                            editModel.dispose();
                        }
                    }
                }
                finally {
                    if (editModel != null) {
                        editModel.dispose();
                    }
                }
            }
        }
    }

    protected void createProxyConfigXML(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        IContainer webContent = component.getRootFolder().getUnderlyingFolder();
        IFile file = webContent.getFile((IPath)new Path("/WEB-INF/proxy-config.xml"));
        if (!file.exists()) {
            URL templateURL = Activator.getResource("xml/ProxyConfig.template");
            try {
                URL localTemplateURL = FileLocator.toFileURL((URL)templateURL);
                InputStream inputStream = localTemplateURL.openStream();
                file.create(inputStream, false, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private IFolder getLibFolderPath(IProject project) {
        IVirtualComponent module = ComponentCore.createComponent((IProject)project);
        IContainer rootFolder = module.getRootFolder().getUnderlyingFolder();
        IFolder libFolder = rootFolder.getFolder((IPath)new Path(LIB_PATH));
        return libFolder;
    }

    public String getRuntimeLocation(IProject project) {
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = null;
        IFacetedProject facetProj = null;
        if (project != null) {
            try {
                facetProj = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            runtime = facetProj.getPrimaryRuntime();
        }
        if (runtime != null) {
            IRuntime wasRuntime = FacetUtil.getRuntime(runtime);
            return wasRuntime.getLocation().toString();
        }
        return null;
    }

    private boolean isWeb2FPInstalled(IProject project) {
        IPath pathToWeb2FP = Web2FeaturePackFacetUtil.findWeb20FePLocation((IProject)project, null);
        return pathToWeb2FP != null;
    }

    private boolean hasDeploymentDescriptor(IProject project) {
        IVirtualComponent component;
        boolean ret = true;
        Path ddFilePath = null;
        if (J2EEProjectUtilities.isDynamicWebProject((IProject)project)) {
            ddFilePath = new Path("WEB-INF/web.xml");
        }
        if ((component = ComponentCore.createComponent((IProject)project)).getRootFolder() != null && component.getRootFolder().getUnderlyingFolder() != null) {
            IFile ddXmlFile = component.getRootFolder().getUnderlyingFolder().getFile((IPath)ddFilePath);
            ret = ddXmlFile.exists();
        }
        return ret;
    }
}

