/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.ajax.library.internal.palette.dojo.actions;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.webedit.commands.SimpleEditRangeCommand;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.core.preview.LinkUtils;
import com.ibm.etools.webtools.ajax.library.Logger;
import com.ibm.etools.webtools.dojo.core.DojoSettings;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.wst.sse.core.internal.FileBufferModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InsertDojoIncludesCommand
extends SimpleEditRangeCommand {
    private Set<String> requiredCSSImports;

    public InsertDojoIncludesCommand() {
        this(null);
    }

    public InsertDojoIncludesCommand(Set<String> requiredCSSImports) {
        super("");
        this.requiredCSSImports = requiredCSSImports;
        if (this.requiredCSSImports == null) {
            this.requiredCSSImports = new HashSet<String>();
        }
    }

    protected void doExecute() {
        Document doc = this.getDocument();
        if (doc == null) {
            return;
        }
        Node head = this.getHead(doc);
        if (head == null) {
            return;
        }
        boolean includeBootStrap = true;
        boolean includeDojoCSS = true;
        boolean includeThemeCSS = true;
        boolean includeDijitCSS = true;
        IStructuredDocument sdoc = this.getCommandTarget().getActiveModel().getStructuredDocument();
        if (sdoc == null) {
            return;
        }
        includeBootStrap = this.findDojoBootStrap(sdoc) == null;
        includeDojoCSS = this.findDojoCSS(sdoc) == null;
        includeThemeCSS = this.findThemeCSS(sdoc) == null;
        includeDijitCSS = this.findDijitCSS(sdoc) == null;
        HashSet<String> newIncludeList = new HashSet<String>();
        for (String include : this.requiredCSSImports) {
            boolean isPresent = this.findCSS(sdoc, include);
            if (isPresent) continue;
            newIncludeList.add(include);
        }
        this.requiredCSSImports = newIncludeList;
        if (!(includeBootStrap || includeDojoCSS || includeThemeCSS || includeDijitCSS || !this.requiredCSSImports.isEmpty())) {
            return;
        }
        String sourceToInsert = this.getDojoIncludes(includeBootStrap, includeDojoCSS, includeThemeCSS, includeDijitCSS);
        IStructuredDocumentRegion headStartRegion = this.findNodeRegion(sdoc, "HEAD", true);
        InsertEdit insertEdit = new InsertEdit(headStartRegion.getEndOffset(), sourceToInsert);
        try {
            insertEdit.apply((IDocument)sdoc);
        }
        catch (MalformedTreeException e) {
            Logger.logException(e);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
    }

    private boolean findCSS(IStructuredDocument doc, String cssImport) {
        IProject project = this.getTargetProject();
        if (project == null) {
            return false;
        }
        if (cssImport == null || cssImport.isEmpty()) {
            return false;
        }
        String themeCSS = new Path(cssImport).lastSegment();
        IStructuredDocumentRegion startHeadRegion = this.findNodeRegion(doc, "HEAD", true);
        IStructuredDocumentRegion endHeadRegion = this.findNodeRegion(doc, "HEAD", false);
        IStructuredDocumentRegion[] nodes = doc.getStructuredDocumentRegions(startHeadRegion.getEndOffset(), endHeadRegion.getStartOffset() - startHeadRegion.getEndOffset());
        int i = 0;
        while (i < nodes.length) {
            IStructuredDocumentRegion node = nodes[i];
            if ("XML_TAG_NAME" == node.getType() || "BLOCK_TEXT" == node.getType()) {
                boolean startTag = false;
                boolean linkTag = false;
                boolean hrefAttrName = false;
                ITextRegionList regions = node.getRegions();
                int j = 0;
                while (j < regions.size()) {
                    String blockText;
                    String attrValue;
                    ITextRegion region = regions.get(j);
                    boolean bl = startTag = "XML_TAG_OPEN" == region.getType();
                    if (startTag && "XML_TAG_NAME" == region.getType()) {
                        String tagName = node.getText(region);
                        boolean bl2 = linkTag = tagName != null && tagName.equalsIgnoreCase("LINK");
                    }
                    if (linkTag && "XML_TAG_ATTRIBUTE_NAME" == region.getType()) {
                        String attrName = node.getText(region);
                        boolean bl3 = hrefAttrName = attrName != null && attrName.equalsIgnoreCase("href");
                    }
                    if (hrefAttrName && "XML_TAG_ATTRIBUTE_VALUE" == region.getType() && (attrValue = node.getText(region)).contains(themeCSS)) {
                        return true;
                    }
                    if ("BLOCK_TEXT" == region.getType() && (blockText = node.getText(region)).contains(themeCSS) && blockText.contains("@import")) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    protected Node getHead(Document doc) {
        NodeList heads = doc.getElementsByTagName("HEAD");
        Node head = null;
        if (heads == null || heads.getLength() == 0) {
            head = doc.createElement("HEAD");
            NodeList htmlList = doc.getElementsByTagName("HTML");
            if (htmlList != null && htmlList.getLength() > 0) {
                Node html = htmlList.item(0);
                Node firstChild = html.getFirstChild();
                html.insertBefore(head, firstChild);
            }
        } else {
            head = heads.item(0);
        }
        return head;
    }

    protected IStructuredDocumentRegion findDojoBootStrap(IStructuredDocument doc) {
        IProject project = this.getTargetProject();
        if (project == null) {
            return null;
        }
        String bootstrapJS = null;
        Object dojoRoot = null;
        try {
            dojoRoot = DojoSettings.getDojoRoot((IProject)project);
            bootstrapJS = DojoSettings.getDojoLoaderJS((IProject)project);
        }
        catch (Exception exception) {
            return null;
        }
        if (bootstrapJS == null || bootstrapJS.isEmpty()) {
            return null;
        }
        if (dojoRoot == null) {
            return null;
        }
        IPath bootStrapPath = new Path(bootstrapJS).makeRelative();
        if (dojoRoot instanceof URL) {
            URL dojoRootURL = (URL)dojoRoot;
            String dojoRootString = dojoRootURL.toString();
            if (!dojoRootString.endsWith("/")) {
                dojoRootString = String.valueOf(dojoRootString) + "/";
            }
            dojoRootString = String.valueOf(dojoRootString) + bootStrapPath.toString();
            return this.findScriptTagWithSrcAttribute(doc, dojoRootString);
        }
        ITextFileBuffer buffer = FileBufferModelManager.getInstance().getBuffer((IDocument)doc);
        if (buffer != null) {
            IPath dojoRootPath = (IPath)dojoRoot;
            bootStrapPath = dojoRootPath.append(bootstrapJS);
            IPath bufferPath = buffer.getLocation();
            IFile bootStrapFile = ResourcesPlugin.getWorkspace().getRoot().getFile(bootStrapPath);
            LinkNode dojoJSNode = ReferenceManager.getReferenceManager().getLinkNode(bootStrapFile);
            Collection matchingLinks = dojoJSNode.getIncomingLinks(null, SearchEngine.createSearchScope((IPath[])new IPath[]{bufferPath}));
            Iterator iterator = matchingLinks.iterator();
            if (iterator.hasNext()) {
                ILink link = (ILink)iterator.next();
                String linkText = link.getLinkText();
                return this.findScriptTagWithSrcAttribute(doc, linkText);
            }
        }
        return null;
    }

    private IStructuredDocumentRegion findScriptTagWithSrcAttribute(IStructuredDocument doc, String linkText) {
        IStructuredDocumentRegion startHeadRegion = this.findNodeRegion(doc, "HEAD", true);
        IStructuredDocumentRegion endHeadRegion = this.findNodeRegion(doc, "HEAD", false);
        IStructuredDocumentRegion[] nodes = doc.getStructuredDocumentRegions(startHeadRegion.getEndOffset(), endHeadRegion.getStartOffset() - startHeadRegion.getEndOffset());
        int i = 0;
        while (i < nodes.length) {
            IStructuredDocumentRegion node = nodes[i];
            if ("XML_TAG_NAME" == node.getType()) {
                boolean startTag = false;
                boolean scriptTag = false;
                boolean srcAttrName = false;
                ITextRegionList regions = node.getRegions();
                int j = 0;
                while (j < regions.size()) {
                    String attrValue;
                    ITextRegion region = regions.get(j);
                    if ("XML_TAG_OPEN" == region.getType()) {
                        startTag = true;
                    }
                    if (startTag && "XML_TAG_NAME" == region.getType()) {
                        String tagName = node.getText(region);
                        boolean bl = scriptTag = tagName != null && tagName.equalsIgnoreCase("SCRIPT");
                    }
                    if (scriptTag && "XML_TAG_ATTRIBUTE_NAME" == region.getType()) {
                        String attrName = node.getText(region);
                        boolean bl = srcAttrName = attrName != null && attrName.equalsIgnoreCase("src");
                    }
                    if (srcAttrName && "XML_TAG_ATTRIBUTE_VALUE" == region.getType() && (attrValue = node.getText(region)).contains(linkText)) {
                        return node;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    protected IStructuredDocumentRegion findDojoCSS(IStructuredDocument doc) {
        IProject project = this.getTargetProject();
        if (project == null) {
            return null;
        }
        String dojoCSS = null;
        try {
            dojoCSS = DojoSettings.getDojoCSS((IProject)project);
        }
        catch (Exception exception) {
            return null;
        }
        if (dojoCSS == null || dojoCSS.isEmpty()) {
            return null;
        }
        dojoCSS = new Path(dojoCSS).lastSegment();
        IStructuredDocumentRegion startHeadRegion = this.findNodeRegion(doc, "HEAD", true);
        IStructuredDocumentRegion endHeadRegion = this.findNodeRegion(doc, "HEAD", false);
        IStructuredDocumentRegion[] nodes = doc.getStructuredDocumentRegions(startHeadRegion.getEndOffset(), endHeadRegion.getStartOffset() - startHeadRegion.getEndOffset());
        int i = 0;
        while (i < nodes.length) {
            IStructuredDocumentRegion node = nodes[i];
            if ("XML_TAG_NAME" == node.getType() || "BLOCK_TEXT" == node.getType()) {
                boolean startTag = false;
                boolean linkTag = false;
                boolean hrefAttrName = false;
                ITextRegionList regions = node.getRegions();
                int j = 0;
                while (j < regions.size()) {
                    String blockText;
                    String attrValue;
                    ITextRegion region = regions.get(j);
                    boolean bl = startTag = "XML_TAG_OPEN" == region.getType();
                    if (startTag && "XML_TAG_NAME" == region.getType()) {
                        String tagName = node.getText(region);
                        boolean bl2 = linkTag = tagName != null && tagName.equalsIgnoreCase("LINK");
                    }
                    if (linkTag && "XML_TAG_ATTRIBUTE_NAME" == region.getType()) {
                        String attrName = node.getText(region);
                        boolean bl3 = hrefAttrName = attrName != null && attrName.equalsIgnoreCase("href");
                    }
                    if (hrefAttrName && "XML_TAG_ATTRIBUTE_VALUE" == region.getType() && (attrValue = node.getText(region)).contains(dojoCSS)) {
                        return node;
                    }
                    if ("BLOCK_TEXT" == region.getType() && (blockText = node.getText(region)).contains(dojoCSS) && blockText.contains("@import")) {
                        return node;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    protected IStructuredDocumentRegion findThemeCSS(IStructuredDocument doc) {
        IProject project = this.getTargetProject();
        if (project == null) {
            return null;
        }
        String themeCSS = null;
        try {
            themeCSS = DojoSettings.getThemeCSS((IProject)project);
        }
        catch (Exception exception) {
            return null;
        }
        if (themeCSS == null || themeCSS.isEmpty()) {
            return null;
        }
        themeCSS = new Path(themeCSS).lastSegment();
        IStructuredDocumentRegion startHeadRegion = this.findNodeRegion(doc, "HEAD", true);
        IStructuredDocumentRegion endHeadRegion = this.findNodeRegion(doc, "HEAD", false);
        IStructuredDocumentRegion[] nodes = doc.getStructuredDocumentRegions(startHeadRegion.getEndOffset(), endHeadRegion.getStartOffset() - startHeadRegion.getEndOffset());
        int i = 0;
        while (i < nodes.length) {
            IStructuredDocumentRegion node = nodes[i];
            if ("XML_TAG_NAME" == node.getType() || "BLOCK_TEXT" == node.getType()) {
                boolean startTag = false;
                boolean linkTag = false;
                boolean hrefAttrName = false;
                ITextRegionList regions = node.getRegions();
                int j = 0;
                while (j < regions.size()) {
                    String blockText;
                    String attrValue;
                    ITextRegion region = regions.get(j);
                    boolean bl = startTag = "XML_TAG_OPEN" == region.getType();
                    if (startTag && "XML_TAG_NAME" == region.getType()) {
                        String tagName = node.getText(region);
                        boolean bl2 = linkTag = tagName != null && tagName.equalsIgnoreCase("LINK");
                    }
                    if (linkTag && "XML_TAG_ATTRIBUTE_NAME" == region.getType()) {
                        String attrName = node.getText(region);
                        boolean bl3 = hrefAttrName = attrName != null && attrName.equalsIgnoreCase("href");
                    }
                    if (hrefAttrName && "XML_TAG_ATTRIBUTE_VALUE" == region.getType() && (attrValue = node.getText(region)).contains(themeCSS)) {
                        return node;
                    }
                    if ("BLOCK_TEXT" == region.getType() && (blockText = node.getText(region)).contains(themeCSS) && blockText.contains("@import")) {
                        return node;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    protected IStructuredDocumentRegion findDijitCSS(IStructuredDocument doc) {
        IProject project = this.getTargetProject();
        if (project == null) {
            return null;
        }
        String dijitCSS = null;
        try {
            dijitCSS = DojoSettings.getDijitCSS((IProject)project);
        }
        catch (Exception exception) {
            return null;
        }
        if (dijitCSS == null || dijitCSS.isEmpty()) {
            return null;
        }
        dijitCSS = new Path(dijitCSS).lastSegment();
        IStructuredDocumentRegion startHeadRegion = this.findNodeRegion(doc, "HEAD", true);
        IStructuredDocumentRegion endHeadRegion = this.findNodeRegion(doc, "HEAD", false);
        IStructuredDocumentRegion[] nodes = doc.getStructuredDocumentRegions(startHeadRegion.getEndOffset(), endHeadRegion.getStartOffset() - startHeadRegion.getEndOffset());
        int i = 0;
        while (i < nodes.length) {
            IStructuredDocumentRegion node = nodes[i];
            if ("XML_TAG_NAME" == node.getType() || "BLOCK_TEXT" == node.getType()) {
                boolean startTag = false;
                boolean linkTag = false;
                boolean hrefAttrName = false;
                ITextRegionList regions = node.getRegions();
                int j = 0;
                while (j < regions.size()) {
                    String blockText;
                    String attrValue;
                    ITextRegion region = regions.get(j);
                    boolean bl = startTag = "XML_TAG_OPEN" == region.getType();
                    if (startTag && "XML_TAG_NAME" == region.getType()) {
                        String tagName = node.getText(region);
                        boolean bl2 = linkTag = tagName != null && tagName.equalsIgnoreCase("LINK");
                    }
                    if (linkTag && "XML_TAG_ATTRIBUTE_NAME" == region.getType()) {
                        String attrName = node.getText(region);
                        boolean bl3 = hrefAttrName = attrName != null && attrName.equalsIgnoreCase("href");
                    }
                    if (hrefAttrName && "XML_TAG_ATTRIBUTE_VALUE" == region.getType() && (attrValue = node.getText(region)).contains(dijitCSS)) {
                        return node;
                    }
                    if ("BLOCK_TEXT" == region.getType() && (blockText = node.getText(region)).contains(dijitCSS) && blockText.contains("@import")) {
                        return node;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    protected IStructuredDocumentRegion findNodeRegion(IStructuredDocument doc, String tagName, boolean returnStartTag) {
        IStructuredDocumentRegion[] nodes = doc.getStructuredDocumentRegions();
        int i = 0;
        while (i < nodes.length) {
            IStructuredDocumentRegion node = nodes[i];
            if ("XML_TAG_NAME" == node.getType()) {
                boolean startTag = false;
                boolean endTag = false;
                ITextRegionList regions = node.getRegions();
                int j = 0;
                while (j < regions.size()) {
                    String foundTagName;
                    ITextRegion region = regions.get(j);
                    if ("XML_TAG_OPEN" == region.getType()) {
                        startTag = true;
                    }
                    if ("XML_END_TAG_OPEN" == region.getType()) {
                        endTag = true;
                    }
                    if (startTag && "XML_TAG_NAME" == region.getType() && (foundTagName = node.getText(region)) != null && foundTagName.equalsIgnoreCase(tagName) && returnStartTag) {
                        return node;
                    }
                    if (endTag && "XML_TAG_NAME" == region.getType() && (foundTagName = node.getText(region)) != null && foundTagName.equalsIgnoreCase(tagName) && !returnStartTag) {
                        return node;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    protected String getDojoIncludes(boolean includeBootStrap, boolean includeDojoCSS, boolean includeThemeCSS, boolean includeDijitCSS) {
        HTMLCommandTarget target = this.getCommandTarget();
        if (target == null) {
            return "";
        }
        String currentFileLoc = target.getActiveModel().getBaseLocation();
        IResource file = ResourcesPlugin.getWorkspace().getRoot().findMember(currentFileLoc);
        if (file == null) {
            return "";
        }
        IProject proj = file.getProject();
        if (proj == null) {
            return "";
        }
        try {
            boolean includeStyleElement;
            Object dojoRoot = DojoSettings.getDojoRoot((IProject)proj);
            String pathToDojoBootStrap = new Path(DojoSettings.getDojoLoaderJS((IProject)proj)).toString();
            String pathToDojoCSS = new Path(DojoSettings.getDojoCSS((IProject)proj)).toString();
            String pathToThemeCSS = new Path(DojoSettings.getThemeCSS((IProject)proj)).toString();
            String pathToDijitCSS = new Path(DojoSettings.getDijitCSS((IProject)proj)).toString();
            IPath currentFilePath = file.getFullPath();
            String dojoRootString = null;
            if (dojoRoot instanceof IPath) {
                dojoRootString = ((IPath)dojoRoot).toOSString();
                if (!dojoRootString.isEmpty()) {
                    if (!dojoRootString.endsWith(Path.ROOT.toString())) {
                        dojoRootString = dojoRootString.concat(Path.ROOT.toString());
                    }
                    dojoRootString = LinkUtils.makeRelative((String)("file:///" + dojoRootString), (IPath)currentFilePath, (boolean)false);
                }
            } else if (dojoRoot instanceof URL) {
                dojoRootString = ((URL)dojoRoot).toString();
                if (!dojoRootString.endsWith(Path.ROOT.toString())) {
                    dojoRootString = dojoRootString.concat(Path.ROOT.toString());
                }
            } else {
                Logger.log(4, "Incorrect DOJO properties settings in the project");
            }
            if (!pathToDojoBootStrap.isEmpty()) {
                pathToDojoBootStrap = this.concatStringPaths(dojoRootString, pathToDojoBootStrap, '/');
            }
            if (!pathToDojoCSS.isEmpty()) {
                pathToDojoCSS = this.concatStringPaths(dojoRootString, pathToDojoCSS, '/');
            }
            if (!pathToThemeCSS.isEmpty()) {
                pathToThemeCSS = this.concatStringPaths(dojoRootString, pathToThemeCSS, '/');
            }
            if (!pathToDijitCSS.isEmpty()) {
                pathToDijitCSS = this.concatStringPaths(dojoRootString, pathToDijitCSS, '/');
            }
            StringBuffer includeToInsert = new StringBuffer();
            if (includeBootStrap) {
                includeToInsert.append("<script type=\"text/javascript\" src=\"" + pathToDojoBootStrap + "\" djConfig=\"isDebug: false, parseOnLoad: true\"></script>");
            }
            includeDojoCSS = includeDojoCSS && pathToDojoCSS != null && !pathToDojoCSS.isEmpty();
            includeThemeCSS = includeThemeCSS && pathToThemeCSS != null && !pathToThemeCSS.isEmpty();
            includeDijitCSS = includeDijitCSS && pathToDijitCSS != null && !pathToDijitCSS.isEmpty();
            boolean bl = includeStyleElement = includeDojoCSS || includeThemeCSS || includeDijitCSS || !this.requiredCSSImports.isEmpty();
            if (includeStyleElement) {
                includeToInsert.append("<style type=\"text/css\">\n");
                if (includeDojoCSS) {
                    includeToInsert.append("@import \"" + pathToDojoCSS + "\";");
                }
                if (includeThemeCSS) {
                    includeToInsert.append("@import \"" + pathToThemeCSS + "\";");
                }
                if (includeDijitCSS) {
                    includeToInsert.append("@import \"" + pathToDijitCSS + "\";");
                }
                for (String cssImport : this.requiredCSSImports) {
                    includeToInsert.append("@import \"" + this.concatStringPaths(dojoRootString, cssImport.trim(), '/') + "\";");
                }
                includeToInsert.append("</style>");
            }
            return includeToInsert.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    protected IProject getTargetProject() {
        HTMLCommandTarget target = this.getCommandTarget();
        if (target == null) {
            return null;
        }
        String currentFileLoc = target.getActiveModel().getBaseLocation();
        IResource file = ResourcesPlugin.getWorkspace().getRoot().findMember(currentFileLoc);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    private String concatStringPaths(String first, String second, char separator) {
        String separatorString = String.valueOf(separator);
        String concatenation = null;
        concatenation = first.endsWith(separatorString) && second.startsWith(separatorString) ? first.replaceAll(String.valueOf(separator) + "$", "") : first;
        return concatenation.concat(second);
    }
}

