/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.ajax.library.internal.palette.dojo.actions;

import com.ibm.etools.webedit.commands.ImportSourceCommand;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ranges.Range;

public class ImportDojoRequiresSourceCommand
extends ImportSourceCommand {
    public ImportDojoRequiresSourceCommand(String source) {
        super(source);
    }

    protected void doExecute() {
        String requiredJavaScript = this.source;
        String aDojoRequireStmt = "dojo.require";
        Range range = this.getRange();
        boolean exactRequireStmtPresent = false;
        boolean anyOtherRequireStmtPresent = false;
        if (requiredJavaScript != null && requiredJavaScript.length() > 0) {
            String existingContent;
            if (range == null) {
                return;
            }
            Node endContainer = range.getEndContainer();
            Document doc = ImportDojoRequiresSourceCommand.getDocument((Node)endContainer);
            if (doc == null) {
                return;
            }
            Node scriptTagHavingDojoRequire = null;
            NodeList scriptTags = doc.getElementsByTagName("SCRIPT");
            int i = 0;
            while (i < scriptTags.getLength()) {
                Node scriptTag = scriptTags.item(i);
                String content = this.getTextContent(scriptTag);
                if (content.contains(requiredJavaScript)) {
                    exactRequireStmtPresent = true;
                    break;
                }
                if (content.contains(aDojoRequireStmt)) {
                    anyOtherRequireStmtPresent = true;
                    scriptTagHavingDojoRequire = scriptTag;
                }
                ++i;
            }
            if (exactRequireStmtPresent) {
                return;
            }
            if (anyOtherRequireStmtPresent && (existingContent = this.getTextContent(scriptTagHavingDojoRequire)) != null && existingContent.contains(aDojoRequireStmt)) {
                requiredJavaScript = this.mergeScriptContents(existingContent.trim(), requiredJavaScript);
                scriptTagHavingDojoRequire.getParentNode().removeChild(scriptTagHavingDojoRequire);
            }
            String SCRIPT_TAG_OPEN = "<script";
            String SCRIPT_TAG_CLOSE = "</script>";
            String HEAD_TAG_OPEN = "<head";
            String HEAD_TAG_CLOSE = "</head>";
            String TAG_END = ">";
            String SCRIPT_TAG_WITH_JS = SCRIPT_TAG_OPEN.concat(" type=\"text/javascript\">");
            String NL = "\n";
            if (!requiredJavaScript.toLowerCase().contains(SCRIPT_TAG_OPEN)) {
                requiredJavaScript = SCRIPT_TAG_WITH_JS.concat(NL).concat(requiredJavaScript).concat(NL).concat(SCRIPT_TAG_CLOSE).concat(NL);
            }
            if (!requiredJavaScript.toLowerCase().contains(HEAD_TAG_OPEN)) {
                requiredJavaScript = HEAD_TAG_OPEN.concat(TAG_END).concat(NL).concat(requiredJavaScript).concat(HEAD_TAG_CLOSE);
            }
            this.source = requiredJavaScript;
            super.doExecute();
        }
    }

    protected String getTextContent(Node node) {
        if (node == null) {
            return null;
        }
        String ret = "";
        if (node.getNodeType() == 1) {
            if (node.getNodeName().equalsIgnoreCase("BR")) {
                ret = String.valueOf(ret) + "\r\n";
            }
        } else if (node.getNodeType() == 3) {
            ret = node instanceof IDOMText ? String.valueOf(ret) + ((IDOMText)node).getValueSource() : String.valueOf(ret) + ((Text)node).getData();
        }
        Node child = node.getFirstChild();
        while (child != null) {
            ret = String.valueOf(ret) + this.getTextContent(child);
            child = child.getNextSibling();
        }
        return ret;
    }

    protected String mergeScriptContents(String scriptTag1, String scriptTag2) {
        if (!scriptTag1.endsWith("\n")) {
            return scriptTag1.concat("\n").concat(scriptTag2);
        }
        return scriptTag1.concat(scriptTag2);
    }
}

