/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.ajax.library.internal.palette.dojo.actions;

import com.ibm.etools.palette.model.PaletteItemData;
import com.ibm.etools.webedit.commands.ImportSourceCommand;
import com.ibm.etools.webedit.common.actions.CommandAction;
import com.ibm.etools.webedit.common.commands.CompoundHTMLCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.palette.PaletteItemInfo;
import com.ibm.etools.webedit.palette.PaletteItemInfoRegistry;
import com.ibm.etools.webtools.ajax.library.Logger;
import com.ibm.etools.webtools.ajax.library.internal.DojoDropActionRegistryReader;
import com.ibm.etools.webtools.ajax.library.internal.ResourceHandler;
import com.ibm.etools.webtools.ajax.library.internal.palette.AJAXLibraryManagerHelper;
import com.ibm.etools.webtools.ajax.library.internal.palette.dojo.actions.IDojoDropActionCommandDelegate;
import com.ibm.etools.webtools.ajax.library.internal.palette.dojo.actions.ImportDojoRequiresSourceCommand;
import com.ibm.etools.webtools.ajax.library.internal.palette.dojo.actions.InsertDojoIncludesCommand;
import com.ibm.etools.webtools.dojo.core.DojoSettings;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.IAction;

public class DojoDropAction
extends CommandAction {
    public DojoDropAction() {
        super(null, null);
    }

    protected Command getCommandForExec() {
        PaletteItemInfo paletteItem = PaletteItemInfoRegistry.getInstance().getPaletteItemInfo((IAction)this);
        IDojoDropActionCommandDelegate delegate = DojoDropActionRegistryReader.getDojoDropActionCommandDelegate();
        if (delegate != null) {
            return delegate.getDojoDropActionCommand((PaletteItemData)paletteItem, this.getTarget());
        }
        return this.getDefaultDojoDropActionCommand((PaletteItemData)paletteItem, this.getTarget());
    }

    private Command getDefaultDojoDropActionCommand(PaletteItemData paletteItem, HTMLEditDomain target) {
        String[] htmlPreloadRequireArray;
        Map properties = paletteItem.getProperties();
        if (properties == null || !properties.containsKey(AJAXLibraryManagerHelper.HTML_CONTENT)) {
            Logger.log(4, ResourceHandler._UI_Error_missing_html_content);
            return null;
        }
        String htmlSource = (String)properties.get(AJAXLibraryManagerHelper.HTML_CONTENT);
        if (htmlSource == null || htmlSource.length() == 0) {
            Logger.log(4, ResourceHandler._UI_Error_empty_html_content);
            return null;
        }
        htmlSource = this.processHtmlSource(htmlSource);
        CompoundHTMLCommand retCommand = new CompoundHTMLCommand(ResourceHandler.bind((String)ResourceHandler._UI_palette_insert_command_name, (Object)paletteItem.getLabel()));
        Set<String> htmlCSSRequires = this.getHTMLCSSRequires(properties);
        retCommand.append((HTMLCommand)new InsertDojoIncludesCommand(htmlCSSRequires));
        retCommand.append((HTMLCommand)new ImportSourceCommand(htmlSource));
        String[] stringArray = htmlPreloadRequireArray = this.getHTMLPreloadRequires(properties);
        int n = htmlPreloadRequireArray.length;
        int n2 = 0;
        while (n2 < n) {
            String reqStmt = stringArray[n2];
            retCommand.append((HTMLCommand)new ImportDojoRequiresSourceCommand(reqStmt));
            ++n2;
        }
        return retCommand;
    }

    private Set<String> getHTMLCSSRequires(Map<String, String> properties) {
        HashSet<String> result = new HashSet<String>();
        String htmlCSSRequires = properties.get(AJAXLibraryManagerHelper.HTML_REQUIRE_CSS);
        boolean hasCSSRequires = htmlCSSRequires != null;
        String[] htmlCSSRequireArray = new String[]{};
        if (hasCSSRequires) {
            htmlCSSRequireArray = htmlCSSRequires.split("\n");
        }
        String[] stringArray = htmlCSSRequireArray;
        int n = htmlCSSRequireArray.length;
        int n2 = 0;
        while (n2 < n) {
            String include = stringArray[n2];
            if (include != null && include.length() > 0) {
                result.add(include);
            }
            ++n2;
        }
        return result;
    }

    private String[] getHTMLPreloadRequires(Map<String, String> properties) {
        String htmlPreloadRequires = properties.get(AJAXLibraryManagerHelper.HTML_REQUIRE_PRELOAD);
        boolean hasPreloadRequires = htmlPreloadRequires != null;
        String[] htmlPreloadRequireArray = new String[]{};
        if (hasPreloadRequires) {
            htmlPreloadRequireArray = htmlPreloadRequires.split("\n");
        }
        return htmlPreloadRequireArray;
    }

    protected Command getCommandForUpdate() {
        return null;
    }

    protected String processHtmlSource(String htmlSource) {
        String themeName;
        String SIMPLE_BODY_TAG_OPEN = "<body".concat(">");
        if (htmlSource == null || htmlSource.length() == 0) {
            return htmlSource;
        }
        if (!htmlSource.toLowerCase().contains("<body")) {
            htmlSource = SIMPLE_BODY_TAG_OPEN.concat(htmlSource).concat("</body>");
        }
        if ((themeName = this.getDojoThemeName()) != null && !themeName.isEmpty()) {
            int bodyStart = htmlSource.indexOf("<body");
            String bodyTagString = htmlSource.substring(bodyStart, htmlSource.indexOf(">", bodyStart) + 1);
            String newBodyTagString = "";
            int insert = bodyTagString.indexOf("<body") + "<body".length();
            String classAttrValue = " class".concat("=\"" + themeName + "\"");
            newBodyTagString = bodyTagString.substring(0, insert).concat(classAttrValue).concat(bodyTagString.substring(insert));
            htmlSource = htmlSource.replace(bodyTagString, newBodyTagString);
        }
        return htmlSource;
    }

    protected String getDojoThemeName() {
        String themeName = null;
        HTMLEditDomain target = this.getTarget();
        themeName = DojoDropAction.getDojoThemeName(target);
        return themeName;
    }

    public static String getDojoThemeName(HTMLEditDomain editDomain) {
        String themeName = null;
        if (editDomain == null) {
            return null;
        }
        String targetLocation = editDomain.getActiveModel().getBaseLocation();
        if (targetLocation == null || targetLocation.isEmpty()) {
            return null;
        }
        IResource targetFile = ResourcesPlugin.getWorkspace().getRoot().findMember(targetLocation);
        if (targetFile == null || !targetFile.exists()) {
            return null;
        }
        IProject targetProject = targetFile.getProject();
        try {
            Path themeCSSPath;
            String themeCSS = DojoSettings.getThemeCSS((IProject)targetProject);
            if (themeCSS != null && (themeCSSPath = new Path(themeCSS)).isValidPath(themeCSS)) {
                themeCSSPath = themeCSSPath.removeFileExtension();
                themeName = themeCSSPath.lastSegment();
            }
        }
        catch (Exception exception) {}
        return themeName;
    }
}

