/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.ajax.library.internal.palette.dojo;

import com.ibm.etools.palette.model.PaletteData;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.palette.view.AbstractHTMLPaletteVisibilityInspector;
import com.ibm.etools.webtools.ajax.library.Logger;
import com.ibm.etools.webtools.ajax.library.internal.palette.AJAXLibraryManagerHelper;
import com.ibm.etools.webtools.dojo.core.DojoSettings;
import com.ibm.etools.webtools.dojo.core.DojoVersion;
import com.ibm.etools.webtools.scriptgrammar.core.ScriptGrammarCore;
import java.net.MalformedURLException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class DojoPaletteVisibilityInspector
extends AbstractHTMLPaletteVisibilityInspector {
    private DojoVersion getDojoVersionFromPaletteItem(String id) {
        DojoVersion ver = null;
        String verString = AJAXLibraryManagerHelper.getInstance().getVersionFromCategoryID(id);
        if (verString == null) {
            return null;
        }
        try {
            ver = new DojoVersion(verString.trim());
        }
        catch (NumberFormatException numberFormatException) {
            ver = null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ver = null;
        }
        return ver;
    }

    private boolean isDojoVisible(PaletteData item, HTMLEditDomain domain) {
        boolean isDojoEnabled;
        boolean hasCorrectDojoVersion = true;
        boolean hasDojoFacet = false;
        try {
            IProject project;
            IResource file;
            String modelLocation = domain.getActiveModel().getBaseLocation();
            if (modelLocation != null && (file = ResourcesPlugin.getWorkspace().getRoot().findMember(modelLocation)) != null && file.exists() && (project = file.getProject()) != null && this.isFacetInstalled(item, domain)) {
                hasDojoFacet = true;
                DojoVersion paletteItemVer = this.getDojoVersionFromPaletteItem(item.getId());
                DojoVersion projectVer = DojoSettings.getDojoVersion((IProject)project);
                if (paletteItemVer != null && projectVer != null && projectVer.compareTo(paletteItemVer) < 0) {
                    hasCorrectDojoVersion = false;
                }
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
            hasCorrectDojoVersion = false;
        }
        catch (MalformedURLException malformedURLException) {
            hasCorrectDojoVersion = false;
        }
        boolean bl = isDojoEnabled = ScriptGrammarCore.getInstance().getScriptGrammarProviders(domain.getActiveModel().getDocument()).length > 0;
        return hasCorrectDojoVersion && (hasDojoFacet || isDojoEnabled);
    }

    private boolean isFacetInstalled(PaletteData item, HTMLEditDomain domain) {
        boolean result = false;
        String modelLocation = domain.getActiveModel().getBaseLocation();
        IResource file = ResourcesPlugin.getWorkspace().getRoot().findMember(modelLocation);
        if (file != null && file.exists()) {
            IProject project = file.getProject();
            Object dojoRoot = null;
            try {
                dojoRoot = DojoSettings.getDojoRoot((IProject)project);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (dojoRoot != null) {
                result = true;
            }
        }
        return result;
    }

    public boolean isItemVisible(PaletteData item, HTMLEditDomain domain) {
        boolean result = false;
        result = this.isDojoVisible(item, domain);
        return result;
    }
}

