/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.ajax.library.internal;

import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webtools.ajax.library.AJAXLibraryPlugin;
import com.ibm.etools.webtools.ajax.library.internal.palette.dojo.actions.IDojoDropActionCommandDelegate;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class DojoDropActionRegistryReader {
    private static final String DOJO_DROP_ACTION_DELEGATE_EXT_PT = "facetDojoDropActionCommandDelegate";
    private static final String FACET = "facet";
    private static final String ID = "id";
    private static final String ATTR_CLASS = "delegateClass";
    private static final String OR = "or";
    protected static IConfigurationElement[] configElements;
    protected static List<String> interestingFacets;
    protected IProjectFacetVersion ajaxProxyFacetVersion = null;
    protected Object ajaxProxyConfig = null;

    static {
        interestingFacets = new ArrayList<String>();
    }

    public static IDojoDropActionCommandDelegate getDojoDropActionCommandDelegate() {
        IProject project;
        IExtensionRegistry extensionRegistry;
        IExtensionPoint extPoint;
        if (configElements == null && (extPoint = (extensionRegistry = Platform.getExtensionRegistry()).getExtensionPoint(AJAXLibraryPlugin.getDefault().getBundle().getSymbolicName(), DOJO_DROP_ACTION_DELEGATE_EXT_PT)) != null) {
            configElements = extPoint.getConfigurationElements();
        }
        if ((project = DojoDropActionRegistryReader.getCurrentlyWorkingProject()) == null) {
            return null;
        }
        IConfigurationElement matchingElement = DojoDropActionRegistryReader.findMatchingElement(project);
        if (matchingElement != null && matchingElement.getAttribute(ATTR_CLASS) != null) {
            try {
                IDojoDropActionCommandDelegate dojoDropActionCommandDelegate = (IDojoDropActionCommandDelegate)matchingElement.createExecutableExtension(ATTR_CLASS);
                return dojoDropActionCommandDelegate;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbench w = PlatformUI.getWorkbench();
        if (w == null) {
            return null;
        }
        IWorkbenchWindow ww = w.getActiveWorkbenchWindow();
        return ww != null ? ww.getActivePage() : null;
    }

    private static IEditorPart getActiveEditorPart() {
        IWorkbenchPage p = DojoDropActionRegistryReader.getActiveWorkbenchPage();
        return p != null ? p.getActiveEditor() : null;
    }

    private static IProject getCurrentlyWorkingProject() {
        IResource file;
        IEditorPart editorPart = DojoDropActionRegistryReader.getActiveEditorPart();
        String modelLocation = null;
        if (editorPart != null && editorPart instanceof HTMLEditDomain) {
            modelLocation = ((HTMLEditDomain)editorPart).getActiveModel().getBaseLocation();
        }
        if (modelLocation != null && (file = ResourcesPlugin.getWorkspace().getRoot().findMember(modelLocation)) != null && file.exists()) {
            return file.getProject();
        }
        return null;
    }

    protected static IConfigurationElement findMatchingElement(IProject project) {
        IConfigurationElement matchingElement = null;
        int i = 0;
        while (i < configElements.length) {
            matchingElement = DojoDropActionRegistryReader.validateElement(configElements[i], project);
            if (matchingElement != null) break;
            ++i;
        }
        return matchingElement;
    }

    protected static IConfigurationElement validateElement(IConfigurationElement element, IProject project) {
        String mgrClass = element.getAttribute(ATTR_CLASS);
        if (mgrClass != null) {
            IConfigurationElement[] ordGroups;
            boolean matchFacets = true;
            boolean matchAllOrdFacets = true;
            IConfigurationElement[] iConfigurationElementArray = ordGroups = element.getChildren(OR);
            int n = ordGroups.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] facets;
                IConfigurationElement orGroup = iConfigurationElementArray[n2];
                boolean matchThisGroup = false;
                IConfigurationElement[] iConfigurationElementArray2 = facets = orGroup.getChildren(FACET);
                int n3 = facets.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement facet = iConfigurationElementArray2[n4];
                    String id = facet.getAttribute(ID);
                    if (!interestingFacets.contains(id)) {
                        interestingFacets.add(id);
                    }
                    if (DojoDropActionRegistryReader.projectHasFacet(project, id, null)) {
                        matchThisGroup = true;
                        break;
                    }
                    ++n4;
                }
                if (!matchThisGroup) {
                    matchAllOrdFacets = false;
                    matchFacets = false;
                    break;
                }
                ++n2;
            }
            if (matchAllOrdFacets) {
                IConfigurationElement[] facets;
                IConfigurationElement[] iConfigurationElementArray3 = facets = element.getChildren(FACET);
                int n5 = facets.length;
                n = 0;
                while (n < n5) {
                    IConfigurationElement facetElement = iConfigurationElementArray3[n];
                    String id = facetElement.getAttribute(ID);
                    if (!interestingFacets.contains(id)) {
                        interestingFacets.add(id);
                    }
                    if (!DojoDropActionRegistryReader.projectHasFacet(project, id, null)) {
                        matchFacets = false;
                        break;
                    }
                    ++n;
                }
                if (matchFacets) {
                    return element;
                }
            }
        }
        return null;
    }

    private static boolean projectHasFacet(IProject project, String facetID, String facetVersion) {
        boolean hasFacet = false;
        if (ProjectFacetsManager.isProjectFacetDefined((String)facetID)) {
            IProjectFacet requiredFacet;
            IFacetedProject facetedProject = null;
            try {
                facetedProject = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
            if (facetedProject != null && (requiredFacet = ProjectFacetsManager.getProjectFacet((String)facetID)) != null) {
                if (facetVersion != null) {
                    IProjectFacetVersion requiredFacetVersion = requiredFacet.getVersion(facetVersion);
                    if (requiredFacetVersion != null) {
                        hasFacet = facetedProject.hasProjectFacet(requiredFacetVersion);
                    }
                } else {
                    hasFacet = facetedProject.hasProjectFacet(requiredFacet);
                }
            }
        }
        return hasFacet;
    }
}

