/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ejb.common.widgets;

import com.ibm.etools.webservice.was.creation.ejb.common.messages.Messages;
import com.ibm.etools.webservice.was.creation.ejb.common.task.JMSURLParser;
import com.ibm.etools.webservice.was.creation.ejb.common.util.EJBRouterComboUtil;
import com.ibm.etools.webservice.was.creation.ejb.common.widgets.CanFinishCondition;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class EjbSkeletonConfigWidget
extends SimpleWidgetDataContributor {
    private String pluginId = "com.ibm.etools.webservice.was.creation.ejb.common";
    private JavaWSDLParameterBase javaWSDLParam;
    private IProject project;
    private IProject routerProject;
    private static final String INFOPOP_PBCF_PAGE = "com.ibm.etools.webservice.was.creation.ejb.common.PBSC0001";
    private Text wsdlBindingText = null;
    private String INFOPOP_PBSC_TEXT_WSDL_BINDING = "com.ibm.etools.webservice.was.creation.ejb.common.PBSC0020";
    private Button switchBindingCheckBox = null;
    private String INFOPOP_PBSC_CHECKBOX_SWITCH_BINDING = "com.ibm.etools.webservice.was.creation.ejb.common.PBSC0021";
    private Label httpRouterProjectLabel;
    private Combo httpRouterProjectCombo = null;
    private String INFOPOP_PBSC_COMBO_ROUTER_HTTP = "com.ibm.etools.webservice.was.creation.ejb.common.PBSC0022";
    private Label jmsRouterProjectLabel;
    private Combo jmsRouterProjectCombo = null;
    private String INFOPOP_PBSC_COMBO_ROUTER_JMS = "com.ibm.etools.webservice.was.creation.ejb.common.PBSC0023";
    private Combo securityTypeCombo_;
    private String INFOPOP_PBCF_COMBO_SECURITYTYPE = "PBCF0015";
    private Button addRemoteClientViewCheckBox_;
    private String INFOPOP_PBSC_ADD_REMOTE_CLIENT_VIEW = "com.ibm.etools.webservice.was.creation.ejb.common.PBSC0024";
    private Button showMappingsCheckbox_;
    private String INFOPOP_N2P_SHOW_MAPPINGS = "com.ibm.etools.webservice.was.creation.ejb.common.PBSC0016";
    private CanFinishCondition canFinish;
    private String earProjectName;
    private Listener statusListener_;
    private boolean httpBinding = false;
    private boolean jmsBinding = false;
    private boolean ejbBinding = false;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        UIUtils uiUtils = new UIUtils(this.pluginId);
        WorkbenchHelp.setHelp((Control)parent, (String)(String.valueOf(this.pluginId) + "." + INFOPOP_PBCF_PAGE));
        parent.setToolTipText(Messages.TOOLTIP_PBSC_PAGE);
        TextBoxModifyListener modifyListener = new TextBoxModifyListener();
        this.statusListener_ = statusListener;
        Group bindingGroup = uiUtils.createGroup(parent, Messages.LABEL_BINDINGS_ROUTERS, Messages.TOOLTIP_BINDINGS_ROUTERS, null);
        Composite composite = uiUtils.createComposite((Composite)bindingGroup, 2);
        this.wsdlBindingText = uiUtils.createText(composite, Messages.LABEL_WSDL_BINDINGS, Messages.TOOLTIP_WSDL_BINDINGS, null, 2060);
        composite = uiUtils.createComposite((Composite)bindingGroup, 2);
        this.switchBindingCheckBox = uiUtils.createCheckbox(composite, Messages.LABEL_SWITCH_HTTP_BINDING, Messages.LABEL_SWITCH_JMS_BINDING, null);
        this.switchBindingCheckBox.setEnabled(false);
        this.switchBindingCheckBox.addSelectionListener((SelectionListener)new SwitchBindingSelectionListener());
        composite = uiUtils.createComposite((Composite)bindingGroup, 2);
        this.httpRouterProjectLabel = this.createLabel(composite, Messages.LABEL_ROUTER_HTTP, Messages.TOOLTIP_COMBO_ROUTER_HTTP);
        this.httpRouterProjectCombo = uiUtils.createCombo(composite, null, Messages.TOOLTIP_COMBO_ROUTER_HTTP, this.INFOPOP_PBSC_COMBO_ROUTER_HTTP, 0);
        this.httpRouterProjectCombo.addModifyListener((ModifyListener)modifyListener);
        this.httpRouterProjectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                EjbSkeletonConfigWidget.this.handleRouterProjectComboEvent();
            }
        });
        this.httpRouterProjectCombo.setEnabled(false);
        this.httpRouterProjectLabel.setEnabled(false);
        this.jmsRouterProjectLabel = this.createLabel(composite, Messages.LABEL_ROUTER_JMS, Messages.TOOLTIP_COMBO_ROUTER_JMS);
        this.jmsRouterProjectCombo = uiUtils.createCombo(composite, null, Messages.TOOLTIP_COMBO_ROUTER_JMS, this.INFOPOP_PBSC_COMBO_ROUTER_JMS, 0);
        this.jmsRouterProjectCombo.addModifyListener((ModifyListener)modifyListener);
        this.jmsRouterProjectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                EjbSkeletonConfigWidget.this.handleRouterProjectComboEvent();
            }
        });
        this.jmsRouterProjectCombo.setEnabled(false);
        this.jmsRouterProjectLabel.setEnabled(false);
        composite = uiUtils.createComposite(parent, 2, 10, 0);
        this.securityTypeCombo_ = uiUtils.createCombo(composite, Messages.LABEL_SECURITY_CONFIG, Messages.TOOLTIP_PBCF_COMBO_SECURITYTYPE, this.INFOPOP_PBCF_COMBO_SECURITYTYPE, 2060);
        this.securityTypeCombo_.add(Messages.COMBO_WS_SECURITY_NONE, 0);
        this.securityTypeCombo_.add(Messages.COMBO_WS_SECURITY_DSIG, 1);
        this.securityTypeCombo_.add(Messages.COMBO_WS_SECURITY_ENC, 2);
        this.securityTypeCombo_.select(0);
        this.addRemoteClientViewCheckBox_ = uiUtils.createCheckbox(parent, Messages.LABEL_ADD_REMOTE_CLIENT_VIEW, Messages.TOOLTIP_ADD_REMOTE_CLIENT_VIEW, this.INFOPOP_PBSC_ADD_REMOTE_CLIENT_VIEW);
        this.addRemoteClientViewCheckBox_.setSelection(true);
        this.showMappingsCheckbox_ = uiUtils.createCheckbox(parent, Messages.LABEL_EXPLORE_MAPPINGS_XML2BEAN, Messages.TOOLTIP_N2P_SHOW_MAPPINGS, this.INFOPOP_N2P_SHOW_MAPPINGS);
        return this;
    }

    private void handleTransportSelectionEvent() {
    }

    private void handleMDBDeploymentEvent() {
        this.statusListener_.handleEvent(null);
    }

    public void setShowMapping(boolean showMapping) {
        this.showMappingsCheckbox_.setSelection(showMapping);
    }

    public boolean getShowMapping() {
        if (this.showMappingsCheckbox_ == null) {
            return false;
        }
        return this.showMappingsCheckbox_.getSelection();
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        this.javaWSDLParam.setSecurityConfig((byte)this.securityTypeCombo_.getSelectionIndex());
        this.javaWSDLParam.setSwitchBinding(this.switchBindingCheckBox.getSelection());
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
        this.httpBinding = false;
        this.ejbBinding = false;
        this.jmsBinding = false;
        new JMSURLParser();
        String jmsLocation = javaWSDLParam.getJmsLocation();
        StringBuffer bindingTypes = new StringBuffer();
        int indexHttp = javaWSDLParam.getBindingTypes().indexOf("http");
        int indexJms = javaWSDLParam.getBindingTypes().indexOf("jms");
        int indexEjb = javaWSDLParam.getBindingTypes().indexOf("ejb");
        if (indexHttp != -1) {
            this.httpBinding = true;
            this.httpRouterProjectCombo.setEnabled(true);
            this.httpRouterProjectLabel.setEnabled(true);
            bindingTypes.append("HTTP");
        }
        if (indexJms != -1) {
            this.jmsBinding = true;
            this.jmsRouterProjectCombo.setEnabled(true);
            this.jmsRouterProjectLabel.setEnabled(true);
            if (bindingTypes.length() != 0) {
                bindingTypes.append(", ");
            }
            bindingTypes.append("JMS");
        }
        if (indexEjb != -1) {
            this.ejbBinding = true;
            if (bindingTypes.length() != 0) {
                bindingTypes.append(", ");
            }
            bindingTypes.append("EJB");
        }
        if (!this.ejbBinding && (this.httpBinding && !this.jmsBinding || !this.httpBinding && this.jmsBinding)) {
            if (this.httpBinding) {
                this.switchBindingCheckBox.setText(Messages.LABEL_SWITCH_JMS_BINDING);
            } else if (this.jmsBinding) {
                this.switchBindingCheckBox.setText(Messages.LABEL_SWITCH_HTTP_BINDING);
            }
            this.switchBindingCheckBox.setEnabled(true);
        }
        this.switchBindingCheckBox.setSelection(javaWSDLParam.getSwitchBinding());
        this.wsdlBindingText.setText(bindingTypes.toString());
        if (javaWSDLParam.getJ2eeLevel().equals("1.4")) {
            this.securityTypeCombo_.add(Messages.COMBO_WS_SECURITY_DSIG_ENC, 3);
            this.addRemoteClientViewCheckBox_.setVisible(true);
        } else {
            this.addRemoteClientViewCheckBox_.setVisible(false);
        }
    }

    public void setServiceProject(IProject project_) {
        this.project = project_;
        if (this.earProjectName != null && this.project != null) {
            this.prepareRouterProjectComboList();
        }
    }

    private void handleRouterProjectComboEvent() {
    }

    private void prepareRouterProjectComboList() {
        List httpRouters = EJBRouterComboUtil.getAppropriateHttpRouterProjects(this.earProjectName, this.project.getName());
        List jmsRouters = EJBRouterComboUtil.getAvailableJmsRouterComponents(this.earProjectName);
        this.httpRouterProjectCombo.removeAll();
        int j = 0;
        while (j < httpRouters.size()) {
            IProject webProject = ((IVirtualComponent)httpRouters.get(j)).getProject();
            this.httpRouterProjectCombo.add(webProject.getName());
            ++j;
        }
        this.jmsRouterProjectCombo.removeAll();
        j = 0;
        while (j < jmsRouters.size()) {
            IProject ejbProject = ((IVirtualComponent)jmsRouters.get(j)).getProject();
            if (ejbProject != this.project) {
                this.jmsRouterProjectCombo.add(ejbProject.getName());
            }
            ++j;
        }
        if (this.httpRouterProjectCombo.getItemCount() == 0) {
            this.httpRouterProjectCombo.add(String.valueOf(this.project.getName()) + "HttpRouter");
        }
        if (this.jmsRouterProjectCombo.getItemCount() == 0) {
            this.jmsRouterProjectCombo.add(String.valueOf(this.project.getName()) + "JmsRouter");
        }
        this.httpRouterProjectCombo.select(0);
        this.jmsRouterProjectCombo.select(0);
        this.statusListener_.handleEvent(null);
    }

    public IProject getHttpRouterProject() {
        String serviceProjectName = this.httpRouterProjectCombo.getText();
        this.routerProject = this.project.getWorkspace().getRoot().getProject(serviceProjectName);
        return this.routerProject;
    }

    public byte getWsSecurityConfig() {
        return (byte)this.securityTypeCombo_.getSelectionIndex();
    }

    public void setCanFinish(CanFinishCondition canFinish) {
        this.canFinish = canFinish;
    }

    public String getHttpRouterProjectName() {
        return this.httpRouterProjectCombo.getText();
    }

    public String getHttpRouterModuleName() {
        return this.httpRouterProjectCombo.getText();
    }

    public String getJmsRouterProjectName() {
        return this.jmsRouterProjectCombo.getText();
    }

    public String getJmsRouterModuleName() {
        return this.jmsRouterProjectCombo.getText();
    }

    public String getEarProjectName() {
        return this.earProjectName;
    }

    public void setEarProjectName(String earProjectName) {
        this.earProjectName = earProjectName;
        if (earProjectName != null && this.project != null) {
            this.prepareRouterProjectComboList();
        }
    }

    public boolean getJMSBindingEnabled() {
        if (this.switchBindingCheckBox == null) {
            return false;
        }
        return this.ejbBinding || this.jmsBinding && !this.switchBindingCheckBox.getSelection() || this.httpBinding && this.switchBindingCheckBox.getSelection();
    }

    public IStatus getStatus() {
        IStatus finalStatus = Status.OK_STATUS;
        if (this.getHttpRouterProjectName().equals("")) {
            finalStatus = StatusUtils.errorStatus((String)Messages.MSG_ERROR_SPECIFY_ROUTER_PROJECT);
            return finalStatus;
        }
        return finalStatus;
    }

    private Label createLabel(Composite parent, String labelName, String tooltip) {
        Label label = new Label(parent, 64);
        label.setText(labelName);
        label.setToolTipText(tooltip);
        return label;
    }

    public boolean getAddRemoteClientView() {
        return this.addRemoteClientViewCheckBox_.getSelection();
    }

    private class SwitchBindingSelectionListener
    extends SelectionAdapter {
        private SwitchBindingSelectionListener() {
        }

        public void widgetSelected(SelectionEvent evt) {
            if (!EjbSkeletonConfigWidget.this.ejbBinding && EjbSkeletonConfigWidget.this.httpBinding && !EjbSkeletonConfigWidget.this.jmsBinding) {
                if (EjbSkeletonConfigWidget.this.switchBindingCheckBox.getSelection()) {
                    EjbSkeletonConfigWidget.this.httpRouterProjectCombo.setEnabled(false);
                    EjbSkeletonConfigWidget.this.httpRouterProjectLabel.setEnabled(false);
                    EjbSkeletonConfigWidget.this.jmsRouterProjectCombo.setEnabled(true);
                    EjbSkeletonConfigWidget.this.jmsRouterProjectLabel.setEnabled(true);
                } else {
                    EjbSkeletonConfigWidget.this.httpRouterProjectCombo.setEnabled(true);
                    EjbSkeletonConfigWidget.this.httpRouterProjectLabel.setEnabled(true);
                    EjbSkeletonConfigWidget.this.jmsRouterProjectCombo.setEnabled(false);
                    EjbSkeletonConfigWidget.this.jmsRouterProjectLabel.setEnabled(false);
                }
            } else if (!EjbSkeletonConfigWidget.this.ejbBinding && !EjbSkeletonConfigWidget.this.httpBinding && EjbSkeletonConfigWidget.this.jmsBinding) {
                if (EjbSkeletonConfigWidget.this.switchBindingCheckBox.getSelection()) {
                    EjbSkeletonConfigWidget.this.httpRouterProjectCombo.setEnabled(true);
                    EjbSkeletonConfigWidget.this.httpRouterProjectLabel.setEnabled(true);
                    EjbSkeletonConfigWidget.this.jmsRouterProjectCombo.setEnabled(false);
                    EjbSkeletonConfigWidget.this.jmsRouterProjectLabel.setEnabled(false);
                } else {
                    EjbSkeletonConfigWidget.this.httpRouterProjectCombo.setEnabled(false);
                    EjbSkeletonConfigWidget.this.httpRouterProjectLabel.setEnabled(false);
                    EjbSkeletonConfigWidget.this.jmsRouterProjectCombo.setEnabled(true);
                    EjbSkeletonConfigWidget.this.jmsRouterProjectLabel.setEnabled(true);
                }
            }
            EjbSkeletonConfigWidget.this.statusListener_.handleEvent(null);
        }
    }

    private class TextBoxModifyListener
    implements ModifyListener {
        private TextBoxModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            EjbSkeletonConfigWidget.this.statusListener_.handleEvent(null);
        }
    }
}

