/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ejb.common.command;

import com.ibm.etools.webservice.was.consumption.plugin.WebServiceWasConsumptionPlugin;
import com.ibm.etools.webservice.was.consumption.util.PlatformUtils;
import com.ibm.etools.webservice.was.creation.ejb.common.messages.Messages;
import com.ibm.etools.webservice.was.creation.ejb.common.util.EJBRouterComboUtil;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;
import org.eclipse.wst.ws.internal.preferences.PersistentMergeContext;

public class DefaultsForWSDL2SkeletonEJBTask
extends AbstractDataModelOperation {
    private JavaWSDLParameterBase javaWSDLParam = null;
    private String eJBProjectName;
    private IProject project = null;
    private IPath moduleServerRoot = null;
    private String earProjectName;

    public String getOutputWSDLFolder() {
        StringBuffer sb = new StringBuffer(this.moduleServerRoot.addTrailingSeparator().toString());
        sb.append("wsdl");
        return sb.toString();
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        if (this.eJBProjectName != null) {
            IPath ejbProjectPath = new Path(this.eJBProjectName).makeAbsolute();
            this.project = ResourceUtils.getProjectOf((IPath)ejbProjectPath);
        }
        this.javaWSDLParam.setProject(this.project);
        if (this.project == null) {
            StatusUtils.errorStatus((String)Messages.PAGE_MSG_PROJECT_NOT_SPECIFIED);
        }
        J2EEUtils.createEJBDeploymentDescriptor((IProject)this.project);
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.project);
        IVirtualFolder ivFolder = J2EEUtils.getEJBDeploymentDescriptorFolder((IVirtualComponent)component);
        this.moduleServerRoot = this.project.getFullPath().append(ivFolder.getParent().getProjectRelativePath());
        if (this.moduleServerRoot == null) {
            return StatusUtils.errorStatus((String)Messages.MSG_ERROR_DEFAULT_EJB);
        }
        String output = PlatformUtils.getPlatformURL((IPath)this.moduleServerRoot);
        this.javaWSDLParam.setOutput(output);
        this.javaWSDLParam.setTempOutput(J2EEUtils.getFileURL((File)J2EEUtils.createTempDir()));
        EJBArtifactEdit artifactEdit = null;
        IVirtualComponent ejbClientComponent = null;
        try {
            artifactEdit = EJBArtifactEdit.getEJBArtifactEditForRead((IVirtualComponent)component);
            ejbClientComponent = artifactEdit.getEJBClientJarModule();
        }
        finally {
            if (artifactEdit != null) {
                artifactEdit.dispose();
            }
        }
        String ejbClientOutput = null;
        String deploymentOutput = null;
        if (ejbClientComponent != null && ejbClientComponent.exists()) {
            IProject ejbClientProject = ejbClientComponent.getProject();
            IPackageFragmentRoot[] iPkgFragment = J2EEProjectUtilities.getSourceContainers((IProject)ejbClientComponent.getProject());
            IPath ejbClientPath = JemProjectUtilities.getSourcePathOrFirst((IProject)ejbClientProject, null);
            if (iPkgFragment != null && iPkgFragment.length > 0) {
                ejbClientPath = iPkgFragment[0].getPath();
                ejbClientOutput = PlatformUtils.getPlatformURL((IPath)ejbClientPath);
            } else if (ejbClientPath != null) {
                ejbClientPath = ejbClientProject.getFullPath().append(ejbClientPath);
                ejbClientOutput = PlatformUtils.getPlatformURL((IPath)ejbClientPath);
            }
            deploymentOutput = J2EEUtils.hasWasXDocletSupport((IProject)this.project) ? PlatformUtils.getPlatformURL((IPath)ejbClientProject.getFolder("gen/src").getFullPath()) : ejbClientOutput;
        } else {
            IPath ejbClientPath;
            IPackageFragmentRoot[] iPkgFragment = J2EEProjectUtilities.getSourceContainers((IProject)component.getProject());
            if (iPkgFragment != null && iPkgFragment.length > 0) {
                ejbClientPath = iPkgFragment[0].getPath();
                ejbClientOutput = PlatformUtils.getPlatformURL((IPath)ejbClientPath);
            } else {
                ejbClientPath = JemProjectUtilities.getSourcePathOrFirst((IProject)this.project, null);
                ejbClientOutput = PlatformUtils.getPlatformURL((IPath)this.project.getFullPath().append(ejbClientPath));
            }
            deploymentOutput = ejbClientOutput;
        }
        this.javaWSDLParam.setDevelopServerJavaOutput(ejbClientOutput);
        this.javaWSDLParam.setJavaOutput(deploymentOutput);
        this.javaWSDLParam.setNoDataBinding(WebServiceWasConsumptionPlugin.getInstance().getCodeGenerationContext().isNoDataBindings());
        PersistentMergeContext mergeContext = WSPlugin.getInstance().getMergeContext();
        if (mergeContext.isSkeletonMergeEnabled()) {
            StringBuffer tmpJavaOutput = new StringBuffer(this.javaWSDLParam.getTempOutput());
            tmpJavaOutput.append("src");
            tmpJavaOutput.append(File.separator);
            this.javaWSDLParam.setTempJavaOutput(tmpJavaOutput.toString());
        }
        return Status.OK_STATUS;
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setEJBProjectName(String projectName) {
        this.eJBProjectName = projectName;
    }

    public String getEarProjectName() {
        return this.earProjectName;
    }

    public void setEarProjectName(String earProjectName) {
        this.earProjectName = earProjectName;
    }

    public String getDefaultHttpRouterProjectName() {
        List httpComponents = EJBRouterComboUtil.getAppropriateHttpRouterProjects(this.earProjectName, this.eJBProjectName);
        if (httpComponents.size() > 0) {
            return ((IVirtualComponent)httpComponents.get(0)).getProject().getName();
        }
        return String.valueOf(this.eJBProjectName) + "HttpRouter";
    }

    public String getDefaultJmsRouterProjectName() {
        List jmsComponents = EJBRouterComboUtil.getAppropriateJmsRouterProjects(this.earProjectName, this.eJBProjectName);
        if (jmsComponents.size() > 0) {
            return ((IVirtualComponent)jmsComponents.get(0)).getProject().getName();
        }
        return String.valueOf(this.eJBProjectName) + "JmsRouter";
    }
}

