/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ejb.common.command;

import com.ibm.ast.ws.rd.utils.CreateModuleCommand;
import com.ibm.etools.webservice.was.creation.ejb.common.messages.Messages;
import com.ibm.etools.webservice.was.creation.ejb.common.util.EJBRouterComboUtil;
import com.ibm.etools.webservice.was.emitterdata.JavaWSDLParameterBase;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class CreateRouterProjectCommand
extends AbstractDataModelOperation {
    private String earProjectName_;
    private String ejbProjectName_;
    private String httpRouterProjectName_ = null;
    private String jmsRouterProjectName_;
    private String j2eeVersion_ = null;
    private String serverId;
    private String serverFactoryId;
    private JavaWSDLParameterBase javaWSDLParam = null;
    private boolean httpRouterCreated = false;
    private boolean jmsRouterCreated = false;
    private boolean httpBinding = false;
    private boolean jmsBinding = false;
    private boolean ejbBinding = false;

    public CreateRouterProjectCommand() {
    }

    public CreateRouterProjectCommand(String id) {
        this();
        this.setID(id);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IVirtualComponent httpComponent;
        IWorkspaceRoot root;
        IEnvironment env = super.getEnvironment();
        if (this.ejbBinding && !this.httpBinding && !this.jmsBinding) {
            return Status.OK_STATUS;
        }
        if (this.httpRouterProjectName_ == null || this.httpRouterProjectName_.equals("")) {
            IStatus status = StatusUtils.errorStatus((String)Messages.MSG_ERROR_SPECIFY_ROUTER_PROJECT);
            env.getStatusHandler().reportError(status);
            return status;
        }
        boolean httpRouterExists = false;
        boolean jmsRouterExists = false;
        if (this.jmsBinding) {
            List jmsRouterProjectComponents = EJBRouterComboUtil.getAvailableJmsRouterComponents(this.earProjectName_);
            root = ResourcesPlugin.getWorkspace().getRoot();
            IProject jmsProject = root.getProject(this.jmsRouterProjectName_);
            httpComponent = ComponentCore.createComponent((IProject)jmsProject);
            int i = 0;
            while (i < jmsRouterProjectComponents.size()) {
                if (jmsRouterProjectComponents.get(i).equals(httpComponent)) {
                    jmsRouterExists = true;
                    break;
                }
                ++i;
            }
            if (!jmsRouterExists) {
                IStatus status = this.createEjbProject(env, monitor, adaptable);
                this.jmsRouterCreated = true;
                if (status.getSeverity() == 4) {
                    return status;
                }
            }
        }
        if (this.httpBinding) {
            List httpRouterProjectComponents = EJBRouterComboUtil.getAvailableHttpRouterComponents(this.earProjectName_);
            root = ResourcesPlugin.getWorkspace().getRoot();
            IProject httpProject = root.getProject(this.httpRouterProjectName_);
            httpComponent = ComponentCore.createComponent((IProject)httpProject);
            int i = 0;
            while (i < httpRouterProjectComponents.size()) {
                if (httpRouterProjectComponents.get(i).equals(httpComponent)) {
                    httpRouterExists = true;
                    break;
                }
                ++i;
            }
            if (!httpRouterExists) {
                IStatus status = this.createWebProject(env, monitor, adaptable);
                this.httpRouterCreated = true;
                if (status.getSeverity() == 4) {
                    return status;
                }
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus createWebProject(IEnvironment env, IProgressMonitor monitor, IAdaptable adaptable) {
        CreateModuleCommand createCmd = new CreateModuleCommand();
        createCmd.setModuleType((byte)0);
        createCmd.setProjectName(this.httpRouterProjectName_);
        createCmd.setJ2eeLevel(this.j2eeVersion_);
        createCmd.setServerFactoryId(this.serverFactoryId);
        createCmd.setServerInstanceId(this.serverId);
        createCmd.setEnvironment(env);
        IStatus status = createCmd.execute(monitor, adaptable);
        if (status.getSeverity() == 4) {
            env.getStatusHandler().reportError(status);
        }
        return status;
    }

    private IStatus createEjbProject(IEnvironment env, IProgressMonitor monitor, IAdaptable adaptable) {
        CreateModuleCommand createCmd = new CreateModuleCommand();
        createCmd.setModuleType((byte)1);
        createCmd.setProjectName(this.jmsRouterProjectName_);
        createCmd.setJ2eeLevel(this.j2eeVersion_);
        createCmd.setServerFactoryId(this.serverFactoryId);
        createCmd.setServerInstanceId(this.serverId);
        createCmd.setEnvironment(env);
        IStatus status = createCmd.execute(monitor, adaptable);
        if (status.getSeverity() == 4) {
            env.getStatusHandler().reportError(status);
        }
        return status;
    }

    public void setEarProjectName(String earProjectName) {
        this.earProjectName_ = earProjectName;
    }

    public void setHttpRouterProjectName(String routerProjectName) {
        this.httpRouterProjectName_ = routerProjectName;
    }

    public String getHttpRouterProjectName() {
        return this.httpRouterProjectName_;
    }

    public void setJmsRouterProjectName(String routerProjectName) {
        this.jmsRouterProjectName_ = routerProjectName;
    }

    public String getJmsRouterProjectName() {
        return this.jmsRouterProjectName_;
    }

    public void setJ2EEVersion(String j2eeVersion) {
        this.j2eeVersion_ = j2eeVersion;
    }

    public String getServerFactoryId() {
        return this.serverFactoryId;
    }

    public void setServerFactoryId(String serverFactoryId) {
        this.serverFactoryId = serverFactoryId;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public JavaWSDLParameterBase getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameterBase javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
        this.httpBinding = false;
        this.jmsBinding = false;
        this.ejbBinding = false;
        if (javaWSDLParam.getBindingTypes() != null) {
            int indexHttp = javaWSDLParam.getBindingTypes().indexOf("http");
            int indexJms = javaWSDLParam.getBindingTypes().indexOf("jms");
            int indexEjb = javaWSDLParam.getBindingTypes().indexOf("ejb");
            if (indexHttp != -1) {
                if (javaWSDLParam.getSwitchBinding()) {
                    this.jmsBinding = true;
                } else {
                    this.httpBinding = true;
                }
            }
            if (indexJms != -1) {
                if (javaWSDLParam.getSwitchBinding()) {
                    this.httpBinding = true;
                } else {
                    this.jmsBinding = true;
                }
            }
            if (indexEjb != -1) {
                this.ejbBinding = true;
            }
        } else if (javaWSDLParam.getTransport().equals("http")) {
            this.httpBinding = true;
        } else if (javaWSDLParam.getTransport().equals("jms")) {
            this.jmsBinding = true;
        }
    }

    public boolean getRouterCreated() {
        return this.httpRouterCreated || this.jmsRouterCreated;
    }

    public void setEJBProjectName(String ejbProjectName_) {
        this.ejbProjectName_ = ejbProjectName_;
    }
}

