/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.was.creation.ejb.common.command;

import com.ibm.etools.webservice.was.creation.ejb.common.plugin.WebServiceWasCreationEJBCommonPlugin;
import com.ibm.etools.webservice.was.utils.J2EEUtils;
import com.ibm.etools.webservice.was.utils.StatusUtils;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.ws.internal.wsrt.IWebService;

public class BUEJBWASInputCommand
extends AbstractDataModelOperation {
    private IWebService ws_;
    private String serverProject_;
    private String earProject_;
    private String ejbName_;
    private String serviceJ2EEVersion_;
    private String serviceServerTypeID_;
    private String serverInstanceId_;
    private String wasFacet_;

    public BUEJBWASInputCommand() {
    }

    public BUEJBWASInputCommand(IWebService ws, String project, String earProject) {
        this.ws_ = ws;
        this.serverProject_ = project;
        this.earProject_ = earProject;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        this.serviceJ2EEVersion_ = J2EEUtils.getJ2EEVersion((String)this.serverProject_);
        this.serverInstanceId_ = this.ws_.getWebServiceInfo().getServerInstanceId();
        String serverFactoryId = this.ws_.getWebServiceInfo().getServerFactoryId();
        this.ejbName_ = this.ws_.getWebServiceInfo().getImplURL();
        IServer serviceExistingServer = null;
        if (this.serverInstanceId_ != null) {
            serviceExistingServer = ServerCore.findServer((String)this.serverInstanceId_);
            if (serviceExistingServer != null) {
                this.serviceServerTypeID_ = serviceExistingServer.getServerType().getId();
            }
        } else {
            this.serviceServerTypeID_ = serverFactoryId;
        }
        this.setupWasFacetVersion();
        return Status.OK_STATUS;
    }

    private void setupWasFacetVersion() {
        block3: {
            try {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.serverProject_);
                IFacetedProject fProject = ProjectFacetsManager.create((IProject)project);
                Set projFacets = fProject.getProjectFacets();
                for (IProjectFacetVersion facetVersion : projFacets) {
                    if (!facetVersion.getProjectFacet().getId().equals("com.ibm.websphere.extended.ejb")) continue;
                    this.wasFacet_ = facetVersion.getVersionString();
                }
            }
            catch (Exception e) {
                if (!WebServiceWasCreationEJBCommonPlugin.isTraceMode()) break block3;
                WebServiceWasCreationEJBCommonPlugin.getInstance().getLog().log(StatusUtils.errorStatus((Throwable)e));
            }
        }
    }

    public String getServerProject() {
        return this.serverProject_;
    }

    public String getServiceServerTypeID() {
        return this.serviceServerTypeID_;
    }

    public String getEjbName() {
        return this.ejbName_;
    }

    public String getServerProjectEAR() {
        return this.earProject_;
    }

    public String getServiceJ2EEVersion() {
        return this.serviceJ2EEVersion_;
    }

    public String getServerInstanceId() {
        return this.serverInstanceId_;
    }

    public String getWasFacetVersion() {
        return this.wasFacet_;
    }
}

