/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.was.v6.ui.editor.wscommonext;

import com.ibm.ast.ws.ext.validator.BSPComplianceUtils;
import com.ibm.etools.webservice.atk.ui.editor.common.SectionTableViewer;
import com.ibm.etools.webservice.atk.was.ui.command.ValidateWSIComplianceCommand;
import com.ibm.etools.webservice.atk.was.ui.constants.ATKWASUIConstants;
import com.ibm.etools.webservice.atk.was.v6.ui.editor.common.ManagedTableViewerEditor;
import com.ibm.etools.webservice.atk.was.v6.ui.editor.common.TableModifyListener;
import com.ibm.etools.webservice.atk.was.v6.ui.plugin.ATKWASUIPlugin;
import com.ibm.etools.webservice.wscommonext.MessageParts;
import com.ibm.etools.webservice.wscommonext.Nonce;
import com.ibm.etools.webservice.wscommonext.Timestamp;
import com.ibm.etools.webservice.wscommonext.WscommonextFactory;
import com.ibm.etools.webservice.wscommonext.WscommonextPackage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandAddElement;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandSetElement;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;

public abstract class DialogMessageParts
extends Dialog
implements TableModifyListener {
    protected Shell shell_;
    protected Text componentName_;
    protected CCombo usageTypeName_;
    protected CCombo order_;
    protected ManagedTableViewerEditor messagePartsTable_;
    protected ManagedTableViewerEditor nonceTable_;
    protected ManagedTableViewerEditor timestampTable_;
    protected ArtifactEdit artifactEdit_;
    protected EObject eObject_;
    protected EObject grandParent_;
    protected EStructuralFeature feature_;
    protected EObject selectedObject_;
    protected Object addedObject_;
    private EList messagePartList_;
    private EList nonceList_;
    private EList timestampList_;
    private EObject currentObject_;
    private boolean hasUsageType_;
    protected SectionTableViewer section_;

    public DialogMessageParts(Shell shell, ArtifactEdit artifactEdit, EObject eObject, EStructuralFeature feature, EObject selectedObject, boolean hasUsage) {
        super(shell);
        this.artifactEdit_ = artifactEdit;
        this.eObject_ = eObject;
        this.feature_ = feature;
        this.selectedObject_ = selectedObject;
        this.addedObject_ = null;
        this.hasUsageType_ = hasUsage;
    }

    public void setSectionTableViewer(SectionTableViewer section) {
        this.section_ = section;
    }

    public void setGrandParent(EObject grand) {
        this.grandParent_ = grand;
    }

    protected void setMessageParts(EList messageParts) {
        this.messagePartList_ = messageParts;
    }

    protected void setNonce(EList nonce) {
        this.nonceList_ = nonce;
    }

    protected void setTimestamp(EList timestamp) {
        this.timestampList_ = timestamp;
    }

    protected void setCurrentObject(EObject curObject) {
        this.currentObject_ = curObject;
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        super.cancelPressed();
    }

    protected void okPressed() {
        CommandSetElement command;
        WscommonextPackage wscommonPkg = WscommonextFactory.eINSTANCE.getWscommonextPackage();
        WscommonextFactory commonFactory = wscommonPkg.getWscommonextFactory();
        ValidateWSIComplianceCommand validator = new ValidateWSIComplianceCommand(this.artifactEdit_.getComponent().getProject());
        int severity = validator.getSeverity();
        TableItem[] messageParts = this.messagePartsTable_.getItems();
        int i = 0;
        while (i < messageParts.length) {
            MessageParts messagePartValue = commonFactory.createMessageParts();
            messagePartValue.setDialect(messageParts[i].getText(0));
            messagePartValue.setKeyword(messageParts[i].getText(1));
            validator.addStatus(BSPComplianceUtils.validateExtKeyword((int)severity, (String)messagePartValue.getKeyword()));
            this.messagePartList_.add((Object)messagePartValue);
            ++i;
        }
        TableItem[] nonces = this.nonceTable_.getItems();
        int i2 = 0;
        while (i2 < nonces.length) {
            Nonce nonceValue = commonFactory.createNonce();
            nonceValue.setDialect(nonces[i2].getText(0));
            nonceValue.setKeyword(nonces[i2].getText(1));
            validator.addStatus(BSPComplianceUtils.validateNonceTimestampKeyword((int)severity, (String)nonceValue.getKeyword()));
            this.nonceList_.add((Object)nonceValue);
            ++i2;
        }
        TableItem[] timestamp = this.timestampTable_.getItems();
        int i3 = 0;
        while (i3 < timestamp.length) {
            Timestamp timestampValue = commonFactory.createTimestamp();
            timestampValue.setDialect(timestamp[i3].getText(0));
            timestampValue.setKeyword(timestamp[i3].getText(1));
            validator.addStatus(BSPComplianceUtils.validateNonceTimestampKeyword((int)severity, (String)timestampValue.getKeyword()));
            timestampValue.setExpires(timestamp[i3].getText(2));
            this.timestampList_.add((Object)timestampValue);
            ++i3;
        }
        if (!validator.execute()) {
            return;
        }
        if (this.selectedObject_ != null) {
            command = new CommandSetElement(null, null, this.eObject_, this.feature_, (Object)this.currentObject_, (Object)this.selectedObject_);
        } else {
            if (this.eObject_ == null && this.grandParent_ != null) {
                this.addParent();
            }
            command = new CommandAddElement(null, null, this.eObject_, this.feature_, (Object)this.currentObject_);
        }
        this.artifactEdit_.getContentModelRoot().eResource().setModified(true);
        ((ArtifactEditModel)this.artifactEdit_.getAdapter(ArtifactEditModel.ADAPTER_TYPE)).getCommandStack().execute((Command)command);
        this.addedObject_ = this.currentObject_;
        this.setReturnCode(0);
        super.okPressed();
    }

    protected void AddElement(EObject parent, EClass childEClass, EStructuralFeature childFeature) {
        EFactory eFactory = childEClass.getEPackage().getEFactoryInstance();
        EObject newChild_ = eFactory.create(childEClass);
        CommandAddElement command = new CommandAddElement(null, null, parent, childFeature, (Object)newChild_);
        this.artifactEdit_.getContentModelRoot().eResource().setModified(true);
        ((ArtifactEditModel)this.artifactEdit_.getAdapter(ArtifactEditModel.ADAPTER_TYPE)).getCommandStack().execute((Command)command);
    }

    public Object getAddedObject() {
        return this.addedObject_;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    public abstract String getComponentName();

    public abstract String getSelectedObjectName();

    public abstract String getSelectedObjectUsageTypeName();

    public abstract EList getSelectedObjectMessageParts();

    public abstract EList getSelectedObjectNonce();

    public abstract EList getSelectedObjectTimestamp();

    public abstract EObject addParent();

    public abstract String getDefaultKeyword();

    public abstract String[] getKeywords(boolean var1);

    protected Control createDialogArea(Composite parent) {
        WscommonextPackage pkg = WscommonextFactory.eINSTANCE.getWscommonextPackage();
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.verticalSpacing = 5;
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.widthHint = 500;
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 64);
        label.setText(this.getComponentName());
        label.setLayoutData((Object)new GridData(256));
        this.componentName_ = new Text(composite, 2116);
        this.componentName_.setLayoutData((Object)new GridData(768));
        if (this.hasUsageType_) {
            label = new Label(composite, 64);
            label.setText(this.getMessage("%LABEL_EXT_USAGE_TYPE"));
            label.setLayoutData((Object)new GridData(256));
            this.usageTypeName_ = new CCombo(composite, 2116);
            this.usageTypeName_.setLayoutData((Object)new GridData(768));
            this.usageTypeName_.setItems(ATKWASUIConstants.getUsageTypeNames());
            this.usageTypeName_.select(0);
        } else {
            label = new Label(composite, 64);
            label.setText(this.getMessage("%LABEL_EXT_ORDER"));
            label.setLayoutData((Object)new GridData(256));
            this.order_ = new CCombo(composite, 2116);
            this.order_.setLayoutData((Object)new GridData(768));
            int i = 1;
            while (i <= 10) {
                this.order_.add(Integer.toString(i));
                ++i;
            }
            this.order_.select(0);
        }
        Composite messagePartsComposite = this.createTableComposite(composite, this.getMessage("%LABEL_EXT_MESSAGE_PARTS"));
        String[] messagePartsTableColumns = new String[]{this.getMessage("%LABEL_EXT_MESSAGE_PARTS_DIALECT"), this.getMessage("%LABEL_EXT_MESSAGE_PARTS_KEYWORD")};
        EStructuralFeature[] messagePartsTableFeatures = new EStructuralFeature[]{pkg.getMessageParts_Dialect(), pkg.getMessageParts_Keyword()};
        Object[] messagePartsTableFeatureValues = new String[]{"http://www.ibm.com/websphere/webservices/wssecurity/dialect-was", this.getDefaultKeyword()};
        String[][] valuesArray = new String[][]{ATKWASUIConstants.getDialects(), this.getKeywords(true)};
        this.messagePartsTable_ = new ManagedTableViewerEditor(messagePartsComposite, messagePartsTableColumns, pkg.getMessageParts(), messagePartsTableFeatures, messagePartsTableFeatureValues, valuesArray);
        this.messagePartsTable_.addTableModifyListener(this);
        Composite nonceComposite = this.createTableComposite(composite, this.getMessage("%LABEL_EXT_NONCE"));
        String[] nonceTableColumns = new String[]{this.getMessage("%LABEL_EXT_NONCE_DIALECT"), this.getMessage("%LABEL_EXT_NONCE_KEYWORD")};
        EStructuralFeature[] nonceTableFeatures = new EStructuralFeature[]{pkg.getNonce_Dialect(), pkg.getNonce_Keyword()};
        Object[] nonceTableFeatureValues = new String[]{"http://www.ibm.com/websphere/webservices/wssecurity/dialect-was", this.getDefaultKeyword()};
        String[][] valuesArray3 = new String[][]{ATKWASUIConstants.getDialects(), this.getKeywords(false)};
        this.nonceTable_ = new ManagedTableViewerEditor(nonceComposite, nonceTableColumns, pkg.getNonce(), nonceTableFeatures, nonceTableFeatureValues, valuesArray3);
        Composite timestampComposite = this.createTableComposite(composite, this.getMessage("%LABEL_EXT_TIMESTAMP"));
        String[] timestampTableColumns = new String[]{this.getMessage("%LABEL_EXT_TIMESTAMP_DIALECT"), this.getMessage("%LABEL_EXT_TIMESTAMP_KEYWORD"), this.getMessage("%LABEL_EXT_TIMESTAMP_EXPIRES")};
        EStructuralFeature[] timestampTableFeatures = new EStructuralFeature[]{pkg.getTimestamp_Dialect(), pkg.getTimestamp_Keyword(), pkg.getTimestamp_Expires()};
        Object[] timestampTableFeatureValues = new String[]{"http://www.ibm.com/websphere/webservices/wssecurity/dialect-was", this.getDefaultKeyword(), ""};
        String[][] valuesArray2 = new String[][]{ATKWASUIConstants.getDialects(), this.getKeywords(false), {"", "", "", ""}};
        this.timestampTable_ = new ManagedTableViewerEditor(timestampComposite, timestampTableColumns, pkg.getTimestamp(), timestampTableFeatures, timestampTableFeatureValues, valuesArray2);
        this.init();
        this.refresh();
        return composite;
    }

    public void handleEvent(Event event) {
    }

    private void refresh() {
        boolean enable = this.messagePartsTable_.getItems() != null && this.messagePartsTable_.getItems().length > 0;
        this.nonceTable_.enableTable(enable);
        this.timestampTable_.enableTable(enable);
    }

    private void init() {
        if (this.selectedObject_ != null) {
            this.setText(this.componentName_, this.getSelectedObjectName());
            if (this.hasUsageType_) {
                this.setCComboText(this.usageTypeName_, this.getSelectedObjectUsageTypeName());
            } else {
                this.setCComboText(this.order_, this.getSelectedObjectUsageTypeName());
            }
            EList messagePartsList = this.getSelectedObjectMessageParts();
            for (MessageParts msgParts : messagePartsList) {
                this.messagePartsTable_.addItem(new Object[]{msgParts.getDialect(), msgParts.getKeyword()});
            }
            this.messagePartsTable_.refresh();
            EList nonceList = this.getSelectedObjectNonce();
            for (Nonce nonce : nonceList) {
                this.nonceTable_.addItem(new Object[]{nonce.getDialect(), nonce.getKeyword()});
            }
            this.nonceTable_.refresh();
            EList timestampList = this.getSelectedObjectTimestamp();
            for (Timestamp timestamp : timestampList) {
                this.timestampTable_.addItem(new Object[]{timestamp.getDialect(), timestamp.getKeyword(), timestamp.getExpires()});
            }
            this.timestampTable_.refresh();
        }
    }

    private void setText(Text text, String s) {
        if (s != null) {
            text.setText(s);
        } else {
            text.setText("");
        }
    }

    private void setCComboText(CCombo ccombo, String s) {
        if (s != null) {
            ccombo.setText(s);
        } else {
            ccombo.setText("");
        }
    }

    private Composite createTableComposite(Composite parent, String name) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 64);
        label.setText(name);
        label.setLayoutData((Object)new GridData(256));
        return composite;
    }

    protected String getMessage(String msgId) {
        return ATKWASUIPlugin.getMessage(msgId);
    }

    public void tableCellSelected(String text, int row, int column) {
        this.refresh();
    }

    public void tableItemRemoved(Object object, EStructuralFeature[] features) {
        this.refresh();
    }
}

