/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.was.v6.ui.editor.wscommonbnd;

import com.ibm.ast.ws.ext.validator.BSPComplianceUtils;
import com.ibm.etools.webservice.atk.was.ui.command.ValidateWSIComplianceCommand;
import com.ibm.etools.webservice.atk.was.ui.constants.ATKWASUIConstants;
import com.ibm.etools.webservice.atk.was.v6.ui.editor.wscommonbnd.DialogTableViewerEditor;
import com.ibm.etools.webservice.atk.was.v6.ui.plugin.ATKWASUIPlugin;
import com.ibm.etools.webservice.wscommonbnd.Property;
import com.ibm.etools.webservice.wscommonbnd.Transform;
import com.ibm.etools.webservice.wscommonbnd.WscommonbndFactory;
import com.ibm.etools.webservice.wscommonbnd.WscommonbndPackage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandAddElement;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandSetElement;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;

public class DialogSigningInfoTsf
extends Dialog
implements Listener {
    private Text Name_;
    private Combo Algorithm_;
    private DialogTableViewerEditor transformPropertyTable_;
    private ArtifactEdit artifactEdit_;
    private EObject eObject_;
    private EStructuralFeature feature_;
    private Transform transform_;
    private Object addedObject_;

    public DialogSigningInfoTsf(Shell shell, ArtifactEdit artifactEdit, EObject eObject, EStructuralFeature feature, Transform transform) {
        super(shell);
        this.artifactEdit_ = artifactEdit;
        this.eObject_ = eObject;
        this.feature_ = feature;
        this.transform_ = transform;
        this.addedObject_ = null;
        this.setShellStyle(67696);
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        super.cancelPressed();
    }

    protected void okPressed() {
        ValidateWSIComplianceCommand validator = new ValidateWSIComplianceCommand(this.artifactEdit_.getComponent().getProject());
        int severity = validator.getSeverity();
        WscommonbndFactory factory = WscommonbndFactory.eINSTANCE;
        Transform transform = factory.createTransform();
        transform.setName(this.Name_.getText());
        transform.setAlgorithm(this.Algorithm_.getText());
        validator.addStatus(BSPComplianceUtils.validateTransformAlgorithm((int)severity, (String)transform.getAlgorithm()));
        EList transformList = transform.getProperties();
        TableItem[] transformProperties = this.transformPropertyTable_.getItems();
        int i = 0;
        while (i < transformProperties.length) {
            Property transformProperty = factory.createProperty();
            transformProperty.setName(transformProperties[i].getText(0));
            transformProperty.setValue(transformProperties[i].getText(1));
            transformList.add((Object)transformProperty);
            ++i;
        }
        if (!validator.execute()) {
            return;
        }
        Object command = this.transform_ != null ? new CommandSetElement(null, null, this.eObject_, this.feature_, (Object)transform, (Object)this.transform_) : new CommandAddElement(null, null, this.eObject_, this.feature_, (Object)transform);
        this.addedObject_ = transform;
        this.artifactEdit_.getContentModelRoot().eResource().setModified(true);
        ((ArtifactEditModel)this.artifactEdit_.getAdapter(ArtifactEditModel.ADAPTER_TYPE)).getCommandStack().execute((Command)command);
        this.setReturnCode(0);
        super.okPressed();
    }

    public Object getAddedObject() {
        return this.addedObject_;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getMessage("%DIALOG_TITLE_SIGNING_INF_TRANSFORM"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)gd);
        WscommonbndPackage pkg = WscommonbndFactory.eINSTANCE.getWscommonbndPackage();
        ATKWASUIConstants atkWasUiConstants = new ATKWASUIConstants();
        Label label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_TRANSFORM_NAME"));
        label.setLayoutData((Object)new GridData(256));
        this.Name_ = new Text(composite, 2116);
        this.Name_.setLayoutData((Object)new GridData(768));
        label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_TRANSFORM_ALGORITHM"));
        label.setLayoutData((Object)new GridData(256));
        this.Algorithm_ = new Combo(composite, 2060);
        this.Algorithm_.setLayoutData((Object)new GridData(768));
        String[] methods = atkWasUiConstants.getSigningInfoTransformsAlgorithms();
        int i = 0;
        while (i < methods.length) {
            this.Algorithm_.add(methods[i]);
            ++i;
        }
        this.Algorithm_.select(0);
        Composite transformPropertyComposite = new Composite(composite, 0);
        transformPropertyComposite.setLayout((Layout)new GridLayout());
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        transformPropertyComposite.setLayoutData((Object)gd);
        label = new Label(transformPropertyComposite, 64);
        label.setText(this.getMessage("%LABEL_TRANSFORM_PROPERTY"));
        label.setLayoutData((Object)new GridData(256));
        String[] transformPropertyTableColumns = new String[]{this.getMessage("%LABEL_TABLE_NAME"), this.getMessage("%LABEL_TABLE_VALUE")};
        EStructuralFeature[] transformPropertyTableFeatures = new EStructuralFeature[]{pkg.getProperty_Name(), pkg.getProperty_Value()};
        Object[] transformPropertyTableFeatureValues = new String[]{atkWasUiConstants.defaultName(), atkWasUiConstants.defaultValue()};
        this.transformPropertyTable_ = new DialogTableViewerEditor(transformPropertyComposite, transformPropertyTableColumns, pkg.getProperty(), transformPropertyTableFeatures, transformPropertyTableFeatureValues);
        composite.setTabList(new Control[]{this.Name_, this.Algorithm_, transformPropertyComposite});
        this.init();
        return composite;
    }

    private void init() {
        if (this.transform_ != null) {
            this.setText(this.Name_, this.transform_.getName());
            String algorithm = this.transform_.getAlgorithm();
            if (algorithm != null) {
                if (this.Algorithm_.indexOf(algorithm) == -1) {
                    this.Algorithm_.add(algorithm);
                }
                this.Algorithm_.setText(algorithm);
            } else {
                this.Algorithm_.select(0);
            }
            EList transformList = this.transform_.getProperties();
            for (Property transformProperty : transformList) {
                this.transformPropertyTable_.addItem(new Object[]{transformProperty.getName(), transformProperty.getValue()});
            }
            this.transformPropertyTable_.refresh();
        }
    }

    public void handleEvent(Event event) {
    }

    private void setText(Text text, String s) {
        if (s != null) {
            text.setText(s);
        } else {
            text.setText("");
        }
    }

    protected String getMessage(String msgId) {
        return ATKWASUIPlugin.getMessage(msgId);
    }
}

