/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.was.v6.ui.editor.wscommonbnd;

import com.ibm.etools.webservice.atk.was.ui.constants.ATKWASUIConstants;
import com.ibm.etools.webservice.atk.was.v6.ui.editor.wscommonbnd.DialogTableViewerEditor;
import com.ibm.etools.webservice.atk.was.v6.ui.editor.wscommonbnd.TextTableAdapter;
import com.ibm.etools.webservice.atk.was.v6.ui.plugin.ATKWASUIPlugin;
import com.ibm.etools.webservice.wscommonbnd.CallbackHandlerFactory;
import com.ibm.etools.webservice.wscommonbnd.LoginMapping;
import com.ibm.etools.webservice.wscommonbnd.Property;
import com.ibm.etools.webservice.wscommonbnd.TokenValueType;
import com.ibm.etools.webservice.wscommonbnd.WscommonbndFactory;
import com.ibm.etools.webservice.wscommonbnd.WscommonbndPackage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandAddElement;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandSetElement;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;

public class DialogLoginMapping
extends Dialog
implements Listener {
    private Combo authMethod_;
    private Text configName_;
    private Color red_;
    private Label status_;
    private Label nonceHeading_;
    private Text nonceMaxAge_;
    private Text nonceClockSkew_;
    private Button useTokenValueType_;
    private Label uriLabel_;
    private Label localNameLabel_;
    private Text uri_;
    private Text localName_;
    private Combo classname_;
    private DialogTableViewerEditor callbackPropertyTable_;
    private DialogTableViewerEditor propertyTable_;
    private ArtifactEdit artifactEdit_;
    private EObject eObject_;
    private EStructuralFeature feature_;
    private LoginMapping loginMapping_;
    private Object addedObject_;
    private String[] defaultAuthMethods_;

    public DialogLoginMapping(Shell shell, ArtifactEdit artifactEdit, EObject eObject, EStructuralFeature feature, LoginMapping loginMapping) {
        super(shell);
        this.artifactEdit_ = artifactEdit;
        this.eObject_ = eObject;
        this.feature_ = feature;
        this.loginMapping_ = loginMapping;
        this.addedObject_ = null;
        this.defaultAuthMethods_ = null;
        this.setShellStyle(67696);
    }

    private String[] getDefaultAuthMethods() {
        if (this.defaultAuthMethods_ == null) {
            ATKWASUIConstants atkWasUiConstants = new ATKWASUIConstants();
            this.defaultAuthMethods_ = atkWasUiConstants.getLoginBindingAuthMethods();
        }
        return this.defaultAuthMethods_;
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        this.disposeWidgets();
        super.cancelPressed();
    }

    protected void okPressed() {
        if (!this.validateInputs()) {
            this.cancelPressed();
            return;
        }
        WscommonbndFactory factory = WscommonbndFactory.eINSTANCE;
        LoginMapping loginMapping = factory.createLoginMapping();
        loginMapping.setAuthMethod(this.authMethod_.getText());
        loginMapping.setConfigName(this.configName_.getText());
        if (this.useTokenValueType_.getSelection() && this.useTokenValueType_.getEnabled()) {
            TokenValueType tokenValueType = factory.createTokenValueType();
            tokenValueType.setUri(this.uri_.getText());
            tokenValueType.setLocalName(this.localName_.getText());
            loginMapping.setTokenValueType(tokenValueType);
        }
        CallbackHandlerFactory callbackHandlerFactory = factory.createCallbackHandlerFactory();
        callbackHandlerFactory.setClassname(this.classname_.getText());
        EList callPropertyList = callbackHandlerFactory.getProperties();
        TableItem[] callupProperties = this.callbackPropertyTable_.getItems();
        int i = 0;
        while (i < callupProperties.length) {
            Property property = factory.createProperty();
            property.setName(callupProperties[i].getText(0));
            property.setValue(callupProperties[i].getText(1));
            callPropertyList.add((Object)property);
            ++i;
        }
        loginMapping.setCallbackHandlerFactory(callbackHandlerFactory);
        EList propertyList = loginMapping.getProperties();
        TableItem[] properties = this.propertyTable_.getItems();
        int i2 = 0;
        while (i2 < properties.length) {
            Property property = factory.createProperty();
            property.setName(properties[i2].getText(0));
            property.setValue(properties[i2].getText(1));
            propertyList.add((Object)property);
            ++i2;
        }
        Object command = this.loginMapping_ != null ? new CommandSetElement(null, null, this.eObject_, this.feature_, (Object)loginMapping, (Object)this.loginMapping_) : new CommandAddElement(null, null, this.eObject_, this.feature_, (Object)loginMapping);
        this.addedObject_ = loginMapping;
        this.artifactEdit_.getContentModelRoot().eResource().setModified(true);
        ((ArtifactEditModel)this.artifactEdit_.getAdapter(ArtifactEditModel.ADAPTER_TYPE)).getCommandStack().execute((Command)command);
        this.setReturnCode(0);
        this.disposeWidgets();
        super.okPressed();
    }

    public Object getAddedObject() {
        return this.addedObject_;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getMessage("%DIALOG_TITLE_LOGIN_MAPPING"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite outerComposite = (Composite)super.createDialogArea(parent);
        GridLayout gl2 = new GridLayout();
        gl2.numColumns = 1;
        gl2.marginHeight = 0;
        gl2.marginWidth = 0;
        outerComposite.setLayout((Layout)gl2);
        GridData gd2 = new GridData(1808);
        outerComposite.setLayoutData((Object)gd2);
        ScrolledComposite sc1 = new ScrolledComposite(outerComposite, 2816);
        sc1.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite((Composite)sc1, 0);
        sc1.setContent((Control)composite);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_AUTH_METHOD"));
        label.setLayoutData((Object)new GridData(256));
        this.authMethod_ = new Combo(composite, 2052);
        this.authMethod_.setLayoutData((Object)new GridData(768));
        String[] methods = this.getDefaultAuthMethods();
        int i = 0;
        while (i < methods.length) {
            this.authMethod_.add(methods[i]);
            ++i;
        }
        this.authMethod_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ATKWASUIConstants atkWasUiConstants;
                boolean userDefinedMethod = true;
                String authMethod = DialogLoginMapping.this.authMethod_.getText();
                if (authMethod.equals((atkWasUiConstants = new ATKWASUIConstants()).getLTPAAuthenticationMethod())) {
                    DialogLoginMapping.this.useTokenValueType_.setEnabled(true);
                    DialogLoginMapping.this.useTokenValueType_.setSelection(true);
                    DialogLoginMapping.this.enableTokenValueType(true);
                    DialogLoginMapping.this.setDefaultValuesForLTPA();
                } else {
                    String[] methods = DialogLoginMapping.this.getDefaultAuthMethods();
                    if (authMethod != null) {
                        int i = 0;
                        while (i < methods.length) {
                            if (authMethod.equals(methods[i])) {
                                userDefinedMethod = false;
                                break;
                            }
                            ++i;
                        }
                    }
                    DialogLoginMapping.this.useTokenValueType_.setEnabled(userDefinedMethod);
                    DialogLoginMapping.this.useTokenValueType_.setSelection(userDefinedMethod);
                    DialogLoginMapping.this.enableTokenValueType(DialogLoginMapping.this.useTokenValueType_.getSelection());
                }
                ATKWASUIConstants constants = new ATKWASUIConstants();
                DialogLoginMapping.this.enableNonce(authMethod.equals(constants.getBasicAuthenticationMethod()));
            }
        });
        this.authMethod_.addListener(24, (Listener)this);
        label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_CONFIG_NAME"));
        label.setLayoutData((Object)new GridData(256));
        this.configName_ = new Text(composite, 2116);
        this.configName_.setLayoutData((Object)new GridData(768));
        this.configName_.addListener(24, (Listener)this);
        this.status_ = new Label(composite, 64);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.status_.setLayoutData((Object)gd);
        this.status_.setVisible(false);
        this.status_.setText("");
        this.red_ = new Color((Device)this.getShell().getDisplay(), 255, 0, 0);
        this.status_.setForeground(this.red_);
        this.nonceHeading_ = new Label(composite, 64);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.nonceHeading_.setLayoutData((Object)gd);
        this.nonceHeading_.setText(this.getMessage("%LABEL_NONCE_PROPS"));
        label = new Label(composite, 64);
        gd = new GridData(256);
        label.setLayoutData((Object)gd);
        label.setText(ATKWASUIPlugin.getMessage("%LABEL_NONCE_MAX_AGE"));
        this.nonceMaxAge_ = new Text(composite, 2116);
        this.nonceMaxAge_.setLayoutData((Object)new GridData(768));
        this.nonceMaxAge_.addListener(24, (Listener)this);
        label = new Label(composite, 64);
        gd = new GridData(256);
        label.setLayoutData((Object)gd);
        label.setText(ATKWASUIPlugin.getMessage("%LABEL_NONCE_CLOCK_SKEW"));
        this.nonceClockSkew_ = new Text(composite, 2116);
        this.nonceClockSkew_.setLayoutData((Object)new GridData(768));
        this.nonceClockSkew_.addListener(24, (Listener)this);
        this.enableNonce(false);
        label = new Label(composite, 64);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.useTokenValueType_ = new Button(composite, 32);
        this.useTokenValueType_.setText(this.getMessage("%LABEL_USE_TOKEN"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.useTokenValueType_.setLayoutData((Object)gd);
        this.useTokenValueType_.setSelection(false);
        this.useTokenValueType_.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DialogLoginMapping.this.enableTokenValueType(DialogLoginMapping.this.useTokenValueType_.getSelection());
            }
        });
        this.uriLabel_ = new Label(composite, 64);
        this.uriLabel_.setText(this.getMessage("%LABEL_URI"));
        this.uriLabel_.setLayoutData((Object)new GridData(256));
        this.uri_ = new Text(composite, 2116);
        this.uri_.setLayoutData((Object)new GridData(768));
        this.localNameLabel_ = new Label(composite, 64);
        this.localNameLabel_.setText(this.getMessage("%LABEL_LOCAL_NAME"));
        this.localNameLabel_.setLayoutData((Object)new GridData(256));
        this.localName_ = new Text(composite, 2116);
        this.localName_.setLayoutData((Object)new GridData(768));
        label = new Label(composite, 64);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        WscommonbndPackage pkg = WscommonbndFactory.eINSTANCE.getWscommonbndPackage();
        ATKWASUIConstants atkWasUiConstants = new ATKWASUIConstants();
        label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_CALLBACK_HANDLER_FACTORY"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_CLASSNAME"));
        label.setLayoutData((Object)new GridData(256));
        this.classname_ = new Combo(composite, 2052);
        this.classname_.setLayoutData((Object)new GridData(768));
        String[] classes = atkWasUiConstants.getCallBackHandlerFactoryClassNames();
        int i2 = 0;
        while (i2 < classes.length) {
            this.classname_.add(classes[i2]);
            ++i2;
        }
        this.classname_.addListener(24, (Listener)this);
        Composite callbackPropertyComposite = new Composite(composite, 0);
        callbackPropertyComposite.setLayout((Layout)new GridLayout());
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        callbackPropertyComposite.setLayoutData((Object)gd);
        label = new Label(callbackPropertyComposite, 64);
        label.setText(this.getMessage("%LABEL_CALLBACK_PROPERTY"));
        label.setLayoutData((Object)new GridData(256));
        String[] propertyTableColumns = new String[]{this.getMessage("%LABEL_TABLE_NAME"), this.getMessage("%LABEL_TABLE_VALUE")};
        EStructuralFeature[] propertyTableFeatures = new EStructuralFeature[]{pkg.getProperty_Name(), pkg.getProperty_Value()};
        Object[] propertyTableFeatureValues = new String[]{atkWasUiConstants.defaultName(), atkWasUiConstants.defaultValue()};
        this.callbackPropertyTable_ = new DialogTableViewerEditor(callbackPropertyComposite, propertyTableColumns, pkg.getProperty(), propertyTableFeatures, propertyTableFeatureValues);
        label = new Label(composite, 64);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Composite propertyComposite = new Composite(composite, 0);
        propertyComposite.setLayout((Layout)new GridLayout());
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        propertyComposite.setLayoutData((Object)gd);
        label = new Label(propertyComposite, 64);
        label.setText(this.getMessage("%LABEL_LOGIN_PROPERTY"));
        label.setLayoutData((Object)new GridData(256));
        propertyTableColumns = new String[]{this.getMessage("%LABEL_TABLE_NAME"), this.getMessage("%LABEL_TABLE_VALUE")};
        propertyTableFeatures = new EStructuralFeature[]{pkg.getProperty_Name(), pkg.getProperty_Value()};
        propertyTableFeatureValues = new String[]{atkWasUiConstants.defaultName(), atkWasUiConstants.defaultValue()};
        this.propertyTable_ = new DialogTableViewerEditor(propertyComposite, propertyTableColumns, pkg.getProperty(), propertyTableFeatures, propertyTableFeatureValues);
        label = new Label(composite, 64);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        composite.setTabList(new Control[]{this.useTokenValueType_, this.authMethod_, this.configName_, this.nonceMaxAge_, this.nonceClockSkew_, this.uri_, this.localName_, this.classname_, callbackPropertyComposite, propertyComposite});
        this.init();
        this.refresh();
        composite.setSize(composite.computeSize(-1, -1));
        return composite;
    }

    private void refresh() {
        this.enableTokenValueType(this.useTokenValueType_.getSelection());
    }

    public void handleEvent(Event event) {
        if (this.nonceMaxAge_ == event.widget || this.nonceClockSkew_ == event.widget) {
            Button okButton = this.getButton(0);
            if (okButton == null) {
                return;
            }
            String errorMessage = this.verifyNonceSettings();
            if (errorMessage != null && errorMessage.length() > 0) {
                this.status_.setText(errorMessage);
                this.status_.setVisible(true);
                okButton.setEnabled(false);
            } else {
                this.status_.setVisible(false);
                okButton.setEnabled(true);
            }
        } else if (this.authMethod_ == event.widget || this.configName_ == event.widget || this.classname_ == event.widget) {
            Button okButton = this.getButton(0);
            if (okButton == null) {
                return;
            }
            okButton.setEnabled(this.validateInputs());
        }
    }

    private String verifyNonceSettings() {
        String clockSkewText;
        ATKWASUIConstants constants = new ATKWASUIConstants();
        String maxAgeText = this.nonceMaxAge_.getText();
        int maxAge = 0;
        if (maxAgeText != null && maxAgeText.length() > 0) {
            try {
                maxAge = Integer.parseInt(maxAgeText);
                int maxAgeMin = Integer.parseInt(constants.getDefaultNonceMaxAge());
                if (maxAge < maxAgeMin) {
                    return ATKWASUIPlugin.getMessage("%MSG_MAX_AGE_TOO_SMALL", new String[]{String.valueOf(maxAgeMin)});
                }
            }
            catch (NumberFormatException numberFormatException) {
                return ATKWASUIPlugin.getMessage("%MSG_MAX_AGE_NOT_INT");
            }
        }
        if ((clockSkewText = this.nonceClockSkew_.getText()) != null && clockSkewText.length() > 0) {
            try {
                int clockSkew = Integer.parseInt(clockSkewText);
                int clockSkewMin = Integer.parseInt(constants.getDefaultNonceClockSkew());
                if (clockSkew < clockSkewMin) {
                    return ATKWASUIPlugin.getMessage("%MSG_CLOCK_SKEW_TOO_SMALL", new String[]{String.valueOf(clockSkewMin)});
                }
                if (maxAgeText != null && maxAgeText.length() > 0 && clockSkew > maxAge) {
                    return ATKWASUIPlugin.getMessage("%MSG_CLOCK_SKEW_TOO_BIG", new String[]{maxAgeText});
                }
            }
            catch (NumberFormatException numberFormatException) {
                return ATKWASUIPlugin.getMessage("%MSG_CLOCK_SKEW_NOT_INT");
            }
        }
        return "";
    }

    private boolean validateInputs() {
        String authMethodValue = this.authMethod_.getText();
        String configNameValue = this.configName_.getText();
        String classnameValue = this.classname_.getText();
        return authMethodValue != null && authMethodValue.length() > 0 && configNameValue != null && configNameValue.length() > 0 && classnameValue != null && classnameValue.length() > 0;
    }

    private void disposeWidgets() {
        if (this.red_ != null && !this.red_.isDisposed()) {
            this.red_.dispose();
        }
    }

    private void enableTokenValueType(boolean enabled) {
        this.uriLabel_.setEnabled(enabled);
        this.localNameLabel_.setEnabled(enabled);
        this.uri_.setEnabled(enabled);
        this.localName_.setEnabled(enabled);
    }

    private void setDefaultValuesForLTPA() {
        ATKWASUIConstants atkWasUiConstants = new ATKWASUIConstants();
        this.uri_.setText(atkWasUiConstants.getLTPATokenURI());
        this.localName_.setText(atkWasUiConstants.getLTPATokenLocalName());
        this.configName_.setText(atkWasUiConstants.getLTPAConfigName());
        this.classname_.setText(atkWasUiConstants.getLoginMappingLTPACallBackHandler());
    }

    private void enableNonce(boolean enable) {
        if (enable) {
            this.nonceMaxAge_.setEnabled(true);
            this.nonceClockSkew_.setEnabled(true);
        } else {
            this.nonceMaxAge_.setText("");
            this.nonceMaxAge_.setEnabled(false);
            this.nonceClockSkew_.setText("");
            this.nonceClockSkew_.setEnabled(false);
        }
    }

    private void init() {
        ATKWASUIConstants constants = new ATKWASUIConstants();
        if (this.loginMapping_ != null) {
            EList propertyList;
            String authMethod = this.loginMapping_.getAuthMethod();
            int authMethodIndex = this.authMethod_.indexOf(authMethod);
            if (authMethodIndex == -1) {
                this.authMethod_.add(authMethod);
                this.authMethod_.select(this.authMethod_.indexOf(authMethod));
            } else {
                this.authMethod_.select(authMethodIndex);
            }
            this.enableNonce(authMethod.equals(constants.getBasicAuthenticationMethod()));
            this.useTokenValueType_.setEnabled(authMethodIndex == -1);
            this.setText(this.configName_, this.loginMapping_.getConfigName());
            TokenValueType tokenValueType = this.loginMapping_.getTokenValueType();
            if (tokenValueType != null) {
                this.useTokenValueType_.setSelection(true);
                this.enableTokenValueType(true);
                this.setText(this.uri_, tokenValueType.getUri());
                this.setText(this.localName_, tokenValueType.getLocalName());
            } else {
                this.useTokenValueType_.setSelection(false);
            }
            CallbackHandlerFactory callbackHandlerFactory = this.loginMapping_.getCallbackHandlerFactory();
            if (callbackHandlerFactory != null) {
                this.setText(this.classname_, callbackHandlerFactory.getClassname());
                propertyList = callbackHandlerFactory.getProperties();
                for (Property property : propertyList) {
                    this.callbackPropertyTable_.addItem(new Object[]{property.getName(), property.getValue()});
                }
                this.callbackPropertyTable_.refresh();
            }
            propertyList = this.loginMapping_.getProperties();
            for (Property property : propertyList) {
                this.propertyTable_.addItem(new Object[]{property.getName(), property.getValue()});
                if (property.getName().equals(constants.getNonceMaxAgeKey())) {
                    this.nonceMaxAge_.setText(property.getValue());
                }
                if (!property.getName().equals(constants.getNonceClockSkewKey())) continue;
                this.nonceClockSkew_.setText(property.getValue());
            }
            this.propertyTable_.refresh();
        }
        Text[] nonceTexts = new Text[]{this.nonceMaxAge_, this.nonceClockSkew_};
        String[] keyValues = new String[]{constants.getNonceMaxAgeKey(), constants.getNonceClockSkewKey()};
        new TextTableAdapter(nonceTexts, keyValues, 0, 1, this.propertyTable_);
    }

    private void setText(Text text, String s) {
        if (s != null) {
            text.setText(s);
        } else {
            text.setText("");
        }
    }

    private void setText(Combo combo, String s) {
        if (s != null) {
            combo.setText(s);
        } else {
            combo.setText("");
        }
    }

    protected String getMessage(String msgId) {
        return ATKWASUIPlugin.getMessage(msgId);
    }
}

