/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.was.v6.ui.editor.wscommonbnd;

import com.ibm.ast.ws.ext.validator.BSPComplianceUtils;
import com.ibm.etools.webservice.atk.was.ui.command.ValidateWSIComplianceCommand;
import com.ibm.etools.webservice.atk.was.ui.constants.ATKWASUIConstants;
import com.ibm.etools.webservice.atk.was.v6.ui.editor.wscommonbnd.DialogTableViewerEditor;
import com.ibm.etools.webservice.atk.was.v6.ui.plugin.ATKWASUIPlugin;
import com.ibm.etools.webservice.wscommonbnd.Key;
import com.ibm.etools.webservice.wscommonbnd.KeyInfo;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.KeyLocatorMapping;
import com.ibm.etools.webservice.wscommonbnd.Property;
import com.ibm.etools.webservice.wscommonbnd.TokenConsumer;
import com.ibm.etools.webservice.wscommonbnd.TokenGenerator;
import com.ibm.etools.webservice.wscommonbnd.TokenReference;
import com.ibm.etools.webservice.wscommonbnd.WscommonbndFactory;
import com.ibm.etools.webservice.wscommonbnd.WscommonbndPackage;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandAddElement;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandSetElement;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;

public class DialogKeyInfo
extends Dialog
implements Listener {
    private Text keyInfoName_;
    private Combo keyInfoType_;
    private Text keyInfoClassName_;
    private Button useKeyLocMap_;
    private Label keyLocMapLocatorRefLabel_;
    private Label keyLocMapKeyNameRefLabel_;
    private Combo keyLocMapLocatorRef_;
    private Combo keyLocMapKeyNameRef_;
    private Button useTokenRef_;
    private Label tokenRefTokenRefLabel_;
    private Combo tokenRefTokenRef_;
    private DialogTableViewerEditor propertyTable_;
    private ArtifactEdit artifactEdit_;
    private EObject eObject_;
    private EStructuralFeature feature_;
    private KeyInfo keyInfo_;
    private boolean generator_;
    private Object addedObject_;
    private EStructuralFeature locatorRefFeature_;
    private EStructuralFeature tokenRefFeature_;

    public DialogKeyInfo(Shell shell, ArtifactEdit artifactEdit, EObject eObject, EStructuralFeature feature, KeyInfo keyInfo, boolean generator) {
        super(shell);
        this.artifactEdit_ = artifactEdit;
        this.eObject_ = eObject;
        this.feature_ = feature;
        this.keyInfo_ = keyInfo;
        this.generator_ = generator;
        this.addedObject_ = null;
        this.setShellStyle(67696);
    }

    public void setLocatorRefFeature(EStructuralFeature locatorRefFeature) {
        this.locatorRefFeature_ = locatorRefFeature;
    }

    public void setTokenRefFeature(EStructuralFeature tokenRefFeature) {
        this.tokenRefFeature_ = tokenRefFeature;
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        super.cancelPressed();
    }

    protected void okPressed() {
        ValidateWSIComplianceCommand validator = new ValidateWSIComplianceCommand(this.artifactEdit_.getComponent().getProject());
        int severity = validator.getSeverity();
        WscommonbndFactory factory = WscommonbndFactory.eINSTANCE;
        KeyInfo keyInfo = factory.createKeyInfo();
        keyInfo.setType(this.keyInfoType_.getText());
        validator.addStatus(BSPComplianceUtils.validateKeyInformationType((int)severity, (String)keyInfo.getType()));
        keyInfo.setName(this.keyInfoName_.getText());
        keyInfo.setClassname(this.keyInfoClassName_.getText());
        if (this.useKeyLocMap_.getSelection()) {
            KeyLocatorMapping keyLocMap = factory.createKeyLocatorMapping();
            keyLocMap.setLocatorRef(this.keyLocMapLocatorRef_.getText());
            keyLocMap.setKeynameRef(this.keyLocMapKeyNameRef_.getText());
            keyInfo.setKeyLocatorMapping(keyLocMap);
        }
        if (this.useTokenRef_.getSelection()) {
            TokenReference tokenRef = factory.createTokenReference();
            tokenRef.setTokenRef(this.tokenRefTokenRef_.getText());
            keyInfo.setTokenReference(tokenRef);
        }
        EList propertyList = keyInfo.getProperties();
        TableItem[] properties = this.propertyTable_.getItems();
        int i = 0;
        while (i < properties.length) {
            Property property = factory.createProperty();
            property.setName(properties[i].getText(0));
            property.setValue(properties[i].getText(1));
            propertyList.add((Object)property);
            ++i;
        }
        if (!validator.execute()) {
            return;
        }
        Object command = this.keyInfo_ != null ? new CommandSetElement(null, null, this.eObject_, this.feature_, (Object)keyInfo, (Object)this.keyInfo_) : new CommandAddElement(null, null, this.eObject_, this.feature_, (Object)keyInfo);
        this.addedObject_ = keyInfo;
        this.artifactEdit_.getContentModelRoot().eResource().setModified(true);
        ((ArtifactEditModel)this.artifactEdit_.getAdapter(ArtifactEditModel.ADAPTER_TYPE)).getCommandStack().execute((Command)command);
        this.setReturnCode(0);
        super.okPressed();
    }

    public Object getAddedObject() {
        return this.addedObject_;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getMessage("%DIALOG_TITLE_KEY_INFO"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.verticalSpacing = 5;
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.widthHint = 500;
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)gd);
        WscommonbndPackage pkg = WscommonbndFactory.eINSTANCE.getWscommonbndPackage();
        final ATKWASUIConstants atkWasUiConstants = new ATKWASUIConstants();
        Label label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_KEY_INF_NAME"));
        label.setLayoutData((Object)new GridData(256));
        this.keyInfoName_ = new Text(composite, 2116);
        this.keyInfoName_.setLayoutData((Object)new GridData(768));
        label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_KEY_INF_TYPE"));
        label.setLayoutData((Object)new GridData(256));
        this.keyInfoType_ = new Combo(composite, 2116);
        this.keyInfoType_.setLayoutData((Object)new GridData(768));
        String[] keyType = atkWasUiConstants.getKeyInfoTypes();
        int i = 0;
        while (i < keyType.length) {
            this.keyInfoType_.add(keyType[i]);
            ++i;
        }
        this.keyInfoType_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String[] keyType = atkWasUiConstants.getKeyInfoTypes();
                String[] keyClass = DialogKeyInfo.this.generator_ ? atkWasUiConstants.getKeyInfoGeneratorClassNames() : atkWasUiConstants.getKeyInfoClassNames();
                String keyInfoType = DialogKeyInfo.this.keyInfoType_.getText();
                if (keyInfoType != null) {
                    int i = 0;
                    while (i < keyType.length) {
                        if (keyInfoType.equals(keyType[i])) {
                            DialogKeyInfo.this.keyInfoClassName_.setText(keyClass[i]);
                            break;
                        }
                        ++i;
                    }
                }
            }
        });
        this.keyInfoType_.addListener(24, (Listener)this);
        label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_KEY_INF_CLASS_NAME"));
        label.setLayoutData((Object)new GridData(256));
        this.keyInfoClassName_ = new Text(composite, 2116);
        this.keyInfoClassName_.setLayoutData((Object)new GridData(768));
        this.useKeyLocMap_ = new Button(composite, 32);
        this.useKeyLocMap_.setText(this.getMessage("%LABEL_USE_KEY_LOC_MAP"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.useKeyLocMap_.setLayoutData((Object)gd);
        this.useKeyLocMap_.setSelection(false);
        this.useKeyLocMap_.addListener(13, (Listener)this);
        this.useKeyLocMap_.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DialogKeyInfo.this.enableKeyLocMap(DialogKeyInfo.this.useKeyLocMap_.getSelection());
            }
        });
        this.keyLocMapLocatorRefLabel_ = new Label(composite, 64);
        this.keyLocMapLocatorRefLabel_.setText(this.getMessage("%LABEL_LOCATOR_REF"));
        gd = new GridData(256);
        gd.horizontalIndent = 10;
        this.keyLocMapLocatorRefLabel_.setLayoutData((Object)gd);
        this.keyLocMapLocatorRef_ = new Combo(composite, 2116);
        this.keyLocMapLocatorRef_.setLayoutData((Object)new GridData(768));
        this.keyLocMapLocatorRef_.setItems(this.getKeyLocatorNames());
        this.keyLocMapLocatorRef_.addListener(24, (Listener)this);
        this.keyLocMapKeyNameRefLabel_ = new Label(composite, 64);
        this.keyLocMapKeyNameRefLabel_.setText(this.getMessage("%LABEL_KEY_NAME_REF"));
        gd = new GridData(256);
        gd.horizontalIndent = 10;
        this.keyLocMapKeyNameRefLabel_.setLayoutData((Object)gd);
        this.keyLocMapKeyNameRef_ = new Combo(composite, 2116);
        this.keyLocMapKeyNameRef_.setLayoutData((Object)new GridData(768));
        this.keyLocMapKeyNameRef_.setItems(this.getKeyLocatorKeysNames());
        this.keyLocMapKeyNameRef_.addListener(24, (Listener)this);
        this.useTokenRef_ = new Button(composite, 32);
        this.useTokenRef_.setText(this.getMessage("%LABEL_USE_TOKEN_REF"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.useTokenRef_.setLayoutData((Object)gd);
        this.useTokenRef_.setSelection(false);
        this.useTokenRef_.addListener(13, (Listener)this);
        this.useTokenRef_.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DialogKeyInfo.this.enableTokenRef(DialogKeyInfo.this.useTokenRef_.getSelection());
            }
        });
        this.tokenRefTokenRefLabel_ = new Label(composite, 64);
        this.tokenRefTokenRefLabel_.setText(this.getMessage("%LABEL_TOKEN_REF"));
        gd = new GridData(256);
        gd.horizontalIndent = 10;
        this.tokenRefTokenRefLabel_.setLayoutData((Object)gd);
        this.tokenRefTokenRef_ = new Combo(composite, 2116);
        this.tokenRefTokenRef_.setLayoutData((Object)new GridData(768));
        String[] tokens = this.getTokenNames();
        int i2 = 0;
        while (i2 < tokens.length) {
            this.tokenRefTokenRef_.add(tokens[i2]);
            ++i2;
        }
        this.tokenRefTokenRef_.addListener(24, (Listener)this);
        Composite propertyComposite = new Composite(composite, 0);
        propertyComposite.setLayout((Layout)new GridLayout());
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        propertyComposite.setLayoutData((Object)gd);
        label = new Label(propertyComposite, 64);
        label.setText(this.getMessage("%LABEL_PROPERTY"));
        label.setLayoutData((Object)new GridData(256));
        String[] propertyTableColumns = new String[]{this.getMessage("%LABEL_TABLE_NAME"), this.getMessage("%LABEL_TABLE_VALUE")};
        EStructuralFeature[] propertyTableFeatures = new EStructuralFeature[]{pkg.getProperty_Name(), pkg.getProperty_Value()};
        Object[] propertyTableFeatureValues = new String[]{atkWasUiConstants.defaultName(), atkWasUiConstants.defaultValue()};
        this.propertyTable_ = new DialogTableViewerEditor(propertyComposite, propertyTableColumns, pkg.getProperty(), propertyTableFeatures, propertyTableFeatureValues);
        composite.setTabList(new Control[]{this.keyInfoName_, this.keyInfoType_, this.keyInfoClassName_, this.useKeyLocMap_, this.keyLocMapLocatorRef_, this.keyLocMapKeyNameRef_, this.useTokenRef_, this.tokenRefTokenRef_, propertyComposite});
        this.init();
        this.refresh();
        return composite;
    }

    private String[] getKeyLocatorNames() {
        if (this.eObject_ != null && this.locatorRefFeature_ != null) {
            Vector<String> keyLocators = new Vector<String>();
            Object object = this.eObject_.eGet(this.locatorRefFeature_);
            if (object instanceof EList) {
                for (Object item : (EList)object) {
                    if (!(item instanceof KeyLocator)) continue;
                    keyLocators.add(((KeyLocator)item).getName());
                }
            } else if (object instanceof KeyLocator) {
                keyLocators.add(((KeyLocator)object).getName());
            }
            Object[] names = new String[keyLocators.size()];
            keyLocators.copyInto(names);
            return names;
        }
        return new String[0];
    }

    private String[] getKeyLocatorKeysNames() {
        if (this.eObject_ != null && this.locatorRefFeature_ != null) {
            Vector<String> locatorKeys = new Vector<String>();
            Object object = this.eObject_.eGet(this.locatorRefFeature_);
            if (object instanceof EList) {
                for (Object item : (EList)object) {
                    if (!(item instanceof KeyLocator)) continue;
                    EList keys = ((KeyLocator)item).getKeys();
                    Iterator i = keys.iterator();
                    while (i.hasNext()) {
                        locatorKeys.add(((Key)i.next()).getName());
                    }
                }
            } else if (object instanceof KeyLocator) {
                EList keys = ((KeyLocator)object).getKeys();
                Iterator i = keys.iterator();
                while (i.hasNext()) {
                    locatorKeys.add(((Key)i.next()).getName());
                }
            }
            Object[] names = new String[locatorKeys.size()];
            locatorKeys.copyInto(names);
            return names;
        }
        return new String[0];
    }

    private String[] getTokenNames() {
        if (this.eObject_ != null && this.tokenRefFeature_ != null) {
            Vector<String> tokens = new Vector<String>();
            Object object = this.eObject_.eGet(this.tokenRefFeature_);
            if (object instanceof EList) {
                for (Object item : (EList)object) {
                    if (item instanceof TokenConsumer) {
                        tokens.add(((TokenConsumer)item).getName());
                    }
                    if (!(item instanceof TokenGenerator)) continue;
                    tokens.add(((TokenGenerator)item).getName());
                }
            } else if (object instanceof TokenConsumer) {
                tokens.add(((TokenConsumer)object).getName());
            } else if (object instanceof TokenGenerator) {
                tokens.add(((TokenGenerator)object).getName());
            }
            Object[] names = new String[tokens.size()];
            tokens.copyInto(names);
            return names;
        }
        return new String[0];
    }

    public void handleEvent(Event event) {
        if (this.useKeyLocMap_ == event.widget || this.keyLocMapLocatorRef_ == event.widget || this.keyLocMapKeyNameRef_ == event.widget) {
            this.verifyKeyLocMapSettings();
        }
    }

    private void verifyKeyLocMapSettings() {
        Button okButton = this.getButton(0);
        if (okButton == null) {
            return;
        }
        boolean usingKeyLocMap = this.useKeyLocMap_.getSelection();
        if (usingKeyLocMap) {
            String locatorRef = this.keyLocMapLocatorRef_.getText();
            if (locatorRef == null || locatorRef.length() == 0) {
                okButton.setEnabled(false);
            } else {
                okButton.setEnabled(true);
            }
        } else {
            okButton.setEnabled(true);
        }
    }

    private void refresh() {
        this.enableKeyLocMap(this.useKeyLocMap_.getSelection());
        this.enableTokenRef(this.useTokenRef_.getSelection());
    }

    private void enableKeyLocMap(boolean enabled) {
        this.keyLocMapLocatorRefLabel_.setEnabled(enabled);
        this.keyLocMapKeyNameRefLabel_.setEnabled(enabled);
        this.keyLocMapLocatorRef_.setEnabled(enabled);
        this.keyLocMapKeyNameRef_.setEnabled(enabled);
    }

    private void enableTokenRef(boolean enabled) {
        this.tokenRefTokenRefLabel_.setEnabled(enabled);
        this.tokenRefTokenRef_.setEnabled(enabled);
    }

    private void init() {
        if (this.keyInfo_ != null) {
            this.setText(this.keyInfoName_, this.keyInfo_.getName());
            this.setComboText(this.keyInfoType_, this.keyInfo_.getType());
            this.setText(this.keyInfoClassName_, this.keyInfo_.getClassname());
            KeyLocatorMapping keyLocMap = this.keyInfo_.getKeyLocatorMapping();
            if (keyLocMap != null) {
                this.setComboText(this.keyLocMapLocatorRef_, keyLocMap.getLocatorRef());
                this.setComboText(this.keyLocMapKeyNameRef_, keyLocMap.getKeynameRef());
                this.useKeyLocMap_.setSelection(true);
                this.enableKeyLocMap(true);
            } else {
                this.useKeyLocMap_.setSelection(false);
            }
            TokenReference tokenRef = this.keyInfo_.getTokenReference();
            if (tokenRef != null) {
                this.setComboText(this.tokenRefTokenRef_, tokenRef.getTokenRef());
                this.useTokenRef_.setSelection(true);
                this.enableTokenRef(true);
            } else {
                this.useTokenRef_.setSelection(false);
            }
            EList propertyList = this.keyInfo_.getProperties();
            for (Property property : propertyList) {
                this.propertyTable_.addItem(new Object[]{property.getName(), property.getValue()});
            }
            this.propertyTable_.refresh();
        }
    }

    private void setText(Text text, String s) {
        if (s != null) {
            text.setText(s);
        } else {
            text.setText("");
        }
    }

    private void setComboText(Combo ccombo, String s) {
        if (s != null) {
            ccombo.setText(s);
        } else {
            ccombo.setText("");
        }
    }

    protected String getMessage(String msgId) {
        return ATKWASUIPlugin.getMessage(msgId);
    }
}

