/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.was.ui.validate;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.internal.operations.EnabledValidatorsOperation;
import org.eclipse.wst.validation.internal.operations.ValidatorManager;

public class ValidationManager {
    private HashSet projects = new HashSet();
    private ValidatorManager j2eeManager = ValidatorManager.getManager();
    private boolean isAutoBuild_;
    private boolean autoBuildDisabled_;

    public ValidationManager() {
        this.setAutoBuildPreference();
        this.autoBuildDisabled_ = false;
    }

    public void disableValidationForProject(IProject project) {
        this.projects.add(project);
        this.j2eeManager.suspendAllValidation(true);
    }

    public void restoreValidationForProjects(IProgressMonitor monitor, boolean runValidation) {
        this.j2eeManager.suspendAllValidation(false);
        for (IProject project : this.projects) {
            if (!runValidation) continue;
            EnabledValidatorsOperation validOp = new EnabledValidatorsOperation(project, false);
            validOp.run(monitor);
        }
    }

    public void modifyAutoBuild(boolean isAutoBuild) {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription workspaceDesc = workspace.getDescription();
            workspaceDesc.setAutoBuilding(isAutoBuild);
            workspace.setDescription(workspaceDesc);
        }
        catch (Exception exception) {}
    }

    public void disableAutoBuild() {
        if (!this.autoBuildDisabled_) {
            this.setAutoBuildPreference();
            this.modifyAutoBuild(false);
            this.autoBuildDisabled_ = true;
        }
    }

    public void restoreAutoBuild() {
        if (this.autoBuildDisabled_) {
            this.modifyAutoBuild(this.getAutoBuildPreference());
            this.autoBuildDisabled_ = false;
        }
    }

    public boolean setAutoBuildPreference() {
        this.isAutoBuild_ = this.getWorkspaceAutoBuildPreference();
        return this.isAutoBuild_;
    }

    public boolean getAutoBuildPreference() {
        return this.isAutoBuild_;
    }

    public boolean getWorkspaceAutoBuildPreference() {
        IWorkspaceDescription workspaceDesc = ResourcesPlugin.getWorkspace().getDescription();
        return workspaceDesc.isAutoBuilding();
    }
}

