/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.was.ui.constants;

import com.ibm.etools.webservice.atk.was.v6.ui.plugin.ATKWASUIPlugin;
import com.ibm.etools.webservice.wscbnd.LoginBinding;
import com.ibm.etools.webservice.wscbnd.WscbndFactory;
import com.ibm.etools.webservice.wscommonbnd.CanonicalizationMethod;
import com.ibm.etools.webservice.wscommonbnd.CertPathSettings;
import com.ibm.etools.webservice.wscommonbnd.DataEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.DigestMethod;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.KeyEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.SignatureMethod;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.WscommonbndFactory;
import java.util.Vector;

public class ATKWASUIConstants {
    private Vector nonFIPSSigningInfoAlgorithms = null;
    private Vector FIPSSigningInfoAlgorithms = null;
    private Vector nonFIPSDigestMethodAlgorithms = null;
    private Vector FIPSDigestMethodAlgorithms = null;
    private Vector FIPSDataEncryptionAlgorithms = null;
    private Vector nonFIPSDataEncryptionAlgorithms = null;
    private Vector FIPSKeyEncryptionAlgorithms = null;
    private Vector nonFIPSKeyEncryptionAlgorithms = null;
    public static final String SIGNING_INFO_CANONICALIZATION_METHOD_VALUE1 = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String SIGNING_INFO_CANONICALIZATION_METHOD_VALUE2 = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    public static final String SIGNING_INFO_CANONICALIZATION_METHOD_VALUE3 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String SIGNING_INFO_CANONICALIZATION_METHOD_VALUE4 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String SIGNING_INFO_TRANSFORMS_METHOD_VALUE3 = "http://www.w3.org/2002/06/xmldsig-filter2";
    public static final String SIGNING_INFO_TRANSFORMS_METHOD_VALUE5 = "http://www.w3.org/2002/07/decrypt#XML";
    public static final String SIGNING_INFO_TRANSFORMS_METHOD_VALUE6 = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
    public static final String SIGNING_INFO_SIGNATURE_METHOD_VALUE1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String SIGNING_INFO_SIGNATURE_METHOD_VALUE3 = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    public static final String SIGNING_INFO_DIGEST_METHOD_VALUE1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String SIGNING_INFO_DIGEST_METHOD_VALUE2 = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String SIGNING_INFO_DIGEST_METHOD_VALUE3 = "http://www.w3.org/2001/04/xmlenc#sha512";
    public static final String ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE1 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    public static final String ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE2 = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
    public static final String ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE3 = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
    public static final String ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE4 = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
    public static final String ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE5 = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    public static final String ENCRYPTION_INFO_DATA_ENCRYPTION_VALUE1 = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    public static final String ENCRYPTION_INFO_DATA_ENCRYPTION_VALUE2 = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    public static final String ENCRYPTION_INFO_DATA_ENCRYPTION_VALUE3 = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    public static final String KEY_INFO_TYPE_STREF = "STRREF";
    public static final String KEY_INFO_TYPE_EMB = "EMB";
    public static final String KEY_INFO_TYPE_KEYID = "KEYID";
    public static final String KEY_INFO_TYPE_X509 = "X509ISSUER";
    public static final String KEY_INFO_CONSUMER_CLASS_STRREF = "com.ibm.ws.webservices.wssecurity.keyinfo.STRReferenceContentConsumer";
    public static final String KEY_INFO_CONSUMER_CLASS_EMB = "com.ibm.ws.webservices.wssecurity.keyinfo.EmbeddedContentConsumer";
    public static final String KEY_INFO_CONSUMER_CLASS_KEYID = "com.ibm.ws.webservices.wssecurity.keyinfo.KeyIdContentConsumer";
    public static final String KEY_INFO_CONSUMER_CLASS_KEYNAME = "com.ibm.ws.webservices.wssecurity.keyinfo.KeyNameContentConsumer";
    public static final String KEY_INFO_CONSUMER_CLASS_X509 = "com.ibm.ws.webservices.wssecurity.keyinfo.X509IssuerContentConsumer";
    public static final String KEY_INFO_GENERATOR_CLASS_STRREF = "com.ibm.ws.webservices.wssecurity.keyinfo.STRReferenceContentGenerator";
    public static final String KEY_INFO_GENERATOR_CLASS_EMB = "com.ibm.ws.webservices.wssecurity.keyinfo.EmbeddedContentGenerator";
    public static final String KEY_INFO_GENERATOR_CLASS_KEYID = "com.ibm.ws.webservices.wssecurity.keyinfo.KeyIdContentGenerator";
    public static final String KEY_INFO_GENERATOR_CLASS_KEYNAME = "com.ibm.ws.webservices.wssecurity.keyinfo.KeyNameContentGenerator";
    public static final String KEY_INFO_GENERATOR_CLASS_X509 = "com.ibm.ws.webservices.wssecurity.keyinfo.X509IssuerContentGenerator";
    public static final String JAAS_CONFIG_USERNAME = "system.wssecurity.UsernameToken";
    public static final String JAAS_CONFIG_X509 = "system.wssecurity.X509BST";
    private String KEY_STORE_TYPE_VALUE1 = "JKS";
    private String KEY_STORE_TYPE_VALUE2 = "JCEKS";
    private String KEY_STORE_TYPE_VALUE3 = "PKCS11";
    private String KEY_STORE_TYPE_VALUE4 = "PKCS12";
    public static final String KEY_LOCATOR_CLASS_NAME_VALUE1 = "com.ibm.wsspi.wssecurity.keyinfo.KeyStoreKeyLocator";
    public static final String KEY_LOCATOR_CLASS_NAME_VALUE2 = "com.ibm.wsspi.wssecurity.keyinfo.SignerCertKeyLocator";
    public static final String KEY_LOCATOR_CLASS_NAME_VALUE3 = "com.ibm.wsspi.wssecurity.keyinfo.X509TokenKeyLocator";
    public static final String GENERATOR_CLASS_NAME_USERNAME = "com.ibm.wsspi.wssecurity.token.UsernameTokenGenerator";
    public static final String GENERATOR_CLASS_NAME_X509 = "com.ibm.wsspi.wssecurity.token.X509TokenGenerator";
    public static final String GENERATOR_CLASS_NAME_LTPA = "com.ibm.wsspi.wssecurity.token.LTPATokenGenerator";
    public static final String TOKEN_TYPE_USERNAME = "Username Token";
    public static final String TOKEN_TYPE_X509 = "X509 certificate token";
    public static final String TOKEN_TYPE_X509_v3 = "X509 certificate token v3";
    public static final String TOKEN_TYPE_X509_PKI = "X509 certificates in a PKIPath";
    public static final String TOKEN_TYPE_X509_PKCS = "A list of X509 certificates and CRLs in a PKCS#7";
    public static final String TOKEN_TYPE_LTPA = "LTPA Token";
    public static final String TOKEN_TYPE_CUSTOM = "Custom Token";
    public static final String LOCAL_NAME_FORTYPE_USERNAME = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken";
    public static final String LOCAL_NAME_FORTYPE_X509 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509";
    public static final String LOCAL_NAME_FORTYPE_X509_v3 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
    public static final String LOCAL_NAME_FORTYPE_X509_PKI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1";
    public static final String LOCAL_NAME_FORTYPE_X509_PKCS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#PKCS7";
    public static final String LOCAL_NAME_FORTYPE_LTPA = "LTPA";
    public static final String URI_FORTYPE_LTPA = "http://www.ibm.com/websphere/appserver/tokentype/5.0.2";
    public static final String CALLBACK_HANDLER_NON_PROMPT = "com.ibm.wsspi.wssecurity.auth.callback.NonPromptCallbackHandler";
    public static final String CALLBACK_HANDLER_GUI_PROMPT = "com.ibm.wsspi.wssecurity.auth.callback.GUIPromptCallbackHandler";
    public static final String CALLBACK_HANDLER_X509 = "com.ibm.wsspi.wssecurity.auth.callback.X509CallbackHandler";
    public static final String CALLBACK_HANDLER_PKI_PATH = "com.ibm.wsspi.wssecurity.auth.callback.PkiPathCallbackHandler";
    public static final String CALLBACK_HANDLER_PKCS7 = "com.ibm.wsspi.wssecurity.auth.callback.PKCS7CallbackHandler";
    public static final String CALLBACK_HANDLER_LTPA = "com.ibm.wsspi.wssecurity.auth.callback.LTPATokenCallbackHandler";
    public static final String CALLBACK_HANDLER_STDN_PROMPT = "com.ibm.wsspi.wssecurity.auth.callback.StdinPromptCallbackHandler";
    public static final String CONSUMER_CLASS_NAME_USERNAME = "com.ibm.wsspi.wssecurity.token.UsernameTokenConsumer";
    public static final String CONSUMER_CLASS_NAME_X509 = "com.ibm.wsspi.wssecurity.token.X509TokenConsumer";
    public static final String CONSUMER_CLASS_NAME_LTPA = "com.ibm.wsspi.wssecurity.token.LTPATokenConsumer";
    public static final String CONSUMER_CLASS_NAME_IDAssertionUserName = "com.ibm.wsspi.wssecurity.token.IDAssertionUsernameTokenConsumer";
    private String LOGIN_BINDING_BASIC_AUTH = "BasicAuth";
    private String LOGIN_BINDING_ID_ASSERTION = "IDAssertion";
    private String LOGIN_BINDING_SIGNATURE = "Signature";
    private String LOGIN_BINDING_LTPA = "LTPA";
    private String DEFAULT_TOKEN_URI = "http://www.ibm.com/websphere/appserver/tokentype/5.0.2";
    private String DEFAULT_TOKEN_LOCAL_NAME = "LTPA";
    private String CALLBACK_HANDLER_FACTORY_CLASS_NAME = "com.ibm.wsspi.wssecurity.auth.callback.WSCallbackHandlerFactoryImpl";
    private String DEFAULT_LTPA_CONFIG_NAME = "WSLogin";
    private String LOGIN_MAPPING_NONCE_MAXAGE = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.maxAge";
    private String LOGIN_MAPPING_NONCE_CLOCKSKEW = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.clockSkew";
    private String NONCE_MAXAGE_DEFAULT = "300";
    private String NONCE_CLOCKSKEW_DEFAULT = "0";
    private String LOGIN_CONFIG_NONCE = "com.ibm.ws.wssecurity.config.token.BasicAuth.NonceRequired";
    private String LOGIN_CONFIG_NONCE_TIMESTAMP = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.timestampRequired";
    private String CLIENT_LOGIN_CONFIG_NONCE = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce";
    private String CLIENT_LOGIN_CONFIG_NONCE_TIMESTAMP = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.timestamp";
    private String ENABLED_VALUE = "true";
    private String DISABLED_VALUE = "false";
    private String SCOPE_REQUEST = "Request";
    private String SCOPE_APPLICATION = "Application";
    private String SCOPE_SESSION = "Session";
    public static final String USAGE_TYPE_REQUIRED = "Required";
    public static final String USAGE_TYPE_OPTIONAL = "Optional";
    public static final String USAGE_TYPE_REJECTED = "Rejected";
    public static final String USAGE_TYPE_OBSERVED = "Observed";
    public static final String USAGE_TYPE_IGNORED = "Ignored";
    public static final String BODY = "body";
    public static final String TIME_STAMP = "timestamp";
    public static final String SECURITY = "securitytoken";
    public static final String DSIG_KEY = "dsigkey";
    public static final String ENC_KEY = "enckey";
    public static final String MESSAGE_ID = "messageid";
    public static final String TO = "to";
    public static final String ACTION = "action";
    public static final String RELATES_TO = "relatesto";
    public static final String CONTEXT = "wscontext";
    public static final String ALL = "wsaall";
    public static final String FROM = "wsafrom";
    public static final String REPLY_TO = "wsareplyto";
    public static final String FAULT_TO = "wsafaultto";
    public static final String BODY_CONTENT = "bodycontent";
    public static final String SIGNATURE = "signature";
    public static final String CONTEXT_CONTENT = "wscontextcontent";

    public String defaultNamespace() {
        return new String(ATKWASUIPlugin.getMessage("%LABEL_TABLE_NAMESPACE_URI"));
    }

    public String defaultLocalname() {
        return new String(ATKWASUIPlugin.getMessage("%LABEL_TABLE_LOCAL_NAME"));
    }

    public String defaultName() {
        return "Name";
    }

    public String defaultValue() {
        return "Value";
    }

    public String defaultKeyInfo() {
        return "KeyInfo";
    }

    public String defaultEndpointURIPrefix() {
        return new String(ATKWASUIPlugin.getMessage("%LABEL_BND_TEXT"));
    }

    public String defaultPortQnameBndLocalname() {
        String localname = new String(ATKWASUIPlugin.getMessage("%LABEL_TABLE_LOCAL_NAME"));
        StringBuffer b = new StringBuffer();
        b.append(ATKWASUIPlugin.getMessage("%_UI_PortQnameBinding_type"));
        b.append(localname);
        return b.toString();
    }

    public String defaultOveriddenEndpointURI() {
        return new String("http://");
    }

    public String defaultKeyAlias() {
        return new String(ATKWASUIPlugin.getMessage("%LABEL_TABLE_KEY_ALIAS"));
    }

    public String defaultKeyKeypass() {
        return new String(ATKWASUIPlugin.getMessage("%LABEL_TABLE_KEY_KEY_PASS"));
    }

    public String defaultKeyName() {
        return new String(ATKWASUIPlugin.getMessage("%LABEL_TABLE_KEY_NAME"));
    }

    public String defaultCollectionCertStoreProvider() {
        return new String("IBMCertPath");
    }

    public String defaultX509CertificatePath() {
        return new String("X509 Certificate Path");
    }

    public String defaultCRLPath() {
        return new String("CRL Path");
    }

    public String[] getWSSENameSpaces() {
        String[] names = new String[]{new String("http://schemas.xmlsoap.org/ws/2003/06/secext"), new String("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")};
        return names;
    }

    public String[] getWSUNameSpaces() {
        String[] names = new String[]{new String("http://schemas.xmlsoap.org/ws/2003/06/utility"), new String("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd")};
        return names;
    }

    public String[] getSigningInfoSignatureMethods(boolean FIPSComplient) {
        if (this.FIPSSigningInfoAlgorithms == null) {
            this.FIPSSigningInfoAlgorithms = new Vector();
            this.FIPSSigningInfoAlgorithms.add(SIGNING_INFO_SIGNATURE_METHOD_VALUE1);
            this.FIPSSigningInfoAlgorithms.add("http://www.w3.org/2000/09/xmldsig#dsa-sha1");
            this.FIPSSigningInfoAlgorithms.add(SIGNING_INFO_SIGNATURE_METHOD_VALUE3);
        }
        if (this.nonFIPSSigningInfoAlgorithms == null) {
            this.nonFIPSSigningInfoAlgorithms = new Vector();
        }
        Vector all = new Vector();
        all.addAll(this.FIPSSigningInfoAlgorithms);
        if (!FIPSComplient) {
            all.addAll(this.nonFIPSSigningInfoAlgorithms);
        }
        Object[] array = new String[all.size()];
        all.copyInto(array);
        return array;
    }

    public boolean isSignatureMethodFIPSCompliant(String method) {
        this.getSigningInfoSignatureMethods(true);
        return this.FIPSSigningInfoAlgorithms.contains(method);
    }

    public String[] getKeyInfoSignatureTypes() {
        String[] types = new String[]{new String("keyinfo"), new String("keyinfochildelements")};
        return types;
    }

    public String[] getSigningInfoCanonicalizationMethods() {
        return new String[]{SIGNING_INFO_CANONICALIZATION_METHOD_VALUE1, SIGNING_INFO_CANONICALIZATION_METHOD_VALUE2, SIGNING_INFO_CANONICALIZATION_METHOD_VALUE3, SIGNING_INFO_CANONICALIZATION_METHOD_VALUE4};
    }

    public String[] getSigningInfoDigestMethodAlgorithms61(boolean FIPSComplient) {
        if (this.FIPSDigestMethodAlgorithms == null) {
            this.FIPSDigestMethodAlgorithms = new Vector();
            this.FIPSDigestMethodAlgorithms.add(SIGNING_INFO_DIGEST_METHOD_VALUE1);
            this.FIPSDigestMethodAlgorithms.add(SIGNING_INFO_DIGEST_METHOD_VALUE2);
            this.FIPSDigestMethodAlgorithms.add(SIGNING_INFO_DIGEST_METHOD_VALUE3);
        }
        if (this.nonFIPSDigestMethodAlgorithms == null) {
            this.nonFIPSDigestMethodAlgorithms = new Vector();
        }
        Vector all = new Vector();
        all.addAll(this.FIPSDigestMethodAlgorithms);
        if (!FIPSComplient) {
            all.addAll(this.nonFIPSDigestMethodAlgorithms);
        }
        Object[] array = new String[all.size()];
        all.copyInto(array);
        return array;
    }

    public String[] getSigningInfoDigestMethodAlgorithms(boolean FIPSComplient) {
        if (this.FIPSDigestMethodAlgorithms == null) {
            this.FIPSDigestMethodAlgorithms = new Vector();
            this.FIPSDigestMethodAlgorithms.add(SIGNING_INFO_DIGEST_METHOD_VALUE1);
        }
        if (this.nonFIPSDigestMethodAlgorithms == null) {
            this.nonFIPSDigestMethodAlgorithms = new Vector();
        }
        Vector all = new Vector();
        all.addAll(this.FIPSDigestMethodAlgorithms);
        if (!FIPSComplient) {
            all.addAll(this.nonFIPSDigestMethodAlgorithms);
        }
        Object[] array = new String[all.size()];
        all.copyInto(array);
        return array;
    }

    public boolean isDigestMethodFIPSCompliant(String method) {
        this.getSigningInfoDigestMethodAlgorithms(true);
        return this.FIPSDigestMethodAlgorithms.contains(method);
    }

    public String[] getSigningInfoTransformsAlgorithms() {
        String[] methods = new String[]{new String(SIGNING_INFO_CANONICALIZATION_METHOD_VALUE1), new String("http://www.w3.org/TR/1999/REC-xpath-19991116"), new String(SIGNING_INFO_TRANSFORMS_METHOD_VALUE3), new String("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform"), new String(SIGNING_INFO_TRANSFORMS_METHOD_VALUE5), new String(SIGNING_INFO_TRANSFORMS_METHOD_VALUE6)};
        return methods;
    }

    public SignatureMethod defaultSigningInfoSignatureMethods() {
        SignatureMethod method = WscommonbndFactory.eINSTANCE.createSignatureMethod();
        method.setAlgorithm(new String(SIGNING_INFO_SIGNATURE_METHOD_VALUE1));
        return method;
    }

    public DigestMethod defaultSigningInfoDigestMethods() {
        DigestMethod method = WscommonbndFactory.eINSTANCE.createDigestMethod();
        method.setAlgorithm(new String(SIGNING_INFO_DIGEST_METHOD_VALUE1));
        return method;
    }

    public CanonicalizationMethod defaultSigningInfoCanonicalizationMethods() {
        CanonicalizationMethod method = WscommonbndFactory.eINSTANCE.createCanonicalizationMethod();
        method.setAlgorithm(new String(SIGNING_INFO_CANONICALIZATION_METHOD_VALUE1));
        return method;
    }

    public CertPathSettings defaultCertPathSettings() {
        WscommonbndFactory factory = WscommonbndFactory.eINSTANCE;
        CertPathSettings certPathSettings = factory.createCertPathSettings();
        certPathSettings.setTrustAnyCertificate(factory.createTrustAnyCertificate());
        return certPathSettings;
    }

    public SigningInfo defaultSigningInfo() {
        SigningInfo signingInfo = WscommonbndFactory.eINSTANCE.createSigningInfo();
        signingInfo.setSignatureMethod(this.defaultSigningInfoSignatureMethods());
        signingInfo.setDigestMethod(this.defaultSigningInfoDigestMethods());
        signingInfo.setCanonicalizationMethod(this.defaultSigningInfoCanonicalizationMethods());
        signingInfo.setCertPathSettings(this.defaultCertPathSettings());
        return signingInfo;
    }

    public String[] getEncryptionInfoKeyEncryptionMethods7(boolean FIPSComplient) {
        String[] array = this.getEncryptionInfoKeyEncryptionMethods(FIPSComplient);
        if (FIPSComplient) {
            return array;
        }
        String[] array7 = new String[array.length + 1];
        int i = 0;
        while (i < array.length) {
            array7[i] = new String(array[i]);
            ++i;
        }
        array7[array.length] = new String(ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE5);
        return array7;
    }

    public String[] getEncryptionInfoKeyEncryptionMethods(boolean FIPSComplient) {
        if (this.FIPSKeyEncryptionAlgorithms == null) {
            this.FIPSKeyEncryptionAlgorithms = new Vector();
            this.FIPSKeyEncryptionAlgorithms.add(ATKWASUIPlugin.getMessage("%ENCRYPTION_INFO_KEY_ENCRYPTION_NONE"));
            this.FIPSKeyEncryptionAlgorithms.add(ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE1);
            this.FIPSKeyEncryptionAlgorithms.add(ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE2);
            this.FIPSKeyEncryptionAlgorithms.add(ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE3);
            this.FIPSKeyEncryptionAlgorithms.add(ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE4);
            this.FIPSKeyEncryptionAlgorithms.add("http://www.w3.org/2001/04/xmlenc#kw-aes192");
        }
        if (this.nonFIPSKeyEncryptionAlgorithms == null) {
            this.nonFIPSKeyEncryptionAlgorithms = new Vector();
        }
        Vector all = new Vector();
        all.addAll(this.FIPSKeyEncryptionAlgorithms);
        if (!FIPSComplient) {
            all.addAll(this.nonFIPSKeyEncryptionAlgorithms);
        }
        Object[] array = new String[all.size()];
        all.copyInto(array);
        return array;
    }

    public boolean isKeyEncryptionFIPSCompliant(String value) {
        this.getEncryptionInfoKeyEncryptionMethods(true);
        return this.FIPSKeyEncryptionAlgorithms.contains(value);
    }

    public String[] getEncryptionInfoDataEncryptionMethods(boolean FIPSComplient) {
        if (this.FIPSDataEncryptionAlgorithms == null) {
            this.FIPSDataEncryptionAlgorithms = new Vector();
            this.FIPSDataEncryptionAlgorithms.add(ENCRYPTION_INFO_DATA_ENCRYPTION_VALUE1);
            this.FIPSDataEncryptionAlgorithms.add(ENCRYPTION_INFO_DATA_ENCRYPTION_VALUE2);
            this.FIPSDataEncryptionAlgorithms.add(ENCRYPTION_INFO_DATA_ENCRYPTION_VALUE3);
            this.FIPSDataEncryptionAlgorithms.add("http://www.w3.org/2001/04/xmlenc#aes192-cbc");
        }
        if (this.nonFIPSDataEncryptionAlgorithms == null) {
            this.nonFIPSDataEncryptionAlgorithms = new Vector();
        }
        Vector all = new Vector();
        all.addAll(this.FIPSDataEncryptionAlgorithms);
        if (!FIPSComplient) {
            all.addAll(this.nonFIPSDataEncryptionAlgorithms);
        }
        Object[] array = new String[all.size()];
        all.copyInto(array);
        return array;
    }

    public boolean isDataEncryptionFIPSCompliant(String value) {
        this.getEncryptionInfoDataEncryptionMethods(true);
        return this.FIPSDataEncryptionAlgorithms.contains(value);
    }

    public KeyEncryptionMethod defaultKeyEncryptionMethod() {
        KeyEncryptionMethod method = WscommonbndFactory.eINSTANCE.createKeyEncryptionMethod();
        method.setAlgorithm(new String(ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE1));
        return method;
    }

    public DataEncryptionMethod defaultDataEncryptionMethod() {
        DataEncryptionMethod method = WscommonbndFactory.eINSTANCE.createDataEncryptionMethod();
        method.setAlgorithm(new String(ENCRYPTION_INFO_DATA_ENCRYPTION_VALUE1));
        return method;
    }

    public EncryptionInfo defaultEncryptionInfo() {
        EncryptionInfo encryptionInfo = WscommonbndFactory.eINSTANCE.createEncryptionInfo();
        encryptionInfo.setName(ATKWASUIPlugin.getMessage("%_UI_EncryptionInfo_type"));
        encryptionInfo.setKeyEncryptionMethod(this.defaultKeyEncryptionMethod());
        encryptionInfo.setEncryptionMethod(this.defaultDataEncryptionMethod());
        return encryptionInfo;
    }

    public String[] getKeyInfoTypes() {
        return new String[]{KEY_INFO_TYPE_STREF, KEY_INFO_TYPE_EMB, KEY_INFO_TYPE_KEYID, "KEYNAME", KEY_INFO_TYPE_X509};
    }

    public String[] getKeyInfoNames() {
        String[] names = new String[]{new String("Security token reference"), new String("Embedded token"), new String("Key Identifier"), new String("Key name"), new String("X509 issuer name and issuer serial")};
        return names;
    }

    public String[] getKeyInfoClassNames() {
        return new String[]{KEY_INFO_CONSUMER_CLASS_STRREF, KEY_INFO_CONSUMER_CLASS_EMB, KEY_INFO_CONSUMER_CLASS_KEYID, KEY_INFO_CONSUMER_CLASS_KEYNAME, KEY_INFO_CONSUMER_CLASS_X509};
    }

    public String[] getKeyInfoGeneratorClassNames() {
        return new String[]{KEY_INFO_GENERATOR_CLASS_STRREF, KEY_INFO_GENERATOR_CLASS_EMB, KEY_INFO_GENERATOR_CLASS_KEYID, KEY_INFO_GENERATOR_CLASS_KEYNAME, KEY_INFO_GENERATOR_CLASS_X509};
    }

    public String[] getKeyStoreTypes() {
        String[] types = new String[]{new String(this.KEY_STORE_TYPE_VALUE1), new String(this.KEY_STORE_TYPE_VALUE2), new String(this.KEY_STORE_TYPE_VALUE3), new String(this.KEY_STORE_TYPE_VALUE4)};
        return types;
    }

    public String[] getKeyLocatorClassNames() {
        String[] classnames = new String[]{new String(KEY_LOCATOR_CLASS_NAME_VALUE1), new String(KEY_LOCATOR_CLASS_NAME_VALUE2), new String(KEY_LOCATOR_CLASS_NAME_VALUE3)};
        return classnames;
    }

    public String[] getTokenGeneratorClassNames() {
        String[] classnames = new String[]{new String(GENERATOR_CLASS_NAME_USERNAME), new String(GENERATOR_CLASS_NAME_X509), new String(GENERATOR_CLASS_NAME_LTPA)};
        return classnames;
    }

    public String[] getValueTypeNames() {
        String[] names = new String[]{TOKEN_TYPE_USERNAME, TOKEN_TYPE_X509, TOKEN_TYPE_X509_v3, TOKEN_TYPE_X509_PKI, TOKEN_TYPE_X509_PKCS, TOKEN_TYPE_LTPA, TOKEN_TYPE_CUSTOM};
        return names;
    }

    public String[] getValueTypeLocalNames() {
        String[] names = new String[]{LOCAL_NAME_FORTYPE_USERNAME, LOCAL_NAME_FORTYPE_X509, LOCAL_NAME_FORTYPE_X509_v3, LOCAL_NAME_FORTYPE_X509_PKI, LOCAL_NAME_FORTYPE_X509_PKCS, LOCAL_NAME_FORTYPE_LTPA, new String("")};
        return names;
    }

    public String[] getValueTypeURIs() {
        String[] names = new String[]{new String(""), new String(""), new String(""), new String(""), new String(""), URI_FORTYPE_LTPA, new String("")};
        return names;
    }

    public String[] getCallBackClassNames() {
        String[] classnames = new String[]{CALLBACK_HANDLER_NON_PROMPT, CALLBACK_HANDLER_GUI_PROMPT, CALLBACK_HANDLER_X509, CALLBACK_HANDLER_PKI_PATH, CALLBACK_HANDLER_PKCS7, CALLBACK_HANDLER_LTPA, CALLBACK_HANDLER_STDN_PROMPT};
        return classnames;
    }

    public String[] getCallbackHandlerValues() {
        String[] values = new String[]{CALLBACK_HANDLER_STDN_PROMPT, CALLBACK_HANDLER_GUI_PROMPT, CALLBACK_HANDLER_NON_PROMPT, CALLBACK_HANDLER_LTPA};
        return values;
    }

    public String[] getTokenConsumerClassNames() {
        String[] classnames = new String[]{new String(CONSUMER_CLASS_NAME_USERNAME), new String(CONSUMER_CLASS_NAME_X509), new String(CONSUMER_CLASS_NAME_LTPA), new String(CONSUMER_CLASS_NAME_IDAssertionUserName)};
        return classnames;
    }

    public String[] getLoginBindingAuthMethods() {
        String[] methods = new String[]{new String(this.LOGIN_BINDING_BASIC_AUTH), new String(this.LOGIN_BINDING_ID_ASSERTION), new String(this.LOGIN_BINDING_SIGNATURE), new String(this.LOGIN_BINDING_LTPA)};
        return methods;
    }

    public LoginBinding defaultLoginBinding() {
        LoginBinding loginBinding = WscbndFactory.eINSTANCE.createLoginBinding();
        loginBinding.setAuthMethod(new String(this.LOGIN_BINDING_BASIC_AUTH));
        loginBinding.setCallbackHandler(ATKWASUIPlugin.getMessage("%LABEL_TABLE_CALLBACK_HANDLER"));
        return loginBinding;
    }

    public String getBasicAuthenticationMethod() {
        return new String(this.LOGIN_BINDING_BASIC_AUTH);
    }

    public String getLTPAAuthenticationMethod() {
        return new String(this.LOGIN_BINDING_LTPA);
    }

    public String getLTPATokenURI() {
        return new String(this.DEFAULT_TOKEN_URI);
    }

    public String getLTPATokenLocalName() {
        return new String(this.DEFAULT_TOKEN_LOCAL_NAME);
    }

    public String getLoginBindingLTPACallbackHandler() {
        return CALLBACK_HANDLER_LTPA;
    }

    public String[] getCallBackHandlerFactoryClassNames() {
        String[] classNames = new String[]{new String(this.CALLBACK_HANDLER_FACTORY_CLASS_NAME)};
        return classNames;
    }

    public String getLTPAConfigName() {
        return new String(this.DEFAULT_LTPA_CONFIG_NAME);
    }

    public String getLoginMappingLTPACallBackHandler() {
        return new String(this.CALLBACK_HANDLER_FACTORY_CLASS_NAME);
    }

    public String getNonceMaxAgeKey() {
        return new String(this.LOGIN_MAPPING_NONCE_MAXAGE);
    }

    public String getNonceClockSkewKey() {
        return new String(this.LOGIN_MAPPING_NONCE_CLOCKSKEW);
    }

    public String getDefaultNonceMaxAge() {
        return new String(this.NONCE_MAXAGE_DEFAULT);
    }

    public String getDefaultNonceClockSkew() {
        return new String(this.NONCE_CLOCKSKEW_DEFAULT);
    }

    public String getNonceKey() {
        return new String(this.LOGIN_CONFIG_NONCE);
    }

    public String getNonceTimestampKey() {
        return new String(this.LOGIN_CONFIG_NONCE_TIMESTAMP);
    }

    public String getClientNonceKey() {
        return new String(this.CLIENT_LOGIN_CONFIG_NONCE);
    }

    public String getClientNonceTimestampKey() {
        return new String(this.CLIENT_LOGIN_CONFIG_NONCE_TIMESTAMP);
    }

    public String getEnabledValue() {
        return new String(this.ENABLED_VALUE);
    }

    public String getDisabledValue() {
        return new String(this.DISABLED_VALUE);
    }

    public String[] getScopes() {
        String[] Scopes = new String[]{new String(this.SCOPE_REQUEST), new String(this.SCOPE_APPLICATION), new String(this.SCOPE_SESSION)};
        return Scopes;
    }

    public static String[] getUsageTypeNames() {
        String[] usageTypes = new String[]{new String(USAGE_TYPE_REQUIRED), new String(USAGE_TYPE_OPTIONAL)};
        return usageTypes;
    }

    public String[] getSecurityTokens() {
        return this.getValueTypeNames();
    }

    public String[] getURIs() {
        return this.getValueTypeURIs();
    }

    public String[] getLocalNames() {
        return this.getValueTypeLocalNames();
    }

    public String[] getTrustMethods() {
        String[] names = new String[]{new String("None"), new String("BasicAuth"), new String("Signature")};
        return names;
    }

    public String[] getTrustMethodLocalNames() {
        String[] names = new String[]{new String(""), new String(LOCAL_NAME_FORTYPE_USERNAME), new String(LOCAL_NAME_FORTYPE_X509)};
        return names;
    }

    public static String[] getDialects() {
        String[] names = new String[]{new String("http://www.ibm.com/websphere/webservices/wssecurity/dialect-was"), new String("http://www.w3.org/TR/1999/REC-xpath-19991116")};
        return names;
    }

    public static String getDefaultDialect() {
        return ATKWASUIConstants.getDialects()[0];
    }

    public static String[] getNames() {
        String[] names = new String[]{new String("WAS6"), new String("XPath")};
        return names;
    }

    public static String[] getIntegrityKeywords6() {
        return new String[]{BODY, TIME_STAMP, SECURITY, DSIG_KEY, ENC_KEY, MESSAGE_ID, TO, ACTION, RELATES_TO};
    }

    public static String[] getIntegrityKeywords7() {
        return new String[]{BODY, TIME_STAMP, SECURITY, DSIG_KEY, ENC_KEY, MESSAGE_ID, TO, ACTION, RELATES_TO, ALL, FROM, REPLY_TO, FAULT_TO, CONTEXT};
    }

    public static String getDefaultIntegrityKeyword() {
        return BODY;
    }

    public static String[] getConfidentialityKeywords6() {
        return new String[]{BODY_CONTENT, "usernametoken", "digestvalue"};
    }

    public static String[] getConfidentialityKeywords7() {
        return new String[]{BODY_CONTENT, "usernametoken", SIGNATURE, "digestvalue", CONTEXT_CONTENT};
    }

    public static String getDefaultConfidentialityKeyword() {
        return BODY_CONTENT;
    }
}

