/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.was.ui.utils;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.common.QName;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class WSDLHelper
extends org.eclipse.jst.j2ee.internal.webservice.helper.WSDLHelper {
    private IProject proj;

    public WSDLHelper(IProject aProject) {
        super(aProject);
        this.proj = aProject;
    }

    public String getPortNamespace(String serviceRefName, String compScopedRefName, ArrayList srs) {
        ServiceRef sr = null;
        int i = 0;
        while (i < srs.size()) {
            if (serviceRefName.equals(((ServiceRef)srs.get(i)).getServiceRefName())) {
                sr = (ServiceRef)srs.get(i);
            }
            ++i;
        }
        if (sr == null) {
            return null;
        }
        String wsdlURL = this.getWSDLFileURL(sr);
        if (wsdlURL.length() == 0) {
            return "";
        }
        String serviceLocalName = this.getServiceQname(sr);
        String namespace = this.getPortNamespace(wsdlURL, serviceLocalName);
        return namespace;
    }

    private String[] getPortNames(String wsdlURL, String serviceLocalName) {
        Service targetService = this.getTargetService(wsdlURL, serviceLocalName);
        if (targetService == null) {
            return null;
        }
        Map ports = targetService.getPorts();
        int numberOfPorts = ports.size();
        String[] portNames = new String[numberOfPorts];
        Iterator k = ports.values().iterator();
        int m = 0;
        while (m < numberOfPorts) {
            Port port = (Port)k.next();
            portNames[m] = port.getName();
            ++m;
        }
        return portNames;
    }

    private String getPortNamespace(String wsdlURL, String serviceLocalName) {
        Service targetService = this.getTargetService(wsdlURL, serviceLocalName);
        if (targetService == null) {
            return "";
        }
        return targetService.getQName().getNamespaceURI();
    }

    public String[] getPortNames(String serviceRefName, String compScopedRefName, ArrayList srs, String[] exclude) {
        ServiceRef sr = null;
        int i = 0;
        while (i < srs.size()) {
            if (serviceRefName.equals(((ServiceRef)srs.get(i)).getServiceRefName())) {
                sr = (ServiceRef)srs.get(i);
            }
            ++i;
        }
        if (sr == null) {
            return null;
        }
        String wsdlURL = this.getWSDLFileURL(sr);
        if (wsdlURL.length() == 0) {
            return null;
        }
        String serviceLocalName = this.getServiceQname(sr);
        String[] portNames = this.getPortNames(wsdlURL, serviceLocalName);
        portNames = this.trim(portNames, exclude);
        return portNames;
    }

    private Service getTargetService(String wsdlURL, String serviceLocalName) {
        Definition definition = this.getWSDLDefinition(wsdlURL);
        if (definition == null) {
            return null;
        }
        Service targetService = null;
        Map services = definition.getServices();
        if (!services.isEmpty()) {
            if ((serviceLocalName == null || serviceLocalName.length() == 0) && services.size() > 1) {
                return null;
            }
            if ((serviceLocalName == null || serviceLocalName.length() == 0) && services.size() == 1) {
                Iterator i = services.values().iterator();
                targetService = (Service)i.next();
            } else {
                for (Service service : services.values()) {
                    String serviceName = service.getQName().getLocalPart();
                    if (!serviceName.equals(serviceLocalName)) continue;
                    targetService = service;
                    break;
                }
            }
        }
        return targetService;
    }

    private Definition getWSDLDefinition(String wsdlURL) {
        Definition definition;
        block3: {
            try {
                WSDLFactory factory = WSDLFactory.newInstance();
                WSDLReader wsdlReader = factory.newWSDLReader();
                wsdlReader.setFeature("javax.wsdl.verbose", false);
                definition = wsdlReader.readWSDL(wsdlURL);
                if (definition != null) break block3;
                return null;
            }
            catch (WSDLException wSDLException) {
                return null;
            }
        }
        return definition;
    }

    private String getWSDLFileURL(ServiceRef sr) {
        String wsdlFileRelPath = sr.getWsdlFile();
        if (wsdlFileRelPath == null || wsdlFileRelPath.length() == 0) {
            return "";
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.proj);
        if (component != null) {
            String wsdlURL;
            IVirtualFolder moduleRoot = component.getRootFolder();
            IFile wsdlFile = moduleRoot.getFile(wsdlFileRelPath).getUnderlyingFile();
            if (!wsdlFile.exists()) {
                return "";
            }
            try {
                wsdlURL = wsdlFile.getLocation().toFile().toURL().toString();
            }
            catch (MalformedURLException malformedURLException) {
                return "";
            }
            if (wsdlURL == null || wsdlURL.length() == 0) {
                return "";
            }
            return wsdlURL;
        }
        return "";
    }

    private String getServiceQname(ServiceRef sr) {
        QName serviceQname = sr.getServiceQname();
        if (serviceQname == null) {
            return "";
        }
        String serviceLocalName = serviceQname.getLocalPart();
        if (serviceLocalName == null) {
            return "";
        }
        return serviceLocalName;
    }

    private String[] trim(String[] values, String[] exclude) {
        if (values == null || values.length == 0 || exclude == null || exclude.length == 0) {
            return values;
        }
        ArrayList<String> finalList = new ArrayList<String>();
        int i = 0;
        while (i < values.length) {
            if (!this.contains(exclude, values[i])) {
                finalList.add(values[i]);
            }
            ++i;
        }
        int finalSize = finalList.size();
        String[] finalValues = new String[finalSize];
        Object[] finalArray = finalList.toArray();
        int j = 0;
        while (j < finalSize) {
            finalValues[j] = (String)finalArray[j];
            ++j;
        }
        return finalValues;
    }

    private boolean contains(String[] values, String s) {
        if (values == null) {
            return false;
        }
        int i = 0;
        while (i < values.length) {
            if (values[i].equals(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

