/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.was.ui.editor.wsc;

import com.ibm.etools.webservice.atk.was.ui.plugin.ATKWASUIPlugin;
import com.ibm.etools.webtools.flatui.WidgetFactory;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.applicationclient.componentcore.util.AppClientArtifactEdit;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsclient.Webservice_clientFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class ServiceReferenceBrowseDialog
extends Dialog {
    private Table serviceRefTable_;
    private TableViewer serviceRefList_;
    private Label status_;
    private IVirtualComponent parent_;
    private String[] excluded_;
    private String addedServiceRefName_;
    private Color red_;
    private WidgetFactory wf_;

    public ServiceReferenceBrowseDialog(Shell shell, IVirtualComponent parent, String[] excluded) {
        super(shell);
        this.parent_ = parent;
        this.excluded_ = excluded;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ATKWASUIPlugin.getMessage("%DIALOG_TITLE_SERVICE_REF"));
    }

    protected Control createContents(Composite parent) {
        Composite comp = (Composite)super.createContents(parent);
        parent.getShell().setSize(400, 300);
        return comp;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.marginHeight = 5;
        gl.marginWidth = 5;
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        composite.setLayoutData((Object)gd);
        this.wf_ = new WidgetFactory();
        this.serviceRefTable_ = this.wf_.createTable(composite, 65540);
        this.serviceRefTable_.setLayoutData((Object)gd);
        this.serviceRefList_ = new TableViewer(this.serviceRefTable_);
        Webservice_clientFactory.eINSTANCE.getWebservice_clientPackage();
        this.serviceRefList_.setContentProvider((IContentProvider)new ServiceRefContentProvider());
        this.serviceRefList_.setLabelProvider((IBaseLabelProvider)new ServiceRefLabelProvider());
        this.serviceRefList_.setInput((Object)this.parent_);
        this.status_ = new Label(composite, 64);
        this.status_.setVisible(false);
        this.status_.setText(ATKWASUIPlugin.getMessage("%MSG_NO_SERVICE_REFS"));
        this.red_ = new Color((Device)this.getShell().getDisplay(), 255, 0, 0);
        this.status_.setForeground(this.red_);
        if (this.serviceRefTable_.getItemCount() > 0) {
            this.serviceRefTable_.select(0);
        } else {
            this.status_.setVisible(true);
        }
        return composite;
    }

    public String getAddedServiceRefName() {
        return this.addedServiceRefName_;
    }

    protected void okPressed() {
        TableItem[] selection = this.serviceRefTable_.getSelection();
        if (selection.length > 0) {
            TableItem item = selection[0];
            this.addedServiceRefName_ = item.getText();
            this.setReturnCode(0);
        } else {
            this.setReturnCode(1);
        }
        this.disposeWidgets();
        this.close();
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        this.disposeWidgets();
        this.close();
    }

    private void disposeWidgets() {
        if (this.red_ != null && !this.red_.isDisposed()) {
            this.red_.dispose();
        }
        if (this.wf_ != null) {
            this.wf_.dispose();
        }
    }

    public class ServiceRefContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            int size;
            ArrayList srs = new ArrayList();
            try {
                if (WebArtifactEdit.isValidWebModule((IVirtualComponent)ServiceReferenceBrowseDialog.this.parent_)) {
                    srs.addAll(((WebApp)ServiceReferenceBrowseDialog.this.parent_).getServiceRefs());
                } else if (EJBArtifactEdit.isValidEJBModule((IVirtualComponent)ServiceReferenceBrowseDialog.this.parent_)) {
                    EJBJar jar = (EJBJar)ServiceReferenceBrowseDialog.this.parent_;
                    EList beans = jar.getEnterpriseBeans();
                    int i = 0;
                    while (i < beans.size()) {
                        EnterpriseBean bean = (EnterpriseBean)beans.get(i);
                        srs.addAll(bean.getServiceRefs());
                        ++i;
                    }
                } else if (AppClientArtifactEdit.isValidApplicationClientModule((IVirtualComponent)ServiceReferenceBrowseDialog.this.parent_)) {
                    srs.addAll(((ApplicationClient)ServiceReferenceBrowseDialog.this.parent_).getServiceRefs());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int resultSize = size = srs.size();
            Object[] temp = new Object[size];
            Iterator i = srs.iterator();
            int j = 0;
            while (i.hasNext()) {
                ServiceRef sr = (ServiceRef)i.next();
                if (this.isExcluded(sr)) {
                    temp[j] = null;
                    --resultSize;
                } else {
                    temp[j] = sr;
                }
                ++j;
            }
            Object[] result = new Object[resultSize];
            int m = 0;
            int k = 0;
            while (k < size) {
                Object sr = temp[k];
                if (sr != null) {
                    result[m] = sr;
                    ++m;
                }
                ++k;
            }
            return result;
        }

        private boolean isExcluded(ServiceRef sr) {
            boolean excluded = false;
            String srName = sr.getServiceRefName();
            if (srName != null) {
                int size = ServiceReferenceBrowseDialog.this.excluded_.length;
                int i = 0;
                while (i < size) {
                    if (srName.equals(ServiceReferenceBrowseDialog.this.excluded_[i])) {
                        excluded = true;
                        break;
                    }
                    ++i;
                }
            }
            return excluded;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object old, Object newobj) {
        }
    }

    public class ServiceRefLabelProvider
    extends LabelProvider {
        private Image image_ = null;

        public Image getImage(Object element) {
            Object imageObj;
            if (this.image_ == null && (imageObj = ATKWASUIPlugin.getInstance().getImage("icons/obj16/serviceref_obj.gif")) != null) {
                this.image_ = (Image)imageObj;
            }
            return this.image_;
        }

        public String getText(Object element) {
            ServiceRef sr = (ServiceRef)element;
            return sr.getServiceRefName();
        }

        public void dispose() {
            if (this.image_ != null && !this.image_.isDisposed()) {
                this.image_.dispose();
            }
            super.dispose();
        }
    }
}

