/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.was.ui.editor.wsc;

import com.ibm.etools.webservice.atk.was.ui.constants.ATKWASUIConstants;
import com.ibm.etools.webservice.atk.was.ui.editor.common.DialogTableViewerEditor;
import com.ibm.etools.webservice.atk.was.ui.plugin.ATKWASUIPlugin;
import com.ibm.etools.webservice.wscbnd.BasicAuth;
import com.ibm.etools.webservice.wscbnd.LoginBinding;
import com.ibm.etools.webservice.wscbnd.WscbndFactory;
import com.ibm.etools.webservice.wscommonbnd.Property;
import com.ibm.etools.webservice.wscommonbnd.TokenValueType;
import com.ibm.etools.webservice.wscommonbnd.WscommonbndFactory;
import com.ibm.etools.webservice.wscommonbnd.WscommonbndPackage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandAddElement;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandSetElement;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.ArtifactEdit;

public class DialogWSCBndLoginBnd
extends Dialog
implements Listener {
    private String INFOPOP_DIALOG_LOGIN_BINDING = "com.ibm.etools.webservice.atk.was.ui.DLBI0001";
    private Shell shell_;
    private Combo authMethodCombo_;
    private Text tokenValueTypeURIText_;
    private Text tokenValueTypeLocalnameText_;
    private Combo callbackHandlerText_;
    private Text basicAuthIdText_;
    private Text basicAuthPasswordText_;
    private DialogTableViewerEditor propertyTable_;
    private ArtifactEdit artifactEdit_;
    private EObject eObject_;
    private EStructuralFeature feature_;
    private LoginBinding loginBinding_;
    private Object addedObject_;
    private String[] defaultAuthMethods_;

    public DialogWSCBndLoginBnd(Shell shell, ArtifactEdit artifactEdit, EObject eObject, EStructuralFeature feature, LoginBinding loginBinding) {
        super(shell);
        this.artifactEdit_ = artifactEdit;
        this.eObject_ = eObject;
        this.feature_ = feature;
        this.loginBinding_ = loginBinding;
        this.addedObject_ = null;
        this.defaultAuthMethods_ = null;
    }

    private String[] getDefaultAuthMethods() {
        if (this.defaultAuthMethods_ == null) {
            ATKWASUIConstants atkWasUiConstants = new ATKWASUIConstants();
            this.defaultAuthMethods_ = atkWasUiConstants.getLoginBindingAuthMethods();
        }
        return this.defaultAuthMethods_;
    }

    public void handleEvent(Event event) {
        if (this.authMethodCombo_ == event.widget || this.callbackHandlerText_ == event.widget) {
            Button okButton = this.getButton(0);
            if (okButton == null) {
                return;
            }
            okButton.setEnabled(this.validateInputs());
        }
    }

    private boolean validateInputs() {
        String authMethodComboValue = this.authMethodCombo_.getText();
        String callbackHandlerTextValue = this.callbackHandlerText_.getText();
        return authMethodComboValue != null && authMethodComboValue.length() > 0 && callbackHandlerTextValue != null && callbackHandlerTextValue.length() > 0;
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        super.cancelPressed();
    }

    protected void okPressed() {
        if (!this.validateInputs()) {
            this.cancelPressed();
            return;
        }
        WscbndFactory wscbndFactory = WscbndFactory.eINSTANCE;
        WscommonbndFactory wscommonbndFactory = WscommonbndFactory.eINSTANCE;
        LoginBinding loginBinding = wscbndFactory.createLoginBinding();
        loginBinding.setAuthMethod(this.authMethodCombo_.getText());
        if (this.tokenValueTypeURIText_.getEnabled() && this.tokenValueTypeLocalnameText_.getEnabled()) {
            TokenValueType tokenValueType = wscommonbndFactory.createTokenValueType();
            tokenValueType.setUri(this.tokenValueTypeURIText_.getText());
            tokenValueType.setLocalName(this.tokenValueTypeLocalnameText_.getText());
            loginBinding.setTokenValueType(tokenValueType);
        }
        loginBinding.setCallbackHandler(this.callbackHandlerText_.getText());
        String basicAuthID = this.basicAuthIdText_.getText();
        String basicAuthPassword = this.basicAuthPasswordText_.getText();
        if (basicAuthID != null && basicAuthID.length() > 0 || basicAuthPassword != null && basicAuthPassword.length() > 0) {
            BasicAuth basicAuth = wscbndFactory.createBasicAuth();
            basicAuth.setUserid(basicAuthID);
            basicAuth.setPassword(basicAuthPassword);
            loginBinding.setBasicAuth(basicAuth);
        }
        EList propertyList = loginBinding.getProperties();
        TableItem[] properties = this.propertyTable_.getItems();
        int i = 0;
        while (i < properties.length) {
            Property property = wscommonbndFactory.createProperty();
            property.setName(properties[i].getText(0));
            property.setValue(properties[i].getText(1));
            propertyList.add((Object)property);
            ++i;
        }
        Object command = this.loginBinding_ != null ? new CommandSetElement(null, null, this.eObject_, this.feature_, (Object)loginBinding, (Object)this.loginBinding_) : new CommandAddElement(null, null, this.eObject_, this.feature_, (Object)loginBinding);
        this.addedObject_ = loginBinding;
        this.artifactEdit_.getContentModelRoot().eResource().setModified(true);
        this.artifactEdit_.getCommandStack().execute((Command)command);
        this.setReturnCode(0);
        super.okPressed();
    }

    public Object getAddedObject() {
        return this.addedObject_;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getMessage("%DIALOG_TITLE_LOGIN_BINDING"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)gd);
        final ATKWASUIConstants atkWasUiConstants = new ATKWASUIConstants();
        Label label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_AUTH_METHOD"));
        label.setLayoutData((Object)new GridData(256));
        this.authMethodCombo_ = new Combo(composite, 2052);
        this.authMethodCombo_.setLayoutData((Object)new GridData(768));
        String[] methods = this.getDefaultAuthMethods();
        int i = 0;
        while (i < methods.length) {
            this.authMethodCombo_.add(methods[i]);
            ++i;
        }
        this.authMethodCombo_.select(0);
        this.authMethodCombo_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean userDefinedMethod = true;
                String authMethod = DialogWSCBndLoginBnd.this.authMethodCombo_.getText();
                if (authMethod.equals(atkWasUiConstants.getLTPAAuthenticationMethod())) {
                    DialogWSCBndLoginBnd.this.tokenValueTypeURIText_.setEnabled(true);
                    DialogWSCBndLoginBnd.this.tokenValueTypeLocalnameText_.setEnabled(true);
                    DialogWSCBndLoginBnd.this.tokenValueTypeURIText_.setText(atkWasUiConstants.getLTPATokenURI());
                    DialogWSCBndLoginBnd.this.tokenValueTypeLocalnameText_.setText(atkWasUiConstants.getLTPATokenLocalName());
                    DialogWSCBndLoginBnd.this.callbackHandlerText_.setText(atkWasUiConstants.getLoginBindingLTPACallbackHandler());
                } else {
                    String[] methods = DialogWSCBndLoginBnd.this.getDefaultAuthMethods();
                    if (authMethod != null) {
                        int i = 0;
                        while (i < methods.length) {
                            if (authMethod.equals(methods[i])) {
                                userDefinedMethod = false;
                                break;
                            }
                            ++i;
                        }
                    }
                    DialogWSCBndLoginBnd.this.tokenValueTypeURIText_.setEnabled(userDefinedMethod);
                    DialogWSCBndLoginBnd.this.tokenValueTypeLocalnameText_.setEnabled(userDefinedMethod);
                }
            }
        });
        this.authMethodCombo_.addListener(24, (Listener)this);
        label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_TOKEN_VALUE_TYPE"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_URI"));
        gd = new GridData(256);
        gd.horizontalIndent = 10;
        label.setLayoutData((Object)gd);
        this.tokenValueTypeURIText_ = new Text(composite, 2116);
        this.tokenValueTypeURIText_.setLayoutData((Object)new GridData(768));
        this.tokenValueTypeURIText_.setEnabled(false);
        label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_LOCALNAME"));
        gd = new GridData(256);
        gd.horizontalIndent = 10;
        label.setLayoutData((Object)gd);
        this.tokenValueTypeLocalnameText_ = new Text(composite, 2116);
        this.tokenValueTypeLocalnameText_.setLayoutData((Object)new GridData(768));
        this.tokenValueTypeLocalnameText_.setEnabled(false);
        label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_CALLBACK_HANDLER"));
        label.setLayoutData((Object)new GridData(256));
        this.callbackHandlerText_ = new Combo(composite, 2052);
        this.callbackHandlerText_.setLayoutData((Object)new GridData(768));
        String[] values = atkWasUiConstants.getCallbackHandlerValues();
        int i2 = 0;
        while (i2 < values.length) {
            this.callbackHandlerText_.add(values[i2]);
            ++i2;
        }
        this.callbackHandlerText_.addListener(24, (Listener)this);
        label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_BASIC_AUTHENTICATION"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_USER_ID"));
        gd = new GridData(256);
        gd.horizontalIndent = 10;
        label.setLayoutData((Object)gd);
        this.basicAuthIdText_ = new Text(composite, 2116);
        this.basicAuthIdText_.setLayoutData((Object)new GridData(768));
        label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_PASSWORD"));
        gd = new GridData(256);
        gd.horizontalIndent = 10;
        label.setLayoutData((Object)gd);
        this.basicAuthPasswordText_ = new Text(composite, 2116);
        this.basicAuthPasswordText_.setEchoChar('*');
        this.basicAuthPasswordText_.setLayoutData((Object)new GridData(768));
        WscommonbndPackage pkg = WscommonbndFactory.eINSTANCE.getWscommonbndPackage();
        Composite propertyComposite = new Composite(composite, 0);
        propertyComposite.setLayout((Layout)new GridLayout());
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        propertyComposite.setLayoutData((Object)gd);
        label = new Label(propertyComposite, 64);
        label.setText(this.getMessage("%LABEL_PROPERTY"));
        label.setLayoutData((Object)new GridData(256));
        String[] propertyTableColumns = new String[]{this.getMessage("%LABEL_TABLE_NAME"), this.getMessage("%LABEL_TABLE_VALUE")};
        EStructuralFeature[] propertyTableFeatures = new EStructuralFeature[]{pkg.getProperty_Name(), pkg.getProperty_Value()};
        Object[] propertyTableFeatureValues = new String[]{atkWasUiConstants.defaultName(), atkWasUiConstants.defaultValue()};
        this.propertyTable_ = new DialogTableViewerEditor(propertyComposite, propertyTableColumns, pkg.getProperty(), propertyTableFeatures, propertyTableFeatureValues);
        composite.setTabList(new Control[]{this.authMethodCombo_, this.tokenValueTypeURIText_, this.tokenValueTypeLocalnameText_, this.callbackHandlerText_, this.basicAuthIdText_, this.basicAuthPasswordText_, propertyComposite});
        this.init();
        return composite;
    }

    private void init() {
        if (this.loginBinding_ != null) {
            String authMethod = this.loginBinding_.getAuthMethod();
            int authMethodIndex = this.authMethodCombo_.indexOf(authMethod);
            if (authMethodIndex == -1) {
                this.authMethodCombo_.add(authMethod);
                this.authMethodCombo_.select(this.authMethodCombo_.indexOf(authMethod));
            } else {
                this.authMethodCombo_.select(authMethodIndex);
            }
            if (authMethodIndex == -1) {
                this.tokenValueTypeURIText_.setEnabled(true);
                this.tokenValueTypeLocalnameText_.setEnabled(true);
                TokenValueType tokenValueType = this.loginBinding_.getTokenValueType();
                if (tokenValueType != null) {
                    this.setText(this.tokenValueTypeURIText_, tokenValueType.getUri());
                    this.setText(this.tokenValueTypeLocalnameText_, tokenValueType.getLocalName());
                }
            }
            this.setText(this.callbackHandlerText_, this.loginBinding_.getCallbackHandler());
            BasicAuth basicAuth = this.loginBinding_.getBasicAuth();
            if (basicAuth != null) {
                this.setText(this.basicAuthIdText_, basicAuth.getUserid());
                this.setText(this.basicAuthPasswordText_, basicAuth.getPassword());
            }
            EList propertyList = this.loginBinding_.getProperties();
            for (Property property : propertyList) {
                this.propertyTable_.addItem(new Object[]{property.getName(), property.getValue()});
            }
            this.propertyTable_.refresh();
        }
    }

    private void setText(Text text, String s) {
        if (s != null) {
            text.setText(s);
        } else {
            text.setText("");
        }
    }

    private void setText(Combo combo, String s) {
        if (s != null) {
            combo.setText(s);
        } else {
            combo.setText("");
        }
    }

    protected String getMessage(String msgId) {
        return ATKWASUIPlugin.getMessage(msgId);
    }
}

