/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.was.ui.editor.wsc;

import com.ibm.etools.webservice.atk.was.ui.constants.ATKWASUIConstants;
import com.ibm.etools.webservice.wscommonext.Property;
import com.ibm.etools.webservice.wscommonext.WscommonextFactory;
import com.ibm.etools.webservice.wscommonext.WscommonextPackage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandModifyElement;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.wst.common.componentcore.ArtifactEdit;

public class AdapterNonce
extends AdapterImpl
implements SelectionListener {
    private ArtifactEdit artifactEdit_;
    private Property nonce_;
    private Property nonceTimestamp_;
    private Button nonceCheckBox_;
    private Button nonceTimestampCheckBox_;

    public AdapterNonce(ArtifactEdit artifactEdit, Property nonceProp, Property nonceTimestampProp, Button nonceCheckBox, Button nonceTimestampCheckBox) {
        this.artifactEdit_ = artifactEdit;
        this.nonceCheckBox_ = nonceCheckBox;
        this.nonceTimestampCheckBox_ = nonceTimestampCheckBox;
        this.adapt(nonceProp, nonceTimestampProp);
        this.addNonceSelectionListener();
    }

    public void adapt(Property nonce, Property nonceTimestamp) {
        ATKWASUIConstants constants = new ATKWASUIConstants();
        if (this.nonce_ != null) {
            this.nonce_.eAdapters().remove((Object)this);
        }
        if (this.nonceTimestamp_ != null) {
            this.nonceTimestamp_.eAdapters().remove((Object)this);
        }
        this.nonce_ = nonce;
        this.nonceTimestamp_ = nonceTimestamp;
        if (this.nonce_ != null) {
            this.nonce_.eAdapters().add((Object)this);
            this.nonceCheckBox_.setSelection(this.nonce_.getValue().equals(constants.getEnabledValue()));
            this.nonceCheckBox_.setEnabled(true);
        } else {
            this.nonceCheckBox_.setSelection(false);
            this.nonceCheckBox_.setEnabled(false);
        }
        if (this.nonceTimestamp_ != null) {
            this.nonceTimestamp_.eAdapters().add((Object)this);
            this.nonceTimestampCheckBox_.setSelection(this.nonceTimestamp_.getValue().equals(constants.getEnabledValue()));
            if (this.nonceCheckBox_.getSelection()) {
                this.nonceTimestampCheckBox_.setEnabled(true);
            }
        } else {
            this.nonceTimestampCheckBox_.setSelection(false);
            this.nonceTimestampCheckBox_.setEnabled(false);
        }
    }

    public void notifyChanged(Notification msg) {
        WscommonextPackage pkg = WscommonextFactory.eINSTANCE.getWscommonextPackage();
        int type = msg.getEventType();
        if (!(type != 1 && type != 2 || msg.getFeature() != pkg.getProperty_Name() && msg.getFeature() != pkg.getProperty_Value())) {
            this.updateCheckBoxes();
        }
    }

    private void updateCheckBoxes() {
        this.removeNonceSelectionListener();
        ATKWASUIConstants constants = new ATKWASUIConstants();
        String nonceName = this.nonce_.getName();
        if (!nonceName.equals(constants.getClientNonceKey())) {
            this.nonceCheckBox_.setSelection(false);
        } else if (this.nonce_.getValue().equals(constants.getEnabledValue())) {
            this.nonceCheckBox_.setSelection(true);
            this.nonceTimestampCheckBox_.setEnabled(true);
        } else {
            this.nonceCheckBox_.setSelection(false);
        }
        String nonceTimestampName = this.nonceTimestamp_.getName();
        if (!nonceTimestampName.equals(constants.getClientNonceTimestampKey())) {
            this.nonceTimestampCheckBox_.setSelection(false);
        } else {
            this.nonceTimestampCheckBox_.setSelection(this.nonceTimestamp_.getValue().equals(constants.getEnabledValue()));
        }
        this.addNonceSelectionListener();
    }

    private void addNonceSelectionListener() {
        this.nonceCheckBox_.addSelectionListener((SelectionListener)this);
        this.nonceTimestampCheckBox_.addSelectionListener((SelectionListener)this);
    }

    private void removeNonceSelectionListener() {
        if (this.nonceCheckBox_ != null && !this.nonceCheckBox_.isDisposed()) {
            this.nonceCheckBox_.removeSelectionListener((SelectionListener)this);
        }
        if (this.nonceTimestampCheckBox_ != null && !this.nonceTimestampCheckBox_.isDisposed()) {
            this.nonceTimestampCheckBox_.removeSelectionListener((SelectionListener)this);
        }
    }

    public void widgetSelected(SelectionEvent event) {
        this.handleCheckboxEvent(event);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.handleCheckboxEvent(event);
    }

    private void handleCheckboxEvent(SelectionEvent event) {
        if (event.widget == this.nonceCheckBox_) {
            this.handleNonceEvent();
        }
        if (event.widget == this.nonceTimestampCheckBox_) {
            this.handleNonceTimestampEvent();
        }
    }

    private void handleNonceEvent() {
        ATKWASUIConstants constants = new ATKWASUIConstants();
        boolean nonceSelected = this.nonceCheckBox_.getSelection();
        if (this.nonce_ == null) {
            return;
        }
        WscommonextPackage pkg = WscommonextFactory.eINSTANCE.getWscommonextPackage();
        EStructuralFeature[] properties = new EStructuralFeature[]{pkg.getProperty_Value()};
        Object[] values = new Object[]{nonceSelected ? constants.getEnabledValue() : constants.getDisabledValue()};
        this.nonce_.eAdapters().remove((Object)this);
        CommandModifyElement command = new CommandModifyElement(null, null, (EObject)this.nonce_, properties, values);
        this.artifactEdit_.getContentModelRoot().eResource().setModified(true);
        this.artifactEdit_.getCommandStack().execute((Command)command);
        this.nonce_.eAdapters().add((Object)this);
        this.removeNonceSelectionListener();
        if (nonceSelected) {
            this.nonceTimestampCheckBox_.setEnabled(true);
            this.nonceTimestampCheckBox_.setSelection(true);
        } else {
            this.nonceTimestampCheckBox_.setSelection(false);
            this.nonceTimestampCheckBox_.setEnabled(false);
        }
        this.addNonceSelectionListener();
        this.handleNonceTimestampEvent();
    }

    private void handleNonceTimestampEvent() {
        if (this.nonceTimestamp_ == null) {
            return;
        }
        ATKWASUIConstants constants = new ATKWASUIConstants();
        WscommonextPackage pkg = WscommonextFactory.eINSTANCE.getWscommonextPackage();
        boolean nonceTimestampSelected = this.nonceTimestampCheckBox_.getSelection();
        EStructuralFeature[] properties = new EStructuralFeature[]{pkg.getProperty_Value()};
        Object[] values = new Object[]{nonceTimestampSelected ? constants.getEnabledValue() : constants.getDisabledValue()};
        this.nonceTimestamp_.eAdapters().remove((Object)this);
        CommandModifyElement command = new CommandModifyElement(null, null, (EObject)this.nonceTimestamp_, properties, values);
        this.artifactEdit_.getContentModelRoot().eResource().setModified(true);
        this.artifactEdit_.getCommandStack().execute((Command)command);
        this.nonceTimestamp_.eAdapters().add((Object)this);
    }

    public void dispose() {
        if (this.nonce_ != null) {
            this.nonce_.eAdapters().remove((Object)this);
        }
        if (this.nonceTimestamp_ != null) {
            this.nonceTimestamp_.eAdapters().remove((Object)this);
        }
        this.removeNonceSelectionListener();
    }
}

