/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.was.ui.editor.ws;

import com.ibm.etools.webservice.atk.was.ui.constants.ATKWASUIConstants;
import com.ibm.etools.webservice.atk.was.ui.editor.ws.SectionLoginConfigEditor;
import com.ibm.etools.webservice.atk.was.ui.plugin.ATKWASUIPlugin;
import com.ibm.etools.webservice.wscommonext.Property;
import com.ibm.etools.webservice.wscommonext.WscommonextFactory;
import com.ibm.etools.webservice.wscommonext.WscommonextPackage;
import com.ibm.etools.webservice.wsext.LoginConfig;
import com.ibm.etools.webservice.wsext.PcBinding;
import com.ibm.etools.webservice.wsext.SecurityRequestReceiverServiceConfig;
import com.ibm.etools.webservice.wsext.ServerServiceConfig;
import com.ibm.etools.webservice.wsext.WsextFactory;
import com.ibm.etools.webservice.wsext.WsextPackage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandAddElement;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.ArtifactEdit;

public class DialogLoginConfigAdd
extends Dialog {
    protected final int DEFAULT_WIDTH_HINT = 256;
    private ArtifactEdit artifactEdit_;
    private PcBinding pcBinding_;
    private EClass childEClass_;
    private EStructuralFeature childFeature_;
    private EObject addedEObject_;
    private SectionLoginConfigEditor launchingSection_;
    protected String label_;
    protected CCombo authMethodText_;
    private Button nonceCheckBox_;
    private Button nonceTimestampCheckBox_;

    public DialogLoginConfigAdd(Shell shell, SectionLoginConfigEditor section, ArtifactEdit artifactEdit, PcBinding pcbnd, EClass childEClass, EStructuralFeature childFeature) {
        super(shell);
        this.artifactEdit_ = artifactEdit;
        this.pcBinding_ = pcbnd;
        this.childEClass_ = childEClass;
        this.childFeature_ = childFeature;
        this.launchingSection_ = section;
        this.label_ = ATKWASUIPlugin.getMessage("%LABEL_EXT_AUTH_METHOD");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginHeight = 5;
        gl.marginWidth = 5;
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 64);
        label.setText(this.label_);
        this.authMethodText_ = new CCombo(composite, 2052);
        gd = new GridData(768);
        gd.widthHint = 256;
        this.authMethodText_.setLayoutData((Object)gd);
        this.authMethodText_.add("BasicAuth");
        this.authMethodText_.add("IDAssertion");
        this.authMethodText_.add("Signature");
        this.authMethodText_.add("LTPA");
        this.authMethodText_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ATKWASUIConstants constants = new ATKWASUIConstants();
                String authMethod = DialogLoginConfigAdd.this.authMethodText_.getText();
                if (authMethod != null && authMethod.length() > 0) {
                    if (authMethod.equals(constants.getBasicAuthenticationMethod())) {
                        DialogLoginConfigAdd.this.nonceCheckBox_.setEnabled(true);
                    } else {
                        DialogLoginConfigAdd.this.nonceCheckBox_.setSelection(false);
                        DialogLoginConfigAdd.this.nonceCheckBox_.setEnabled(false);
                        DialogLoginConfigAdd.this.nonceTimestampCheckBox_.setSelection(false);
                        DialogLoginConfigAdd.this.nonceTimestampCheckBox_.setEnabled(false);
                    }
                }
            }
        });
        this.createNonceCheckboxes(composite);
        this.initializeControls();
        return composite;
    }

    private void createNonceCheckboxes(Composite parent) {
        this.nonceCheckBox_ = new Button(parent, 32);
        this.nonceCheckBox_.setText(ATKWASUIPlugin.getMessage("%LABEL_NONCE"));
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.nonceCheckBox_.setLayoutData((Object)gd);
        this.nonceCheckBox_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                DialogLoginConfigAdd.this.handleNonceCheckbox();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                DialogLoginConfigAdd.this.handleNonceCheckbox();
            }
        });
        this.nonceTimestampCheckBox_ = new Button(parent, 32);
        this.nonceTimestampCheckBox_.setText(ATKWASUIPlugin.getMessage("%LABEL_NONCE_TIMESTAMP"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.nonceTimestampCheckBox_.setLayoutData((Object)gd);
    }

    private void handleNonceCheckbox() {
        if (this.nonceCheckBox_.getSelection()) {
            this.nonceTimestampCheckBox_.setEnabled(true);
            this.nonceTimestampCheckBox_.setSelection(true);
        } else {
            this.nonceTimestampCheckBox_.setEnabled(false);
            this.nonceTimestampCheckBox_.setSelection(false);
        }
    }

    private void initializeControls() {
        ATKWASUIConstants constants = new ATKWASUIConstants();
        this.authMethodText_.setText(constants.getBasicAuthenticationMethod());
        this.nonceCheckBox_.setEnabled(true);
        this.nonceCheckBox_.setSelection(false);
        this.nonceTimestampCheckBox_.setEnabled(false);
    }

    protected void okPressed() {
        WsextPackage pkg = WsextFactory.eINSTANCE.getWsextPackage();
        WscommonextPackage wscommonPkg = WscommonextFactory.eINSTANCE.getWscommonextPackage();
        WsextFactory factory = pkg.getWsextFactory();
        wscommonPkg.getWscommonextFactory();
        if (this.pcBinding_ != null) {
            LoginConfig loginConfig;
            SecurityRequestReceiverServiceConfig srrsc;
            ServerServiceConfig serverServiceConfig = this.pcBinding_.getServerServiceConfig();
            if (serverServiceConfig == null) {
                serverServiceConfig = factory.createServerServiceConfig();
                srrsc = factory.createSecurityRequestReceiverServiceConfig();
                loginConfig = factory.createLoginConfig();
                srrsc.setLoginConfig(loginConfig);
                serverServiceConfig.setSecurityRequestReceiverServiceConfig(srrsc);
                this.pcBinding_.setServerServiceConfig(serverServiceConfig);
                this.launchingSection_.adaptModel((EObject)loginConfig);
            } else {
                srrsc = serverServiceConfig.getSecurityRequestReceiverServiceConfig();
                if (srrsc == null) {
                    srrsc = factory.createSecurityRequestReceiverServiceConfig();
                    loginConfig = factory.createLoginConfig();
                    srrsc.setLoginConfig(loginConfig);
                    serverServiceConfig.setSecurityRequestReceiverServiceConfig(srrsc);
                    this.launchingSection_.adaptModel((EObject)loginConfig);
                } else {
                    loginConfig = srrsc.getLoginConfig();
                    if (loginConfig == null) {
                        loginConfig = factory.createLoginConfig();
                        srrsc.setLoginConfig(loginConfig);
                        this.launchingSection_.adaptModel((EObject)loginConfig);
                    }
                }
            }
            String authMethodValue = this.authMethodText_.getText();
            EStructuralFeature[] features = new EStructuralFeature[]{wscommonPkg.getAuthMethod_Text()};
            Object[] featureValues = new Object[]{authMethodValue};
            CommandAddElement command = new CommandAddElement(null, null, (EObject)loginConfig, wscommonPkg.getAuthMethod(), (EStructuralFeature)pkg.getLoginConfig_AuthMethods(), features, featureValues);
            this.artifactEdit_.getContentModelRoot().eResource().setModified(true);
            this.artifactEdit_.getCommandStack().execute((Command)command);
            this.addedEObject_ = (EObject)command.getAddedObject();
            ATKWASUIConstants constants = new ATKWASUIConstants();
            if (authMethodValue.equals(constants.getBasicAuthenticationMethod())) {
                boolean nonceSelected = this.nonceCheckBox_.getSelection();
                if (!this.propertyExists(srrsc, constants.getNonceKey())) {
                    if (nonceSelected) {
                        this.addProperty(srrsc, constants.getNonceKey(), constants.getEnabledValue());
                    } else {
                        this.addProperty(srrsc, constants.getNonceKey(), constants.getDisabledValue());
                    }
                }
                boolean nonceTimestampSelected = this.nonceTimestampCheckBox_.getSelection();
                if (!this.propertyExists(srrsc, constants.getNonceTimestampKey())) {
                    if (nonceTimestampSelected) {
                        this.addProperty(srrsc, constants.getNonceTimestampKey(), constants.getEnabledValue());
                    } else {
                        this.addProperty(srrsc, constants.getNonceTimestampKey(), constants.getDisabledValue());
                    }
                }
            }
        }
        this.close();
    }

    private boolean propertyExists(SecurityRequestReceiverServiceConfig srrsc, String key) {
        for (Property prop : srrsc.getProperties()) {
            if (!prop.getName().equals(key)) continue;
            return true;
        }
        return false;
    }

    private Property addProperty(SecurityRequestReceiverServiceConfig srrsc, String name, String value) {
        WsextPackage pkg = WsextFactory.eINSTANCE.getWsextPackage();
        WscommonextPackage wscommonPkg = WscommonextFactory.eINSTANCE.getWscommonextPackage();
        pkg.getWsextFactory();
        wscommonPkg.getWscommonextFactory();
        EStructuralFeature[] features = new EStructuralFeature[]{wscommonPkg.getProperty_Name(), wscommonPkg.getProperty_Value()};
        Object[] featureValues = new Object[]{name, value};
        CommandAddElement command = new CommandAddElement(null, null, (EObject)srrsc, wscommonPkg.getProperty(), (EStructuralFeature)pkg.getSecurityRequestReceiverServiceConfig_Properties(), features, featureValues);
        this.artifactEdit_.getContentModelRoot().eResource().setModified(true);
        this.artifactEdit_.getCommandStack().execute((Command)command);
        Property addedProperty = (Property)command.getAddedObject();
        return addedProperty;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ATKWASUIPlugin.getMessage("%DIALOG_TITLE_ADD", new String[]{ATKWASUIPlugin.getMessage("%LABEL_EXT_AUTH_METHOD")}));
    }

    public EObject getAddedEObject() {
        return this.addedEObject_;
    }

    protected void cancelPressed() {
        this.close();
    }

    private void setText(Text text, String value) {
        if (value == null) {
            text.setText("");
        } else {
            text.setText(value);
        }
    }
}

