/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.was.ui.editor.common;

import com.ibm.etools.webservice.atk.was.ui.editor.common.DialogTableViewerEditor;
import com.ibm.etools.webservice.atk.was.ui.editor.common.TableModifyListener;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TextTableAdapter
implements ModifyListener,
TableModifyListener {
    private final int NOT_LISTENING = 0;
    private final int LISTENING_TO_KEY_COLUMN = 1;
    private final int LISTENING_TO_VALUE_COLUMN = 2;
    private Text[] texts_;
    private String[] keyValues_;
    private int keyColumn_;
    private int valueColumn_;
    private DialogTableViewerEditor tableEditor_;
    private Text tableText_;
    private int tableTextRow_;
    private Text text_;
    private int tableModifyListenerStatus = 0;

    public TextTableAdapter(Text[] texts, String[] keyValues, int keyColumn, int valueColumn, DialogTableViewerEditor tableEditor) {
        this.texts_ = texts;
        this.keyValues_ = keyValues;
        this.keyColumn_ = keyColumn;
        this.valueColumn_ = valueColumn;
        this.tableEditor_ = tableEditor;
        if (this.inputsValid()) {
            int i = 0;
            while (i < this.texts_.length) {
                this.texts_[i].addModifyListener((ModifyListener)this);
                ++i;
            }
            this.tableEditor_.addTableModifyListener(this);
        }
    }

    private boolean inputsValid() {
        if (this.texts_ == null || this.texts_.length == 0 || this.keyValues_ == null || this.keyValues_.length == 0 || this.tableEditor_ == null) {
            return false;
        }
        if (this.texts_.length != this.keyValues_.length) {
            return false;
        }
        int i = 0;
        while (i < this.keyValues_.length) {
            if (this.keyValues_[i] == null || this.keyValues_[i].length() == 0) {
                return false;
            }
            ++i;
        }
        if (this.keyColumn_ == this.valueColumn_) {
            return false;
        }
        int numColumns = this.tableEditor_.getNumColumns();
        if (this.keyColumn_ < 0 || this.keyColumn_ > numColumns - 1) {
            return false;
        }
        return this.valueColumn_ >= 0 && this.valueColumn_ <= numColumns - 1;
    }

    public void modifyText(ModifyEvent e) {
        if (this.tableText_ != null && e.widget == this.tableText_) {
            String newValue = this.tableText_.getText();
            if (this.tableModifyListenerStatus == 1) {
                boolean newValueIsKey = false;
                int keyValIndex = this.isKey(newValue);
                if (keyValIndex >= 0 && keyValIndex < this.keyValues_.length) {
                    TableItem item = this.tableEditor_.getItem(this.tableTextRow_);
                    String value = item.getText(this.valueColumn_);
                    this.texts_[keyValIndex].removeModifyListener((ModifyListener)this);
                    this.texts_[keyValIndex].setText(value);
                    this.texts_[keyValIndex].addModifyListener((ModifyListener)this);
                    newValueIsKey = true;
                }
                if (!newValueIsKey) {
                    this.resyncTextAndTable(this.tableTextRow_);
                }
            } else if (this.tableModifyListenerStatus == 2) {
                this.text_.removeModifyListener((ModifyListener)this);
                this.text_.setText(newValue);
                this.text_.addModifyListener((ModifyListener)this);
            }
            return;
        }
        int i = 0;
        while (i < this.texts_.length) {
            Text text = this.texts_[i];
            if (e.widget == text) {
                this.tableEditor_.notifyPropertyChanged(this.keyValues_[i], this.keyColumn_, text.getText(), this.valueColumn_);
            }
            ++i;
        }
    }

    public void tableCellSelected(Text text, int row, int column) {
        if (column == this.keyColumn_) {
            this.resetTableText();
            this.tableText_ = text;
            this.tableText_.addModifyListener((ModifyListener)this);
            this.tableModifyListenerStatus = 1;
            this.tableTextRow_ = row;
            this.text_ = null;
        } else if (column == this.valueColumn_) {
            TableItem item = this.tableEditor_.getItem(row);
            String keyColVal = item.getText(this.keyColumn_);
            int keyValIndex = this.isKey(keyColVal);
            if (keyValIndex >= 0 && keyValIndex < this.keyValues_.length) {
                this.resetTableText();
                this.tableText_ = text;
                this.tableText_.addModifyListener((ModifyListener)this);
                this.tableModifyListenerStatus = 2;
                this.text_ = this.texts_[keyValIndex];
            }
        } else {
            this.resetTableText();
            this.text_ = null;
        }
    }

    public void tableItemRemoved(Object object, EStructuralFeature[] features) {
        String keyColVal;
        int keyValIndex;
        EStructuralFeature keyFeature;
        Object keyObject;
        if (object != null && object instanceof EObject && (keyObject = ((EObject)object).eGet(keyFeature = features[this.keyColumn_])) instanceof String && (keyValIndex = this.isKey(keyColVal = (String)keyObject)) >= 0 && keyValIndex < this.keyValues_.length) {
            this.texts_[keyValIndex].removeModifyListener((ModifyListener)this);
            this.texts_[keyValIndex].setText("");
            this.texts_[keyValIndex].addModifyListener((ModifyListener)this);
        }
    }

    private void resyncTextAndTable(int rowToExclude) {
        this.clearTexts();
        TableItem[] items = this.tableEditor_.getItems();
        int i = 0;
        while (i < items.length) {
            String valColValue;
            TableItem item;
            String keyColVal;
            int keyValIndex;
            if (i != rowToExclude && (keyValIndex = this.isKey(keyColVal = (item = items[i]).getText(this.keyColumn_))) >= 0 && keyValIndex < this.keyValues_.length && (valColValue = item.getText(this.valueColumn_)) != null && valColValue.length() > 0) {
                this.texts_[keyValIndex].removeModifyListener((ModifyListener)this);
                this.texts_[keyValIndex].setText(valColValue);
                this.texts_[keyValIndex].addModifyListener((ModifyListener)this);
            }
            ++i;
        }
    }

    private int isKey(String s) {
        int i = 0;
        while (i < this.keyValues_.length) {
            if (s.equals(this.keyValues_[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void clearTexts() {
        int i = 0;
        while (i < this.texts_.length) {
            this.texts_[i].removeModifyListener((ModifyListener)this);
            this.texts_[i].setText("");
            this.texts_[i].addModifyListener((ModifyListener)this);
            ++i;
        }
    }

    private void resetTableText() {
        if (this.tableText_ != null && !this.tableText_.isDisposed()) {
            this.tableText_.removeModifyListener((ModifyListener)this);
        }
        this.tableText_ = null;
        this.tableModifyListenerStatus = 0;
    }
}

