/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.was.ui.editor.common;

import com.ibm.etools.webservice.atk.was.ui.editor.common.TableModifyListener;
import com.ibm.etools.webservice.atk.was.ui.plugin.ATKWASUIPlugin;
import java.util.ArrayList;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DialogTableViewerEditor
extends Composite {
    private int DEFAULT_TABLE_HEIGHT_HINT = 100;
    private int DEFAULT_COLUMN_WIDTH = 80;
    private String[] columns_;
    private TableViewer tableViewer_;
    private Table table_;
    private TableEditor editor_;
    private TableEditorListener tableEditorListener_;
    private Text text_;
    private Button add_;
    private Button remove_;
    private EClass eClass_;
    private EStructuralFeature[] features_;
    private Object[] featureValues_;
    private InputObject inputObject_;
    private InputObjectContentProvider contentProvider_;
    private InputObjectLabelProvider labelProvider_;
    private ArrayList tableModifyListeners_;

    public DialogTableViewerEditor(Composite parent, String[] columns, EClass eClass, EStructuralFeature[] features, Object[] featureValues) {
        super(parent, 0);
        this.columns_ = columns;
        this.eClass_ = eClass;
        this.features_ = features;
        this.featureValues_ = featureValues;
        this.inputObject_ = new InputObject();
        this.contentProvider_ = new InputObjectContentProvider();
        this.labelProvider_ = new InputObjectLabelProvider();
        this.createPartControl(this);
        this.tableModifyListeners_ = new ArrayList();
    }

    private void createPartControl(Composite parent) {
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
        this.setLayoutData(new GridData(768));
        Composite composite = new Composite(parent, 0);
        gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(768));
        this.table_ = new Table(composite, 67588);
        GridData gd = new GridData(1808);
        gd.heightHint = this.DEFAULT_TABLE_HEIGHT_HINT;
        this.table_.setLayoutData((Object)gd);
        this.table_.setHeaderVisible(true);
        this.table_.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        int maxWidth = this.DEFAULT_COLUMN_WIDTH;
        int i = 0;
        while (i < this.columns_.length) {
            TableColumn tableColumn = new TableColumn(this.table_, 0);
            tableColumn.setText(this.columns_[i]);
            tableColumn.pack();
            int tableColumnWidth = Math.max(this.DEFAULT_COLUMN_WIDTH, tableColumn.getWidth());
            maxWidth = Math.max(maxWidth, tableColumnWidth);
            ColumnWeightData columnData = new ColumnWeightData(tableColumnWidth, tableColumnWidth, true);
            tableLayout.addColumnData((ColumnLayoutData)columnData);
            ++i;
        }
        this.table_.setLayout((Layout)tableLayout);
        this.editor_ = new TableEditor(this.table_);
        this.editor_.horizontalAlignment = 16384;
        this.editor_.grabHorizontal = true;
        this.editor_.minimumWidth = maxWidth;
        this.tableEditorListener_ = new TableEditorListener();
        this.table_.addMouseListener((MouseListener)this.tableEditorListener_);
        this.tableViewer_ = new TableViewer(this.table_);
        this.tableViewer_.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                char asciiDel = e.character;
                if (asciiDel == '\u007f') {
                    DialogTableViewerEditor.this.handleDeleteKeyPressed();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.tableViewer_.setContentProvider((IContentProvider)this.contentProvider_);
        this.tableViewer_.setLabelProvider((IBaseLabelProvider)this.labelProvider_);
        this.tableViewer_.setInput((Object)this.inputObject_);
        this.tableViewer_.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DialogTableViewerEditor.this.enableRemove(true);
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        gl = new GridLayout();
        gl.numColumns = 2;
        gl.makeColumnsEqualWidth = true;
        buttonComposite.setLayout((Layout)gl);
        buttonComposite.setLayoutData((Object)new GridData(544));
        this.add_ = new Button(buttonComposite, 8);
        this.add_.setText(ATKWASUIPlugin.getMessage("%LABEL_ADD"));
        this.add_.setLayoutData((Object)new GridData(256));
        this.add_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                DialogTableViewerEditor.this.handleAddButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.remove_ = new Button(buttonComposite, 8);
        this.remove_.setText(ATKWASUIPlugin.getMessage("%LABEL_REMOVE"));
        this.remove_.setLayoutData((Object)new GridData(256));
        this.remove_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                DialogTableViewerEditor.this.handleRemoveButtonSelected(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.enableRemove(false);
    }

    private void enableRemove(boolean enabled) {
        this.remove_.setEnabled(enabled && !this.tableViewer_.getSelection().isEmpty());
    }

    private void handleAddButtonSelected(SelectionEvent event) {
        this.addItem(this.featureValues_);
        this.refresh();
        this.table_.select(this.table_.getItemCount() - 1);
        this.tableEditorListener_.editSelection();
    }

    private void handleRemoveButtonSelected(SelectionEvent event) {
        this.handleDeleteKeyPressed();
    }

    private void handleDeleteKeyPressed() {
        this.internalDispose();
        ISelection selection = this.tableViewer_.getSelection();
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            int selectionIndex = this.table_.getSelectionIndex();
            int selectionCount = this.table_.getItemCount();
            Object object = ((IStructuredSelection)selection).getFirstElement();
            this.inputObject_.remove(object);
            if (selectionIndex < selectionCount - 1) {
                this.table_.select(selectionIndex);
            } else if (selectionCount - 2 >= 0) {
                this.table_.select(selectionCount - 2);
            }
            this.refresh();
            this.notifyRemoved(object);
        }
    }

    private void internalRefresh() {
        if (this.text_ != null) {
            TableItem oldTableItem = this.editor_.getItem();
            int oldColumnIndex = this.editor_.getColumn();
            if (oldTableItem != null && oldColumnIndex >= 0 && oldColumnIndex < this.columns_.length) {
                String oldText = this.text_.getText();
                oldTableItem.setText(oldColumnIndex, oldText);
                int oldRowIndex = this.table_.indexOf(oldTableItem);
                Object object = this.tableViewer_.getElementAt(oldRowIndex);
                if (object != null && object instanceof EObject && this.features_.length > oldColumnIndex) {
                    ((EObject)object).eSet(this.features_[oldColumnIndex], (Object)oldText);
                }
            }
        }
    }

    public void refresh() {
        this.internalRefresh();
        this.tableViewer_.refresh();
    }

    public void addItem(Object[] itemValues) {
        if (this.eClass_ != null) {
            EFactory eFactory = this.eClass_.getEPackage().getEFactoryInstance();
            EObject eObject = eFactory.create(this.eClass_);
            if (this.features_ != null && itemValues != null && this.features_.length == itemValues.length) {
                int i = 0;
                while (i < this.features_.length) {
                    eObject.eSet(this.features_[i], itemValues[i]);
                    ++i;
                }
            }
            this.inputObject_.add(eObject);
        }
    }

    public void addConfiguredItem(String[] propertyValues) {
        this.addItem(propertyValues);
        this.refresh();
        this.table_.select(this.table_.getItemCount() - 1);
    }

    private Object findObject(String value, EStructuralFeature feature) {
        EList existingObjects = this.inputObject_.getExistingEObjects();
        EList newObjects = this.inputObject_.getNewEObjects();
        for (EObject eObject : existingObjects) {
            String keyFeatureValue;
            Object keyFeatureObj = eObject.eGet(feature);
            if (!(keyFeatureObj instanceof String) || !(keyFeatureValue = (String)keyFeatureObj).equals(value)) continue;
            return eObject;
        }
        for (EObject eObject : newObjects) {
            String keyFeatureValue;
            Object keyFeatureObj = eObject.eGet(feature);
            if (!(keyFeatureObj instanceof String) || !(keyFeatureValue = (String)keyFeatureObj).equals(value)) continue;
            return eObject;
        }
        return null;
    }

    public void notifyPropertyChanged(String key, int keyColumn, String newValue, int valueColumn) {
        Object object = this.findObject(key, this.features_[keyColumn]);
        if (object == null && newValue != null && newValue.length() > 0) {
            String[] configuredItem = new String[this.table_.getColumnCount()];
            int k = 0;
            while (k < configuredItem.length) {
                configuredItem[k] = k == keyColumn ? key : (k == valueColumn ? newValue : "");
                ++k;
            }
            this.addConfiguredItem(configuredItem);
        }
        if (newValue != null && newValue.length() > 0) {
            if (object instanceof EObject) {
                this.internalRefresh();
                this.internalDispose();
                EObject eObject = (EObject)object;
                eObject.eSet(this.features_[valueColumn], (Object)newValue);
                this.refresh();
            }
        } else {
            this.inputObject_.remove(object);
            this.refresh();
        }
    }

    public TableItem[] getItems() {
        this.internalRefresh();
        return this.table_.getItems();
    }

    public TableItem getItem(int row) {
        this.internalRefresh();
        return this.table_.getItem(row);
    }

    public int getNumColumns() {
        return this.table_.getColumnCount();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.add_.setEnabled(enabled);
        this.enableRemove(enabled);
    }

    public void dispose() {
        super.dispose();
        this.internalDispose();
        if (this.editor_ != null) {
            this.editor_.dispose();
        }
        if (this.table_ != null) {
            this.table_.dispose();
        }
        if (this.add_ != null) {
            this.add_.dispose();
        }
        if (this.remove_ != null) {
            this.remove_.dispose();
        }
    }

    public void internalDispose() {
        if (this.text_ != null) {
            this.text_.dispose();
        }
        this.text_ = null;
    }

    public void addTableModifyListener(TableModifyListener listener) {
        this.tableModifyListeners_.add(listener);
    }

    public void removeTableModifyListener(TableModifyListener listener) {
        this.tableModifyListeners_.remove(listener);
    }

    private void updateTableModifyListeners(Text text, int row, int column) {
        Object[] listeners = this.tableModifyListeners_.toArray();
        int i = 0;
        while (i < listeners.length) {
            TableModifyListener listener = (TableModifyListener)listeners[i];
            listener.tableCellSelected(text, row, column);
            ++i;
        }
    }

    private void notifyRemoved(Object removedObject) {
        Object[] listeners = this.tableModifyListeners_.toArray();
        int i = 0;
        while (i < listeners.length) {
            TableModifyListener listener = (TableModifyListener)listeners[i];
            listener.tableItemRemoved(removedObject, this.features_);
            ++i;
        }
    }

    private class InputObject {
        private EList existingEObjects_ = new BasicEList();
        private EList newEObjects_ = new BasicEList();

        public EList getExistingEObjects() {
            return this.existingEObjects_;
        }

        public void setExistingEObjects(EList existingEObjects) {
            this.existingEObjects_ = existingEObjects;
        }

        public EList getNewEObjects() {
            return this.newEObjects_;
        }

        public void setNewEObjects(EList newEObjects) {
            this.newEObjects_ = newEObjects;
        }

        public void add(Object object) {
            this.newEObjects_.add(object);
        }

        public void remove(Object object) {
            if (!this.existingEObjects_.remove(object)) {
                this.newEObjects_.remove(object);
            }
        }
    }

    private class InputObjectContentProvider
    implements IStructuredContentProvider {
        private InputObjectContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            DialogTableViewerEditor.this.tableViewer_.add(this.getElements(newInput));
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof InputObject) {
                InputObject inputObject = (InputObject)inputElement;
                Object[] existingObjects = inputObject.getExistingEObjects().toArray();
                Object[] newObjects = inputObject.getNewEObjects().toArray();
                Object[] objects = new Object[existingObjects.length + newObjects.length];
                int index = 0;
                int i = 0;
                while (i < existingObjects.length) {
                    objects[index++] = existingObjects[i];
                    ++i;
                }
                i = 0;
                while (i < newObjects.length) {
                    objects[index++] = newObjects[i];
                    ++i;
                }
                return objects;
            }
            return new Object[0];
        }
    }

    private class InputObjectLabelProvider
    implements ITableLabelProvider {
        private InputObjectLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            EObject eObject;
            Object value;
            if (DialogTableViewerEditor.this.features_ != null && DialogTableViewerEditor.this.features_.length > columnIndex && element instanceof EObject && (value = (eObject = (EObject)element).eGet(DialogTableViewerEditor.this.features_[columnIndex])) != null) {
                return value.toString();
            }
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void dispose() {
        }
    }

    private class TableEditorListener
    implements MouseListener {
        private int currSelectionIndex_ = -1;

        public void mouseDoubleClick(MouseEvent e) {
            this.mouseDown(e);
        }

        public void mouseDown(MouseEvent e) {
            DialogTableViewerEditor.this.internalRefresh();
            DialogTableViewerEditor.this.internalDispose();
            if (DialogTableViewerEditor.this.table_.isFocusControl()) {
                TableItem tableItem;
                int selectedColumnIndex;
                int selectedRowIndex = this.getSelectedRow(DialogTableViewerEditor.this.table_, e.y);
                if (this.currSelectionIndex_ != -1 && selectedRowIndex != -1 && this.currSelectionIndex_ == selectedRowIndex && (selectedColumnIndex = this.getSelectedColumn(tableItem = DialogTableViewerEditor.this.table_.getItem(selectedRowIndex), e.x, e.y)) != -1 && (DialogTableViewerEditor.this.text_ == null || DialogTableViewerEditor.this.text_.isDisposed() || selectedColumnIndex != DialogTableViewerEditor.this.editor_.getColumn())) {
                    this.editSelection(selectedRowIndex, selectedColumnIndex);
                }
                this.currSelectionIndex_ = selectedRowIndex;
            }
        }

        public void mouseUp(MouseEvent e) {
        }

        private int getSelectedRow(Table table, int y) {
            TableItem[] tableItems = table.getItems();
            int i = 0;
            while (i < tableItems.length) {
                Rectangle rectangle = tableItems[i].getBounds(0);
                if (rectangle != null && y >= rectangle.y && y < rectangle.y + rectangle.height) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private int getSelectedColumn(TableItem tableItem, int x, int y) {
            int i = 0;
            while (i < DialogTableViewerEditor.this.columns_.length) {
                if (tableItem.getBounds(i).contains(x, y)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private void editSelection(int row, int column) {
            TableItem tableItem = DialogTableViewerEditor.this.table_.getItem(row);
            DialogTableViewerEditor.this.text_ = new Text((Composite)DialogTableViewerEditor.this.table_, 0);
            String text = tableItem.getText(column);
            DialogTableViewerEditor.this.text_.setText(text != null ? text : "");
            DialogTableViewerEditor.this.editor_.setEditor((Control)DialogTableViewerEditor.this.text_, tableItem, column);
            DialogTableViewerEditor.this.text_.setFocus();
            DialogTableViewerEditor.this.text_.selectAll();
            DialogTableViewerEditor.this.updateTableModifyListeners(DialogTableViewerEditor.this.text_, row, column);
        }

        public void editSelection() {
            int selectedRowIndex = DialogTableViewerEditor.this.table_.getSelectionIndex();
            if (selectedRowIndex != -1 && DialogTableViewerEditor.this.columns_.length > 0) {
                DialogTableViewerEditor.this.internalRefresh();
                DialogTableViewerEditor.this.internalDispose();
                this.editSelection(selectedRowIndex, 0);
            }
            this.currSelectionIndex_ = selectedRowIndex;
        }
    }
}

