/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.was.ui.editor.common;

import com.ibm.ast.ws.ui.messages.Messages;
import com.ibm.ast.ws.ui.plugin.WSUIPlugin;
import com.ibm.etools.webservice.atk.was.ui.constants.ATKWASUIConstants;
import com.ibm.etools.webservice.atk.was.ui.plugin.ATKWASUIPlugin;
import com.ibm.etools.webservice.wscommonbnd.CanonicalizationMethod;
import com.ibm.etools.webservice.wscommonbnd.CertPathSettings;
import com.ibm.etools.webservice.wscommonbnd.CertStoreList;
import com.ibm.etools.webservice.wscommonbnd.CertStoreRef;
import com.ibm.etools.webservice.wscommonbnd.CollectionCertStore;
import com.ibm.etools.webservice.wscommonbnd.DigestMethod;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.LDAPCertStore;
import com.ibm.etools.webservice.wscommonbnd.SignatureMethod;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.SigningKey;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchor;
import com.ibm.etools.webservice.wscommonbnd.TrustAnchorRef;
import com.ibm.etools.webservice.wscommonbnd.TrustAnyCertificate;
import com.ibm.etools.webservice.wscommonbnd.WscommonbndFactory;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandAddElement;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandSetElement;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.common.componentcore.ArtifactEdit;

public class DialogSingingInfo
extends Dialog
implements Listener {
    private String INFOPOP_DIALOG_SIGNING_INFO = "com.ibm.etools.webservice.atk.was.ui.DSIG0001";
    private Shell shell_;
    private Combo canonicalizationMethodAlgorithm_;
    private Button showFIPSComplientAlgorithms_;
    private Combo digestMethodAlgorithm_;
    private Combo signatureMethodAlgorithm_;
    private Text signingKeyName_;
    private Combo signingKeyLocatorRef_;
    private Combo trustAnchorRef_;
    private Combo certStoreRef_;
    private Button signingKeyButton_;
    private Button certPathSettingsButton_;
    private Button specifyCertPathRefButton_;
    private Button trustAnyCertButton_;
    private ArtifactEdit artifactEdit_;
    private EObject eObject_;
    private EStructuralFeature feature_;
    private SigningInfo signingInfo_;
    private Object addedObject_;
    private EStructuralFeature locatorRefFeature_;
    private EStructuralFeature trustAnchorFeature_;
    private EStructuralFeature certStoreListFeature_;
    private boolean useSigningKey_;
    private boolean useCertificate_;
    private ATKWASUIConstants atkWasUiConstants;

    public DialogSingingInfo(Shell shell, ArtifactEdit artifactEdit, EObject eObject, EStructuralFeature feature, SigningInfo signingInfo) {
        super(shell);
        this.artifactEdit_ = artifactEdit;
        this.eObject_ = eObject;
        this.feature_ = feature;
        this.signingInfo_ = signingInfo;
        this.addedObject_ = null;
        this.locatorRefFeature_ = null;
        this.trustAnchorFeature_ = null;
        this.certStoreListFeature_ = null;
        this.useSigningKey_ = true;
        this.useCertificate_ = true;
        this.atkWasUiConstants = new ATKWASUIConstants();
    }

    public void setLocatorRefFeature(EStructuralFeature locatorRefFeature) {
        this.locatorRefFeature_ = locatorRefFeature;
    }

    public void setTrustAnchorFeature(EStructuralFeature trustAnchorFeature) {
        this.trustAnchorFeature_ = trustAnchorFeature;
    }

    public void setCertStoreListFeature(EStructuralFeature certStoreListFeature) {
        this.certStoreListFeature_ = certStoreListFeature;
    }

    public void setUseSigningKey(boolean useSigningKey) {
        this.useSigningKey_ = useSigningKey;
    }

    public void setUseCertificate(boolean useCertificate) {
        this.useCertificate_ = useCertificate;
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        super.cancelPressed();
    }

    protected void okPressed() {
        String signatureMethodText;
        String digestMethodText;
        WscommonbndFactory factory = WscommonbndFactory.eINSTANCE;
        SigningInfo signingInfo = factory.createSigningInfo();
        String canonicalizationMethodText = this.canonicalizationMethodAlgorithm_.getText();
        if (canonicalizationMethodText != null && canonicalizationMethodText.length() > 0) {
            CanonicalizationMethod canonicalizationMethod = factory.createCanonicalizationMethod();
            canonicalizationMethod.setAlgorithm(canonicalizationMethodText);
            signingInfo.setCanonicalizationMethod(canonicalizationMethod);
        }
        if ((digestMethodText = this.digestMethodAlgorithm_.getText()) != null && digestMethodText.length() > 0) {
            DigestMethod digestMethod = factory.createDigestMethod();
            digestMethod.setAlgorithm(digestMethodText);
            signingInfo.setDigestMethod(digestMethod);
        }
        if ((signatureMethodText = this.signatureMethodAlgorithm_.getText()) != null && signatureMethodText.length() > 0) {
            SignatureMethod signatureMethod = factory.createSignatureMethod();
            signatureMethod.setAlgorithm(signatureMethodText);
            signingInfo.setSignatureMethod(signatureMethod);
        }
        if (this.useSigningKey_) {
            if (this.signingKeyButton_ == null || this.signingKeyButton_.getSelection()) {
                SigningKey signingKey = factory.createSigningKey();
                signingKey.setName(this.signingKeyName_.getText());
                signingKey.setLocatorRef(this.signingKeyLocatorRef_.getText());
                signingInfo.setSigningKey(signingKey);
            }
        } else if (this.useCertificate_ && (this.certPathSettingsButton_ == null || this.certPathSettingsButton_.getSelection())) {
            CertPathSettings certPathSettings = factory.createCertPathSettings();
            if (this.specifyCertPathRefButton_.getSelection()) {
                TrustAnchorRef trustAnchorRef = factory.createTrustAnchorRef();
                trustAnchorRef.setRef(this.trustAnchorRef_.getText());
                certPathSettings.setTrustAnchorRef(trustAnchorRef);
                String storeRef = this.certStoreRef_.getText();
                if (storeRef != null && storeRef.length() > 0) {
                    CertStoreRef certStoreRef = factory.createCertStoreRef();
                    certStoreRef.setRef(storeRef);
                    certPathSettings.setCertStoreRef(certStoreRef);
                }
            } else {
                TrustAnyCertificate trustAnyCertificate = factory.createTrustAnyCertificate();
                certPathSettings.setTrustAnyCertificate(trustAnyCertificate);
            }
            signingInfo.setCertPathSettings(certPathSettings);
        }
        Object command = this.signingInfo_ != null ? new CommandSetElement(null, null, this.eObject_, this.feature_, (Object)signingInfo, (Object)this.signingInfo_) : new CommandAddElement(null, null, this.eObject_, this.feature_, (Object)signingInfo);
        this.addedObject_ = signingInfo;
        this.artifactEdit_.getContentModelRoot().eResource().setModified(true);
        this.artifactEdit_.getCommandStack().execute((Command)command);
        this.setReturnCode(0);
        super.okPressed();
    }

    public Object getAddedObject() {
        return this.addedObject_;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getMessage("%DIALOG_TITLE_SIGNING_INFO"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite composite1 = new Composite(composite, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        composite1.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        composite1.setLayoutData((Object)gd);
        this.canonicalizationMethodAlgorithm_ = this.createComboBox(composite1, this.getMessage("%LABEL_CANONICALIZATION_METHOD_ALGORITHM"));
        this.canonicalizationMethodAlgorithm_.setItems(this.atkWasUiConstants.getSigningInfoCanonicalizationMethods());
        this.canonicalizationMethodAlgorithm_.select(0);
        Group fipsGroup = new Group(composite, 0);
        gl = new GridLayout();
        gl.numColumns = 2;
        fipsGroup.setLayout((Layout)gl);
        gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        fipsGroup.setLayoutData((Object)gd);
        this.showFIPSComplientAlgorithms_ = this.creatCheckBox((Composite)fipsGroup, Messages.BUTTON_SHOW_FIPS, WSUIPlugin.getInstance().getWASSecurityContext().isFIPSComplient());
        this.showFIPSComplientAlgorithms_.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DialogSingingInfo.this.getAlgorithms(DialogSingingInfo.this.showFIPSComplientAlgorithms_.getSelection());
            }
        });
        this.digestMethodAlgorithm_ = this.createComboBox((Composite)fipsGroup, this.getMessage("%LABEL_DIGEST_METHOD_ALGORITHM"));
        this.signatureMethodAlgorithm_ = this.createComboBox((Composite)fipsGroup, this.getMessage("%LABEL_SIGNATURE_METHOD_ALGORITHM"));
        this.getAlgorithms(this.showFIPSComplientAlgorithms_.getSelection());
        if (this.useSigningKey_ && this.useCertificate_) {
            this.signingKeyButton_ = this.createRadio(composite, this.getMessage("%LABEL_USE_SIGNING_KEY"), false);
        }
        if (this.useSigningKey_) {
            this.createSigningKeyComposite(composite);
        }
        if (this.useSigningKey_ && this.useCertificate_) {
            this.certPathSettingsButton_ = this.createRadio(composite, this.getMessage("%LABEL_USE_CERT_PATH_SETTINGS"), true);
        }
        if (this.useCertificate_) {
            this.createCertificateComposite(composite);
        }
        this.init();
        this.refresh();
        return composite;
    }

    private Composite createSigningKeyComposite(Composite parent) {
        Composite signingKeyComposite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        signingKeyComposite.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        signingKeyComposite.setLayoutData((Object)gd);
        this.signingKeyName_ = this.createText(signingKeyComposite, this.getMessage("%LABEL_SIGNING_KEY_NAME"));
        this.signingKeyLocatorRef_ = this.createComboBox(signingKeyComposite, this.getMessage("%LABEL_SIGNING_KEY_LOCATOR_REF"));
        this.signingKeyLocatorRef_.setItems(this.getKeyLocatorNames());
        return signingKeyComposite;
    }

    private Composite createCertificateComposite(Composite parent) {
        Composite certPathComposite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        certPathComposite.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        certPathComposite.setLayoutData((Object)gd);
        this.specifyCertPathRefButton_ = this.createRadio(certPathComposite, this.getMessage("%LABEL_USE_CERT_PATH_REF"), false);
        this.specifyCertPathRefButton_.addListener(13, (Listener)this);
        this.trustAnchorRef_ = this.createComboBox(certPathComposite, this.getMessage("%LABEL_TRUST_ANCHOR_REF"));
        this.trustAnchorRef_.setItems(this.getTrustAnchorNames());
        this.trustAnchorRef_.addListener(24, (Listener)this);
        this.certStoreRef_ = this.createComboBox(certPathComposite, this.getMessage("%LABEL_CERT_STORE_REF"));
        this.certStoreRef_.setItems(this.getCertStoreNames());
        this.trustAnyCertButton_ = this.createRadio(certPathComposite, this.getMessage("%LABEL_TRUST_ANY_CERTIFICATE"), true);
        return certPathComposite;
    }

    public void handleEvent(Event event) {
        if (this.specifyCertPathRefButton_ == event.widget || this.trustAnchorRef_ == event.widget) {
            this.verifyCertPathSettings();
        }
    }

    private void verifyCertPathSettings() {
        Button okButton = this.getButton(0);
        if (okButton == null) {
            return;
        }
        boolean usingCertPathRef = this.specifyCertPathRefButton_.getSelection();
        if (usingCertPathRef) {
            String anchorRef = this.trustAnchorRef_.getText();
            if (anchorRef == null || anchorRef.length() == 0) {
                okButton.setEnabled(false);
            } else {
                okButton.setEnabled(true);
            }
        } else {
            okButton.setEnabled(true);
        }
    }

    private void refresh() {
        this.handleRadioButtonSelected((Widget)this.trustAnyCertButton_);
        this.handleRadioButtonSelected((Widget)this.certPathSettingsButton_);
    }

    private void handleRadioButtonSelected(Widget widget) {
        if (this.signingKeyButton_ != null && this.certPathSettingsButton_ != null && (widget == this.signingKeyButton_ || widget == this.certPathSettingsButton_)) {
            boolean signingKeySelected = this.signingKeyButton_.getSelection();
            this.signingKeyName_.setEnabled(signingKeySelected);
            this.signingKeyLocatorRef_.setEnabled(signingKeySelected);
            this.signingKeyName_.setEnabled(signingKeySelected);
            this.signingKeyLocatorRef_.setEnabled(signingKeySelected);
            this.specifyCertPathRefButton_.setEnabled(!signingKeySelected);
            this.trustAnyCertButton_.setEnabled(!signingKeySelected);
            boolean specifyCertPathRefSelected = this.specifyCertPathRefButton_.getSelection();
            this.trustAnchorRef_.setEnabled(!signingKeySelected && specifyCertPathRefSelected);
            this.certStoreRef_.setEnabled(!signingKeySelected && specifyCertPathRefSelected);
            this.trustAnchorRef_.setEnabled(!signingKeySelected && specifyCertPathRefSelected);
            this.certStoreRef_.setEnabled(!signingKeySelected && specifyCertPathRefSelected);
        } else if (this.specifyCertPathRefButton_ != null && this.trustAnyCertButton_ != null && (widget == this.specifyCertPathRefButton_ || widget == this.trustAnyCertButton_)) {
            boolean specifyCertPathRefSelected = this.specifyCertPathRefButton_.getSelection();
            this.trustAnchorRef_.setEnabled(specifyCertPathRefSelected);
            this.certStoreRef_.setEnabled(specifyCertPathRefSelected);
            this.trustAnchorRef_.setEnabled(specifyCertPathRefSelected);
            this.certStoreRef_.setEnabled(specifyCertPathRefSelected);
        }
    }

    private void init() {
        if (this.signingInfo_ != null) {
            CanonicalizationMethod canonicalizationMethod = this.signingInfo_.getCanonicalizationMethod();
            if (canonicalizationMethod != null) {
                this.canonicalizationMethodAlgorithm_.select(this.canonicalizationMethodAlgorithm_.indexOf(canonicalizationMethod.getAlgorithm()));
            } else {
                this.canonicalizationMethodAlgorithm_.select(this.canonicalizationMethodAlgorithm_.indexOf(""));
            }
            DigestMethod digestMethod = this.signingInfo_.getDigestMethod();
            if (digestMethod != null) {
                String algorithm = digestMethod.getAlgorithm();
                if (!this.atkWasUiConstants.isDigestMethodFIPSCompliant(algorithm)) {
                    this.showFIPSComplientAlgorithms_.setSelection(false);
                    this.getAlgorithms(false);
                }
                this.digestMethodAlgorithm_.select(this.digestMethodAlgorithm_.indexOf(algorithm));
            } else {
                this.digestMethodAlgorithm_.select(0);
            }
            SignatureMethod signatureMethod = this.signingInfo_.getSignatureMethod();
            if (signatureMethod != null) {
                String algorithm = signatureMethod.getAlgorithm();
                if (!this.atkWasUiConstants.isSignatureMethodFIPSCompliant(algorithm)) {
                    this.showFIPSComplientAlgorithms_.setSelection(false);
                    this.getAlgorithms(false);
                }
                this.signatureMethodAlgorithm_.select(this.signatureMethodAlgorithm_.indexOf(algorithm));
            } else {
                this.signatureMethodAlgorithm_.select(0);
            }
            SigningKey signingKey = this.signingInfo_.getSigningKey();
            CertPathSettings certPathSettings = this.signingInfo_.getCertPathSettings();
            if (signingKey != null && this.useSigningKey_) {
                this.setSelection(this.signingKeyButton_, true);
                this.setSelection(this.certPathSettingsButton_, false);
                this.setText(this.signingKeyName_, signingKey.getName());
                this.internalInitCombo(this.signingKeyLocatorRef_, signingKey.getLocatorRef());
            } else if (certPathSettings != null && this.useCertificate_) {
                this.setSelection(this.signingKeyButton_, false);
                this.setSelection(this.certPathSettingsButton_, true);
                TrustAnchorRef trustAnchorRef = certPathSettings.getTrustAnchorRef();
                CertStoreRef certStoreRef = certPathSettings.getCertStoreRef();
                certPathSettings.getTrustAnyCertificate();
                if (trustAnchorRef != null || certStoreRef != null) {
                    this.specifyCertPathRefButton_.setSelection(true);
                    this.trustAnyCertButton_.setSelection(false);
                    if (trustAnchorRef != null) {
                        this.internalInitCombo(this.trustAnchorRef_, trustAnchorRef.getRef());
                    }
                    if (certStoreRef != null) {
                        this.internalInitCombo(this.certStoreRef_, certStoreRef.getRef());
                    }
                } else {
                    this.specifyCertPathRefButton_.setSelection(false);
                    this.trustAnyCertButton_.setSelection(true);
                }
            }
        }
    }

    private String[] getKeyLocatorNames() {
        if (this.eObject_ != null && this.locatorRefFeature_ != null) {
            Vector<String> keyLocators = new Vector<String>();
            Object object = this.eObject_.eGet(this.locatorRefFeature_);
            if (object instanceof EList) {
                for (Object item : (EList)object) {
                    if (!(item instanceof KeyLocator)) continue;
                    keyLocators.add(((KeyLocator)item).getName());
                }
            } else if (object instanceof KeyLocator) {
                keyLocators.add(((KeyLocator)object).getName());
            }
            Object[] names = new String[keyLocators.size()];
            keyLocators.copyInto(names);
            return names;
        }
        return new String[0];
    }

    private String[] getTrustAnchorNames() {
        if (this.eObject_ != null && this.trustAnchorFeature_ != null) {
            Vector<String> trustAnchors = new Vector<String>();
            Object object = this.eObject_.eGet(this.trustAnchorFeature_);
            if (object instanceof EList) {
                for (Object item : (EList)object) {
                    if (!(item instanceof TrustAnchor)) continue;
                    trustAnchors.add(((TrustAnchor)item).getName());
                }
            } else if (object instanceof TrustAnchor) {
                trustAnchors.add(((TrustAnchor)object).getName());
            }
            Object[] names = new String[trustAnchors.size()];
            trustAnchors.copyInto(names);
            return names;
        }
        return new String[0];
    }

    private String[] getCertStoreNames() {
        if (this.eObject_ != null && this.certStoreListFeature_ != null) {
            Vector<String> certStores = new Vector<String>();
            Object object = this.eObject_.eGet(this.certStoreListFeature_);
            if (object instanceof CertStoreList) {
                CertStoreList certStoreList = (CertStoreList)object;
                EList ldapCertStores = certStoreList.getLdapCertStores();
                Iterator it = ldapCertStores.iterator();
                while (it.hasNext()) {
                    certStores.add(((LDAPCertStore)it.next()).getName());
                }
                EList collectionCertStores = certStoreList.getCollectionCertStores();
                Iterator it2 = collectionCertStores.iterator();
                while (it2.hasNext()) {
                    certStores.add(((CollectionCertStore)it2.next()).getName());
                }
            }
            Object[] names = new String[certStores.size()];
            certStores.copyInto(names);
            return names;
        }
        return new String[0];
    }

    private void internalInitCombo(Combo combo, String string) {
        int index = combo.indexOf(string);
        if (index == -1) {
            combo.add(string);
            combo.select(combo.indexOf(string));
        } else {
            combo.select(index);
        }
    }

    private void setSelection(Button button, boolean selection) {
        if (button != null) {
            button.setSelection(selection);
        }
    }

    private void setText(Text text, String s) {
        if (s != null) {
            text.setText(s);
        } else {
            text.setText("");
        }
    }

    private Combo createComboBox(Composite parent, String message) {
        Label label = new Label(parent, 64);
        label.setText(message);
        label.setLayoutData((Object)new GridData(256));
        Combo combo = new Combo(parent, 2060);
        combo.setLayoutData((Object)new GridData(768));
        return combo;
    }

    private Button creatCheckBox(Composite parent, String message, boolean value) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(message);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.setSelection(value);
        return checkBox;
    }

    private Button createRadio(Composite parent, String message, boolean value) {
        Button radio = new Button(parent, 16);
        radio.setText(message);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        radio.setLayoutData((Object)gd);
        radio.setSelection(value);
        radio.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DialogSingingInfo.this.handleRadioButtonSelected(e.widget);
            }
        });
        return radio;
    }

    private Text createText(Composite parent, String message) {
        Label label = new Label(parent, 64);
        label.setText(message);
        label.setLayoutData((Object)new GridData(256));
        Text text = new Text(parent, 2116);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private void createLabel(Composite parent, String message) {
        Label label = new Label(parent, 64);
        label.setText(message);
        label.setLayoutData((Object)new GridData(256));
    }

    private void getAlgorithms(boolean showFIPSComplientOnly) {
        String algorithm = this.digestMethodAlgorithm_.getText();
        this.digestMethodAlgorithm_.setItems(this.atkWasUiConstants.getSigningInfoDigestMethods(showFIPSComplientOnly));
        this.digestMethodAlgorithm_.select(algorithm.equals("") ? 0 : this.digestMethodAlgorithm_.indexOf(algorithm));
        algorithm = this.signatureMethodAlgorithm_.getText();
        this.signatureMethodAlgorithm_.setItems(this.atkWasUiConstants.getSigningInfoSignatureMethods(showFIPSComplientOnly));
        this.signatureMethodAlgorithm_.select(algorithm.equals("") ? 0 : this.signatureMethodAlgorithm_.indexOf(algorithm));
    }

    private void setComboText(Combo ccombo, String s) {
        if (s != null) {
            ccombo.setText(s);
        } else {
            ccombo.setText("");
        }
    }

    protected String getMessage(String msgId) {
        return ATKWASUIPlugin.getMessage(msgId);
    }
}

