/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.was.ui.editor.common;

import com.ibm.etools.webservice.atk.was.ui.constants.ATKWASUIConstants;
import com.ibm.etools.webservice.atk.was.ui.editor.common.DialogTableViewerEditor;
import com.ibm.etools.webservice.atk.was.ui.plugin.ATKWASUIPlugin;
import com.ibm.etools.webservice.wscommonbnd.LDAPCertStore;
import com.ibm.etools.webservice.wscommonbnd.LDAPServer;
import com.ibm.etools.webservice.wscommonbnd.Property;
import com.ibm.etools.webservice.wscommonbnd.WscommonbndFactory;
import com.ibm.etools.webservice.wscommonbnd.WscommonbndPackage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandAddElement;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandSetElement;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.ArtifactEdit;

public class DialogLDAPCertStore
extends Dialog {
    private String INFOPOP_DIALOG_LDAP_CERT_STORE = "com.ibm.etools.webservice.atk.was.ui.DLDA0001";
    private Shell shell_;
    private Text nameText_;
    private Text providerText_;
    private Text hostText_;
    private Text portText_;
    private DialogTableViewerEditor propertyTable_;
    private ArtifactEdit artifactEdit_;
    private EObject eObject_;
    private EStructuralFeature feature_;
    private LDAPCertStore ldapCertStore_;
    private Object addedObject_;

    public DialogLDAPCertStore(Shell shell, ArtifactEdit artifactEdit, EObject eObject, EStructuralFeature feature, LDAPCertStore ldapCertStore) {
        super(shell);
        this.artifactEdit_ = artifactEdit;
        this.eObject_ = eObject;
        this.feature_ = feature;
        this.ldapCertStore_ = ldapCertStore;
        this.addedObject_ = null;
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        super.cancelPressed();
    }

    protected void okPressed() {
        WscommonbndFactory factory = WscommonbndFactory.eINSTANCE;
        LDAPCertStore ldapCertStore = factory.createLDAPCertStore();
        ldapCertStore.setName(this.nameText_.getText());
        ldapCertStore.setProvider(this.providerText_.getText());
        LDAPServer ldapServer = factory.createLDAPServer();
        ldapServer.setHost(this.hostText_.getText());
        ldapServer.setPort(this.portText_.getText());
        EList propertyList = ldapServer.getProperties();
        TableItem[] properties = this.propertyTable_.getItems();
        int i = 0;
        while (i < properties.length) {
            Property property = factory.createProperty();
            property.setName(properties[i].getText(0));
            property.setValue(properties[i].getText(1));
            propertyList.add((Object)property);
            ++i;
        }
        ldapCertStore.setLdapServer(ldapServer);
        Object command = this.ldapCertStore_ != null ? new CommandSetElement(null, null, this.eObject_, this.feature_, (Object)ldapCertStore, (Object)this.ldapCertStore_) : new CommandAddElement(null, null, this.eObject_, this.feature_, (Object)ldapCertStore);
        this.addedObject_ = ldapCertStore;
        this.artifactEdit_.getContentModelRoot().eResource().setModified(true);
        this.artifactEdit_.getCommandStack().execute((Command)command);
        this.setReturnCode(0);
        super.okPressed();
    }

    public Object getAddedObject() {
        return this.addedObject_;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getMessage("%DIALOG_TITLE_LDAP_CERT_STORE"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_NAME"));
        label.setLayoutData((Object)new GridData(256));
        this.nameText_ = new Text(composite, 2116);
        this.nameText_.setLayoutData((Object)new GridData(768));
        label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_PROVIDER"));
        label.setLayoutData((Object)new GridData(256));
        this.providerText_ = new Text(composite, 2116);
        this.providerText_.setLayoutData((Object)new GridData(768));
        label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_LDAP_SERVER"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_HOST"));
        gd = new GridData(256);
        gd.horizontalIndent = 10;
        label.setLayoutData((Object)gd);
        this.hostText_ = new Text(composite, 2116);
        this.hostText_.setLayoutData((Object)new GridData(768));
        label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_PORT"));
        gd = new GridData(256);
        gd.horizontalIndent = 10;
        label.setLayoutData((Object)gd);
        this.portText_ = new Text(composite, 2116);
        this.portText_.setLayoutData((Object)new GridData(768));
        WscommonbndPackage pkg = WscommonbndFactory.eINSTANCE.getWscommonbndPackage();
        ATKWASUIConstants atkWasUiConstants = new ATKWASUIConstants();
        Composite propertyComposite = new Composite(composite, 0);
        propertyComposite.setLayout((Layout)new GridLayout());
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        propertyComposite.setLayoutData((Object)gd);
        label = new Label(propertyComposite, 64);
        label.setText(this.getMessage("%LABEL_PROPERTY"));
        label.setLayoutData((Object)new GridData(256));
        String[] propertyTableColumns = new String[]{this.getMessage("%LABEL_TABLE_NAME"), this.getMessage("%LABEL_TABLE_VALUE")};
        EStructuralFeature[] propertyTableFeatures = new EStructuralFeature[]{pkg.getProperty_Name(), pkg.getProperty_Value()};
        Object[] propertyTableFeatureValues = new String[]{atkWasUiConstants.defaultName(), atkWasUiConstants.defaultValue()};
        this.propertyTable_ = new DialogTableViewerEditor(propertyComposite, propertyTableColumns, pkg.getProperty(), propertyTableFeatures, propertyTableFeatureValues);
        composite.setTabList(new Control[]{this.nameText_, this.providerText_, this.hostText_, this.portText_, propertyComposite});
        this.init();
        return composite;
    }

    private void init() {
        if (this.ldapCertStore_ != null) {
            this.setText(this.nameText_, this.ldapCertStore_.getName());
            this.setText(this.providerText_, this.ldapCertStore_.getProvider());
            LDAPServer ldapServer = this.ldapCertStore_.getLdapServer();
            if (ldapServer != null) {
                this.setText(this.hostText_, ldapServer.getHost());
                this.setText(this.portText_, ldapServer.getPort());
                EList propertyList = ldapServer.getProperties();
                for (Property property : propertyList) {
                    this.propertyTable_.addItem(new Object[]{property.getName(), property.getValue()});
                }
                this.propertyTable_.refresh();
            }
        }
    }

    private void setText(Text text, String s) {
        if (s != null) {
            text.setText(s);
        } else {
            text.setText("");
        }
    }

    protected String getMessage(String msgId) {
        return ATKWASUIPlugin.getMessage(msgId);
    }
}

