/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.was.ui.editor.common;

import com.ibm.ast.ws.ui.plugin.WSUIPlugin;
import com.ibm.etools.webservice.atk.was.ui.constants.ATKWASUIConstants;
import com.ibm.etools.webservice.atk.was.ui.editor.common.DialogTableViewerEditor;
import com.ibm.etools.webservice.atk.was.ui.plugin.ATKWASUIPlugin;
import com.ibm.etools.webservice.wscommonbnd.Key;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.KeyStore;
import com.ibm.etools.webservice.wscommonbnd.Property;
import com.ibm.etools.webservice.wscommonbnd.WscommonbndFactory;
import com.ibm.etools.webservice.wscommonbnd.WscommonbndPackage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandAddElement;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandSetElement;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.ArtifactEdit;

public class DialogKeyLocator
extends Dialog
implements Listener {
    private Label keyStoreStorePassLabel_;
    private Label keyStorePathLabel_;
    private Label keyStoreTypeLabel_;
    private Button useKeyStore_;
    private Text keyLocatorName_;
    private CCombo keyLocatorClassName_;
    private Text keyStoreStorePass_;
    private Text keyStorePath_;
    private Combo keyStoreType_;
    private DialogTableViewerEditor keyTable_;
    private DialogTableViewerEditor propertyTable_;
    private ArtifactEdit artifactEdit_;
    private EObject eObject_;
    private EStructuralFeature feature_;
    private KeyLocator keyLocator_;
    private Object addedObject_;

    public DialogKeyLocator(Shell shell, ArtifactEdit artifactEdit, EObject eObject, EStructuralFeature feature, KeyLocator keyLocator) {
        super(shell);
        this.artifactEdit_ = artifactEdit;
        this.eObject_ = eObject;
        this.feature_ = feature;
        this.keyLocator_ = keyLocator;
        this.addedObject_ = null;
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        super.cancelPressed();
    }

    protected void okPressed() {
        WscommonbndFactory factory = WscommonbndFactory.eINSTANCE;
        KeyLocator keyLocator = factory.createKeyLocator();
        keyLocator.setName(this.keyLocatorName_.getText());
        keyLocator.setClassname(this.keyLocatorClassName_.getText());
        if (this.useKeyStore_.getSelection()) {
            KeyStore keyStore = factory.createKeyStore();
            keyStore.setStorepass(this.keyStoreStorePass_.getText());
            keyStore.setPath(this.keyStorePath_.getText());
            keyStore.setType(this.keyStoreType_.getText());
            keyLocator.setKeyStore(keyStore);
            EList keyList = keyLocator.getKeys();
            TableItem[] keys = this.keyTable_.getItems();
            int i = 0;
            while (i < keys.length) {
                Key key = factory.createKey();
                key.setAlias(keys[i].getText(0));
                key.setKeypass(keys[i].getText(1));
                key.setName(keys[i].getText(2));
                keyList.add((Object)key);
                ++i;
            }
        }
        EList propertyList = keyLocator.getProperties();
        TableItem[] properties = this.propertyTable_.getItems();
        int i = 0;
        while (i < properties.length) {
            Property property = factory.createProperty();
            property.setName(properties[i].getText(0));
            property.setValue(properties[i].getText(1));
            propertyList.add((Object)property);
            ++i;
        }
        Object command = this.keyLocator_ != null ? new CommandSetElement(null, null, this.eObject_, this.feature_, (Object)keyLocator, (Object)this.keyLocator_) : new CommandAddElement(null, null, this.eObject_, this.feature_, (Object)keyLocator);
        this.addedObject_ = keyLocator;
        this.artifactEdit_.getContentModelRoot().eResource().setModified(true);
        this.artifactEdit_.getCommandStack().execute((Command)command);
        this.setReturnCode(0);
        super.okPressed();
    }

    public Object getAddedObject() {
        return this.addedObject_;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getMessage("%DIALOG_TITLE_KEY_LOCATOR"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.verticalSpacing = 5;
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.widthHint = 500;
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)gd);
        WscommonbndPackage pkg = WscommonbndFactory.eINSTANCE.getWscommonbndPackage();
        ATKWASUIConstants atkWasUiConstants = new ATKWASUIConstants();
        Label label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_KEY_LOCATOR_NAME"));
        label.setLayoutData((Object)new GridData(256));
        this.keyLocatorName_ = new Text(composite, 2116);
        this.keyLocatorName_.setLayoutData((Object)new GridData(768));
        label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_KEY_LOCATOR_CLASS_NAME"));
        label.setLayoutData((Object)new GridData(256));
        this.keyLocatorClassName_ = new CCombo(composite, 2116);
        this.keyLocatorClassName_.setLayoutData((Object)new GridData(768));
        String[] classNames = atkWasUiConstants.getKeyLocatorClassNames();
        int i = 0;
        while (i < classNames.length) {
            this.keyLocatorClassName_.add(classNames[i]);
            ++i;
        }
        this.keyLocatorClassName_.select(0);
        this.useKeyStore_ = new Button(composite, 32);
        this.useKeyStore_.setText(this.getMessage("%LABEL_USE_KEY_STORE"));
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.useKeyStore_.setLayoutData((Object)gd);
        this.useKeyStore_.setSelection(false);
        this.useKeyStore_.addListener(13, (Listener)this);
        this.useKeyStore_.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DialogKeyLocator.this.enableKeyStore(DialogKeyLocator.this.useKeyStore_.getSelection());
            }
        });
        this.keyStoreStorePassLabel_ = new Label(composite, 64);
        this.keyStoreStorePassLabel_.setText(this.getMessage("%LABEL_KEY_STORE_STORE_PASS"));
        gd = new GridData(256);
        gd.horizontalIndent = 10;
        this.keyStoreStorePassLabel_.setLayoutData((Object)gd);
        int style = WSUIPlugin.getInstance().getWASSecurityContext().isStarPassword() ? 0x400844 : 2116;
        this.keyStoreStorePass_ = new Text(composite, style);
        this.keyStoreStorePass_.setLayoutData((Object)new GridData(768));
        this.keyStoreStorePass_.addListener(24, (Listener)this);
        this.keyStorePathLabel_ = new Label(composite, 64);
        this.keyStorePathLabel_.setText(this.getMessage("%LABEL_KEY_STORE_PATH"));
        gd = new GridData(256);
        gd.horizontalIndent = 10;
        this.keyStorePathLabel_.setLayoutData((Object)gd);
        this.keyStorePath_ = new Text(composite, 2116);
        this.keyStorePath_.setLayoutData((Object)new GridData(768));
        this.keyStorePath_.addListener(24, (Listener)this);
        this.keyStoreTypeLabel_ = new Label(composite, 64);
        this.keyStoreTypeLabel_.setText(this.getMessage("%LABEL_KEY_STORE_TYPE"));
        gd = new GridData(256);
        gd.horizontalIndent = 10;
        this.keyStoreTypeLabel_.setLayoutData((Object)gd);
        this.keyStoreType_ = new Combo(composite, 2052);
        this.keyStoreType_.setLayoutData((Object)new GridData(768));
        String[] types = atkWasUiConstants.getKeyStoreTypes();
        int i2 = 0;
        while (i2 < types.length) {
            this.keyStoreType_.add(types[i2]);
            ++i2;
        }
        this.keyStoreType_.addListener(24, (Listener)this);
        Composite keyComposite = new Composite(composite, 0);
        keyComposite.setLayout((Layout)new GridLayout());
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        keyComposite.setLayoutData((Object)gd);
        label = new Label(keyComposite, 64);
        label.setText(this.getMessage("%LABEL_KEY"));
        label.setLayoutData((Object)new GridData(256));
        String[] keyTableColumns = new String[]{this.getMessage("%LABEL_TABLE_KEY_ALIAS"), this.getMessage("%LABEL_TABLE_KEY_KEY_PASS"), this.getMessage("%LABEL_TABLE_KEY_NAME")};
        EStructuralFeature[] keyTableFeatures = new EStructuralFeature[]{pkg.getKey_Alias(), pkg.getKey_Keypass(), pkg.getKey_Name()};
        Object[] keyTableFeatureValues = new String[]{atkWasUiConstants.defaultKeyAlias(), atkWasUiConstants.defaultKeyKeypass(), atkWasUiConstants.defaultKeyName()};
        this.keyTable_ = new DialogTableViewerEditor(keyComposite, keyTableColumns, pkg.getKey(), keyTableFeatures, keyTableFeatureValues);
        Composite propertyComposite = new Composite(composite, 0);
        propertyComposite.setLayout((Layout)new GridLayout());
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        propertyComposite.setLayoutData((Object)gd);
        label = new Label(propertyComposite, 64);
        label.setText(this.getMessage("%LABEL_PROPERTY"));
        label.setLayoutData((Object)new GridData(256));
        String[] propertyTableColumns = new String[]{this.getMessage("%LABEL_TABLE_NAME"), this.getMessage("%LABEL_TABLE_VALUE")};
        EStructuralFeature[] propertyTableFeatures = new EStructuralFeature[]{pkg.getProperty_Name(), pkg.getProperty_Value()};
        Object[] propertyTableFeatureValues = new String[]{atkWasUiConstants.defaultName(), atkWasUiConstants.defaultValue()};
        this.propertyTable_ = new DialogTableViewerEditor(propertyComposite, propertyTableColumns, pkg.getProperty(), propertyTableFeatures, propertyTableFeatureValues);
        composite.setTabList(new Control[]{this.useKeyStore_, this.keyLocatorName_, this.keyLocatorClassName_, this.keyStoreStorePass_, this.keyStorePath_, this.keyStoreType_, keyComposite, propertyComposite});
        this.init();
        this.refresh();
        return composite;
    }

    public void handleEvent(Event event) {
        if (this.useKeyStore_ == event.widget || this.keyStoreStorePass_ == event.widget || this.keyStorePath_ == event.widget || this.keyStoreType_ == event.widget) {
            this.verifyKeyStoreSettings();
        }
    }

    private void verifyKeyStoreSettings() {
        Button okButton = this.getButton(0);
        if (okButton == null) {
            return;
        }
        boolean usingKeyStore = this.useKeyStore_.getSelection();
        if (usingKeyStore) {
            String storePass = this.keyStoreStorePass_.getText();
            String storePath = this.keyStorePath_.getText();
            String storeType = this.keyStoreType_.getText();
            if (storePass == null || storePass.length() == 0 || storePath == null || storePath.length() == 0 || storeType == null || storeType.length() == 0) {
                okButton.setEnabled(false);
            } else {
                okButton.setEnabled(true);
            }
        } else {
            okButton.setEnabled(true);
        }
    }

    private void refresh() {
        this.enableKeyStore(this.useKeyStore_.getSelection());
    }

    private void enableKeyStore(boolean enabled) {
        this.keyStoreStorePassLabel_.setEnabled(enabled);
        this.keyStorePathLabel_.setEnabled(enabled);
        this.keyStoreTypeLabel_.setEnabled(enabled);
        this.keyStoreStorePass_.setEnabled(enabled);
        this.keyStorePath_.setEnabled(enabled);
        this.keyStoreType_.setEnabled(enabled);
        this.keyTable_.setEnabled(enabled);
    }

    private void init() {
        if (this.keyLocator_ != null) {
            this.setText(this.keyLocatorName_, this.keyLocator_.getName());
            this.setCComboText(this.keyLocatorClassName_, this.keyLocator_.getClassname());
            KeyStore keyStore = this.keyLocator_.getKeyStore();
            EList keyList = this.keyLocator_.getKeys();
            if (keyStore != null || keyList != null && keyList.size() > 0) {
                this.useKeyStore_.setSelection(true);
                this.enableKeyStore(true);
                if (keyStore != null) {
                    this.setText(this.keyStoreStorePass_, keyStore.getStorepass());
                    this.setText(this.keyStorePath_, keyStore.getPath());
                    this.setText(this.keyStoreType_, keyStore.getType());
                }
                for (Key key : keyList) {
                    this.keyTable_.addItem(new Object[]{key.getAlias(), key.getKeypass(), key.getName()});
                }
                this.keyTable_.refresh();
            } else {
                this.useKeyStore_.setSelection(false);
            }
            EList propertyList = this.keyLocator_.getProperties();
            for (Property property : propertyList) {
                this.propertyTable_.addItem(new Object[]{property.getName(), property.getValue()});
            }
            this.propertyTable_.refresh();
        }
    }

    private void setText(Text text, String s) {
        if (s != null) {
            text.setText(s);
        } else {
            text.setText("");
        }
    }

    private void setText(Combo combo, String s) {
        if (s != null) {
            combo.setText(s);
        } else {
            combo.setText("");
        }
    }

    private void setCComboText(CCombo ccombo, String s) {
        if (s != null) {
            ccombo.setText(s);
        } else {
            ccombo.setText("");
        }
    }

    protected String getMessage(String msgId) {
        return ATKWASUIPlugin.getMessage(msgId);
    }
}

