/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.was.ui.editor.common;

import com.ibm.ast.ws.ui.messages.Messages;
import com.ibm.ast.ws.ui.plugin.WSUIPlugin;
import com.ibm.etools.webservice.atk.was.ui.constants.ATKWASUIConstants;
import com.ibm.etools.webservice.atk.was.ui.plugin.ATKWASUIPlugin;
import com.ibm.etools.webservice.wscommonbnd.DataEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.EncryptionKey;
import com.ibm.etools.webservice.wscommonbnd.KeyEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.KeyLocator;
import com.ibm.etools.webservice.wscommonbnd.WscommonbndFactory;
import java.util.Vector;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandAddElement;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandSetElement;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.ArtifactEdit;

public class DialogEncryptionInfo
extends Dialog
implements Listener {
    private String INFOPOP_DIALOG_ENCRYPTION_INFO = "com.ibm.etools.webservice.atk.was.ui.DENC0001";
    private Shell shell_;
    private ATKWASUIConstants atkWasUiConstants;
    private Button showFIPSComplientAlgorithms_;
    private Combo dataEncryptMethodAlgorithm_;
    private Combo keyEncryptMethodAlgorithm_;
    private Text encryptName_;
    private Text encryptKeyName_;
    private Combo encryptKeyLocatorRef_;
    private ArtifactEdit artifactEdit_;
    private EObject eObject_;
    private EStructuralFeature feature_;
    private EncryptionInfo encryptionInfo_;
    private Object addedObject_;
    private EStructuralFeature locatorRefFeature_;

    public DialogEncryptionInfo(Shell shell, ArtifactEdit artifactEdit, EObject eObject, EStructuralFeature feature, EncryptionInfo encryptionInfo) {
        super(shell);
        this.artifactEdit_ = artifactEdit;
        this.eObject_ = eObject;
        this.feature_ = feature;
        this.encryptionInfo_ = encryptionInfo;
        this.addedObject_ = null;
        this.locatorRefFeature_ = null;
        this.atkWasUiConstants = new ATKWASUIConstants();
    }

    public void setLocatorRefFeature(EStructuralFeature locatorRefFeature) {
        this.locatorRefFeature_ = locatorRefFeature;
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        super.cancelPressed();
    }

    protected void okPressed() {
        if (!this.validateInputs()) {
            this.cancelPressed();
            return;
        }
        WscommonbndFactory factory = WscommonbndFactory.eINSTANCE;
        EncryptionInfo encryptionInfo = factory.createEncryptionInfo();
        encryptionInfo.setName(this.encryptName_.getText());
        EncryptionKey encryptionKey = factory.createEncryptionKey();
        String encryptKeyNameValue = this.encryptKeyName_.getText();
        if (encryptKeyNameValue != null && encryptKeyNameValue.length() > 0) {
            encryptionKey.setName(encryptKeyNameValue);
        }
        encryptionKey.setLocatorRef(this.encryptKeyLocatorRef_.getText());
        encryptionInfo.setEncryptionKey(encryptionKey);
        DataEncryptionMethod dataEncryptionMethod = factory.createDataEncryptionMethod();
        dataEncryptionMethod.setAlgorithm(this.dataEncryptMethodAlgorithm_.getText());
        encryptionInfo.setEncryptionMethod(dataEncryptionMethod);
        String keyEncryptionMethodText = this.keyEncryptMethodAlgorithm_.getText();
        if (keyEncryptionMethodText != null && keyEncryptionMethodText.length() > 0) {
            KeyEncryptionMethod keyEncryptionMethod = factory.createKeyEncryptionMethod();
            keyEncryptionMethod.setAlgorithm(keyEncryptionMethodText);
            encryptionInfo.setKeyEncryptionMethod(keyEncryptionMethod);
        }
        Object command = this.encryptionInfo_ != null ? new CommandSetElement(null, null, this.eObject_, this.feature_, (Object)encryptionInfo, (Object)this.encryptionInfo_) : new CommandAddElement(null, null, this.eObject_, this.feature_, (Object)encryptionInfo);
        this.addedObject_ = encryptionInfo;
        this.artifactEdit_.getContentModelRoot().eResource().setModified(true);
        this.artifactEdit_.getCommandStack().execute((Command)command);
        this.setReturnCode(0);
        super.okPressed();
    }

    public Object getAddedObject() {
        return this.addedObject_;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getMessage("%DIALOG_TITLE_ENCRYPTION_INFO"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite group1 = new Composite(composite, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        group1.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        group1.setLayoutData((Object)gd);
        this.encryptName_ = this.createText(group1, this.getMessage("%LABEL_ENCRYPTION_NAME"));
        this.encryptName_.addListener(24, (Listener)this);
        Group fipsGroup = new Group(composite, 0);
        gl = new GridLayout();
        gl.numColumns = 2;
        fipsGroup.setLayout((Layout)gl);
        gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        fipsGroup.setLayoutData((Object)gd);
        this.showFIPSComplientAlgorithms_ = this.creatCheckBox((Composite)fipsGroup, Messages.BUTTON_SHOW_FIPS, WSUIPlugin.getInstance().getWASSecurityContext().isFIPSComplient());
        this.showFIPSComplientAlgorithms_.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DialogEncryptionInfo.this.getAlgorithms(DialogEncryptionInfo.this.showFIPSComplientAlgorithms_.getSelection());
            }
        });
        this.dataEncryptMethodAlgorithm_ = this.createComboBox((Composite)fipsGroup, this.getMessage("%LABEL_DATA_ENCRYPTION_METHOD_ALGORITHM"));
        this.keyEncryptMethodAlgorithm_ = this.createComboBox((Composite)fipsGroup, this.getMessage("%LABEL_KEY_ENCRYPTION_METHOD_ALGORITHM"));
        this.getAlgorithms(this.showFIPSComplientAlgorithms_.getSelection());
        Composite group3 = new Composite(composite, 0);
        gl = new GridLayout();
        gl.numColumns = 2;
        group3.setLayout((Layout)gl);
        gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        group3.setLayoutData((Object)gd);
        this.encryptKeyName_ = this.createText(group3, this.getMessage("%LABEL_ENCRYPTION_KEY_NAME"));
        this.encryptKeyLocatorRef_ = this.createComboBox(group3, this.getMessage("%LABEL_ENCRYPTION_KEY_LOCATOR_REF"));
        this.encryptKeyLocatorRef_.setItems(this.getKeyLocatorNames());
        this.encryptKeyLocatorRef_.addListener(24, (Listener)this);
        this.init();
        return composite;
    }

    private void init() {
        if (this.encryptionInfo_ != null) {
            this.setText(this.encryptName_, this.encryptionInfo_.getName());
            DataEncryptionMethod dataEncryptionMethod = this.encryptionInfo_.getEncryptionMethod();
            if (dataEncryptionMethod != null) {
                String algorithm = dataEncryptionMethod.getAlgorithm();
                if (!this.atkWasUiConstants.isDataEncryptionFIPSCompliant(algorithm)) {
                    this.showFIPSComplientAlgorithms_.setSelection(false);
                    this.getAlgorithms(false);
                }
                this.dataEncryptMethodAlgorithm_.select(this.dataEncryptMethodAlgorithm_.indexOf(algorithm));
            } else {
                this.dataEncryptMethodAlgorithm_.select(0);
            }
            KeyEncryptionMethod keyEncryptionMethod = this.encryptionInfo_.getKeyEncryptionMethod();
            if (keyEncryptionMethod != null) {
                String algorithm = keyEncryptionMethod.getAlgorithm();
                if (!this.atkWasUiConstants.isKeyEncryptionFIPSCompliant(algorithm)) {
                    this.showFIPSComplientAlgorithms_.setSelection(false);
                    this.getAlgorithms(false);
                }
                this.keyEncryptMethodAlgorithm_.select(this.keyEncryptMethodAlgorithm_.indexOf(algorithm));
            } else {
                this.keyEncryptMethodAlgorithm_.select(0);
            }
            EncryptionKey encryptionKey = this.encryptionInfo_.getEncryptionKey();
            if (encryptionKey != null) {
                this.setText(this.encryptKeyName_, encryptionKey.getName());
                this.internalInitCombo(this.encryptKeyLocatorRef_, encryptionKey.getLocatorRef());
            }
        }
    }

    public void handleEvent(Event event) {
        if (this.encryptName_ == event.widget || this.dataEncryptMethodAlgorithm_ == event.widget || this.encryptKeyLocatorRef_ == event.widget) {
            Button okButton = this.getButton(0);
            if (okButton == null) {
                return;
            }
            okButton.setEnabled(this.validateInputs());
        }
    }

    private boolean validateInputs() {
        String encryptNameValue = this.encryptName_.getText();
        String dataEncryptMethodAlgorithmValue = this.dataEncryptMethodAlgorithm_.getText();
        String encryptKeyLocatorRefValue = this.encryptKeyLocatorRef_.getText();
        return encryptNameValue != null && encryptNameValue.length() > 0 && dataEncryptMethodAlgorithmValue != null && dataEncryptMethodAlgorithmValue.length() > 0 && encryptKeyLocatorRefValue != null && encryptKeyLocatorRefValue.length() > 0;
    }

    private String[] getKeyLocatorNames() {
        if (this.eObject_ != null && this.locatorRefFeature_ != null) {
            Vector<String> keyLocators = new Vector<String>();
            Object object = this.eObject_.eGet(this.locatorRefFeature_);
            if (object instanceof EList) {
                for (Object item : (EList)object) {
                    if (!(item instanceof KeyLocator)) continue;
                    keyLocators.add(((KeyLocator)item).getName());
                }
            } else if (object instanceof KeyLocator) {
                keyLocators.add(((KeyLocator)object).getName());
            }
            Object[] names = new String[keyLocators.size()];
            keyLocators.copyInto(names);
            return names;
        }
        return new String[0];
    }

    private void internalInitCombo(Combo combo, String string) {
        int index = combo.indexOf(string);
        if (index == -1) {
            combo.add(string);
            combo.select(combo.indexOf(string));
        } else {
            combo.select(index);
        }
    }

    private Combo createComboBox(Composite parent, String message) {
        Label label = new Label(parent, 64);
        label.setText(message);
        label.setLayoutData((Object)new GridData(256));
        Combo combo = new Combo(parent, 2060);
        combo.setLayoutData((Object)new GridData(768));
        return combo;
    }

    private Button creatCheckBox(Composite parent, String message, boolean value) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(message);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.setSelection(value);
        return checkBox;
    }

    private Text createText(Composite parent, String message) {
        Label label = new Label(parent, 64);
        label.setText(message);
        label.setLayoutData((Object)new GridData(256));
        Text text = new Text(parent, 2116);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private void createLabel(Composite parent, String message) {
        Label label = new Label(parent, 64);
        label.setText(message);
        label.setLayoutData((Object)new GridData(256));
    }

    private void getAlgorithms(boolean showFIPSComplientOnly) {
        String algorithm = this.dataEncryptMethodAlgorithm_.getText();
        this.dataEncryptMethodAlgorithm_.setItems(this.atkWasUiConstants.getEncryptionInfoDataEncryptionMethods(showFIPSComplientOnly));
        this.dataEncryptMethodAlgorithm_.select(algorithm.equals("") ? 0 : this.dataEncryptMethodAlgorithm_.indexOf(algorithm));
        algorithm = this.keyEncryptMethodAlgorithm_.getText();
        this.keyEncryptMethodAlgorithm_.setItems(this.atkWasUiConstants.getEncryptionInfoKeyEncryptionMethods(showFIPSComplientOnly));
        this.keyEncryptMethodAlgorithm_.select(algorithm.equals("") ? 0 : this.keyEncryptMethodAlgorithm_.indexOf(algorithm));
    }

    private void setText(Text text, String s) {
        if (s != null) {
            text.setText(s);
        } else {
            text.setText("");
        }
    }

    protected String getMessage(String msgId) {
        return ATKWASUIPlugin.getMessage(msgId);
    }
}

