/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.was.ui.editor.common;

import com.ibm.etools.webservice.atk.was.ui.constants.ATKWASUIConstants;
import com.ibm.etools.webservice.atk.was.ui.editor.common.DialogTableViewerEditor;
import com.ibm.etools.webservice.atk.was.ui.plugin.ATKWASUIPlugin;
import com.ibm.etools.webservice.wscommonbnd.CollectionCertStore;
import com.ibm.etools.webservice.wscommonbnd.WscommonbndFactory;
import com.ibm.etools.webservice.wscommonbnd.WscommonbndPackage;
import com.ibm.etools.webservice.wscommonbnd.X509Certificate;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandAddElement;
import org.eclipse.jst.j2ee.internal.webservice.command.CommandSetElement;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.ArtifactEdit;

public class DialogCollectionCertStore
extends Dialog {
    private String INFOPOP_DIALOG_COLLECTION_CERT_STORE = "com.ibm.etools.webservice.atk.was.ui.DCOL0001";
    private Shell shell_;
    private Text nameText_;
    private Text providerText_;
    private DialogTableViewerEditor x509CertTable_;
    private ArtifactEdit artifactEdit_;
    private EObject eObject_;
    private EStructuralFeature feature_;
    private CollectionCertStore collectionCertStore_;
    private Object addedObject_;

    public DialogCollectionCertStore(Shell shell, ArtifactEdit artifactEdit, EObject eObject, EStructuralFeature feature, CollectionCertStore collectionCertStore) {
        super(shell);
        this.artifactEdit_ = artifactEdit;
        this.eObject_ = eObject;
        this.feature_ = feature;
        this.collectionCertStore_ = collectionCertStore;
        this.addedObject_ = null;
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        super.cancelPressed();
    }

    protected void okPressed() {
        WscommonbndFactory factory = WscommonbndFactory.eINSTANCE;
        CollectionCertStore collectionCertStore = factory.createCollectionCertStore();
        collectionCertStore.setName(this.nameText_.getText());
        collectionCertStore.setProvider(this.providerText_.getText());
        EList x509CertList = collectionCertStore.getX509Certificates();
        TableItem[] x509Certs = this.x509CertTable_.getItems();
        int i = 0;
        while (i < x509Certs.length) {
            X509Certificate x509Cert = factory.createX509Certificate();
            x509Cert.setPath(x509Certs[i].getText(0));
            x509CertList.add((Object)x509Cert);
            ++i;
        }
        Object command = this.collectionCertStore_ != null ? new CommandSetElement(null, null, this.eObject_, this.feature_, (Object)collectionCertStore, (Object)this.collectionCertStore_) : new CommandAddElement(null, null, this.eObject_, this.feature_, (Object)collectionCertStore);
        this.addedObject_ = collectionCertStore;
        this.artifactEdit_.getContentModelRoot().eResource().setModified(true);
        this.artifactEdit_.getCommandStack().execute((Command)command);
        this.setReturnCode(0);
        super.okPressed();
    }

    public Object getAddedObject() {
        return this.addedObject_;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getMessage("%DIALOG_TITLE_COLLECTION_CERT_STORE"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)gd);
        WscommonbndPackage pkg = WscommonbndFactory.eINSTANCE.getWscommonbndPackage();
        ATKWASUIConstants atkWasUiConstants = new ATKWASUIConstants();
        Label label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_NAME"));
        label.setLayoutData((Object)new GridData(256));
        this.nameText_ = new Text(composite, 2116);
        this.nameText_.setLayoutData((Object)new GridData(768));
        label = new Label(composite, 64);
        label.setText(this.getMessage("%LABEL_PROVIDER"));
        label.setLayoutData((Object)new GridData(256));
        this.providerText_ = new Text(composite, 2116);
        this.providerText_.setLayoutData((Object)new GridData(768));
        this.providerText_.setText(atkWasUiConstants.defaultCollectionCertStoreProvider());
        Composite x509CertComposite = new Composite(composite, 0);
        x509CertComposite.setLayout((Layout)new GridLayout());
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        x509CertComposite.setLayoutData((Object)gd);
        label = new Label(x509CertComposite, 64);
        label.setText(this.getMessage("%LABEL_X509CERTIFICATE"));
        label.setLayoutData((Object)new GridData(256));
        String[] propertyTableColumns = new String[]{this.getMessage("%LABEL_PATH")};
        EStructuralFeature[] propertyTableFeatures = new EStructuralFeature[]{pkg.getX509Certificate_Path()};
        Object[] propertyTableFeatureValues = new String[]{atkWasUiConstants.defaultX509CertificatePath()};
        this.x509CertTable_ = new DialogTableViewerEditor(x509CertComposite, propertyTableColumns, pkg.getX509Certificate(), propertyTableFeatures, propertyTableFeatureValues);
        composite.setTabList(new Control[]{this.nameText_, this.providerText_, x509CertComposite});
        this.init();
        return composite;
    }

    private void init() {
        if (this.collectionCertStore_ != null) {
            this.setText(this.nameText_, this.collectionCertStore_.getName());
            this.setText(this.providerText_, this.collectionCertStore_.getProvider());
            EList x509CertList = this.collectionCertStore_.getX509Certificates();
            for (X509Certificate x509Cert : x509CertList) {
                this.x509CertTable_.addItem(new Object[]{x509Cert.getPath()});
            }
            this.x509CertTable_.refresh();
        }
    }

    private void setText(Text text, String s) {
        if (s != null) {
            text.setText(s);
        } else {
            text.setText("");
        }
    }

    protected String getMessage(String msgId) {
        return ATKWASUIPlugin.getMessage(msgId);
    }
}

