/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.was.ui.constants;

import com.ibm.etools.webservice.atk.was.ui.plugin.ATKWASUIPlugin;
import com.ibm.etools.webservice.wscbnd.LoginBinding;
import com.ibm.etools.webservice.wscbnd.WscbndFactory;
import com.ibm.etools.webservice.wscommonbnd.CanonicalizationMethod;
import com.ibm.etools.webservice.wscommonbnd.CertPathSettings;
import com.ibm.etools.webservice.wscommonbnd.DataEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.DigestMethod;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.KeyEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.SignatureMethod;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.WscommonbndFactory;
import java.util.Vector;

public class ATKWASUIConstants {
    private Vector nonFIPSSigningInfoAlgorithms = null;
    private Vector FIPSSigningInfoAlgorithms = null;
    private Vector nonFIPSDigestMethodAlgorithms = null;
    private Vector FIPSDigestMethodAlgorithms = null;
    private Vector FIPSDataEncryptionAlgorithms = null;
    private Vector nonFIPSDataEncryptionAlgorithms = null;
    private Vector FIPSKeyEncryptionAlgorithms = null;
    private Vector nonFIPSKeyEncryptionAlgorithms = null;
    private String CLIENT_BINDING_NAME = "com.ibm.ws.wssecurity.config.WSSE.Namespace";
    private String CLIENT_BINDING_VALUE1 = "http://schemas.xmlsoap.org/ws/2003/06/secext";
    private String SIGNING_INFO_SIGNATURE_METHOD_VALUE1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private String SIGNING_INFO_SIGNATURE_METHOD_VALUE2 = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private String SIGNING_INFO_DIGEST_METHOD_VALUE1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    private String SIGNING_INFO_CANONICALIZATION_METHOD_VALUE1 = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private String SIGNING_INFO_CANONICALIZATION_METHOD_VALUE2 = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    private String SIGNING_INFO_CANONICALIZATION_METHOD_VALUE3 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private String SIGNING_INFO_CANONICALIZATION_METHOD_VALUE4 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    private String ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE1 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    private String ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE2 = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
    private String ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE3 = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
    private String ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE4 = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
    private String ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE5 = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
    private String ENCRYPTION_INFO_DATA_ENCRYPTION_VALUE1 = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    private String ENCRYPTION_INFO_DATA_ENCRYPTION_VALUE2 = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    private String ENCRYPTION_INFO_DATA_ENCRYPTION_VALUE3 = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    private String ENCRYPTION_INFO_DATA_ENCRYPTION_VALUE4 = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    private String KEY_STORE_TYPE_VALUE1 = "JKS";
    private String KEY_STORE_TYPE_VALUE2 = "JCEKS";
    private String KEY_STORE_TYPE_VALUE3 = "PKCS11";
    private String KEY_STORE_TYPE_VALUE4 = "PKCS12";
    private String DEFAULT_KEY_LOCATOR_CLASS_NAME = "com.ibm.wsspi.wssecurity.config.KeyStoreKeyLocator";
    private String DEFAULT_KEY_LOCATOR_CLASS_NAME_CONFIDENTIALITY = "com.ibm.wsspi.wssecurity.config.WSIdKeyStoreMapKeyLocator";
    private String KEY_LOCATOR_CLASS_NAME_VALUE2 = "com.ibm.wsspi.wssecurity.config.CertInRequestKeyLocator";
    private String KEY_LOCATOR_CLASS_NAME_VALUE3 = "com.ibm.wsspi.wssecurity.config.WSIdKeyStoreMapKeyLocator";
    private String LOGIN_BINDING_BASIC_AUTH = "BasicAuth";
    private String LOGIN_BINDING_ID_ASSERTION = "IDAssertion";
    private String LOGIN_BINDING_SIGNATURE = "Signature";
    private String LOGIN_BINDING_LTPA = "LTPA";
    private String DEFAULT_TOKEN_URI = "http://www.ibm.com/websphere/appserver/tokentype/5.0.2";
    private String DEFAULT_TOKEN_LOCAL_NAME = "LTPA";
    private String CALLBACK_HANDLER_VALUE1 = "com.ibm.wsspi.wssecurity.auth.callback.StdinPromptCallbackHandler";
    private String CALLBACK_HANDLER_VALUE2 = "com.ibm.wsspi.wssecurity.auth.callback.GUIPromptCallbackHandler";
    private String CALLBACK_HANDLER_VALUE3 = "com.ibm.wsspi.wssecurity.auth.callback.NonPromptCallbackHandler";
    private String CALLBACK_HANDLER_VALUE4 = "com.ibm.wsspi.wssecurity.auth.callback.LTPATokenCallbackHandler";
    private String CALLBACK_HANDLER_FACTORY_CLASS_NAME = "com.ibm.wsspi.wssecurity.auth.callback.WSCallbackHandlerFactoryImpl";
    private String DEFAULT_LTPA_CONFIG_NAME = "WSLogin";
    private String LOGIN_MAPPING_NONCE_MAXAGE = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.maxAge";
    private String LOGIN_MAPPING_NONCE_CLOCKSKEW = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.clockSkew";
    private String NONCE_MAXAGE_DEFAULT = "300";
    private String NONCE_CLOCKSKEW_DEFAULT = "0";
    private String LOGIN_CONFIG_NONCE = "com.ibm.ws.wssecurity.config.token.BasicAuth.NonceRequired";
    private String LOGIN_CONFIG_NONCE_TIMESTAMP = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.timestampRequired";
    private String CLIENT_LOGIN_CONFIG_NONCE = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce";
    private String CLIENT_LOGIN_CONFIG_NONCE_TIMESTAMP = "com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.timestamp";
    private String ENABLED_VALUE = "true";
    private String DISABLED_VALUE = "false";
    private String SCOPE_REQUEST = "Request";
    private String SCOPE_APPLICATION = "Application";
    private String SCOPE_SESSION = "Session";

    public String defaultNamespace() {
        return new String(ATKWASUIPlugin.getMessage("%LABEL_TABLE_NAMESPACE_URI"));
    }

    public String defaultLocalname() {
        return new String(ATKWASUIPlugin.getMessage("%LABEL_TABLE_LOCAL_NAME"));
    }

    public String defaultName() {
        return new String(ATKWASUIPlugin.getMessage("%LABEL_TABLE_NAME"));
    }

    public String defaultValue() {
        return new String(ATKWASUIPlugin.getMessage("%LABEL_TABLE_VALUE"));
    }

    public String defaultClientBindingName() {
        return new String(this.CLIENT_BINDING_NAME);
    }

    public String defaultClientBindingValue() {
        return new String(this.CLIENT_BINDING_VALUE1);
    }

    public String defaultEndpointURIPrefix() {
        return new String(ATKWASUIPlugin.getMessage("%LABEL_BND_TEXT"));
    }

    public String defaultPortQnameBndLocalname() {
        String localname = new String(ATKWASUIPlugin.getMessage("%LABEL_TABLE_LOCAL_NAME"));
        StringBuffer b = new StringBuffer();
        b.append(ATKWASUIPlugin.getMessage("%_UI_PortQnameBinding_type"));
        b.append(localname);
        return b.toString();
    }

    public String defaultOveriddenEndpointURI() {
        return new String("http://");
    }

    public String defaultKeyAlias() {
        return new String(ATKWASUIPlugin.getMessage("%LABEL_TABLE_KEY_ALIAS"));
    }

    public String defaultKeyKeypass() {
        return new String(ATKWASUIPlugin.getMessage("%LABEL_TABLE_KEY_KEY_PASS"));
    }

    public String defaultKeyName() {
        return new String(ATKWASUIPlugin.getMessage("%LABEL_TABLE_KEY_NAME"));
    }

    public String defaultCollectionCertStoreProvider() {
        return new String("IBMCertPath");
    }

    public String defaultX509CertificatePath() {
        return new String(ATKWASUIPlugin.getMessage("%LABEL_TABLE_X509CERTIFICATE_PATH"));
    }

    public String[] getSigningInfoSignatureMethods(boolean FIPSComplient) {
        if (this.FIPSSigningInfoAlgorithms == null) {
            this.FIPSSigningInfoAlgorithms = new Vector();
            this.FIPSSigningInfoAlgorithms.add(this.SIGNING_INFO_SIGNATURE_METHOD_VALUE1);
            this.FIPSSigningInfoAlgorithms.add(this.SIGNING_INFO_SIGNATURE_METHOD_VALUE2);
        }
        if (this.nonFIPSSigningInfoAlgorithms == null) {
            this.nonFIPSSigningInfoAlgorithms = new Vector();
        }
        Vector all = new Vector();
        all.addAll(this.FIPSSigningInfoAlgorithms);
        if (!FIPSComplient) {
            all.addAll(this.nonFIPSSigningInfoAlgorithms);
        }
        Object[] array = new String[all.size()];
        all.copyInto(array);
        return array;
    }

    public boolean isSignatureMethodFIPSCompliant(String method) {
        return this.FIPSSigningInfoAlgorithms.contains(method);
    }

    public String[] getSigningInfoDigestMethods(boolean FIPSComplient) {
        if (this.FIPSDigestMethodAlgorithms == null) {
            this.FIPSDigestMethodAlgorithms = new Vector();
            this.FIPSDigestMethodAlgorithms.add(this.SIGNING_INFO_DIGEST_METHOD_VALUE1);
        }
        if (this.nonFIPSDigestMethodAlgorithms == null) {
            this.nonFIPSDigestMethodAlgorithms = new Vector();
        }
        Vector all = new Vector();
        all.addAll(this.FIPSDigestMethodAlgorithms);
        if (!FIPSComplient) {
            all.addAll(this.nonFIPSDigestMethodAlgorithms);
        }
        Object[] array = new String[all.size()];
        all.copyInto(array);
        return array;
    }

    public boolean isDigestMethodFIPSCompliant(String method) {
        return this.FIPSDigestMethodAlgorithms.contains(method);
    }

    public String[] getSigningInfoCanonicalizationMethods() {
        String[] methods = new String[]{new String(this.SIGNING_INFO_CANONICALIZATION_METHOD_VALUE1), new String(this.SIGNING_INFO_CANONICALIZATION_METHOD_VALUE2), new String(this.SIGNING_INFO_CANONICALIZATION_METHOD_VALUE3), new String(this.SIGNING_INFO_CANONICALIZATION_METHOD_VALUE4), ""};
        return methods;
    }

    public SignatureMethod defaultSigningInfoSignatureMethods() {
        SignatureMethod method = WscommonbndFactory.eINSTANCE.createSignatureMethod();
        method.setAlgorithm(new String(this.SIGNING_INFO_SIGNATURE_METHOD_VALUE1));
        return method;
    }

    public DigestMethod defaultSigningInfoDigestMethods() {
        DigestMethod method = WscommonbndFactory.eINSTANCE.createDigestMethod();
        method.setAlgorithm(new String(this.SIGNING_INFO_DIGEST_METHOD_VALUE1));
        return method;
    }

    public CanonicalizationMethod defaultSigningInfoCanonicalizationMethods() {
        CanonicalizationMethod method = WscommonbndFactory.eINSTANCE.createCanonicalizationMethod();
        method.setAlgorithm(new String(this.SIGNING_INFO_CANONICALIZATION_METHOD_VALUE1));
        return method;
    }

    public CertPathSettings defaultCertPathSettings() {
        WscommonbndFactory factory = WscommonbndFactory.eINSTANCE;
        CertPathSettings certPathSettings = factory.createCertPathSettings();
        certPathSettings.setTrustAnyCertificate(factory.createTrustAnyCertificate());
        return certPathSettings;
    }

    public SigningInfo defaultSigningInfo() {
        SigningInfo signingInfo = WscommonbndFactory.eINSTANCE.createSigningInfo();
        signingInfo.setSignatureMethod(this.defaultSigningInfoSignatureMethods());
        signingInfo.setDigestMethod(this.defaultSigningInfoDigestMethods());
        signingInfo.setCanonicalizationMethod(this.defaultSigningInfoCanonicalizationMethods());
        signingInfo.setCertPathSettings(this.defaultCertPathSettings());
        return signingInfo;
    }

    public String[] getEncryptionInfoKeyEncryptionMethods(boolean FIPSComplient) {
        if (this.FIPSKeyEncryptionAlgorithms == null) {
            this.FIPSKeyEncryptionAlgorithms = new Vector();
            this.FIPSKeyEncryptionAlgorithms.add(this.ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE1);
            this.FIPSKeyEncryptionAlgorithms.add(this.ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE2);
            this.FIPSKeyEncryptionAlgorithms.add(this.ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE3);
            this.FIPSKeyEncryptionAlgorithms.add(this.ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE4);
            this.FIPSKeyEncryptionAlgorithms.add(this.ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE5);
        }
        if (this.nonFIPSKeyEncryptionAlgorithms == null) {
            this.nonFIPSKeyEncryptionAlgorithms = new Vector();
        }
        Vector all = new Vector();
        all.addAll(this.FIPSKeyEncryptionAlgorithms);
        if (!FIPSComplient) {
            all.addAll(this.nonFIPSKeyEncryptionAlgorithms);
        }
        Object[] array = new String[all.size()];
        all.copyInto(array);
        return array;
    }

    public boolean isKeyEncryptionFIPSCompliant(String value) {
        return this.FIPSKeyEncryptionAlgorithms.contains(value);
    }

    public String[] getEncryptionInfoDataEncryptionMethods(boolean FIPSComplient) {
        if (this.FIPSDataEncryptionAlgorithms == null) {
            this.FIPSDataEncryptionAlgorithms = new Vector();
            this.FIPSDataEncryptionAlgorithms.add(this.ENCRYPTION_INFO_DATA_ENCRYPTION_VALUE1);
            this.FIPSDataEncryptionAlgorithms.add(this.ENCRYPTION_INFO_DATA_ENCRYPTION_VALUE2);
            this.FIPSDataEncryptionAlgorithms.add(this.ENCRYPTION_INFO_DATA_ENCRYPTION_VALUE3);
            this.FIPSDataEncryptionAlgorithms.add(this.ENCRYPTION_INFO_DATA_ENCRYPTION_VALUE4);
        }
        if (this.nonFIPSDataEncryptionAlgorithms == null) {
            this.nonFIPSDataEncryptionAlgorithms = new Vector();
        }
        Vector all = new Vector();
        all.addAll(this.FIPSDataEncryptionAlgorithms);
        if (!FIPSComplient) {
            all.addAll(this.nonFIPSDataEncryptionAlgorithms);
        }
        Object[] array = new String[all.size()];
        all.copyInto(array);
        return array;
    }

    public boolean isDataEncryptionFIPSCompliant(String value) {
        return this.FIPSDataEncryptionAlgorithms.contains(value);
    }

    public KeyEncryptionMethod defaultKeyEncryptionMethod() {
        KeyEncryptionMethod method = WscommonbndFactory.eINSTANCE.createKeyEncryptionMethod();
        method.setAlgorithm(new String(this.ENCRYPTION_INFO_KEY_ENCRYPTION_VALUE1));
        return method;
    }

    public DataEncryptionMethod defaultDataEncryptionMethod() {
        DataEncryptionMethod method = WscommonbndFactory.eINSTANCE.createDataEncryptionMethod();
        method.setAlgorithm(new String(this.ENCRYPTION_INFO_DATA_ENCRYPTION_VALUE1));
        return method;
    }

    public EncryptionInfo defaultEncryptionInfo() {
        EncryptionInfo encryptionInfo = WscommonbndFactory.eINSTANCE.createEncryptionInfo();
        encryptionInfo.setName(ATKWASUIPlugin.getMessage("%_UI_EncryptionInfo_type"));
        encryptionInfo.setKeyEncryptionMethod(this.defaultKeyEncryptionMethod());
        encryptionInfo.setEncryptionMethod(this.defaultDataEncryptionMethod());
        return encryptionInfo;
    }

    public String[] getKeyStoreTypes() {
        String[] types = new String[]{new String(this.KEY_STORE_TYPE_VALUE1), new String(this.KEY_STORE_TYPE_VALUE2), new String(this.KEY_STORE_TYPE_VALUE3), new String(this.KEY_STORE_TYPE_VALUE4)};
        return types;
    }

    public String defaultKeyLocatorClassName() {
        return this.defaultKeyLocatorClassName(false);
    }

    public String defaultKeyLocatorClassName(boolean confidentiality) {
        if (confidentiality) {
            return new String(this.DEFAULT_KEY_LOCATOR_CLASS_NAME_CONFIDENTIALITY);
        }
        return new String(this.DEFAULT_KEY_LOCATOR_CLASS_NAME);
    }

    public String[] getKeyLocatorClassNames() {
        String[] classnames = new String[]{new String(this.DEFAULT_KEY_LOCATOR_CLASS_NAME), new String(this.KEY_LOCATOR_CLASS_NAME_VALUE2), new String(this.KEY_LOCATOR_CLASS_NAME_VALUE3)};
        return classnames;
    }

    public String[] getLoginBindingAuthMethods() {
        String[] methods = new String[]{new String(this.LOGIN_BINDING_BASIC_AUTH), new String(this.LOGIN_BINDING_ID_ASSERTION), new String(this.LOGIN_BINDING_SIGNATURE), new String(this.LOGIN_BINDING_LTPA)};
        return methods;
    }

    public LoginBinding defaultLoginBinding() {
        LoginBinding loginBinding = WscbndFactory.eINSTANCE.createLoginBinding();
        loginBinding.setAuthMethod(new String(this.LOGIN_BINDING_BASIC_AUTH));
        loginBinding.setCallbackHandler(ATKWASUIPlugin.getMessage("%LABEL_TABLE_CALLBACK_HANDLER"));
        return loginBinding;
    }

    public String getBasicAuthenticationMethod() {
        return new String(this.LOGIN_BINDING_BASIC_AUTH);
    }

    public String getLTPAAuthenticationMethod() {
        return new String(this.LOGIN_BINDING_LTPA);
    }

    public String getLTPATokenURI() {
        return new String(this.DEFAULT_TOKEN_URI);
    }

    public String getLTPATokenLocalName() {
        return new String(this.DEFAULT_TOKEN_LOCAL_NAME);
    }

    public String[] getCallbackHandlerValues() {
        String[] values = new String[]{new String(this.CALLBACK_HANDLER_VALUE1), new String(this.CALLBACK_HANDLER_VALUE2), new String(this.CALLBACK_HANDLER_VALUE3), new String(this.CALLBACK_HANDLER_VALUE4)};
        return values;
    }

    public String getLoginBindingLTPACallbackHandler() {
        return new String(this.CALLBACK_HANDLER_VALUE4);
    }

    public String[] getCallBackHandlerFactoryClassNames() {
        String[] classNames = new String[]{new String(this.CALLBACK_HANDLER_FACTORY_CLASS_NAME)};
        return classNames;
    }

    public String getLTPAConfigName() {
        return new String(this.DEFAULT_LTPA_CONFIG_NAME);
    }

    public String getLoginMappingLTPACallBackHandler() {
        return new String(this.CALLBACK_HANDLER_FACTORY_CLASS_NAME);
    }

    public String getNonceMaxAgeKey() {
        return new String(this.LOGIN_MAPPING_NONCE_MAXAGE);
    }

    public String getNonceClockSkewKey() {
        return new String(this.LOGIN_MAPPING_NONCE_CLOCKSKEW);
    }

    public String getDefaultNonceMaxAge() {
        return new String(this.NONCE_MAXAGE_DEFAULT);
    }

    public String getDefaultNonceClockSkew() {
        return new String(this.NONCE_CLOCKSKEW_DEFAULT);
    }

    public String getNonceKey() {
        return new String(this.LOGIN_CONFIG_NONCE);
    }

    public String getNonceTimestampKey() {
        return new String(this.LOGIN_CONFIG_NONCE_TIMESTAMP);
    }

    public String getClientNonceKey() {
        return new String(this.CLIENT_LOGIN_CONFIG_NONCE);
    }

    public String getClientNonceTimestampKey() {
        return new String(this.CLIENT_LOGIN_CONFIG_NONCE_TIMESTAMP);
    }

    public String getEnabledValue() {
        return new String(this.ENABLED_VALUE);
    }

    public String getDisabledValue() {
        return new String(this.DISABLED_VALUE);
    }

    public String[] getScopes() {
        String[] Scopes = new String[]{new String(this.SCOPE_REQUEST), new String(this.SCOPE_APPLICATION), new String(this.SCOPE_SESSION)};
        return Scopes;
    }
}

