/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.preference;

import com.ibm.etools.webedit.common.internal.utils.AccessibleUtil;
import com.ibm.etools.webpage.template.ResourceHandler;
import com.ibm.etools.webpage.template.TemplatePlugin;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class PageTemplatePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button useJSPCommentButton;
    private Button useHTMLCommentButton;
    private Button readOnlyPromptButton;
    private Button createTemplateButton;
    private Button frameColorButton;
    RGB frameColor;

    protected Control createContents(Composite parent) {
        Composite page = PageTemplatePreferencePage.createPageComposite(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)page, "com.ibm.etools.webpage.template.tplu0040");
        Composite commentComposite = PageTemplatePreferencePage.createDummyComposite(page, 1, false);
        this.createLabel(commentComposite, ResourceHandler._UI_Page_Template_tag_creation_1, true);
        Composite composite = this.createCompositeGroup(commentComposite, false, false, 1);
        this.useJSPCommentButton = this.createRadioButton(composite, ResourceHandler._UI_Use__JSP_comment_in_JSP_file_2);
        this.useHTMLCommentButton = this.createRadioButton(composite, ResourceHandler._UI_Use__HTML_comment_in_JSP_file_3);
        Composite updatingFilesComposite = PageTemplatePreferencePage.createDummyComposite(page, 1, false);
        this.createLabel(updatingFilesComposite, ResourceHandler._UI_Builder_Updating_Files_using_Page_Template_1, true);
        composite = this.createCompositeGroup(updatingFilesComposite, false, false, 1);
        this.readOnlyPromptButton = new Button(composite, 32);
        this.readOnlyPromptButton.setText(ResourceHandler._UI_Prefs_Show__warning_when_read_only_files_can_not_be_updated_2);
        this.readOnlyPromptButton.setLayoutData((Object)new GridData(768));
        this.createTemplateButton = new Button(composite, 32);
        this.createTemplateButton.setText(ResourceHandler.PageTemplatePreferencePage_0);
        this.createTemplateButton.setLayoutData((Object)new GridData(768));
        Composite colorComposite = PageTemplatePreferencePage.createDummyComposite(page, 1, false);
        this.createLabel(colorComposite, ResourceHandler._UI_Apply_Page_Template_Wizard_1, true);
        String colText = ResourceHandler._UI_Frame__color_of_selected_page_elements__2;
        composite = this.createCompositeGroup(colorComposite, false, false, 2);
        this.createLabel(composite, colText, false);
        this.frameColorButton = this.createColorButton(composite);
        AccessibleUtil.addAccessibleListener((Control)this.frameColorButton, (String)colText);
        this.initializeValues();
        return page;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(TemplatePlugin.getDefault().getPreferenceStore());
    }

    protected void performDefaults() {
        boolean comments = TemplatePlugin.getDefault().getDefaultJSPCommentPreference();
        this.useJSPCommentButton.setSelection(comments);
        this.useHTMLCommentButton.setSelection(!comments);
        this.readOnlyPromptButton.setSelection(TemplatePlugin.getDefault().getDefaultReadOnlyPromptPreference());
        this.createTemplateButton.setSelection(TemplatePlugin.getDefault().getDefaultCreateTemplatePreference());
        this.frameColor = TemplatePlugin.getDefault().getDefaultFrameColorPreference();
        this.setButtonColor(this.frameColorButton, this.frameColor);
    }

    public boolean performOk() {
        TemplatePlugin.getDefault().setJSPCommentPreference(this.useJSPCommentButton.getSelection());
        TemplatePlugin.getDefault().setReadOnlyPromptPreference(this.readOnlyPromptButton.getSelection());
        TemplatePlugin.getDefault().setCreateTemplatePreference(this.createTemplateButton.getSelection());
        TemplatePlugin.getDefault().setFrameColorPreference(this.frameColor);
        return super.performOk();
    }

    static Composite createPageComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layoutParent = (GridLayout)parent.getLayout();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = layoutParent.verticalSpacing;
        layout.horizontalSpacing = layoutParent.horizontalSpacing;
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(parent.getFont());
        return composite;
    }

    private static Composite createDummyComposite(Composite parent, int numColumns, boolean makeColumnsEqualWidth) {
        Composite composite = new Composite(parent, 0);
        GridLayout layoutParent = (GridLayout)parent.getLayout();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = layoutParent.verticalSpacing;
        layout.horizontalSpacing = layoutParent.horizontalSpacing;
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData());
        composite.setFont(parent.getFont());
        return composite;
    }

    private Composite createCompositeGroup(Composite parent, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalIndent = 10;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
        data.grabExcessVerticalSpace = grabExcessVerticalSpace;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private Label createLabel(Composite parent, String text, boolean verticalIndent) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        if (verticalIndent) {
            data.verticalIndent = 10;
        }
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private Button createRadioButton(Composite group, String label) {
        Button button = new Button(group, 16400);
        button.setText(label);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        button.setLayoutData((Object)data);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        return button;
    }

    static void setGroupLayout(Composite composite, int numColumns, boolean makeColumnsEqualWidth) {
        Composite parent = composite.getParent();
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        composite.setFont(parent.getFont());
    }

    private void initializeValues() {
        boolean comments = TemplatePlugin.getDefault().getJSPCommentPreference();
        this.useJSPCommentButton.setSelection(comments);
        this.useHTMLCommentButton.setSelection(!comments);
        this.readOnlyPromptButton.setSelection(TemplatePlugin.getDefault().getReadOnlyPromptPreference());
        this.createTemplateButton.setSelection(TemplatePlugin.getDefault().getCreateTemplatePreference());
        this.frameColor = TemplatePlugin.getDefault().getFrameColorPreference();
        this.setButtonColor(this.frameColorButton, this.frameColor);
    }

    private Button createColorButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                RGB color = PageTemplatePreferencePage.this.openColorDialog((Button)event.widget, PageTemplatePreferencePage.this.frameColor);
                if (color != null) {
                    PageTemplatePreferencePage.this.frameColor = color;
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        return button;
    }

    protected RGB openColorDialog(Button button, RGB color) {
        ColorDialog dlg = new ColorDialog(button.getShell());
        dlg.setRGB(color);
        dlg.open();
        RGB rgb = dlg.getRGB();
        if (rgb != null && rgb != color) {
            this.setButtonColor(button, rgb);
        }
        return rgb;
    }

    private void setButtonColor(Button button, RGB rgb) {
        Display display = button.getDisplay();
        GC gc = new GC((Drawable)button);
        gc.setFont(this.getFont());
        Point point = gc.textExtent("X");
        gc.dispose();
        point.x = point.y * 3 - 6;
        Image image = new Image((Device)display, point.x, point.y);
        gc = new GC((Drawable)image);
        Rectangle rect = new Rectangle(0, 0, point.x, point.y);
        Color color = new Color((Device)display, rgb);
        gc.setBackground(color);
        gc.fillRectangle(rect);
        gc.dispose();
        color.dispose();
        Image oldImage = button.getImage();
        button.setImage(image);
        if (oldImage != null) {
            oldImage.dispose();
        }
    }
}

