/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.model.util;

import com.ibm.etools.webedit.viewer.internal.utils.ModelManagerUtil;
import com.ibm.etools.webpage.template.TemplatePlugin;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.wst.sse.core.internal.encoding.IContentDescriptionExtended;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class TemplateEncodingUtil {
    public static String getCharset(IStructuredModel model) {
        return TemplateEncodingUtil.getJavaEncoding(model);
    }

    public static String getJavaEncoding(IStructuredModel model) {
        IContentDescription description = null;
        String location = ModelManagerUtil.getBaseLocation((IStructuredModel)model);
        if (location != null) {
            description = TemplateEncodingUtil.getContentDescription((IPath)new Path(location));
        }
        if (description == null) {
            description = TemplateEncodingUtil.getContentDescriptionFromModel(model);
        }
        return TemplateEncodingUtil.getJavaEncoding(description);
    }

    public static String getIANAEncoding(IStructuredModel model) {
        IContentDescription description = null;
        String location = ModelManagerUtil.getBaseLocation((IStructuredModel)model);
        if (location != null) {
            description = TemplateEncodingUtil.getContentDescription((IPath)new Path(location));
        }
        if (description == null) {
            description = TemplateEncodingUtil.getContentDescriptionFromModel(model);
        }
        return TemplateEncodingUtil.getIANAEncoding(description);
    }

    public static String getJavaEncoding(IPath fileLocation) {
        return TemplateEncodingUtil.getJavaEncoding(TemplateEncodingUtil.getContentDescription(fileLocation));
    }

    public static String getIANAEncoding(IPath fileLocation) {
        return TemplateEncodingUtil.getIANAEncoding(TemplateEncodingUtil.getContentDescription(fileLocation));
    }

    public static String getIANAEncoding(IContentDescription description) {
        if (description == null) {
            return null;
        }
        String result = (String)description.getProperty(IContentDescriptionExtended.DETECTED_CHARSET);
        if (result == null) {
            result = description.getCharset();
        }
        return result;
    }

    protected static String getJavaEncoding(IContentDescription description) {
        return description == null ? null : description.getCharset();
    }

    public static IContentDescription getContentDescription(IPath fileLocation) {
        IContentDescription resultn;
        block7: {
            resultn = null;
            try {
                IFile file = TemplatePlugin.getWorkspace().getRoot().getFileForLocation(fileLocation);
                if (file != null) {
                    resultn = file.getContentDescription();
                    break block7;
                }
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(fileLocation.toFile()));
                try {
                    resultn = Platform.getContentTypeManager().getDescriptionFor((InputStream)is, fileLocation.lastSegment(), IContentDescription.ALL);
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {}
        }
        return resultn;
    }

    protected static IContentDescription getContentDescriptionFromModel(IStructuredModel model) {
        if (model == null) {
            return null;
        }
        String name = null;
        String location = ModelManagerUtil.getBaseLocation((IStructuredModel)model);
        if (location != null) {
            name = new Path(location).lastSegment();
        }
        StringReader reader = new StringReader(model.getStructuredDocument().get());
        try {
            IContentDescription iContentDescription = Platform.getContentTypeManager().getDescriptionFor((Reader)reader, name, IContentDescription.ALL);
            return iContentDescription;
        }
        catch (IOException iOException) {
        }
        finally {
            reader.close();
        }
        return null;
    }
}

