/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.model;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public class TplRange {
    private final IStructuredDocument flatModel;
    private final IStructuredDocumentRegion startNode;
    private final IStructuredDocumentRegion endNode;
    private final int position;

    public TplRange(IStructuredDocument fModel, IStructuredDocumentRegion start, IStructuredDocumentRegion end) {
        this.flatModel = fModel;
        this.startNode = start;
        this.endNode = end;
        this.position = -1;
    }

    public TplRange(IStructuredDocument fModel, int position) {
        this.flatModel = fModel;
        this.startNode = null;
        this.endNode = null;
        this.position = position;
    }

    public IStructuredDocumentRegion getEndNode() {
        return this.endNode;
    }

    public IStructuredDocument getModel() {
        return this.flatModel;
    }

    public IStructuredDocumentRegion getStartNode() {
        return this.startNode;
    }

    public int getPosition() {
        return this.position;
    }

    public String getText() {
        if (this.startNode == null || this.endNode == null) {
            return "";
        }
        try {
            return this.flatModel.get(this.startNode.getStartOffset(), this.endNode.getEndOffset() - this.startNode.getStartOffset());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public boolean isValid() {
        if (this.flatModel == null) {
            return false;
        }
        return this.startNode != null && this.endNode != null || this.position >= 0 && this.position <= this.flatModel.getLength();
    }

    public boolean isBefore(TplRange other) {
        if (this.flatModel != other.flatModel) {
            return false;
        }
        return this.getEndPosition() <= other.getStartPosition();
    }

    public boolean isBeforePrevious(TplRange other) {
        if (this.flatModel != other.flatModel) {
            return false;
        }
        return this.getEndPosition() < other.getStartPosition();
    }

    public TplRange getRangeTo(TplRange other) {
        IStructuredDocumentRegion nextEndNode;
        if (!this.isBefore(other)) {
            return null;
        }
        IStructuredDocumentRegion nextStartNode = this.endNode != null ? this.endNode.getNext() : this.flatModel.getRegionAtCharacterOffset(this.position);
        IStructuredDocumentRegion iStructuredDocumentRegion = nextEndNode = other.startNode != null ? other.startNode.getPrevious() : this.flatModel.getRegionAtCharacterOffset(other.position - 1);
        if (nextStartNode == null) {
            return new TplRange(this.flatModel, this.flatModel.getLength());
        }
        if (nextEndNode == null) {
            return new TplRange(this.flatModel, 0);
        }
        if (nextStartNode.getPrevious() == nextEndNode) {
            return new TplRange(this.flatModel, nextStartNode.getStart());
        }
        return new TplRange(this.flatModel, nextStartNode, nextEndNode);
    }

    public TplRange getLeftEndRange() {
        if (this.startNode == null || this.endNode == null) {
            return this;
        }
        return new TplRange(this.flatModel, this.startNode.getStart());
    }

    public TplRange getRightEndRange() {
        if (this.startNode == null || this.endNode == null) {
            return this;
        }
        return new TplRange(this.flatModel, this.endNode.getEnd() + 1);
    }

    protected int getStartPosition() {
        return this.startNode != null ? this.startNode.getStart() : this.getPosition();
    }

    protected int getEndPosition() {
        return this.endNode != null ? this.endNode.getEnd() + 1 : this.getPosition();
    }
}

