/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.validation;

import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.TemplatePlugin;
import com.ibm.etools.webpage.template.internal.validation.PropertyResolverImpl;
import com.ibm.etools.webpage.template.internal.validation.PropertyResolverRegistoryReader;
import com.ibm.etools.webpage.template.internal.validation.TemplateValidatorWrapper;
import com.ibm.etools.webpage.template.validation.IPropertyResolver;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class TemplateValidationImpl {
    private static final String TRACE_KEY = "validator/validation";

    public static IStatus validate(String validationType, IPropertyResolver instanceResolver, IPropertyResolver templateResolver, boolean stopOnFirstError) {
        long base = System.currentTimeMillis();
        StringWriter writer = null;
        PrintWriter out = null;
        try {
            TemplateValidatorWrapper[] validators = PropertyResolverRegistoryReader.getInstance().getTemplateValidator(validationType);
            if (TemplateValidationImpl._isTracing()) {
                writer = new StringWriter();
                out = new PrintWriter(writer);
                out.println("TemplateValidationImpl.validate start:");
                out.println("\tinstance: ");
                TemplateValidationImpl._dumpResolver(out, instanceResolver);
                out.println("\ttemplate: ");
                TemplateValidationImpl._dumpResolver(out, templateResolver);
                out.println("\tvalidator list:");
                int i = 0;
                while (i < validators.length) {
                    out.println("\t" + validators[i].getClassName());
                    ++i;
                }
            }
            IStatus result = null;
            int i = 0;
            while (i < validators.length) {
                TemplateValidatorWrapper validator = validators[i];
                IStatus myStatus = validator.validate(instanceResolver, templateResolver);
                if (TemplateValidationImpl._isTracing()) {
                    out.println("\t    validator:" + validators[i].getClassName() + " => " + myStatus);
                }
                if (myStatus != null && !myStatus.isOK()) {
                    if (result == null) {
                        result = myStatus;
                    } else if (result.isMultiStatus()) {
                        ((MultiStatus)result).merge(myStatus);
                    } else {
                        MultiStatus multi = new MultiStatus(TemplatePlugin.getDefault().getBundle().getSymbolicName(), 0, "", null);
                        multi.merge(result);
                        multi.merge(myStatus);
                        result = multi;
                    }
                    if (stopOnFirstError && result.getSeverity() >= 4) {
                        IStatus iStatus = result;
                        return iStatus;
                    }
                }
                ++i;
            }
            if (result == null) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            IStatus iStatus = result;
            return iStatus;
        }
        finally {
            if (TemplateValidationImpl._isTracing()) {
                out.println("  Template validation has finished in " + (System.currentTimeMillis() - base) + " milli seconds.");
                out.flush();
                TemplateValidationImpl._trace(writer.getBuffer().toString());
            }
        }
    }

    static void _dumpResolver(PrintWriter out, IPropertyResolver resolver) {
        if (!(resolver instanceof PropertyResolverImpl)) {
            return;
        }
        PropertyResolverImpl r = (PropertyResolverImpl)resolver;
        r._dump(out);
    }

    static void _trace(String msg) {
        Logger.trace(TRACE_KEY, msg);
    }

    static boolean _isTracing() {
        return Logger.isTracing(TRACE_KEY);
    }
}

