/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.validation;

import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.internal.validation.TemplateValidatorWrapper;
import com.ibm.etools.webpage.template.validation.IPropertyResolverContributor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;

class PropertyResolverRegistoryReader {
    private static final PropertyResolverRegistoryReader _instance = new PropertyResolverRegistoryReader();
    private static final String POINT_NAME = "com.ibm.etools.webpage.template.templateValidation";
    static final String ELE_PROPERTY_RESOLVER = "propertyResolver";
    static final String ELE_CONTRIBUTOR = "contributor";
    static final String ELE_VALIDATORGROUP = "validatorGroup";
    static final String ELE_VALIDATOR = "validator";
    static final String ATT_TYPE = "type";
    static final String ATT_OBJECT_CLASS = "objectClass";
    static final String ATT_CLASS = "class";
    static final String ATT_PRIORITY = "priority";
    static final String ATT_EN_INSTANCE = "enablementInstanceProperties";
    static final String ATT_EN_TEMPLATE = "enablementTemplateProperties";
    private static final int DEFAULT_PRIORITY = 100;
    private HashMap validatorMap = new HashMap();

    PropertyResolverRegistoryReader() {
    }

    static PropertyResolverRegistoryReader getInstance() {
        return _instance;
    }

    public TemplateValidatorWrapper[] getTemplateValidator(String type) {
        Object[] result = (TemplateValidatorWrapper[])this.validatorMap.get(type);
        if (result == null) {
            HashMap<TemplateValidatorWrapper, Integer> resultMap = new HashMap<TemplateValidatorWrapper, Integer>(10);
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(POINT_NAME);
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                if (element.getName().equals(ELE_VALIDATORGROUP) && this.isValidTypeFor(element, type)) {
                    IConfigurationElement[] children = element.getChildren(ELE_VALIDATOR);
                    int j = 0;
                    while (j < children.length) {
                        IConfigurationElement child = children[j];
                        int priority = this.getPriority(child);
                        resultMap.put(new TemplateValidatorWrapper(type, child), new Integer(priority));
                        ++j;
                    }
                }
                ++i;
            }
            result = new TemplateValidatorWrapper[resultMap.size()];
            this.createResult(result, resultMap);
            this.validatorMap.put(type, result);
        }
        return result;
    }

    public IPropertyResolverContributor[] getPropertyResolverContributorFor(String type, Object object) {
        HashMap<IPropertyResolverContributor, Integer> resultMap = new HashMap<IPropertyResolverContributor, Integer>(10);
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(POINT_NAME);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals(ELE_PROPERTY_RESOLVER) && this.isValidTypeFor(element, type)) {
                IConfigurationElement[] contributors = element.getChildren(ELE_CONTRIBUTOR);
                int j = 0;
                while (j < contributors.length) {
                    IConfigurationElement contributor = contributors[j];
                    if (this.isValidElementForPropertyResolverContributor(contributor, type, object)) {
                        int priority = this.getPriority(contributor);
                        try {
                            IPropertyResolverContributor c = (IPropertyResolverContributor)contributor.createExecutableExtension(ATT_CLASS);
                            resultMap.put(c, new Integer(priority));
                        }
                        catch (CoreException e) {
                            Logger.log(e);
                        }
                        catch (ClassCastException e) {
                            Logger.log(e);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        Object[] result = new IPropertyResolverContributor[resultMap.size()];
        this.createResult(result, resultMap);
        return result;
    }

    private void createResult(Object[] result, final HashMap map) {
        result = map.keySet().toArray(result);
        Arrays.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                int v = (Integer)map.get(o1) - (Integer)map.get(o2);
                if (v != 0) {
                    return v;
                }
                return o1.getClass().getName().compareTo(o2.getClass().getName());
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isValidElementForPropertyResolverContributor(IConfigurationElement element, String type, Object object) {
        try {
            if (!element.getName().equals(ELE_CONTRIBUTOR)) {
                return false;
            }
            String requiredName = element.getAttributeAsIs(ATT_OBJECT_CLASS);
            if (requiredName == null) {
                return true;
            }
            if (object == null) {
                return false;
            }
            Class<?> clazz = object.getClass();
            block2: while (true) {
                if (clazz == null) {
                    return false;
                }
                if (clazz.getName().equals(requiredName)) {
                    return true;
                }
                Class<?>[] ifs = clazz.getInterfaces();
                int i = 0;
                while (true) {
                    if (i >= ifs.length) {
                        clazz = clazz.getSuperclass();
                        continue block2;
                    }
                    if (ifs[i].getName().equals(requiredName)) {
                        return true;
                    }
                    ++i;
                }
                break;
            }
        }
        catch (InvalidRegistryObjectException e) {
            Logger.log(e);
            return false;
        }
    }

    private boolean isValidTypeFor(IConfigurationElement element, String type) {
        String validTypes = element.getAttributeAsIs(ATT_TYPE);
        return validTypes != null && validTypes.indexOf(type) != -1;
    }

    private int getPriority(IConfigurationElement contributor) {
        int priority = 100;
        String strPriority = contributor.getAttributeAsIs(ATT_PRIORITY);
        if (strPriority != null) {
            try {
                priority = Integer.parseInt(strPriority);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return priority;
    }
}

