/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.sample;

import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.TemplatePlugin;
import com.ibm.etools.webpage.template.TemplateSampleFamily;
import com.ibm.etools.webpage.template.TemplateSampleItem;
import com.ibm.etools.webpage.template.internal.sample.TemplateSampleFamilyImpl;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class TemplateRegistryReader {
    public static final String PL_TEMPLATESAMPLE = "templateSamples";
    public static final String ELE_FOLDER = "folder";
    public static final String ELE_FILE = "file";
    public static final String ELE_FAMILY = "family";
    public static final String ATT_ID = "id";
    public static final String ATT_NAME = "name";
    public static final String ATT_PATH = "path";
    public static final String ATT_IMGPATH = "imagePath";
    public static final String ATT_FAMILY = "family";
    public static final String ATT_PRIORITY = "priority";
    private static final String NL_KEY = "$nl$";
    private static final int DEFAULT_PRIORITY = 65535;
    private static final String DOT = ".";
    private static final String GIF_EXT = "gif";
    private List itemList;
    private Map familyMap;

    public List getSampleItemList() {
        this.itemList = new ArrayList();
        this.familyMap = new HashMap(5);
        this.readRegistry(PL_TEMPLATESAMPLE);
        return this.itemList;
    }

    private static IPath getLocation(Bundle bundle, IPath relativePath) {
        return TemplateRegistryReader.getLocation(bundle, relativePath, true);
    }

    private static IPath getLocation(Bundle bundle, IPath relativePath, boolean nl) {
        URL url = null;
        IPath defaultSample = new Path(NL_KEY).append(relativePath);
        if (nl) {
            HashMap<String, String> override = new HashMap<String, String>(1);
            String localeString = Locale.getDefault().toString();
            while (localeString.length() > 0) {
                override.put(NL_KEY, localeString);
                url = FileLocator.find((Bundle)bundle, (IPath)defaultSample, override);
                if (url != null) break;
                int i = localeString.lastIndexOf(95);
                localeString = i < 0 ? "" : localeString.substring(0, i);
            }
        }
        if (url == null && (url = FileLocator.find((Bundle)bundle, (IPath)defaultSample.removeFirstSegments(1), null)) == null) {
            return null;
        }
        try {
            url = FileLocator.toFileURL(url);
        }
        catch (IOException iOException) {
            return null;
        }
        return new Path(url.getFile());
    }

    protected void readFileElement(IConfigurationElement element) {
        if (!element.getName().equals(ELE_FILE)) {
            return;
        }
        String id = element.getAttribute(ATT_ID);
        if (id == null) {
            return;
        }
        Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getContributor().getName());
        if (bundle == null) {
            return;
        }
        String path = element.getAttribute(ATT_PATH);
        if (path == null) {
            return;
        }
        IPath samplePath = TemplateRegistryReader.getLocation(bundle, (IPath)new Path(path));
        IPath enSamplePath = TemplateRegistryReader.getLocation(bundle, (IPath)new Path(path), false);
        String imagePath = element.getAttribute(ATT_IMGPATH);
        IPath sampleImgPath = imagePath != null ? TemplateRegistryReader.getLocation(bundle, (IPath)new Path(imagePath)) : null;
        File file = samplePath.toFile();
        if (file == null || !file.isFile()) {
            return;
        }
        String familyId = element.getAttribute("family");
        String fName = file.getName();
        if (TemplateRegistryReader.isValidFileName(fName)) {
            if (sampleImgPath != null && !sampleImgPath.toFile().exists()) {
                sampleImgPath = null;
            }
            TemplateSampleItem item = new TemplateSampleItem(samplePath, enSamplePath, sampleImgPath, null, this.getFamily(familyId));
            this.itemList.add(item);
        }
    }

    protected void readFolderElement(IConfigurationElement element) {
        if (!element.getName().equals(ELE_FOLDER)) {
            return;
        }
        String id = element.getAttribute(ATT_ID);
        if (id == null) {
            return;
        }
        Bundle bundle = Platform.getBundle((String)element.getDeclaringExtension().getContributor().getName());
        if (bundle == null) {
            return;
        }
        String path = element.getAttribute(ATT_PATH);
        if (path == null) {
            return;
        }
        IPath samplePath = TemplateRegistryReader.getLocation(bundle, (IPath)new Path(path));
        IPath enSamplePath = TemplateRegistryReader.getLocation(bundle, (IPath)new Path(path), false);
        String imagePath = element.getAttribute(ATT_IMGPATH);
        IPath sampleImgPath = imagePath != null ? TemplateRegistryReader.getLocation(bundle, (IPath)new Path(imagePath)) : null;
        String familyId = element.getAttribute("family");
        this.readSampleFolder(samplePath, enSamplePath, sampleImgPath, familyId);
    }

    private void readSampleFolder(IPath samplePath, IPath enSamplePath, IPath sampleImagePath, String familyId) {
        if (samplePath == null) {
            return;
        }
        File folder = samplePath.toFile();
        if (folder == null) {
            return;
        }
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            String fName;
            if (files[i].isFile() && TemplateRegistryReader.isValidFileName(fName = files[i].getName())) {
                IPath imgFilePath;
                int pos = fName.lastIndexOf(DOT);
                IPath iPath = imgFilePath = sampleImagePath != null ? sampleImagePath.addTrailingSeparator().append(String.valueOf(fName.substring(0, pos + 1)) + GIF_EXT) : null;
                if (imgFilePath != null && !imgFilePath.toFile().exists()) {
                    imgFilePath = null;
                }
                IPath sampleFilePath = samplePath.addTrailingSeparator().append(fName);
                IPath enSampleFilePath = enSamplePath.addTrailingSeparator().append(fName);
                TemplateSampleItem item = new TemplateSampleItem(sampleFilePath, enSampleFilePath, imgFilePath, null, this.getFamily(familyId));
                this.itemList.add(item);
            }
            ++i;
        }
    }

    protected void readFamilyElement(IConfigurationElement element) {
        String id = element.getAttribute(ATT_ID);
        if (id == null) {
            return;
        }
        String name = element.getAttribute(ATT_NAME);
        if (name == null) {
            return;
        }
        int priority = 65535;
        String sPriority = element.getAttribute(ATT_PRIORITY);
        if (sPriority != null) {
            try {
                priority = Integer.parseInt(sPriority);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.familyMap.put(id, new TemplateSampleFamilyImpl(id, name, priority));
    }

    protected TemplateSampleFamily getFamily(String familyId) {
        TemplateSampleFamily result;
        if (familyId == null || familyId.length() == 0) {
            familyId = "com.ibm.etools.webpage.template.defaultSampleFamily";
        }
        if ((result = (TemplateSampleFamily)this.familyMap.get(familyId)) == null) {
            Logger.log(NLS.bind((String)"Specified sample family '{0}' is undefined.", (Object)familyId));
            result = new TemplateSampleFamilyImpl(familyId, familyId, 65536);
            this.familyMap.put(familyId, result);
        }
        return result;
    }

    private static boolean isValidFileName(String fileName) {
        return fileName != null && (fileName.endsWith(".htpl") || fileName.endsWith(".jtpl"));
    }

    private void readRegistry(String extensionPointId) {
        int j;
        IConfigurationElement[] elements;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(TemplatePlugin.getDefault().getBundle().getSymbolicName(), extensionPointId);
        if (point == null) {
            return;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            elements = extensions[i].getConfigurationElements();
            j = 0;
            while (j < elements.length) {
                if (elements[j].getName().equals("family")) {
                    this.readFamilyElement(elements[j]);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < extensions.length) {
            elements = extensions[i].getConfigurationElements();
            j = 0;
            while (j < elements.length) {
                if (elements[j].getName().equals(ELE_FOLDER)) {
                    this.readFolderElement(elements[j]);
                } else if (elements[j].getName().equals(ELE_FILE)) {
                    this.readFileElement(elements[j]);
                }
                ++j;
            }
            ++i;
        }
        Collections.sort(this.itemList, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                TemplateSampleItem i0 = (TemplateSampleItem)arg0;
                TemplateSampleItem i1 = (TemplateSampleItem)arg1;
                return TemplateRegistryReader.compareToPath(i0.getSampleFileLocation(), i1.getSampleFileLocation());
            }
        });
    }

    private static int compareToPath(IPath a, IPath b) {
        int matchCount = a.matchingFirstSegments(b);
        int comparableCount = Math.min(a.segmentCount(), b.segmentCount());
        int i = matchCount;
        while (i < comparableCount) {
            int c = a.segment(i).compareTo(b.segment(i));
            if (c != 0) {
                return c;
            }
            ++i;
        }
        return a.segmentCount() - b.segmentCount();
    }
}

