/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.sample;

import com.ibm.etools.webedit.common.utils.NodeDataAccessor;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.wst.sse.core.internal.encoding.CodedIO;
import org.eclipse.wst.sse.core.internal.encoding.CommonCharsetNames;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncodingUtil {
    public static final String JSP12_PAGE_ENCODING = "pageEncoding";
    public static final String META_CONTENT_TYPE = "Content-Type";
    private static final String ENCODING_EQUAL = "encoding=";
    private static final String DOUBLEQUOTE = "\"";
    private static final String CHARSET_EQUAL = "charset=";
    private static HashMap map1 = new HashMap();
    private static HashMap map2 = new HashMap();

    static {
        String[] values = CommonCharsetNames.getCommonCharsetNames();
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                String value = values[i];
                String displayName = CommonCharsetNames.getDisplayString((String)value);
                map1.put(value, displayName);
                map2.put(displayName, value);
                ++i;
            }
        }
    }

    public static boolean compareEncoding(String value, String value2) {
        value = CodedIO.getAppropriateJavaCharset((String)value);
        value2 = CodedIO.getAppropriateJavaCharset((String)value2);
        if (value == null && value2 == null) {
            return true;
        }
        if (value != null && value2 != null) {
            return value.equalsIgnoreCase(value2);
        }
        return false;
    }

    public static String getDisplayName(String value) {
        return (String)map1.get(value);
    }

    public static String getValue(String displayName) {
        return (String)map2.get(displayName);
    }

    public static String[] getSupportedEncodings() {
        return CommonCharsetNames.getCommonCharsetNames();
    }

    public static String getMetaCharset(Node node) {
        Attr attr;
        if (EncodingUtil.isMetaContentType(node) && (attr = ((Element)node).getAttributeNode("content")) != null) {
            return EncodingUtil.getMetaCharset(NodeDataAccessor.getAttribute((Attr)attr));
        }
        return null;
    }

    public static String getMetaCharset(String value) {
        return EncodingUtil.parseAttribute(value, CHARSET_EQUAL);
    }

    public static String getJSP11Encoding(Node node) {
        Attr attr;
        if (EncodingUtil.isJSPPageDirective(node) && (attr = ((Element)node).getAttributeNode("contentType")) != null) {
            return EncodingUtil.getJSP11Encoding(NodeDataAccessor.getAttribute((Attr)attr));
        }
        return null;
    }

    public static String getJSP11Encoding(String value) {
        return EncodingUtil.parseAttribute(value, CHARSET_EQUAL);
    }

    public static String getJSP12Encoding(Node node) {
        Attr attr;
        if (EncodingUtil.isJSPPageDirective(node) && (attr = ((Element)node).getAttributeNode(JSP12_PAGE_ENCODING)) != null) {
            return NodeDataAccessor.getAttribute((Attr)attr);
        }
        return null;
    }

    public static String getXmlEncoding(Node node) {
        return node != null ? EncodingUtil.getXmlEncoding(node.getNodeValue()) : null;
    }

    public static String getXmlEncoding(String value) {
        if (value == null) {
            return null;
        }
        return EncodingUtil.trimDoubleQuote(EncodingUtil.parseAttribute(value, ENCODING_EQUAL));
    }

    public static boolean hasMetaCharset(Node node) {
        Attr attr;
        if (EncodingUtil.isMetaContentType(node) && (attr = ((Element)node).getAttributeNode("content")) != null) {
            return EncodingUtil.hasMetaCharset(NodeDataAccessor.getAttribute((Attr)attr));
        }
        return false;
    }

    public static boolean hasMetaCharset(String value) {
        return value != null ? value.toLowerCase(Locale.US).indexOf(CHARSET_EQUAL) != -1 : false;
    }

    public static boolean hasJSP12Encoding(Node node) {
        return EncodingUtil.getJSP12Encoding(node) != null;
    }

    public static boolean hasXmlEncoding(Node node) {
        return node != null && node.getNodeType() == 7 ? EncodingUtil.hasXmlEncoding(node.getNodeValue()) : false;
    }

    public static boolean hasXmlEncoding(String value) {
        return value != null ? value.toLowerCase(Locale.US).indexOf(ENCODING_EQUAL) != -1 : false;
    }

    public static boolean isJSPPageDirective(Node node) {
        return node != null && node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("jsp:directive.page");
    }

    public static boolean isMetaContentType(Node node) {
        Attr attr;
        return node != null && node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("META") && (attr = ((Element)node).getAttributeNode("http-equiv")) != null && NodeDataAccessor.getAttribute((Attr)attr) != null && NodeDataAccessor.getAttribute((Attr)attr).equalsIgnoreCase(META_CONTENT_TYPE);
    }

    private static String parseAttribute(String value, String name) {
        String lowname;
        String lowValue;
        int index;
        if (value != null && (index = (lowValue = value.toLowerCase(Locale.US)).indexOf(lowname = name.toLowerCase(Locale.US))) != -1) {
            int quote_index;
            String ret = value.substring(index + name.length());
            if (ret != null && (quote_index = ret.indexOf(DOUBLEQUOTE)) == 0 && (quote_index = ret.indexOf(DOUBLEQUOTE, 1)) != -1) {
                ret = ret.substring(1, quote_index);
            }
            return ret;
        }
        return null;
    }

    public static String replaceXMLEncoding(String content, String encoding) {
        if (content != null) {
            String curCharset;
            String preCharset;
            int index;
            String orgEncoding = EncodingUtil.getXmlEncoding(content);
            if (orgEncoding != null && orgEncoding.length() > 0 && (index = content.indexOf(orgEncoding)) != -1) {
                return String.valueOf(content.substring(0, index)) + encoding + content.substring(index + orgEncoding.length());
            }
            String lowContent = content.toLowerCase(Locale.US);
            int index2 = lowContent.indexOf(ENCODING_EQUAL);
            if (index2 != -1) {
                preCharset = content.substring(0, index2);
                curCharset = content.substring(index2 + ENCODING_EQUAL.length());
            } else {
                preCharset = content;
                curCharset = null;
            }
            String newContent = null;
            if (curCharset == null) {
                if (encoding != null) {
                    newContent = String.valueOf(content) + " " + ENCODING_EQUAL + DOUBLEQUOTE + encoding + DOUBLEQUOTE;
                }
            } else if (!curCharset.equalsIgnoreCase(encoding)) {
                int semicolon;
                newContent = encoding != null ? String.valueOf(preCharset) + ENCODING_EQUAL + DOUBLEQUOTE + encoding + DOUBLEQUOTE : ((semicolon = preCharset.lastIndexOf(" ")) != -1 ? preCharset.substring(0, semicolon) : preCharset);
            }
            return newContent;
        }
        if (encoding != null) {
            return "encoding=\"" + encoding + DOUBLEQUOTE;
        }
        return null;
    }

    public static String replaceCharset(String content, String encoding) {
        if (content != null) {
            String curCharset;
            String preCharset;
            String lowContent = content.toLowerCase(Locale.US);
            int index = lowContent.indexOf(CHARSET_EQUAL);
            if (index != -1) {
                preCharset = content.substring(0, index);
                curCharset = content.substring(index + CHARSET_EQUAL.length());
            } else {
                preCharset = content;
                curCharset = null;
            }
            String newContent = content;
            if (curCharset == null) {
                if (encoding != null) {
                    newContent = content.trim().length() > 0 ? String.valueOf(content) + "; " + CHARSET_EQUAL + encoding : CHARSET_EQUAL + encoding;
                }
            } else if (!curCharset.equalsIgnoreCase(encoding)) {
                int semicolon;
                newContent = encoding != null ? String.valueOf(preCharset) + CHARSET_EQUAL + encoding : ((semicolon = preCharset.lastIndexOf(";")) != -1 ? preCharset.substring(0, semicolon) : preCharset);
            }
            return newContent;
        }
        if (encoding != null) {
            return CHARSET_EQUAL + encoding;
        }
        return null;
    }

    public static String trimDoubleQuote(String value) {
        if (value != null) {
            char[] p = value.toCharArray();
            int begin = -1;
            int i = 0;
            while (i < value.length()) {
                if (!Character.isWhitespace(p[i]) && p[i] == '\"') {
                    begin = i + 1;
                    break;
                }
                ++i;
            }
            int end = -1;
            int i2 = value.length() - 1;
            while (i2 > begin) {
                if (!Character.isWhitespace(p[i2]) && p[i2] == '\"') {
                    end = i2;
                    break;
                }
                --i2;
            }
            if (begin < end) {
                return value.substring(begin, end);
            }
            if (begin > 0) {
                return value.substring(begin);
            }
            return value;
        }
        return null;
    }
}

