/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.model.comment;

import com.ibm.etools.webpage.template.internal.model.TplNodeImpl;
import com.ibm.etools.webpage.template.internal.model.comment.CommentTagInfo;
import com.ibm.etools.webpage.template.internal.model.comment.FlatNodeCommentUtil;
import com.ibm.etools.webpage.template.internal.model.comment.TplCmGet;
import com.ibm.etools.webpage.template.internal.model.comment.TplCmInclusion;
import com.ibm.etools.webpage.template.internal.model.comment.TplCmMetadata;
import com.ibm.etools.webpage.template.internal.model.comment.TplCmOperator;
import com.ibm.etools.webpage.template.internal.model.comment.TplCmPut;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TplNode;
import com.ibm.etools.webpage.template.model.TplNodeFactoryContributor;
import com.ibm.etools.webpage.template.model.TplNodeList;
import com.ibm.etools.webpage.template.model.TplOperator;
import com.ibm.etools.webpage.template.model.TplRange;
import com.ibm.etools.webpage.template.model.TplRefNode;
import com.ibm.etools.webpage.template.model.TplRoot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public class TplCmNodeFactoryContributor
implements TplNodeFactoryContributor {
    public static final String BASETYPE = "CommentElement";

    @Override
    public boolean isApplicable(TplNode parent) {
        if (parent == null) {
            return false;
        }
        if ((((TplNodeImpl)parent).getRawNodeType() & 9) != 0) {
            return true;
        }
        if ((((TplNodeImpl)parent).getRawNodeType() & 0x74) != 0) {
            return false;
        }
        return parent.getTemplateBaseType() == BASETYPE;
    }

    @Override
    public TplNodeList createNodes(TplRange range, boolean asTemplateChild, TemplateModel model) {
        TplNode child;
        List<String> TARGET_TAGS;
        IStructuredDocumentRegion initialNode = range.getStartNode();
        IStructuredDocumentRegion endNode = range.getEndNode() == null ? null : range.getEndNode().getNext();
        ArrayList<TplNode> nodes = new ArrayList<TplNode>();
        Stack<CommentTagInfo> nodeStack = new Stack<CommentTagInfo>();
        if (!asTemplateChild) {
            TARGET_TAGS = Arrays.asList("tpl:insert", "tpl:put", "tpl:metadata", "tpl:operator");
            ArrayList<TplNode> operatorContext = new ArrayList<TplNode>(3);
            IStructuredDocumentRegion node = initialNode;
            while (node != null && node != endNode) {
                if (FlatNodeCommentUtil.isTplComment(node)) {
                    TplNode child2;
                    CommentTagInfo startInfo = null;
                    CommentTagInfo info = new CommentTagInfo(node);
                    if (TARGET_TAGS.contains(info.getTagName())) {
                        if (info.isStart()) {
                            nodeStack.push(info);
                        } else {
                            CommentTagInfo start = this.popToValidStartTag(info, nodeStack, asTemplateChild);
                            int nInsert = this.countTagInStack(nodeStack, "tpl:insert");
                            if (nInsert == 0) {
                                startInfo = start;
                            }
                        }
                    }
                    if (startInfo != null && (child2 = this.createNode(startInfo, info, model)) != null) {
                        String attrValue;
                        String tagName = startInfo.getTagName();
                        if ("tpl:operator".equals(tagName)) {
                            operatorContext.add(child2);
                        } else if ("tpl:insert".equals(tagName) && (attrValue = startInfo.getAttrValue("page")) != null && attrValue.length() > 0 && child2 instanceof TplCmInclusion) {
                            ((TplCmInclusion)child2).setOperator(operatorContext.toArray(new TplOperator[operatorContext.size()]));
                            operatorContext.clear();
                        }
                        nodes.add(child2);
                    }
                }
                node = node.getNext();
            }
        } else {
            TARGET_TAGS = Arrays.asList("tpl:insert", "tpl:put");
            IStructuredDocumentRegion node = initialNode;
            while (node != null && node != endNode) {
                if (FlatNodeCommentUtil.isTplComment(node)) {
                    TplNode child3;
                    CommentTagInfo startInfo = null;
                    CommentTagInfo info = new CommentTagInfo(node);
                    if (TARGET_TAGS.contains(info.getTagName())) {
                        if (info.isStart()) {
                            nodeStack.push(info);
                        } else {
                            int nPut;
                            CommentTagInfo start = this.popToValidStartTag(info, nodeStack, asTemplateChild);
                            int nInsert = this.countTagInStack(nodeStack, "tpl:insert");
                            if (nInsert == (nPut = this.countTagInStack(nodeStack, "tpl:put"))) {
                                startInfo = start;
                            }
                        }
                    }
                    if (startInfo != null && "tpl:put".equals(startInfo.getTagName()) && (child3 = this.createNode(startInfo, info, model)) != null) {
                        nodes.add(child3);
                    }
                }
                node = node.getNext();
            }
        }
        CommentTagInfo lastStart = null;
        while (!nodeStack.isEmpty()) {
            lastStart = (CommentTagInfo)nodeStack.pop();
        }
        if (lastStart != null && (!asTemplateChild || "tpl:put".equals(lastStart.getTagName())) && (child = this.createNode(lastStart, null, model)) != null) {
            nodes.add(child);
        }
        return new myTplNodeList(nodes);
    }

    private int countTagInStack(List nodeStack, String tagName) {
        int result = 0;
        int i = nodeStack.size() - 1;
        while (i >= 0) {
            if (tagName.equals(((CommentTagInfo)nodeStack.get(i)).getTagName())) {
                ++result;
            }
            --i;
        }
        return result;
    }

    private boolean isValidEndTag(CommentTagInfo endTagInfo, List nodeStack, boolean asTemplateChild) {
        int i = nodeStack.size() - 1;
        while (i >= 0) {
            if (((CommentTagInfo)nodeStack.get(i)).getTagName().equals(endTagInfo.getTagName())) {
                return true;
            }
            --i;
        }
        return false;
    }

    private CommentTagInfo popToValidStartTag(CommentTagInfo endTagInfo, Stack nodeStack, boolean asTemplateChild) {
        if (!this.isValidEndTag(endTagInfo, nodeStack, asTemplateChild)) {
            return null;
        }
        CommentTagInfo startInfo = null;
        while (!nodeStack.isEmpty()) {
            startInfo = (CommentTagInfo)nodeStack.pop();
            if (startInfo.getTagName().equals(endTagInfo.getTagName())) break;
            startInfo = null;
        }
        return startInfo;
    }

    TplNode createNode(CommentTagInfo startInfo, CommentTagInfo endInfo, TemplateModel model) {
        TplRefNode refNode = new TplRefNode(startInfo.getFlatNode(), endInfo != null ? endInfo.getFlatNode() : null, model);
        CommentTagInfo[] infos = new CommentTagInfo[]{startInfo, endInfo};
        String tagName = startInfo.getTagName();
        if (tagName.equals("tpl:put")) {
            return new TplCmPut(refNode, infos);
        }
        if (tagName.equals("tpl:insert")) {
            String attr = startInfo.getAttrValue("attribute");
            if (attr != null && attr.length() > 0) {
                return new TplCmGet(refNode, infos);
            }
            return new TplCmInclusion(refNode, infos);
        }
        if (tagName.equals("tpl:metadata")) {
            return new TplCmMetadata(refNode, infos);
        }
        if (tagName.equals("tpl:operator")) {
            return new TplCmOperator(refNode, infos);
        }
        return null;
    }

    @Override
    public String getRawTextFilter() {
        return "tpl:";
    }

    @Override
    public TplRoot createRoot(TemplateModel model) {
        return null;
    }

    @Override
    public String getRootXmlDeclaration(TemplateModel model) {
        return null;
    }

    class myTplNodeList
    implements TplNodeList {
        private List nodes;

        public myTplNodeList(List list) {
            this.nodes = list;
        }

        @Override
        public int getLength() {
            return this.nodes.size();
        }

        @Override
        public TplNode item(int index) throws IndexOutOfBoundsException {
            return (TplNode)this.nodes.get(index);
        }
    }
}

