/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.model.comment;

import com.ibm.etools.webpage.template.FileTypeHandler;
import com.ibm.etools.webpage.template.TemplatePlugin;
import com.ibm.etools.webpage.template.internal.model.TplInclusionImpl;
import com.ibm.etools.webpage.template.internal.model.comment.CommentTagInfo;
import com.ibm.etools.webpage.template.internal.model.comment.TplCmGet;
import com.ibm.etools.webpage.template.internal.model.comment.TplCmPut;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateTaskReporter;
import com.ibm.etools.webpage.template.model.TplException;
import com.ibm.etools.webpage.template.model.TplGet;
import com.ibm.etools.webpage.template.model.TplNode;
import com.ibm.etools.webpage.template.model.TplNodeList;
import com.ibm.etools.webpage.template.model.TplOperator;
import com.ibm.etools.webpage.template.model.TplPut;
import com.ibm.etools.webpage.template.model.TplRange;
import com.ibm.etools.webpage.template.model.TplRefNode;
import com.ibm.etools.webpage.template.model.TplReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class TplCmInclusion
extends TplInclusionImpl {
    private CommentTagInfo[] tagInfos;
    private String reference;
    private TplOperator[] operators;

    public TplCmInclusion(TplRefNode refNode) {
        super(refNode);
    }

    public TplCmInclusion(TplRefNode refNode, CommentTagInfo[] tagInfos) {
        super(refNode);
        this.tagInfos = tagInfos;
    }

    @Override
    public String getReference() {
        if (this.reference == null) {
            this.reference = this.getCommentTagInfo(true).getAttrValue("page");
        }
        return this.reference;
    }

    @Override
    public void setReference(String ref) throws TplException {
        if (ref != null) {
            CommentTagInfo.Region reg = this.getCommentTagInfo(true).getAttrValueRegion("page");
            if (reg == null) {
                throw new TplException(2, "");
            }
            this.getModel().getFlatModel().replaceText(this.getModificationRequester(), reg.start + this.getCommentTagInfo(true).getFlatNode().getStartOffset(), reg.offset, ref);
            this.reference = null;
            this.tagInfos[0] = new CommentTagInfo(this.tagInfos[0].getFlatNode());
        }
    }

    @Override
    public String getTemplateBaseType() {
        return "CommentElement";
    }

    protected CommentTagInfo getCommentTagInfo(boolean start) {
        if (this.tagInfos == null && this.tagInfos.length < 2) {
            this.tagInfos = new CommentTagInfo[2];
            this.tagInfos[0] = new CommentTagInfo(this.getRefNode().getStartNode());
            this.tagInfos[1] = new CommentTagInfo(this.getRefNode().getEndNode());
        }
        return this.tagInfos[start ? 0 : 1];
    }

    @Override
    public boolean rebuildContent(TemplateTaskReporter report, boolean reportOnly) {
        TplPut putNode;
        boolean modified = false;
        IPath refLocation = this.getReferedFileLocation();
        if (refLocation == null) {
            CommentTagInfo.Region reg = this.getCommentTagInfo(true).getAttrValueRegion("page");
            this.reportTask(report, "BrokenLink", this.getCommentTagInfo(true).getFlatNode().getStart() + (reg != null ? reg.start : 0), reg != null ? reg.offset : this.getCommentTagInfo(true).getFlatNode().getLength());
            return modified;
        }
        String orgType = FileTypeHandler.getFileType(this.getModel().getLocation());
        String refType = FileTypeHandler.getFileType(refLocation.toString());
        if (refType == null) {
            CommentTagInfo.Region reg = this.getCommentTagInfo(true).getAttrValueRegion("page");
            this.reportTask(report, "InvalidReference", this.getCommentTagInfo(true).getFlatNode().getStart() + (reg != null ? reg.start : 0), reg != null ? reg.offset : this.getCommentTagInfo(true).getFlatNode().getLength());
            return modified;
        }
        if (("html".equals(orgType) || "htpl".equals(orgType)) && ("jsp".equals(refType) || "jtpl".equals(refType))) {
            CommentTagInfo.Region reg = this.getCommentTagInfo(true).getAttrValueRegion("page");
            this.reportTask(report, "InvalidReference", this.getCommentTagInfo(true).getFlatNode().getStart() + (reg != null ? reg.start : 0), reg != null ? reg.offset : this.getCommentTagInfo(true).getFlatNode().getLength());
            return modified;
        }
        TemplateModel refModel = this.getReferedModel();
        if (refModel == null) {
            CommentTagInfo.Region reg = this.getCommentTagInfo(true).getAttrValueRegion("page");
            this.reportTask(report, "BrokenLink", this.getCommentTagInfo(true).getFlatNode().getStart() + (reg != null ? reg.start : 0), reg != null ? reg.offset : this.getCommentTagInfo(true).getFlatNode().getLength());
            return modified;
        }
        if (this.getRefNode().getEndNode() == null) {
            this.reportTask(report, "SyntaxError", this.getRefNode().getStartNode().getStartOffset(), this.getRefNode().getStartNode().getLength());
            return modified;
        }
        TplNodeList putList = this.getPutList();
        int i = 0;
        while (i < putList.getLength()) {
            putNode = (TplPut)this.getPutList().item(i);
            if (putNode.getRefNode().getEndNode() == null) {
                this.reportTask(report, "SyntaxError", putNode.getRefNode().getStartNode().getStartOffset(), putNode.getRefNode().getStartNode().getLength());
                return modified;
            }
            ++i;
        }
        if (this.getNodeType() == 2 && !refModel.isTemplate()) {
            i = 0;
            while (i < putList.getLength()) {
                putNode = (TplPut)this.getPutList().item(i);
                this.reportTask(report, "GetPutMismatch", putNode.getRefNode().getStartNode().getStartOffset(), putNode.getRefNode().getStartNode().getLength());
                ++i;
            }
            return modified;
        }
        TplNodeList getList = TplCmInclusion.getGetListIn(refModel);
        boolean valid = true;
        int i2 = 0;
        while (i2 < putList.getLength()) {
            TplPut putNode2 = (TplPut)this.getPutList().item(i2);
            String name = putNode2.getName().trim();
            boolean found = false;
            int j = 0;
            while (j < getList.getLength()) {
                if (name.equals(((TplGet)getList.item(j)).getName().trim())) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                this.reportTask(report, "GetPutMismatch", putNode2.getRefNode().getStartNode().getStartOffset(), putNode2.getRefNode().getStartNode().getLength());
                valid = false;
            }
            ++i2;
        }
        if (!valid) {
            return modified;
        }
        if (!(reportOnly || report != null && report.getLength() > 0)) {
            short commentType = this.getCommentConvType();
            try {
                StringBuffer buf = new StringBuffer();
                TplRange last = refModel.getRoot().getRefNode().toRange().getLeftEndRange();
                TplNodeList gmList = TplCmInclusion.getGetAndMetadataAndPutListIn(refModel);
                int i3 = 0;
                while (i3 < gmList.getLength()) {
                    TplNode node = gmList.item(i3);
                    TplRange start = node.getRefNode().toRange();
                    if (last.isBeforePrevious(start)) {
                        buf.append(this.getOperatedTextFor(last.getRangeTo(start)));
                    }
                    if (node.getNodeType() == 4) {
                        TplGet getNode = (TplGet)gmList.item(i3);
                        TplPut putNode3 = TplCmInclusion.findPutIn(putList, getNode.getName());
                        if (putNode3 != null) {
                            buf.append(((TplCmPut)putNode3).getCommentTagInfo(true).generatePutSource(commentType));
                            buf.append(putNode3.getContent().getText());
                            buf.append(((TplCmPut)putNode3).getCommentTagInfo(false).generatePutSource(commentType));
                        } else {
                            buf.append(((TplCmGet)getNode).getCommentTagInfo(true).generatePutSource(commentType));
                            buf.append(getNode.getContent().getText());
                            buf.append(((TplCmGet)getNode).getCommentTagInfo(false).generatePutSource(commentType));
                        }
                    } else if (node.getNodeType() != 32 && node.getNodeType() != 64 && node.getNodeType() == 8) {
                        buf.append(node.getContent().getText());
                    }
                    last = start;
                    ++i3;
                }
                TplRange length = refModel.getRoot().getRefNode().toRange().getRightEndRange();
                if (last.isBeforePrevious(length)) {
                    buf.append(this.getOperatedTextFor(last.getRangeTo(length)));
                }
                if (!this.getContent().getText().equals(buf.toString())) {
                    modified |= this.setContent(buf.toString());
                }
            }
            catch (TplException tplException) {
                this.reportTask(report, "UnexpectedError", this.getRefNode().getStartNode().getStart(), this.getRefNode().getStartNode().getLength());
                return modified;
            }
        }
        TplNodeList list = this.getPutList();
        int i4 = list.getLength() - 1;
        while (i4 >= 0) {
            boolean b = list.item(i4).rebuildContent(report, reportOnly || report != null && report.getLength() > 0);
            modified |= b;
            --i4;
        }
        return modified;
    }

    protected String getOperatedTextFor(TplRange range) {
        TplOperator[] operators = this.operators;
        if (operators == null || operators.length == 0) {
            return range.getText();
        }
        if (operators.length == 0) {
            return range.getText();
        }
        StringBuffer result = new StringBuffer();
        IStructuredDocumentRegion region = range.getStartNode();
        IStructuredDocumentRegion endRegion = range.getEndNode().getNext();
        while (region != endRegion) {
            String regionType = region.getType();
            String text = region.getText();
            if ("JSP_ROOT_TAG_NAME" == regionType) {
                ITextRegionList texts;
                StringBuffer jsprootInsertionText = new StringBuffer();
                HashMap attr = this.validateJSPRootOperatorBuildAttrMap(region);
                int i = 0;
                while (i < operators.length) {
                    TplOperator op = operators[i];
                    if ("jsproot".equals(op.getType()) && this.validateJSPRootOperator(op, attr)) {
                        String name = op.getAttr("name");
                        String value = op.getAttr("value");
                        boolean valueHasQuote = value.indexOf(39) != -1;
                        boolean valueHasDQuote = value.indexOf(34) != -1;
                        char quote = !valueHasDQuote || valueHasQuote ? (char)'\"' : '\'';
                        jsprootInsertionText.append(' ').append(name).append('=');
                        jsprootInsertionText.append(quote).append(value).append(quote);
                    }
                    ++i;
                }
                if (jsprootInsertionText.length() > 0 && (texts = region.getRegions()).size() >= 1 && "XML_TAG_OPEN" == texts.get(0).getType()) {
                    text = String.valueOf(text.substring(0, texts.get(texts.size() - 1).getStart())) + jsprootInsertionText + region.getText(texts.get(texts.size() - 1));
                }
            }
            result.append(text);
            region = region.getNext();
        }
        return result.toString();
    }

    public void setOperator(TplOperator[] operators) {
        this.operators = operators;
    }

    private boolean validateJSPRootOperator(TplOperator op, Map attrMap) {
        if ("jsproot".equals(op.getType())) {
            String name = op.getAttr("name");
            String value = op.getAttr("value");
            if (attrMap.containsKey(name) && !attrMap.get(name).equals(value)) {
                return false;
            }
        }
        return true;
    }

    private HashMap validateJSPRootOperatorBuildAttrMap(IStructuredDocumentRegion region) {
        HashMap<String, String> result = new HashMap<String, String>(3);
        String name = null;
        String value = null;
        ITextRegionList texts = region.getRegions();
        int i = 0;
        while (i < texts.size()) {
            ITextRegion r = texts.get(i);
            if (r.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                name = region.getText(r);
            } else if (r.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                value = region.getText(r);
            }
            if (name != null && value != null) {
                result.put(name, value);
                value = null;
                name = null;
            }
            ++i;
        }
        return result;
    }

    private short getCommentConvType() {
        String location;
        String fType;
        if (TemplatePlugin.getDefault().getJSPCommentPreference() && ("jsp".equals(fType = FileTypeHandler.getFileType(location = this.getModel().getLocation())) || "jtpl".equals(fType))) {
            return TplCmInclusion.findJSPRoot(this.getModel());
        }
        return 1;
    }

    private static short findJSPRoot(TemplateModel model) {
        if (model == null) {
            return 0;
        }
        TplNodeList children = model.getRoot().getContentNodeList();
        ArrayList<TplNode> inclusions = new ArrayList<TplNode>();
        if (children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                if ((children.item(i).getNodeType() & 0x12) != 0) {
                    inclusions.add(children.item(i));
                }
                ++i;
            }
        }
        IStructuredDocumentRegion node = model.getFlatModel().getFirstStructuredDocumentRegion();
        TplNode recursiveNode = inclusions.size() > 0 ? inclusions.get(0) : null;
        while (node != null) {
            if (node.getType().equals("JSP_ROOT_TAG_NAME")) {
                return 1;
            }
            if (node.getType().equals("XML_TAG_NAME")) {
                return 2;
            }
            if (recursiveNode != null && node.equals(recursiveNode.getRefNode().getStartNode())) {
                short ret = TplCmInclusion.findJSPRoot(((TplReference)((Object)recursiveNode)).getReferedModel());
                if (ret != 0) {
                    return ret;
                }
                inclusions.remove(recursiveNode);
                recursiveNode = inclusions.size() > 0 ? inclusions.get(0) : null;
            }
            node = node.getNext();
        }
        return 0;
    }
}

