/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.model.comment;

import com.ibm.etools.webpage.template.PageTemplateCommentConstants;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jst.jsp.core.internal.regions.DOMJSPRegionContexts;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.commentelement.util.TagScanner;

public class FlatNodeCommentUtil
implements DOMJSPRegionContexts,
PageTemplateCommentConstants {
    public static final String SLASH = "/";

    public static boolean isTplComment(IStructuredDocumentRegion flatNode) {
        if (flatNode == null) {
            return false;
        }
        String regionType = FlatNodeCommentUtil.getFirstRegionType(flatNode);
        if (regionType == "XML_COMMENT_OPEN" || regionType == "JSP_COMMENT_OPEN") {
            ITextRegionList regions = flatNode.getRegions();
            String data = null;
            for (ITextRegion region : regions) {
                regionType = region.getType();
                if (regionType != "XML_COMMENT_TEXT" && regionType != "JSP_COMMENT_TEXT" || data != null) continue;
                data = flatNode.getText(region);
            }
            if (data != null) {
                boolean start = !(data = data.trim()).startsWith(SLASH);
                return data.startsWith("tpl:", start ? 0 : 1);
            }
        }
        return false;
    }

    public static String getCommentData(IStructuredDocumentRegion flatNode) {
        if (flatNode == null) {
            return null;
        }
        String data = null;
        String regionType = FlatNodeCommentUtil.getFirstRegionType(flatNode);
        if (regionType == "XML_COMMENT_OPEN" || regionType == "JSP_COMMENT_OPEN") {
            ITextRegionList regions = flatNode.getRegions();
            for (ITextRegion region : regions) {
                regionType = region.getType();
                if (regionType != "XML_COMMENT_TEXT" && regionType != "JSP_COMMENT_TEXT" || data != null) continue;
                data = flatNode.getText(region);
            }
            if (data != null) {
                data = data.trim();
            }
        }
        return data;
    }

    public static String getAttrValue(String commentData, String attrName) {
        String name;
        TagScanner scanner = new TagScanner(commentData, 0);
        String value = "";
        while ((name = scanner.nextName()) != null) {
            if (!name.equals(attrName)) continue;
            value = scanner.nextValue();
            break;
        }
        return value;
    }

    public static int getAttrValueOffset(String commentData, String attrName) {
        String name;
        TagScanner scanner = new TagScanner(commentData, 0);
        while ((name = scanner.nextName()) != null) {
            if (!name.equals(attrName)) continue;
            return scanner.getNextOffset();
        }
        return -1;
    }

    public static int getAttrOffset(String commentData, String attrName) {
        String name;
        TagScanner scanner = new TagScanner(commentData, 0);
        while ((name = scanner.nextName()) != null) {
            if (!name.equals(attrName)) continue;
            return scanner.getOffset();
        }
        return -1;
    }

    public static String getTagName(String commentData) {
        TagScanner scanner = new TagScanner(commentData, 0);
        return scanner.nextName();
    }

    public static Map getAttrMap(String commentData) {
        String name;
        TreeMap<String, String> result = new TreeMap<String, String>();
        TagScanner scanner = new TagScanner(commentData, 0);
        while ((name = scanner.nextName()) != null) {
            result.put(name, scanner.nextValue());
        }
        return result;
    }

    static String getFirstRegionType(IStructuredDocumentRegion flatNode) {
        if (flatNode == null) {
            return "UNDEFINED";
        }
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null || regions.size() == 0) {
            return "UNDEFINED";
        }
        ITextRegion region = regions.get(0);
        return region.getType();
    }
}

