/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.model;

import com.ibm.etools.webpage.template.internal.model.TemplateModelImpl;
import com.ibm.etools.webpage.template.internal.model.TplNodeImpl;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateTaskReporter;
import com.ibm.etools.webpage.template.model.TplException;
import com.ibm.etools.webpage.template.model.TplNodeList;
import com.ibm.etools.webpage.template.model.TplRange;
import com.ibm.etools.webpage.template.model.TplRefNode;
import com.ibm.etools.webpage.template.model.TplRoot;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public class TplRootImpl
extends TplNodeImpl
implements TplRoot {
    private final TemplateModel model;

    protected TplRootImpl(TplRefNode refNode, TemplateModel model) {
        super(refNode);
        this.model = model;
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public TplRange getContent() {
        if (this.contentRange == null) {
            IStructuredDocumentRegion start = this.getRefNode().getStartNode();
            IStructuredDocumentRegion end = this.getRefNode().getEndNode();
            this.contentRange = start != null && end != null ? new TplRange(this.getModel().getFlatModel(), start, end) : new TplRange(this.getModel().getFlatModel(), 0);
        }
        return this.contentRange;
    }

    @Override
    public TplNodeList getContentNodeList() {
        if (this.children == null) {
            ((TemplateModelImpl)this.getModel()).getNodeFactory().parseAndCreateChidren(this);
        }
        return this;
    }

    @Override
    public void updateContent() {
        this.contentRange = null;
        this.children.clear();
        this.children = null;
    }

    @Override
    public TemplateModel getModel() {
        return this.model;
    }

    @Override
    public void setContent(String content) throws TplException {
        TplRange range = this.getContent();
        if (!range.isValid()) {
            throw new TplException(1, "Invalid content");
        }
        int start = 0;
        int length = 0;
        if (range.getStartNode() != null) {
            start = range.getStartNode().getStartOffset();
            length = range.getEndNode().getEndOffset() - start;
        } else if (this.getRefNode().getStartNode() != null) {
            start = range.getPosition();
        }
        this.getModel().getFlatModel().replaceText(this.getModificationRequester(), start, length, content);
        this.updateContent();
    }

    @Override
    public String getTemplateBaseType() {
        return "neutral";
    }

    @Override
    public boolean rebuildContent(TemplateTaskReporter report, boolean reportOnly) {
        TplNodeList list = this.getContentNodeList();
        boolean modified = false;
        int i = list.getLength() - 1;
        while (i >= 0) {
            boolean b = list.item(i).rebuildContent(report, reportOnly || report != null && report.getLength() > 0);
            modified |= b;
            --i;
        }
        return modified;
    }
}

