/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.model;

import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateTaskReporter;
import com.ibm.etools.webpage.template.model.TplNode;
import com.ibm.etools.webpage.template.model.TplNodeList;
import com.ibm.etools.webpage.template.model.TplRange;
import com.ibm.etools.webpage.template.model.TplRefNode;
import com.ibm.etools.webpage.template.model.TplRoot;
import com.ibm.etools.webpage.template.model.TplTask;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public abstract class TplNodeImpl
implements TplNode,
TplNodeList {
    private TplNode parent;
    List children;
    TplRange contentRange;
    private TplRefNode refNode;

    protected TplNodeImpl(TplRefNode refNode) {
        this.refNode = refNode;
    }

    @Override
    public TplRange getContent() {
        if (this.contentRange == null) {
            IStructuredDocumentRegion start = this.getRefNode().getStartNode();
            IStructuredDocumentRegion end = this.getRefNode().getEndNode();
            if (start != null && end == null) {
                TplNode tplNode = this;
                while (tplNode != null) {
                    end = tplNode.getRefNode().getEndNode();
                    if (end != null) break;
                    tplNode = tplNode.getParent();
                }
            }
            this.contentRange = start == end ? new TplRange(start.getParentDocument(), null, null) : (start.getNext() == end ? new TplRange(start.getParentDocument(), start.getEndOffset()) : new TplRange(start.getParentDocument(), start.getNext(), end.getPrevious()));
        }
        return this.contentRange;
    }

    @Override
    public TplNode getParent() {
        return this.parent;
    }

    @Override
    public TemplateModel getModel() {
        return this.getRoot().getModel();
    }

    @Override
    public TplRefNode getRefNode() {
        return this.refNode;
    }

    protected void setRefNode(TplRefNode refNode) {
        this.refNode = refNode;
    }

    public TplRoot getRoot() {
        TplNode node = this;
        while (node != null && node.getRawNodeType() != 1) {
            node = node.getParent();
        }
        return (TplRoot)node;
    }

    void setParent(TplNode parent) {
        this.parent = parent;
    }

    List getChildren() {
        if (this.children == null) {
            this.children = new LinkedList();
        }
        return this.children;
    }

    @Override
    public int getLength() {
        return this.children != null ? this.children.size() : 0;
    }

    @Override
    public TplNode item(int index) throws IndexOutOfBoundsException {
        return this.children != null ? (TplNode)this.children.get(index) : null;
    }

    public short getRawNodeType() {
        return this.getNodeType();
    }

    protected void reportTask(TemplateTaskReporter report, String type, int start, int length) {
        if (report != null) {
            int line = this.getModel().getFlatModel().getLineOfOffset(start);
            int end = start + length;
            TplTask task = new TplTask(type, start, end, line);
            report.add(task);
        }
    }

    protected Object getModificationRequester() {
        if (this.getModel().getStructuredModel() != null) {
            return this.getModel().getStructuredModel();
        }
        if (this.getModel().getFlatModel() != null) {
            return this.getModel().getFlatModel();
        }
        return this.getModel();
    }
}

