/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.model;

import com.ibm.etools.webpage.template.internal.model.TplDefaultNodeFactoryContributor;
import com.ibm.etools.webpage.template.internal.model.TplNodeImpl;
import com.ibm.etools.webpage.template.internal.model.comment.TplCmNodeFactoryContributor;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TplNode;
import com.ibm.etools.webpage.template.model.TplNodeFactoryContributor;
import com.ibm.etools.webpage.template.model.TplNodeList;
import com.ibm.etools.webpage.template.model.TplRange;
import com.ibm.etools.webpage.template.model.TplRoot;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public class TplNodeFactory {
    private static List contributors;
    private static String[] rawTextNodeFilter;
    private static TplNodeFactory instance;

    static TplNodeFactory getInstance() {
        if (instance == null) {
            instance = new TplNodeFactory();
        }
        return instance;
    }

    private TplNodeFactory() {
    }

    static List getContributors() {
        if (contributors == null) {
            contributors = new ArrayList();
            contributors.add(new TplCmNodeFactoryContributor());
            contributors.add(new TplDefaultNodeFactoryContributor());
        }
        return contributors;
    }

    void parseAndCreateChidren(TplNode parent) {
        if (parent == null || (((TplNodeImpl)parent).getRawNodeType() & 0xB) == 0) {
            return;
        }
        List contributors = TplNodeFactory.getContributors();
        LinkedList<TplRange> regions = new LinkedList<TplRange>();
        LinkedList children = new LinkedList();
        regions.add(parent.getContent());
        int visitPutOnly = 0;
        while (!regions.isEmpty()) {
            TplRange currentRange = (TplRange)regions.get(0);
            regions.remove(0);
            TplNodeList list = null;
            int counter = 0;
            while (counter < contributors.size()) {
                TplNodeFactoryContributor contr = (TplNodeFactoryContributor)contributors.get(counter);
                if (contr.isApplicable(parent)) {
                    boolean putOnly;
                    boolean bl = putOnly = ((TplNodeImpl)parent).getRawNodeType() == 2;
                    if (putOnly) {
                        ++visitPutOnly;
                    }
                    if (putOnly && visitPutOnly != 1) break;
                    list = contr.createNodes(currentRange, putOnly, parent.getModel());
                    break;
                }
                ++counter;
            }
            if (list == null || list.getLength() <= 0) continue;
            IStructuredDocumentRegion start = currentRange.getStartNode();
            int regionIndex = 0;
            int i = 0;
            while (i < list.getLength()) {
                TplNode node = list.item(i);
                if (start != node.getRefNode().getStartNode()) {
                    regions.add(regionIndex++, new TplRange(currentRange.getModel(), start, node.getRefNode().getStartNode().getPrevious()));
                }
                if (node.getRefNode().getEndNode() == null) break;
                start = node.getRefNode().getEndNode().getNext();
                ++i;
            }
            ListIterator<TplNode> it = children.listIterator();
            while (it.hasNext()) {
                TplNode base = (TplNode)it.next();
                if (base.getRefNode().getStartNode().getStartOffset() <= list.item(0).getRefNode().getStartNode().getStartOffset()) continue;
                it.previous();
                break;
            }
            int j = 0;
            while (j < list.getLength()) {
                it.add(list.item(j));
                ++j;
            }
        }
        List actualChildren = ((TplNodeImpl)parent).getChildren();
        actualChildren.clear();
        actualChildren.addAll(children);
        Iterator it = children.iterator();
        while (it.hasNext()) {
            ((TplNodeImpl)it.next()).setParent(parent);
        }
    }

    TplRoot createRoot(TemplateModel model) {
        List contributors = TplNodeFactory.getContributors();
        int i = 0;
        while (i < contributors.size()) {
            TplRoot root = ((TplNodeFactoryContributor)contributors.get(i)).createRoot(model);
            if (root != null) {
                return root;
            }
            ++i;
        }
        return null;
    }

    String getXmlDeclaration(TemplateModel model) {
        List contributors = TplNodeFactory.getContributors();
        int i = 0;
        while (i < contributors.size()) {
            String decl = ((TplNodeFactoryContributor)contributors.get(i)).getRootXmlDeclaration(model);
            if (decl != null) {
                return decl;
            }
            ++i;
        }
        return null;
    }

    String[] getRawTextNodeFilter() {
        if (rawTextNodeFilter == null) {
            HashSet<String> ar = new HashSet<String>(contributors.size());
            for (TplNodeFactoryContributor c : contributors) {
                String f = c.getRawTextFilter();
                if (f == null) continue;
                if (f.length() == 0) {
                    ar.clear();
                    ar.add(f);
                    break;
                }
                ar.add(f);
            }
            rawTextNodeFilter = ar.toArray(new String[ar.size()]);
        }
        return rawTextNodeFilter;
    }
}

