/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.model;

import com.ibm.etools.webpage.template.internal.model.LinkUtil;
import com.ibm.etools.webpage.template.internal.model.TemplateModelImpl;
import com.ibm.etools.webpage.template.internal.model.TplNodeImpl;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TplException;
import com.ibm.etools.webpage.template.model.TplNode;
import com.ibm.etools.webpage.template.model.TplNodeList;
import com.ibm.etools.webpage.template.model.TplPut;
import com.ibm.etools.webpage.template.model.TplRange;
import com.ibm.etools.webpage.template.model.TplRefNode;
import com.ibm.etools.webpage.template.model.TplTemplate;
import com.ibm.etools.webpage.template.model.util.TemplateModelUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class TplInclusionImpl
extends TplNodeImpl
implements TplTemplate {
    protected TplInclusionImpl(TplRefNode refNode) {
        super(refNode);
    }

    @Override
    public TplNodeList getPutList() {
        if (this.children == null) {
            ((TemplateModelImpl)this.getModel()).getNodeFactory().parseAndCreateChidren(this);
        }
        return this;
    }

    @Override
    public IFile getReferedFile() {
        String ref = this.getReference();
        if (ref != null) {
            IFile thisFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(this.getModel().getLocation()));
            return thisFile != null ? LinkUtil.getFile(thisFile, ref, false) : null;
        }
        return null;
    }

    @Override
    public IPath getReferedFileLocation() {
        String ref = this.getReference();
        if (ref != null) {
            Path thisLocation = new Path(this.getModel().getLocation());
            return LinkUtil.getFileLocation((IPath)thisLocation, ref);
        }
        return null;
    }

    @Override
    public TemplateModel getReferedModel() {
        IFile file = this.getReferedFile();
        if (file != null) {
            return ((TemplateModelImpl)this.getModel()).getSession().getTemplateModel(file);
        }
        IPath location = this.getReferedFileLocation();
        if (location != null) {
            return ((TemplateModelImpl)this.getModel()).getSession().getTemplateModel(location);
        }
        return null;
    }

    @Override
    public short getRawNodeType() {
        return (short)(this.children == null || this.children.size() > 0 ? 2 : 16);
    }

    @Override
    public short getNodeType() {
        return this.getPutList().getLength() > 0 ? (short)2 : 16;
    }

    protected boolean setContent(String content) throws TplException {
        TplRange range = this.getContent();
        if (!range.isValid()) {
            throw new TplException(1, "Invalid content");
        }
        int start = 0;
        int length = 0;
        if (range.getStartNode() != null) {
            start = range.getStartNode().getStartOffset();
            length = range.getEndNode().getEndOffset() - start;
        } else {
            start = range.getPosition();
        }
        if (content.length() != length || length != 0 && !content.equals(range.getText())) {
            this.getModel().getFlatModel().replaceText(this.getModificationRequester(), start, length, content);
            this.contentRange = null;
            this.children.clear();
            this.children = null;
            return true;
        }
        return false;
    }

    protected static TplNodeList getGetListIn(TemplateModel model) {
        ArrayList list = new ArrayList();
        TemplateModelUtil.collectGetNode(model.getRoot(), list);
        return new myTplNodeList(list);
    }

    protected static TplNodeList getGetAndMetadataAndPutListIn(TemplateModel model) {
        ArrayList list = new ArrayList();
        TemplateModelUtil.collectTypedNode(model.getRoot(), list, (short)100);
        return new myTplNodeList(list);
    }

    protected static TplPut findPutIn(TplNodeList list, String getName) {
        int i = 0;
        while (i < list.getLength()) {
            TplPut current = (TplPut)list.item(i);
            if (getName.equals(current.getName())) {
                return current;
            }
            ++i;
        }
        return null;
    }

    static class myTplNodeList
    implements TplNodeList {
        private List nodes;

        public myTplNodeList(List list) {
            this.nodes = list;
        }

        @Override
        public int getLength() {
            return this.nodes.size();
        }

        @Override
        public TplNode item(int index) throws IndexOutOfBoundsException {
            return (TplNode)this.nodes.get(index);
        }
    }
}

