/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.model;

import com.ibm.etools.webpage.template.internal.model.TplNodeFactory;
import com.ibm.etools.webpage.template.internal.model.TplNodeImpl;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import com.ibm.etools.webpage.template.model.TemplateTaskReporter;
import com.ibm.etools.webpage.template.model.TplContainer;
import com.ibm.etools.webpage.template.model.TplNode;
import com.ibm.etools.webpage.template.model.TplNodeList;
import com.ibm.etools.webpage.template.model.TplRoot;
import com.ibm.etools.webpage.template.model.TplTemplate;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class TemplateModelImpl
implements TemplateModel {
    private final TplRoot root;
    private final IStructuredDocument flatModel;
    private final IStructuredModel structuredModel;
    private String location;
    private final TemplateModelSession session;

    protected TemplateModelImpl(IStructuredDocument flatModel, String location, TemplateModelSession session) {
        this.flatModel = flatModel;
        this.location = location;
        this.session = session;
        this.structuredModel = null;
        this.root = this.getNodeFactory().createRoot(this);
    }

    protected TemplateModelImpl(IStructuredModel structuredModel, String location, TemplateModelSession session) {
        this.structuredModel = structuredModel;
        this.flatModel = structuredModel.getStructuredDocument();
        this.location = location;
        this.session = session;
        this.root = this.getNodeFactory().createRoot(this);
    }

    @Override
    public boolean isTemplate() {
        return TemplateModelImpl.findNodeOf(this.getRoot(), (short)4);
    }

    protected static boolean findNodeOf(TplNode node, short nodeTypes) {
        TplNodeList list = null;
        if ((node.getNodeType() & 9) != 0) {
            list = ((TplContainer)((Object)node)).getContentNodeList();
        }
        if (node.getNodeType() == 2) {
            list = ((TplTemplate)node).getPutList();
        }
        if (list != null) {
            int i = 0;
            while (i < list.getLength()) {
                TplNode child = list.item(i);
                if ((child.getNodeType() & nodeTypes) != 0) {
                    return true;
                }
                boolean b = TemplateModelImpl.findNodeOf(child, nodeTypes);
                if (b) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public boolean rebuildContent(TemplateTaskReporter report) {
        return ((TplNodeImpl)((Object)this.getRoot())).rebuildContent(report, false);
    }

    @Override
    public IStructuredDocument getFlatModel() {
        return this.flatModel;
    }

    @Override
    public TplRoot getRoot() {
        return this.root;
    }

    public String getXmlDeclaration() {
        return this.getNodeFactory().getXmlDeclaration(this);
    }

    TplNodeFactory getNodeFactory() {
        return TplNodeFactory.getInstance();
    }

    public static String[] getRawTextNodeFilter() {
        return TplNodeFactory.getInstance().getRawTextNodeFilter();
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public TemplateModelSession getSession() {
        return this.session;
    }

    @Override
    public IStructuredModel getStructuredModel() {
        return this.structuredModel;
    }

    @Override
    public void getRebuildingContentReport(TemplateTaskReporter report) {
        ((TplNodeImpl)((Object)this.getRoot())).rebuildContent(report, true);
    }
}

