/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.builder.indexer;

import com.ibm.etools.webpage.template.TemplatePlugin;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import com.ibm.etools.webpage.template.model.TplGet;
import com.ibm.etools.webpage.template.model.TplNode;
import com.ibm.etools.webpage.template.model.TplPut;
import com.ibm.etools.webpage.template.model.TplReference;
import com.ibm.etools.webpage.template.model.util.TemplateModelUtil;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class TemplateRefInfo {
    private final IFile keyFile;
    private final long synchronizationStamp;
    private final Reference[] refArray;
    private final boolean hasTplNodes;
    private final String putNodes;
    private final String getNodes;

    public TemplateRefInfo(IFile keyFile, TemplateModelSession session) {
        this(session.getTemplateModel(keyFile));
    }

    public TemplateRefInfo(TemplateModel model) {
        this.keyFile = TemplatePlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(model.getLocation()));
        this.synchronizationStamp = this.keyFile != null ? this.keyFile.getModificationStamp() : 0L;
        List inclusions = TemplateModelUtil.collectInclusionNode(model);
        ArrayList<Reference> relations = new ArrayList<Reference>();
        int i = 0;
        while (inclusions != null && i < inclusions.size()) {
            IFile relatedFile;
            Object obj = inclusions.get(i);
            if (obj instanceof TplReference && (relatedFile = ((TplReference)obj).getReferedFile()) != null) {
                relations.add(new Reference(relatedFile, ((TplNode)obj).getNodeType()));
            }
            ++i;
        }
        this.refArray = new Reference[relations.size()];
        relations.toArray(this.refArray);
        this.hasTplNodes = model.getRoot().getContentNodeList() != null && model.getRoot().getContentNodeList().getLength() > 0;
        this.putNodes = TemplateRefInfo.createPutNodesString(model);
        this.getNodes = TemplateRefInfo.createGetNodesString(model);
    }

    public TemplateRefInfo(IFile keyFile, long stamp, boolean hasTplNodes, IFile[] files, short[] types, String putNodes, String getNodes) {
        this.keyFile = keyFile;
        this.synchronizationStamp = stamp;
        this.hasTplNodes = hasTplNodes;
        Reference[] array = new Reference[files.length];
        int i = 0;
        while (i < files.length) {
            array[i] = new Reference(files[i], types[i]);
            ++i;
        }
        this.refArray = array;
        this.putNodes = putNodes;
        this.getNodes = getNodes;
    }

    public static String createPutNodesString(TemplateModel model) {
        List putNodeList = TemplateModelUtil.collectPutNode(model);
        if (putNodeList != null && putNodeList.size() > 0) {
            StringBuffer buf = new StringBuffer();
            for (Object obj : putNodeList) {
                if (!(obj instanceof TplPut)) continue;
                buf.append("|");
                buf.append(((TplPut)obj).getName());
            }
            return URLEncoder.encode(buf.toString());
        }
        return null;
    }

    public static String createGetNodesString(TemplateModel model) {
        List getNodeList = TemplateModelUtil.collectGetNode(model);
        if (getNodeList != null && getNodeList.size() > 0) {
            StringBuffer buf = new StringBuffer();
            for (Object obj : getNodeList) {
                if (!(obj instanceof TplGet)) continue;
                buf.append("|");
                buf.append(((TplGet)obj).getName());
            }
            return URLEncoder.encode(buf.toString());
        }
        return null;
    }

    public IFile getKeyFile() {
        return this.keyFile;
    }

    public IFile[] getReferedFiles() {
        IFile[] files = new IFile[this.refArray.length];
        int i = 0;
        while (i < files.length) {
            files[i] = this.refArray[i].refFile;
            ++i;
        }
        return files;
    }

    public IFile getRefFile(int i) {
        if (i < 0 || this.refArray.length <= i) {
            return null;
        }
        return this.refArray[i].refFile;
    }

    public short getRefType(int i) {
        if (i < 0 || this.refArray.length <= i) {
            return 0;
        }
        return this.refArray[i].refType;
    }

    public int getRefCount() {
        return this.refArray.length;
    }

    public long getInfoStamp() {
        return this.synchronizationStamp;
    }

    public IFile[] getReferedFilesAsTemplate() {
        ArrayList<IFile> files = new ArrayList<IFile>(1);
        int i = 0;
        while (i < this.refArray.length) {
            if ((this.refArray[i].refType & 2) != 0) {
                files.add(this.refArray[i].refFile);
            }
            ++i;
        }
        IFile[] fileArray = new IFile[files.size()];
        files.toArray(fileArray);
        return fileArray;
    }

    public IFile[] getReferdFilesAsFragment() {
        ArrayList<IFile> files = new ArrayList<IFile>(this.refArray.length);
        int i = 0;
        while (i < this.refArray.length) {
            if ((this.refArray[i].refType & 0x10) != 0) {
                files.add(this.refArray[i].refFile);
            }
            ++i;
        }
        IFile[] fileArray = new IFile[files.size()];
        files.toArray(fileArray);
        return fileArray;
    }

    public boolean hasTplNodes() {
        return this.hasTplNodes;
    }

    public String getGetNodes() {
        return this.getNodes;
    }

    public String getPutNodes() {
        return this.putNodes;
    }

    public static class Reference {
        public final IFile refFile;
        public final short refType;

        public Reference(IFile refFile, short refType) {
            this.refFile = refFile;
            this.refType = refType;
        }
    }
}

