/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.builder.indexer;

import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateRefIndex;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateRefIndexImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class TemplateRefIndexManager {
    private static TemplateRefIndexManager mgr;
    private Map indexes;

    private TemplateRefIndexManager() {
    }

    public static TemplateRefIndexManager getInstance() {
        if (mgr == null) {
            mgr = new TemplateRefIndexManager();
        }
        return mgr;
    }

    public TemplateRefIndex getIndex(IProject project) {
        TemplateRefIndex index = (TemplateRefIndex)this.getIndexes().get(project);
        if (index == null) {
            index = this.newIndex(project);
        }
        return index;
    }

    protected Map getIndexes() {
        if (this.indexes == null) {
            this.indexes = new HashMap();
        }
        return this.indexes;
    }

    public void clearAll() {
        Set entries = this.getIndexes().entrySet();
        for (Map.Entry entry : entries) {
            if (!(entry instanceof TemplateRefIndexImpl)) continue;
            ((TemplateRefIndexImpl)((Object)entry)).clear();
        }
        this.getIndexes().clear();
    }

    public void clear(IProject project) {
        Object entry = this.getIndexes().get(project);
        if (entry instanceof TemplateRefIndexImpl) {
            ((TemplateRefIndexImpl)entry).clear();
        }
        this.getIndexes().remove(project);
    }

    protected TemplateRefIndex newIndex(IProject project) {
        if (project == null) {
            return null;
        }
        boolean hasNature = false;
        try {
            hasNature = project.hasNature("com.ibm.etools.webpage.template.templatenature");
        }
        catch (CoreException coreException) {}
        if (!hasNature) {
            return null;
        }
        TemplateRefIndexImpl index = new TemplateRefIndexImpl(project);
        this.getIndexes().put(project, index);
        return index;
    }

    public void saveIndexes() {
        Collection values = this.getIndexes().values();
        for (Object value : values) {
            if (!(value instanceof TemplateRefIndexImpl)) continue;
            ((TemplateRefIndexImpl)value).saveIndex();
        }
    }

    public boolean saveIndex(IProject project) {
        if (project == null || !project.isAccessible()) {
            return false;
        }
        Object entry = this.getIndexes().get(project);
        if (entry instanceof TemplateRefIndexImpl) {
            ((TemplateRefIndexImpl)entry).saveIndex();
        }
        return true;
    }
}

