/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webpage.template.internal.builder.indexer;

import com.ibm.etools.webpage.template.FileTypeHandler;
import com.ibm.etools.webpage.template.Logger;
import com.ibm.etools.webpage.template.TemplatePlugin;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateRefIndex;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateRefIndexUtil;
import com.ibm.etools.webpage.template.internal.builder.indexer.TemplateRefInfo;
import com.ibm.etools.webpage.template.model.TemplateModel;
import com.ibm.etools.webpage.template.model.TemplateModelSession;
import com.ibm.etools.webpage.template.model.TplReference;
import com.ibm.etools.webpage.template.model.util.TemplateModelUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class TemplateRefIndexImpl
implements TemplateRefIndex {
    private static final IFile[] NULL_ARRAY = new IFile[0];
    private static final String FILE_ENTRY = "File=";
    private static final String STAMP_ENTRY = "  FileStamp=";
    private static final String NODES_ENTRY = "  FileHasTplNodes=";
    private static final String PUT_ENTRY = "  FilePutNodes=";
    private static final String GET_ENTRY = "  FileGetNodes=";
    private static final String FREF_TPL_ENTRY = " FileRefTpl=";
    private static final String FREF_FRG_ENTRY = " FileRefFrg=";
    private static final String SEPARATOR = "SEPARATOR";
    private IProject project;
    private Map table;

    public TemplateRefIndexImpl(IProject project) {
        this.project = project;
        this.restoreIndex();
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public IFile[] getReferedFiles(IFile keyFile) {
        if (keyFile == null) {
            return NULL_ARRAY;
        }
        Object entry = this.getTable().get(keyFile);
        if (entry instanceof TemplateRefInfo) {
            return ((TemplateRefInfo)entry).getReferedFiles();
        }
        return NULL_ARRAY;
    }

    @Override
    public void setReference(TemplateModel model) {
        if (model == null) {
            return;
        }
        IFile keyFile = TemplatePlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(model.getLocation()));
        if (keyFile == null || FileTypeHandler.getFileType(keyFile) == null) {
            return;
        }
        TemplateRefInfo oldInfo = this.getReferedInfo(keyFile);
        if (oldInfo != null && oldInfo.getInfoStamp() == keyFile.getModificationStamp()) {
            return;
        }
        TemplateRefInfo info = new TemplateRefInfo(model);
        if (info.getInfoStamp() == 0L || TemplateModelUtil.hasSyntaxError(model)) {
            this.getTable().remove(info.getKeyFile());
        } else {
            this.getTable().put(info.getKeyFile(), info);
        }
    }

    @Override
    public void setReference(IFile keyFile, TemplateModelSession session) {
        if (keyFile == null || session == null) {
            return;
        }
        this.setReference(session.getTemplateModel(keyFile));
    }

    private Map getTable() {
        if (this.table == null) {
            this.table = new HashMap();
        }
        return this.table;
    }

    @Override
    public boolean isChanged(IFile keyFile, TemplateModelSession session) {
        if (keyFile == null || session == null) {
            return false;
        }
        return this.isChanged(session.getTemplateModel(keyFile));
    }

    @Override
    public boolean isChanged(TemplateModel model) {
        if (model == null) {
            return false;
        }
        IFile keyFile = TemplatePlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(model.getLocation()));
        if (keyFile == null) {
            return false;
        }
        TemplateRefInfo info = this.getReferedInfo(keyFile);
        if (info == null) {
            return true;
        }
        if (TemplateModelUtil.hasSyntaxError(model)) {
            return true;
        }
        if (info.getPutNodes() != null ? !info.getPutNodes().equals(TemplateRefInfo.createPutNodesString(model)) : TemplateRefInfo.createPutNodesString(model) != null) {
            return true;
        }
        if (info.getGetNodes() != null ? !info.getGetNodes().equals(TemplateRefInfo.createGetNodesString(model)) : TemplateRefInfo.createGetNodesString(model) != null) {
            return true;
        }
        List inclusions = TemplateModelUtil.collectInclusionNode(model);
        ArrayList<IFile> relations = new ArrayList<IFile>();
        int i = 0;
        while (inclusions != null && i < inclusions.size()) {
            IFile relatedFile;
            Object obj = inclusions.get(i);
            if (obj instanceof TplReference && (relatedFile = ((TplReference)obj).getReferedFile()) != null) {
                relations.add(relatedFile);
            }
            ++i;
        }
        IFile[] array = new IFile[relations.size()];
        relations.toArray(array);
        return !TemplateRefIndexUtil.isEqual(array, this.getReferedFiles(keyFile));
    }

    @Override
    public boolean hasValidInfo(IFile file) {
        TemplateRefInfo info = this.getReferedInfo(file);
        return info != null && info.getInfoStamp() == file.getModificationStamp();
    }

    private void addEntry(String key, String stamp, String hasNodes, List files, List types, String putNodes, String getNodes) {
        if (key != null && key.length() > 0 && stamp != null && stamp.length() > 0 && files != null && types != null && files.size() == types.size()) {
            IFile file = this.getProject().getFile((IPath)new Path(key));
            long lStamp = Long.parseLong(stamp);
            boolean bHasNodes = Boolean.TRUE.toString().equals(hasNodes);
            IFile[] refFiles = new IFile[files.size()];
            short[] refTypes = new short[types.size()];
            int i = 0;
            while (i < refFiles.length) {
                refFiles[i] = this.getProject().getFile((IPath)new Path(files.get(i).toString()));
                refTypes[i] = types.get(i).equals(FREF_FRG_ENTRY) ? 16 : 2;
                ++i;
            }
            TemplateRefInfo info = new TemplateRefInfo(file, lStamp, bHasNodes, refFiles, refTypes, putNodes, getNodes);
            this.getTable().put(file, info);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void restoreIndex() {
        File stateFile = this.getStateFile(this.project);
        if (!stateFile.exists()) return;
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(stateFile), "UTF-8"));
                String line = null;
                String key = null;
                String stamp = null;
                String hasNodes = null;
                String putNodes = null;
                String getNodes = null;
                ArrayList<String> refFiles = new ArrayList<String>();
                ArrayList<String> refTypes = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    String value;
                    if (line.startsWith(FILE_ENTRY)) {
                        this.addEntry(key, stamp, hasNodes, refFiles, refTypes, putNodes, getNodes);
                        key = line.substring(FILE_ENTRY.length());
                        refFiles.clear();
                        refTypes.clear();
                        stamp = null;
                        hasNodes = null;
                        getNodes = null;
                        putNodes = null;
                        continue;
                    }
                    if (line.startsWith(STAMP_ENTRY)) {
                        stamp = line.substring(STAMP_ENTRY.length());
                        continue;
                    }
                    if (line.startsWith(NODES_ENTRY)) {
                        hasNodes = line.substring(NODES_ENTRY.length());
                        continue;
                    }
                    if (line.startsWith(PUT_ENTRY)) {
                        putNodes = line.substring(PUT_ENTRY.length());
                        continue;
                    }
                    if (line.startsWith(GET_ENTRY)) {
                        getNodes = line.substring(GET_ENTRY.length());
                        continue;
                    }
                    if (line.startsWith(FREF_FRG_ENTRY)) {
                        value = line.substring(FREF_FRG_ENTRY.length());
                        if (value == null || value.length() <= 0) continue;
                        refFiles.add(value);
                        refTypes.add(FREF_FRG_ENTRY);
                        continue;
                    }
                    if (line.startsWith(FREF_TPL_ENTRY)) {
                        value = line.substring(FREF_TPL_ENTRY.length());
                        if (value == null || value.length() <= 0) continue;
                        refFiles.add(value);
                        refTypes.add(FREF_TPL_ENTRY);
                        continue;
                    }
                    if (!line.startsWith(SEPARATOR)) continue;
                    this.addEntry(key, stamp, hasNodes, refFiles, refTypes, putNodes, getNodes);
                    key = null;
                    refFiles.clear();
                    refTypes.clear();
                    stamp = null;
                    hasNodes = null;
                    getNodes = null;
                    putNodes = null;
                }
                this.addEntry(key, stamp, hasNodes, refFiles, refTypes, putNodes, getNodes);
                return;
            }
            catch (FileNotFoundException fe) {
                Logger.log(fe);
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException ie2) {
                    Logger.log(ie2);
                }
                return;
            }
            catch (IOException ie) {
                Logger.log(ie);
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException ie2) {
                    Logger.log(ie2);
                }
                return;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ie2) {
                    Logger.log(ie2);
                }
            }
        }
    }

    public void saveIndex() {
        File stateFile = this.getStateFile(this.project);
        if (this.getTable().size() <= 0 || !this.project.isAccessible()) {
            stateFile.delete();
        } else {
            try {
                File parentFolder = stateFile.getParentFile();
                if (!parentFolder.exists()) {
                    parentFolder.mkdirs();
                }
                PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(stateFile), "UTF-8")));
                for (Object key : this.getTable().keySet()) {
                    Object entry = this.getTable().get(key);
                    if (!(entry instanceof TemplateRefInfo) || !(key instanceof IFile) || !((IFile)key).isAccessible()) continue;
                    TemplateRefInfo info = (TemplateRefInfo)entry;
                    out.print(FILE_ENTRY);
                    out.println(((IFile)key).getProjectRelativePath().toString());
                    out.print(STAMP_ENTRY);
                    out.println(info.getInfoStamp());
                    if (info.hasTplNodes()) {
                        out.print(NODES_ENTRY);
                        out.println(info.hasTplNodes());
                    }
                    if (info.getPutNodes() != null && info.getPutNodes().length() > 0) {
                        out.print(PUT_ENTRY);
                        out.println(info.getPutNodes());
                    }
                    if (info.getGetNodes() != null && info.getGetNodes().length() > 0) {
                        out.print(GET_ENTRY);
                        out.println(info.getGetNodes());
                    }
                    int i = 0;
                    while (i < info.getRefCount()) {
                        if ((info.getRefType(i) & 0x10) != 0) {
                            out.print(FREF_FRG_ENTRY);
                        } else {
                            out.print(FREF_TPL_ENTRY);
                        }
                        out.println(info.getRefFile(i).getProjectRelativePath().toString());
                        ++i;
                    }
                }
                out.flush();
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void clear() {
        this.getTable().clear();
        File stateFile = this.getStateFile(this.project);
        stateFile.delete();
    }

    private File getStateFile(IProject project) {
        return new Path(String.valueOf(TemplatePlugin.getDefault().getStateLocation().toString()) + File.separator + project.getName() + ".index").toFile();
    }

    @Override
    public TemplateRefInfo getReferedInfo(IFile keyFile) {
        if (keyFile == null) {
            return null;
        }
        Object entry = this.getTable().get(keyFile);
        if (entry instanceof TemplateRefInfo) {
            return (TemplateRefInfo)entry;
        }
        return null;
    }

    @Override
    public void removeReference(IFile keyFile) {
        this.getTable().remove(keyFile);
    }

    @Override
    public void setReference(TemplateRefInfo info) {
        if (info != null && info.getKeyFile() != null && FileTypeHandler.getFileType(info.getKeyFile()) != null && info.getKeyFile().getProject().equals((Object)this.getProject())) {
            this.getTable().put(info.getKeyFile(), info);
        }
    }
}

